<?php

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package acadia
 */


// main header settings
$acadia_header_hamburger   = get_theme_mod('acadia_header_hamburger', false);
$header_right_switch     = get_theme_mod('header_right_switch', false);
$acadia_menu_col           = $header_right_switch ? 'col-xl-8 d-none d-xl-block text-center' : 'col-xl-10 col-lg-10 d-none d-xl-block text-end';
$acadia_header_sticky      = get_theme_mod('acadia_header_sticky', false);

// woocommerce controls
$acadia_header_cart     = get_theme_mod('acadia_header_cart', true);


$has_menu = has_nav_menu('main-menu') ? '' : ' main-menu-assigned';

$sticky_id = $acadia_header_sticky ? 'header-sticky' : '';
?>

<!-- header-area-start -->
<header class="header-area p-relative tp-acadia-defaults-headers">
   <div id="<?php echo esc_attr($sticky_id); ?>" class="tp-header-2">
      <div class="container custom-container-larg">
         <div class="row align-items-center">
            <div class="col-xl-2 col-lg-6 col-6">
               <div class="tp-header-2-logo">
                  <?php acadia_header_logo(); ?>
               </div>
            </div>
            <div class="<?php echo esc_attr($acadia_menu_col); ?>">
               <div class="main-menu">
                  <nav class="tp-main-menu-content">
                     <?php acadia_header_menu(); ?>
                  </nav>
               </div>
            </div>

            <?php if ($header_right_switch) : ?>
               <div class="col-xl-2 col-lg-6 col-6">
                  <div class="tp-header-2-contact d-flex align-items-center justify-content-end">

                     <?php if ($acadia_header_cart && class_exists('WooCommerce')) : ?>
                        <div class="tp-header-2-cart ml-35">
                           <button class="cartmini-open-btn">
                              <span>
                                 <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.71429 19H13.5314C16.4028 19 18.6057 17.9629 17.98 13.7886L17.2514 8.13145C16.8657 6.0486 15.5371 5.25146 14.3714 5.25146H4.84C3.65715 5.25146 2.40572 6.1086 1.96001 8.13145L1.23144 13.7886C0.700012 17.4914 2.84287 19 5.71429 19Z" stroke="currentcolor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M5.58578 5.04574C5.58578 2.81136 7.39711 1.00004 9.63149 1.00004V1.00004C10.7074 0.995477 11.7409 1.41971 12.5033 2.17892C13.2658 2.93813 13.6943 3.96978 13.6943 5.04574V5.04574" stroke="currentcolor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M6.85469 9.26288H6.89755" stroke="currentcolor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M12.3146 9.26287H12.3575" stroke="currentcolor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                 </svg>
                                 <?php
                                 $cart_count = !is_null(WC()->cart) ? WC()->cart->get_cart_contents_count() : 0;
                                 ?>
                                 <span id="tp-cart-item" class="tp-header-action-badge cart__count"><?php echo esc_html($cart_count); ?></span>
                              </span>
                           </button>
                        </div>
                     <?php endif; ?>

                     <?php if (!empty($acadia_header_hamburger)) : ?>
                        <div class="tp-header-5-sidebar offcanvas-btns ml-35">
                           <button class="offcanvas-open-btn">
                              <span></span>
                           </button>
                        </div>
                     <?php endif; ?>
                  </div>
               </div>
            <?php endif; ?>

            <?php if (!$header_right_switch) : ?>
               <div class="col-6 d-xl-none">
                  <div class="tp-header-2-contact d-flex align-items-center justify-content-end">

                     <div class="tp-header-5-sidebar offcanvas-btns ml-35">
                        <button class="offcanvas-open-btn">
                           <span></span>
                        </button>
                     </div>
                  </div>
               </div>
            <?php endif; ?>
         </div>
      </div>
   </div>
</header>
<!-- header-area-end -->


<?php if (class_exists('WooCommerce')) : ?>
   <?php print acadia_shopping_cart(); ?>
<?php endif; ?>


<?php do_action('acadia_offcanvas_style'); ?>