<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

if (!defined('ABSPATH')) {
	exit;
}

?>


<div class="tp-shop-widget mb-35 tp-sidebar-search">
	<form role="get_search_form('seacrh')" method="get" class="woocommerce-product-search"
		action="<?php echo esc_url(home_url('/shop')); ?>">
		<div class="tp-sidebar-search-input">
			<input type="search" id="-field-<?php echo isset($index) ? absint($index) : 0; ?>" class="search-field"
				placeholder="<?php echo esc_attr__('Search...', 'acadia'); ?>" value="<?php echo get_search_query(); ?>"
				name="s" />
			<button type="submit" value="<?php echo esc_attr_x('Search', 'submit button', 'acadia'); ?>"
				class="<?php echo esc_attr(wc_wp_theme_get_element_class_name('button')); ?> woo-search-btn">
				<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path
						d="M8.11111 15.2222C12.0385 15.2222 15.2222 12.0385 15.2222 8.11111C15.2222 4.18375 12.0385 1 8.11111 1C4.18375 1 1 4.18375 1 8.11111C1 12.0385 4.18375 15.2222 8.11111 15.2222Z"
						stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M16.9995 17L13.1328 13.1333" stroke="currentColor" stroke-width="2" stroke-linecap="round"
						stroke-linejoin="round"></path>
				</svg>
			</button>
		</div>
	</form>
</div>