<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Repeater;


if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Yoga_Accordion extends Widget_Base
{

    use TP_Style_Trait, TP_Icon_Trait, TP_Offcanvas_Trait, TP_Menu_Trait, TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-yoga-accordion';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Yoga Accordion', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {


        $this->tp_design_layout('Select Layout', 1);

        // Accordion
        $this->start_controls_section(
            'app_accordion',
            [
                'label' => esc_html__('App Accordion', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tp_app_accordion_active_switch',
            [
                'label' => esc_html__('Active Switch', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tpcore'),
                'label_off' => esc_html__('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'app_accordion_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('This is title', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tp_app_accordion_description',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'description' => tp_get_allowed_html_desc('Type your description'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => "This is description",
                'label_block' => true,
            ]
        );

        $this->add_control(
            'app_accordions',
            [
                'label' => esc_html__('Repeater Accordion', 'tpcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'separator' => 'before',
                'default' => [
                    [
                        'app_accordion_title' => esc_html__('Title 1', 'tpcore'),
                    ],
                    [
                        'app_accordion_title' => esc_html__('Title 2', 'tpcore'),
                    ],
                ],
                'title_field' => '{{{ app_accordion_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->tp_creative_animation();
    }

    // style_tab_content
    protected function style_tab_content()
    {
        $this->tp_section_style_controls('accor_section', 'Section - Style', '.tp-el-section');
        $this->tp_basic_style_controls('accor_title', 'Title', '.tp-el-title');
        $this->tp_basic_style_controls('accor_desc_title', 'Description', '.tp-el-desc');
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>


        <?php else: 
            $animation = $this->tp_animation_show($settings);
            ?>

            <div class="tp-faq-box tp-faq-yoga-wrap ml-75 mb-30 tp-el-section <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
                <div class="tpd-accordion">
                    <div class="accordion accordion-flush" id="accordionFlushExample">

                        <?php foreach ($settings['app_accordions'] as $key => $item):
                            $collapsed = $item['tp_app_accordion_active_switch'] == 'yes' ? '' : 'collapsed';
                            $show = $item['tp_app_accordion_active_switch'] == 'yes' ? 'show' : null;
                            $expand = $item['tp_app_accordion_active_switch'] == 'yes' ? 'expand' : null;
                            $title = $item['app_accordion_title'];
                            $desc = $item['tp_app_accordion_description'];

                            ?>
                            <div class="accordion-item <?php echo esc_attr($expand); ?>">
                                <h2 class="accordion-header">
                                    <button class="accordion-button faq-expend tp-el-title <?php echo esc_attr($collapsed); ?>"
                                        type="button" data-bs-toggle="collapse"
                                        data-bs-target="#flush-collapseTwo-<?php echo esc_attr($this->get_id() . $key); ?>"
                                        aria-expanded="false"
                                        aria-controls="flush-collapseTwo-<?php echo esc_attr($this->get_id() . $key); ?>">
                                        <?php echo tp_kses($title); ?>
                                        <span class="accordion-btn"></span>
                                    </button>
                                </h2>
                                <div id="flush-collapseTwo-<?php echo esc_attr($this->get_id() . $key); ?>"
                                    class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
                                    data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body tp-el-desc">
                                        <?php if (!empty($desc)): ?>
                                            <?php echo tp_kses($desc); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

        <?php endif;
    }
}
$widgets_manager->register(new TP_Yoga_Accordion());
