<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;

if (!defined('ABSPATH'))
	exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Theme_Button_1 extends Widget_Base
{

	use TP_Style_Trait, TP_Icon_Trait, TP_Offcanvas_Trait, TP_Menu_Trait, TP_Animation_Trait;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'tp-theme-button-1';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('Button 1', 'tpcore');
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['tpcore'];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends()
	{
		return ['tpcore'];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

	protected function register_controls()
	{
		$this->register_controls_section();
		$this->style_tab_content();
	}

	protected function register_controls_section()
	{

		$this->tp_design_layout('Select Layout', 2);

		$this->start_controls_section(
			'tp_btn_1_content_sec',
			[
				'label' => esc_html__('Content', 'tpcore'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'tp_btn_1_text',
			[
				'label' => esc_html__('Button Text', 'tpcore'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('View More', 'tpcore'),
				'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
			]
		);
		$this->add_control(
			'tp_btn_1_icon_Switcher',
			[
				'label' => esc_html__('Show Icon ?', 'tpcore'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'tpcore'),
				'label_off' => esc_html__('Hide', 'tpcore'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		tp_render_links_controls($this, 'btn_1_url');

		$this->end_controls_section();

		$this->tp_creative_animation();
	}

	// style_tab_content
	protected function style_tab_content()
	{
		$this->tp_link_controls_style('', 'btn_1_style', 'Button', '.tp-el-btn');

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$btn_id = 'theme_btn';

		$btn = $settings['tp_btn_1_text'];
		$attrs = tp_get_repeater_links_attr($settings, 'btn_1_url');
		extract($attrs);

		$links_attrs = [
			'href' => $link,
			'target' => $target,
			'rel' => $rel,
		];

		$animation = $this->tp_animation_show($settings);

		?>

		<?php if ($settings['tp_design_style'] == 'layout-2'): ?>

			<div class="tp-about-yoga-content <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<a class="about-btn tp-el-btn" <?php echo tp_implode_html_attributes($links_attrs); ?>>
					<?php echo tp_kses($btn); ?>
					<?php if ($settings['tp_btn_1_icon_Switcher'] == 'yes'): ?>
						<svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M1 9L9 1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M1 1H9V9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
						</svg>
					<?php endif; ?>
				</a>
			</div>


		<?php else:
			?>
			<div class="tp-hero-6-btn <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<a class="tp-btn-inner tp-el-btn" <?php echo tp_implode_html_attributes($links_attrs); ?>>
					<?php echo tp_kses($btn); ?>
					<?php if ($settings['tp_btn_1_icon_Switcher'] == 'yes'): ?>
						<span>
							<svg width="14" height="11" viewBox="0 0 14 11" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M8.71533 1L13 5.28471L8.71533 9.56941" stroke="currentColor" stroke-width="2"
									stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
								<path d="M1 5.28473H12.88" stroke="currentColor" stroke-width="2" stroke-miterlimit="10"
									stroke-linecap="round" stroke-linejoin="round"></path>
							</svg>
						</span>
					<?php endif; ?>
				</a>
			</div>
		<?php endif; ?>

		<?php
	}
}

$widgets_manager->register(new TP_Theme_Button_1());
