<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;

use \Etn\Utils\Helper as Helper;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly


/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Course_Slider extends Widget_Base
{

    use TP_Style_Trait, TP_Column_Trait, TP_Query_Trait, TP_Animation_Trait;
    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'course-slider';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Course Slider', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */



    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        $this->tp_design_layout('Select Layout', 2);

        $this->start_controls_section(
            'tp_section_style_type',
            [
                'label' => esc_html__('Layout Style Section', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );
        $this->add_control(
            'tp_style_type',
            [
                'label' => esc_html__('Style Type', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'tp-courses-quran-wrap' => esc_html__('Quran Box Style', 'tpcore'),
                    'tp_kitchen_box' => esc_html__('Kitchen Box Style', 'tpcore'),
                ],
                'default' => 'tp-courses-quran-wrap',

            ]
        );

        $this->end_controls_section();

        // query
        $this->tp_query_controls('course_card', 'Course Controls', 'courses', 'course-category');

        // content settings
        $this->start_controls_section(
            'tp_course_section_id',
            [
                'label' => esc_html__('Content', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );
        $this->add_control(
            'tp_post_content',
            [
                'label' => __('Content', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'tpcore'),
                'label_off' => __('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'tp_post_content_limit',
            [
                'label' => __('Content Limit', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => '12',
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'tp_post_content' => 'yes',

                ]
            ]
        );

        $this->end_controls_section();

        // animation
        $this->tp_creative_animation(['layout-1', 'layout-2']);
    }

    protected function style_tab_content()
    {

        $this->tp_section_style_controls('portfolio_section', 'Course Card Style', '.tp-course-item');

        $this->tp_basic_style_controls('course_title', 'Course Title', '.tp-courses-chef-title, .tp-classes-yoga-title');
        $this->tp_basic_style_controls('course_desc', 'Course Description', '.tp-courses-quran-text');
        $this->tp_basic_style_controls('course_meta', 'Course Meta', '.tp-courses-chef-studebts span, .tp-classes-yoga-meta span');
        $this->tp_basic_style_controls('course_tag', 'Course Tag', '.tp-classes-yoga-tag', 'layout-2');
        $this->tp_basic_style_controls('course_price', 'Course New Price', '.tp-courses-chef-price span, .tp-classes-yoga-price span');
        $this->tp_basic_style_controls('course_price_old', 'Course Old Price', '.tp-courses-chef-price .price del span, .tp-classes-yoga-price .price del span');
        $this->tp_image_style('tp_course_image', 'Image Style', '.tp-courses-chef-thumb, tp-classes-yoga-thumb ');

        /* ===================== Rating ===================== */
        $this->start_controls_section(
            'tp_rating_style',
            [
                'label' => esc_html__('Rating', 'tpcore'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        $this->add_control(
            'rating_color',
            [
                'label' => esc_html__('Star Color', 'tpcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tp-courses-chef-ratings span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>

        <?php if ($settings['tp_design_style'] == 'layout-2'):
            $animation = $this->tp_animation_show($settings);
            ?>

            <!-- mouse cursor drag start -->
            <div class="mouseCursor cursor-outer"></div>
            <div class="mouseCursor cursor-inner">
                <span>
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/cursor.svg" alt="">
                </span>
            </div>
            <!-- mouse cursor drag end -->

            <div class="swiper tp-classes-yoga-active tp-cursor-point-area <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
                <div class="swiper-wrapper">
                    <?php
                    $args = tp_query_args('courses', 'course-category', $this->get_settings());
                    $main_query = new \WP_Query($args);

                    ?>
                    <?php if ($main_query->have_posts()): ?>
                        <?php while ($main_query->have_posts()):
                            $main_query->the_post();
                            global $post, $authordata;

                            $tutor_course_img = get_tutor_course_thumbnail_src();
                            $course_id = get_the_ID();

                            $tutor_lesson_count = tutor_utils()->get_lesson_count_by_course(get_the_ID());
                            $course_students = apply_filters('tutor_course_students', tutor_utils()->count_enrolled_users_by_course($course_id), $course_id);

                            $show_course_ratings = apply_filters('tutor_show_course_ratings', true, get_the_ID());
                            $course_rating = tutor_utils()->get_course_rating();

                            $price = !empty(tutor_utils()->get_course_price()) ? tutor_utils()->get_course_price() : "<span class='price'><span class='lms-free'>Free</span></span>";

                            $course_categories = get_tutor_course_categories($course_id);

                            $show_course_ratings = apply_filters('tutor_show_course_ratings', true, get_the_ID());
                            $course_rating = tutor_utils()->get_course_rating();
                            $price = !empty(tutor_utils()->get_course_price()) ? tutor_utils()->get_course_price() : "<span class='price'><span class='lms-free'>Free</span></span>";

                            ?>
                            <div class="swiper-slide">
                                <div class="tp-classes-yoga-wrap mb-30">
                                    <div class="tp-classes-yoga-thumb fix">
                                        <img class="w-100" src="<?php echo esc_url($tutor_course_img); ?>" alt="<?php the_title(); ?>" loading="lazy">
                                    </div>
                                    <div class="tp-classes-yoga-content p-relative">

                                        <span class="tp-classes-yoga-price">
                                            <?php echo tp_kses($price); ?>
                                        </span>

                                        <?php if (!empty($course_categories[0])): ?>
                                            <span class="tp-classes-yoga-tag">
                                                <a href="<?php echo get_term_link($course_categories[0]); ?>">
                                                    <?php echo esc_html($course_categories[0]->name); ?>
                                                </a>
                                            </span>
                                        <?php endif; ?>

                                        <h4 class="tp-classes-yoga-title mb-15">
                                            <a class="tp-linksa" href="<?php the_permalink(); ?>">
                                                <?php echo wp_trim_words(get_the_title(), $settings['tp_post_title_word'], ''); ?>
                                            </a>
                                        </h4>

                                        <?php if (tutor_utils()->get_option('enable_course_total_enrolled') || !empty($tutor_lesson_count)): ?>
                                            <div class="tp-classes-yoga-meta">
                                                <?php if (!empty($tutor_lesson_count)): ?>
                                                    <span>
                                                        <svg class="mr-5" width="15" height="14" viewBox="0 0 15 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                                                stroke="#94928E" stroke-width="1.2" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                            <path d="M7.46118 2.81787V12.4506" stroke="#94928E" stroke-width="1.2"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                        <?php printf(_n('%d Lesson', '%d Lessons', $tutor_lesson_count, 'acadia'), $tutor_lesson_count); ?>
                                                    </span>
                                                <?php endif; ?>

                                                <?php if (!empty($course_students)): ?>
                                                    <span>
                                                        <svg class="mr-5" width="13" height="15" viewBox="0 0 13 15" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                                                stroke="#94928E" stroke-width="1.2" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                            <path
                                                                d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                                                stroke="#94928E" stroke-width="1.2" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                        </svg>
                                                        <?php printf(_n('%d Student', '%d Students', $course_students, 'acadia'), $course_students); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_query();
                    endif; ?>
                </div>
            </div>

        <?php else:
            $animation = $this->tp_animation_show($settings);
            ?>

            <div class="swiper tp-courses-chef-active <?php echo esc_attr($settings['tp_style_type']); ?> pb-30 <?php echo esc_attr($animation['animation']); ?>"
                <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
                <div class="swiper-wrapper slide-transtion">

                    <?php
                    $animation = $this->tp_animation_show($settings);
                    $args = tp_query_args('courses', 'course-category', $this->get_settings());
                    $main_query = new \WP_Query($args);

                    ?>
                    <?php if ($main_query->have_posts()): ?>
                        <?php while ($main_query->have_posts()):
                            $main_query->the_post();
                            global $post, $authordata;

                            $tutor_course_img = get_tutor_course_thumbnail_src();
                            $course_id = get_the_ID();

                            $tutor_lesson_count = tutor_utils()->get_lesson_count_by_course(get_the_ID());
                            $course_students = apply_filters('tutor_course_students', tutor_utils()->count_enrolled_users_by_course($course_id), $course_id);

                            $show_course_ratings = apply_filters('tutor_show_course_ratings', true, get_the_ID());
                            $course_rating = tutor_utils()->get_course_rating();

                            $price = !empty(tutor_utils()->get_course_price()) ? tutor_utils()->get_course_price() : "<span class='price'><span class='lms-free'>Free</span></span>";


                            $show_course_ratings = apply_filters('tutor_show_course_ratings', true, get_the_ID());
                            $course_rating = tutor_utils()->get_course_rating();
                            $price = !empty(tutor_utils()->get_course_price()) ? tutor_utils()->get_course_price() : "<span class='price'><span class='lms-free'>Free</span></span>";

                            ?>
                            <div class="swiper-slide">
                                <div class="tp-courses-chef-2-wrap">
                                    <div class="tp-courses-chef-thumb p-relative">
                                        <a href="<?php the_permalink(); ?>">
                                            <img class="w-100" src="<?php echo esc_url($tutor_course_img); ?>" alt="<?php the_title(); ?>" loading="lazy">
                                        </a>
                                    </div>

                                    <div class="tp-courses-chef-2-content p-relative">

                                        <span class="tp-courses-chef-price">
                                            <?php echo tp_kses($price); ?>
                                        </span>

                                        <?php if ($show_course_ratings): ?>
                                            <div class="tp-courses-chef-ratings mb-15">
                                                <?php
                                                $course_rating = tutor_utils()->get_course_rating();
                                                tutor_utils()->star_rating_generator_course($course_rating->rating_avg);
                                                ?>
                                            </div>
                                        <?php endif; ?>

                                        <h3 class="tp-courses-chef-title">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php echo wp_trim_words(get_the_title(), $settings['tp_post_title_word'], ''); ?>
                                            </a>
                                        </h3>

                                        <?php if ($settings['tp_post_content'] == 'yes'): ?>
                                            <p class="tp-courses-quran-text tp-el-content">
                                                <?php echo wp_trim_words(get_the_content(), $settings['tp_post_content_limit'], ''); ?>
                                            </p>
                                        <?php endif; ?>

                                        <?php if (tutor_utils()->get_option('enable_course_total_enrolled') || !empty($tutor_lesson_count)): ?>
                                            <div class="tp-courses-chef-studebts">
                                                <?php if (!empty($tutor_lesson_count)): ?>
                                                    <span>
                                                        <svg width="15" height="14" viewBox="0 0 15 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                                                stroke="#94928E" stroke-width="1.2" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                            <path d="M7.46118 2.81787V12.4506" stroke="#94928E" stroke-width="1.2"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                        <?php printf(_n('%d Lesson', '%d Lessons', $tutor_lesson_count, 'acadia'), $tutor_lesson_count); ?>
                                                    </span>
                                                <?php endif; ?>

                                                <?php if (!empty($course_students)): ?>
                                                    <span>
                                                        <svg width="13" height="15" viewBox="0 0 13 15" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                                                stroke="#94928E" stroke-width="1.2" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                            <path
                                                                d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                                                stroke="#94928E" stroke-width="1.2" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                        </svg>
                                                        <?php printf(_n('%d Student', '%d Students', $course_students, 'acadia'), $course_students); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_query();
                    endif; ?>
                </div>
                <div class="text-center mt-40">
                    <span class="tp-courses-chef-dot"></span>
                </div>
            </div>
            <?php
        endif; ?>
    <?php
    }
}
$widgets_manager->register(new TP_Course_Slider());
