<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_FAQ extends Widget_Base
{

    use TP_Style_Trait, TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-faq';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('FAQ', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }



    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {


        $this->tp_design_layout('Select Layout', 1);


        $this->start_controls_section(
            '_accordion',
            [
                'label' => esc_html__('Accordion', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tp_faq_style',
            [
                'label' => esc_html__('Faq Style', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'Default' => esc_html__('Default Style', 'tpcore'),
                    'tp-faq-quran-box' => esc_html__('Quran Box', 'tpcore'),
                ],
                'default' => 'Default',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tp_accordion_active_switch',
            [
                'label' => esc_html__('Show', 'tp-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tp-core'),
                'label_off' => esc_html__('Hide', 'tp-core'),
                'return_value' => 'yes',
                'default' => '0',
            ]
        );

        $repeater->add_control(
            'accordion_title',
            [
                'label' => esc_html__('Accordion Item', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('This is accordion item title', 'tpcore'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'accordion_description',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'description' => tp_get_allowed_html_desc('intermediate'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Facilis fugiat hic ipsam iusto laudantium libero maiores minima molestiae mollitia repellat rerum sunt ullam voluptates? Perferendis, suscipit.',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'accordions',
            [
                'label' => esc_html__('Repeater Accordion', 'tpcore'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'separator' => 'before',
                'default' => [
                    [
                        'accordion_title' => esc_html__('This is accordion item title #1', 'tpcore'),
                    ],
                    [
                        'accordion_title' => esc_html__('This is accordion item title #2', 'tpcore'),
                    ],
                    [
                        'accordion_title' => esc_html__('This is accordion item title #3', 'tpcore'),
                    ],
                    [
                        'accordion_title' => esc_html__('This is accordion item title #4', 'tpcore'),
                    ],
                ],
                'title_field' => '{{{ accordion_title }}}',
            ]
        );

        $this->end_controls_section();
        // animation
        $this->tp_creative_animation();

    }

    // style_tab_content
    protected function style_tab_content()
    {

    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $animation = $this->tp_animation_show($settings);
        ?>


        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>


        <?php else: ?>

            <div class="<?php echo esc_attr($settings['tp_faq_style']); ?>">
                <div class="tp-faq-box <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
                    <div class="tpd-accordion">
                        <div class="accordion accordion-flush" id="accordionExample-<?php echo esc_attr($this->get_id()); ?>">

                            <?php foreach ($settings['accordions'] as $key => $item):
                                $collapsed = $item['tp_accordion_active_switch'] ? '' : 'collapsed';
                                $show = $item['tp_accordion_active_switch'] ? 'show' : '';
                                ?>

                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button <?php echo esc_attr($collapsed); ?>" type="button"
                                            data-bs-toggle="collapse"
                                            data-bs-target="#collapseOne-<?php echo esc_attr($this->get_id() . $key); ?>"
                                            aria-expanded="true"
                                            aria-controls="collapseOne-<?php echo esc_attr($this->get_id() . $key); ?>">
                                            <?php echo esc_html($item['accordion_title']); ?>
                                            <span class="accordion-btn"></span>
                                        </button>
                                    </h2>
                                    <div id="collapseOne-<?php echo esc_attr($this->get_id() . $key); ?>"
                                        class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
                                        data-bs-parent="#accordionExample-<?php echo esc_attr($this->get_id()); ?>">
                                        <div class="accordion-body">
                                            <p><?php echo tp_kses($item['accordion_description']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>

        <?php endif;
    }
}
$widgets_manager->register(new TP_FAQ());