<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Control_Media;

use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Hero_Online extends Widget_Base
{

    use \TPCore\Widgets\TP_Style_Trait;
    use \TPCore\Widgets\TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-hero-online';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Hero Online', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        // layout Panel
        $this->tp_design_layout('Layout Style', 2);

        // Hero title/content
        $this->start_controls_section(
            'tp_hero_online_sec',
            [
                'label' => esc_html__('Content', 'tpcore'),
            ]
        );

        $this->add_control(
            'tp_hero_online_image',
            [
                'label' => esc_html__('Choose Main Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        $this->add_control(
            'tp_hero_online_background',
            [
                'label' => esc_html__('Background Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );

        $this->add_control(
            'tp_hero_online_subtitle',
            [
                'label' => esc_html__('Sub Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Subtitle Here', 'tpcore'),
                'placeholder' => esc_html__('Type Heading Text', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tp_hero_online_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('TP Title Here', 'tpcore'),
                'placeholder' => esc_html__('Type Heading Text', 'tpcore'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'tp_hero_online_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h2',
            ]
        );

        $this->add_control(
            'tp_hero_online_description',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('This is description text here.', 'tpcore'),
                'placeholder' => esc_html__('Type section description here', 'tpcore'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]

            ]
        );
        $this->end_controls_section();

        // button
        $this->start_controls_section(
            'tp_hero_online_button_sec',
            [
                'label' => esc_html__('Button', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        $this->add_control(
            'tp_hero_online_button_text',
            [
                'label' => esc_html__('Button text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Default Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );

        tp_render_links_controls($this, 'online_url');

        $this->add_control(
            'tp_hero_online_button_video_heading',
            [
                'label' => esc_html__('Video Button', 'tpcore'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'tp_hero_online_button_video_url',
            [
                'label' => esc_html__('Video Url', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Default Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tp_hero_online_instructor_sec',
            [
                'label' => esc_html__('Instructor', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'tp_hero_online_instructor_switcher',
            [
                'label' => esc_html__('Show Instructor', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tpcore'),
                'label_off' => esc_html__('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tp_hero_online_instructor_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Instructor', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
                'condition' => [
                    'tp_hero_online_instructor_switcher' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'tp_hero_online_instructor_media',
            [
                'label' => esc_html__('Instructor Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_hero_online_instructor_switcher' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'tp_hero_online_instructor_number',
            [
                'label' => esc_html__('Instructor number', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('100+', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
                'condition' => [
                    'tp_hero_online_instructor_switcher' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'tp_hero_online_instructor_desc',
            [
                'label' => esc_html__('Instructor Description', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Description', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
                'condition' => [
                    'tp_hero_online_instructor_switcher' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tp_hero_online_shape_sec',
            [
                'label' => esc_html__('Shape', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'tp_hero_online_shape_top_left',
            [
                'label' => esc_html__('Top Left', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        $this->add_responsive_control(
            'tp_hero_online_shape_bottom_left',
            [
                'label' => esc_html__('bottom Left', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        $this->add_responsive_control(
            'tp_hero_online_shape_thumbnail_top',
            [
                'label' => esc_html__('Thumbnail Top', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        $this->add_responsive_control(
            'tp_hero_online_shape_thumbnail_middle',
            [
                'label' => esc_html__('Thumbnail Middle', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );
        $this->add_responsive_control(
            'tp_hero_online_shape_thumbnail_bottom',
            [
                'label' => esc_html__('Thumbnail Bottom', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        // layout 3 shape 

        $this->add_responsive_control(
            'tp_hero_online_shape_2_left_thumb',
            [
                'label' => esc_html__('Left Thumbnail', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );
        $this->add_responsive_control(
            'tp_hero_online_shape_2_left_thumb_shape',
            [
                'label' => esc_html__('Left Thumbnail Shape', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );
        $this->add_responsive_control(
            'tp_hero_online_shape_2_right_thumb',
            [
                'label' => esc_html__('Right Thumbnail', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );

        $this->add_responsive_control(
            'tp_hero_online_shape_2_right_thumb_top_left',
            [
                'label' => esc_html__('Right Thumbnail Top Left', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );

        $this->add_responsive_control(
            'tp_hero_online_shape_2_right_thumb_top_right',
            [
                'label' => esc_html__('Right Thumbnail Top Right', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );

        $this->add_responsive_control(
            'tp_hero_online_shape_2_right_thumb_top_bottom',
            [
                'label' => esc_html__('Right Thumbnail Top Bottom', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tp_hero_online_shape_2_search_sec',
            [
                'label' => esc_html__('Search', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );

        $this->add_control(
            'tp_hero_online_shape_2_search_switcher',
            [
                'label' => esc_html__('Show Search ?', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tpcore'),
                'label_off' => esc_html__('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tp_hero_online_shape_2_search_placeholder_text',
            [
                'label' => esc_html__('Place', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Default Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );

        $this->end_controls_section();


        // info box area 
        $this->start_controls_section(
            'tp_hero_online_shape_2_info_sec',
            [
                'label' => esc_html__('Info Box', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                ]
            ]
        );

        $this->add_control(
            'tp_hero_online_shape_2_left_info',
            [
                'label' => esc_html__('Left Info', 'tpcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        tp_render_icon_controls($this, 'left_info_icon');

        $this->add_control(
            'tp_hero_online_shape_2_left_info_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Default Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );

        $this->add_control(
            'tp_hero_online_shape_2_left_info_desc',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Default Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );


        // right info 
        $this->add_control(
            'tp_hero_online_shape_2_right_info',
            [
                'label' => esc_html__('Right Info', 'tpcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        tp_render_icon_controls($this, 'right_info_icon');

        $this->add_control(
            'tp_hero_online_shape_2_right_info_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Default Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );

        $this->add_control(
            'tp_hero_online_shape_2_right_info_desc',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Default Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );

        $this->end_controls_section();

    }

    protected function style_tab_content()
    {
        $this->tp_section_style_controls('heading_online_section', 'Section - Style', '.tp-el-section');
        $this->tp_basic_style_controls('heading_online_subtitle', 'Section - Subtitle', '.tp-el-subtitle');
        $this->tp_basic_style_controls('heading_online_title', 'Section - Title', '.tp-el-title');
        $this->tp_basic_style_controls('heading_online_desc', 'Section - Description', '.tp-el-content', 'layout-1');
        $this->tp_link_controls_style('layout-1', 'btn1_style', 'Button', '.tp-els-btn');

        $this->tp_basic_style_controls('heading_online_instructor_title', 'Instructor Title', '.tp-el-ins-title');
        $this->tp_basic_style_controls('heading_online_instructor_number', 'Instructor Number', '.tp-el-ins-number');
        $this->tp_basic_style_controls('heading_online_instructor_desc', 'Instructor Description', '.tp-el-ins-desc');

        // icon box 
        $this->tp_basic_style_controls('heading_online_info_title', 'Info Title', '.tp-el-info-title');
        $this->tp_basic_style_controls('heading_online_info_desc', 'Info Description', '.tp-el-info-desc');
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $subtitle = $settings['tp_hero_online_subtitle'];
        $title = $settings['tp_hero_online_title'];
        $title_tag = $settings['tp_hero_online_title_tag'];
        $desc = $settings['tp_hero_online_description'];

        $this->add_render_attribute('title_args', 'class', 'tp-hero-6-title wow fadeInUp tp-el-title');
        $this->add_render_attribute('title_data', 'data-wow-delay', '.5s');


        $ins_title = $settings['tp_hero_online_instructor_title'];
        $ins_number = $settings['tp_hero_online_instructor_number'];
        $ins_desc = $settings['tp_hero_online_instructor_desc'];

        ?>
        <?php if ($settings['tp_design_style'] == 'layout-2'):

            $ins_img = tp_get_img($settings, 'tp_hero_online_instructor_media', 'full', false);
            if (!empty($settings['tp_hero_online_background']['url'])) {
                $img_bg = !empty($settings['tp_hero_online_background']['url']) ? $settings['tp_hero_online_background']['url'] : '';
            }

            $shape_2_left_thumb = tp_get_img($settings, 'tp_hero_online_shape_2_left_thumb', 'full', false);
            $shape_2_left_thumb_shape = tp_get_img($settings, 'tp_hero_online_shape_2_left_thumb_shape', 'full', false);
            $shape_2_right_thumb = tp_get_img($settings, 'tp_hero_online_shape_2_right_thumb', 'full', false);
            $shape_2_right_thumb_top_left = tp_get_img($settings, 'tp_hero_online_shape_2_right_thumb_top_left', 'full', false);
            $shape_2_right_thumb_top_right = tp_get_img($settings, 'tp_hero_online_shape_2_right_thumb_top_right', 'full', false);
            $shape_2_right_thumb_top_bottom = tp_get_img($settings, 'tp_hero_online_shape_2_right_thumb_top_bottom', 'full', false);

            $left_info_title = $settings['tp_hero_online_shape_2_left_info_title'];
            $left_info_desc = $settings['tp_hero_online_shape_2_left_info_desc'];

            $right_info_title = $settings['tp_hero_online_shape_2_right_info_title'];
            $right_info_desc = $settings['tp_hero_online_shape_2_right_info_desc'];

            ?>

            <div class="tp-hero-7-ptb tp-hero-2-bg fix pb-110 tp-el-section" style="background-image:url(<?php echo esc_url($img_bg); ?>)">
                <div class="tp-hero-7-group">
                    <?php if ($settings['tp_hero_online_instructor_switcher'] == 'yes'): ?>
                        <div class="tp-hero-6-user">
                            <span class="tp-el-ins-title"><?php echo tp_kses($ins_title); ?></span>
                            <div class="tp-hero-6-user-content d-flex align-items-center">
                                <div class="tp-hero-6-user-thumb">
                                    <img src="<?php echo esc_url($ins_img['tp_hero_online_instructor_media']); ?>"
                                        alt="<?php echo esc_attr($ins_img['tp_hero_online_instructor_media_alt']); ?>">
                                </div>
                                <div class="tp-hero-6-user-text">
                                    <p class="tp-el-ins-desc"><i class="tp-el-ins-number"><?php echo tp_kses($ins_number); ?></i> <br>
                                        <?php echo tp_kses($ins_desc); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="tp-hero-7-shape">
                    <div class="shape-1">
                        <img src="<?php echo esc_url($shape_2_right_thumb_top_right['tp_hero_online_shape_2_right_thumb_top_right']); ?>"
                            alt="<?php echo esc_attr($shape_2_right_thumb_top_right['tp_hero_online_shape_2_right_thumb_top_right_alt']); ?>">
                    </div>

                    <div class="shape-2">
                        <img src="<?php echo esc_url($shape_2_right_thumb_top_left['tp_hero_online_shape_2_right_thumb_top_left']); ?>"
                            alt="<?php echo esc_attr($shape_2_right_thumb_top_left['tp_hero_online_shape_2_right_thumb_top_left_alt']); ?>">
                    </div>
                    <div class="shape-3">
                        <img src="<?php echo esc_url($shape_2_right_thumb_top_bottom['tp_hero_online_shape_2_right_thumb_top_bottom']); ?>"
                            alt="<?php echo esc_attr($shape_2_right_thumb_top_bottom['tp_hero_online_shape_2_right_thumb_top_bottom_alt']); ?>">
                    </div>
                    <div class="shape-4">
                        <img src="<?php echo esc_url($shape_2_left_thumb['tp_hero_online_shape_2_left_thumb']); ?>"
                            alt="<?php echo esc_attr($shape_2_left_thumb['tp_hero_online_shape_2_left_thumb_alt']); ?>">
                    </div>
                    <div class="shape-5">
                        <img src="<?php echo esc_url($shape_2_right_thumb['tp_hero_online_shape_2_right_thumb']); ?>"
                            alt="<?php echo esc_attr($shape_2_right_thumb['tp_hero_online_shape_2_right_thumb_alt']); ?>">
                    </div>
                    <div class="shape-6">
                        <img src="<?php echo esc_url($shape_2_left_thumb_shape['tp_hero_online_shape_2_left_thumb_shape']); ?>"
                            alt="<?php echo esc_attr($shape_2_left_thumb_shape['tp_hero_online_shape_2_left_thumb_shape_alt']); ?>">
                    </div>
                </div>
                <div class="container">
                    <div class="tp-hero-7-wrap p-relative">
                        <div class="row justify-content-center">
                            <div class="col-xl-8">
                                <div class="tp-hero-7-content text-center">
                                    <?php if (!empty($subtitle)): ?>
                                        <span class="tp-hero-6-subtitle wow fadeInUp tp-el-subtitle" data-wow-delay=".3s"><svg
                                                xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15"
                                                fill="none">
                                                <path
                                                    d="M13.1291 14.5H0.525163C0.238074 14.5 0 14.2619 0 13.9748C0 13.6877 0.238074 13.4496 0.525163 13.4496H13.1291C13.4162 13.4496 13.6542 13.6877 13.6542 13.9748C13.6542 14.2619 13.4162 14.5 13.1291 14.5Z"
                                                    fill="#5956E9" />
                                                <path
                                                    d="M11.7432 1.53199C10.3848 0.173566 9.05439 0.138555 7.66096 1.53199L6.8137 2.37925C6.74368 2.44927 6.71567 2.56131 6.74368 2.65934C7.27584 4.51491 8.7603 5.99937 10.6159 6.53153C10.6439 6.53854 10.6719 6.54554 10.6999 6.54554C10.7769 6.54554 10.8469 6.51753 10.903 6.46151L11.7432 5.61425C12.4364 4.92804 12.7725 4.26283 12.7725 3.59062C12.7795 2.89741 12.4434 2.2252 11.7432 1.53199Z"
                                                    fill="#FFC221" />
                                                <path
                                                    d="M9.35439 7.16872C9.15133 7.07069 8.95527 6.97266 8.76621 6.86062C8.61217 6.7696 8.46512 6.67156 8.31807 6.56653C8.19904 6.48951 8.05899 6.37747 7.92595 6.26544C7.91195 6.25844 7.86293 6.21642 7.80692 6.16041C7.57584 5.96435 7.31676 5.71227 7.08569 5.43218C7.06469 5.41818 7.02968 5.36916 6.98066 5.30614C6.91064 5.22212 6.7916 5.08207 6.68657 4.92102C6.60254 4.81599 6.50451 4.66194 6.41348 4.50789C6.30145 4.31884 6.20342 4.12978 6.10539 3.93372C5.97686 3.65829 5.61537 3.57648 5.40045 3.79139L1.46295 7.72889C1.37192 7.81992 1.2879 7.99497 1.26689 8.11401L0.888773 10.7958C0.818751 11.272 0.951793 11.7201 1.24588 12.0212C1.49796 12.2663 1.84807 12.3993 2.22619 12.3993C2.31021 12.3993 2.39424 12.3923 2.47827 12.3783L5.1671 12.0002C5.29314 11.9792 5.46819 11.8952 5.55222 11.8042L9.49622 7.86016C9.70683 7.64954 9.6277 7.28715 9.35439 7.16872Z"
                                                    fill="#5956E9" />
                                            </svg> <?php echo tp_kses($subtitle); ?></span>
                                    <?php endif; ?>
                                    <?php
                                    if (!empty($title)):
                                        printf(
                                            '<%1$s %2$s %3$s>%4$s</%1$s>',
                                            tag_escape($title_tag),
                                            $this->get_render_attribute_string('title_args'),
                                            $this->get_render_attribute_string('title_data'),
                                            tp_kses($title)
                                        );
                                    endif;
                                    ?>
                                    <?php if($settings['tp_hero_online_shape_2_search_switcher'] == 'yes'):?>
                                    <div class="tp-hero-7-input p-relative wow fadeInUp" data-wow-delay=".7s">

                                    <form action="<?php print esc_url(home_url('/courses')); ?>">
                                        <input type="search" name="s" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php echo esc_attr($settings['tp_hero_online_shape_2_search_placeholder_text']);?>">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                                    fill="none">
                                                    <path
                                                        d="M21.9993 22L17.166 17.1667M19.7778 10.8889C19.7778 15.7981 15.7981 19.7778 10.8889 19.7778C5.97969 19.7778 2 15.7981 2 10.8889C2 5.97969 5.97969 2 10.8889 2C15.7981 2 19.7778 5.97969 19.7778 10.8889Z"
                                                        stroke="#5956E9" stroke-width="2.5" stroke-linecap="round"
                                                        stroke-linejoin="round" />
                                                </svg>
                                            </span>
                                        </form>

                                    </div>
                                <?php endif;?>
                                </div>
                                <div class="tp-hero-7-item-box d-flex justify-content-center wow fadeInUp" data-wow-delay=".9s">

                                    <div class="tp-hero-7-item d-flex">
                                        <div class="tp-hero-7-item-icon">
                                        <?php tp_render_signle_icon_html($settings, 'left_info_icon'); ?>
                                        </div>
                                        <div class="tp-hero-7-item-content">
                                            <span class="tp-el-info-title"><?php echo tp_kses($left_info_title);?></span>
                                            <p class="tp-el-info-desc"><?php echo tp_kses($left_info_desc);?></p>
                                        </div>
                                    </div>

                                    <div class="tp-hero-7-item d-flex">
                                        <div class="tp-hero-7-item-icon">
                                        <?php tp_render_signle_icon_html($settings, 'right_info_icon'); ?>
                                        </div>
                                        <div class="tp-hero-7-item-content">
                                            <span class="tp-el-info-title"><?php echo tp_kses($right_info_title);?></span>
                                            <p class="tp-el-info-desc"><?php echo tp_kses($right_info_desc);?></p>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php else:

            // thumbnail
            $img = tp_get_img($settings, 'tp_hero_online_image', 'full', false);
            $ins_img = tp_get_img($settings, 'tp_hero_online_instructor_media', 'full', false);

            $desc = $settings['tp_hero_online_description'];
            $button_text = $settings['tp_hero_online_button_text'];
            $video_url = $settings['tp_hero_online_button_video_url'];

            $attrs = tp_get_repeater_links_attr($settings, 'online_url');
            extract($attrs);

            $links_attrs = [
                'href' => $link,
                'target' => $target,
                'rel' => $rel,
            ];

            $shape_top_left = tp_get_img($settings, 'tp_hero_online_shape_top_left', 'full', false);
            $shape_bottom_left = tp_get_img($settings, 'tp_hero_online_shape_bottom_left', 'full', false);
            $shape_thumb_top = tp_get_img($settings, 'tp_hero_online_shape_thumbnail_top', 'full', false);
            $shape_thumb_middle = tp_get_img($settings, 'tp_hero_online_shape_thumbnail_middle', 'full', false);
            $shape_thumb_bottom = tp_get_img($settings, 'tp_hero_online_shape_thumbnail_bottom', 'full', false);

            ?>
            <div class="tp-hero-6-area lightblue-bg tp-hero-2-bg fix tp-el-section">
                <div class="container custom-container-1300">
                    <div class="tp-hero-6-wrap">
                        <div class="row align-items-end">
                            <div class="col-xxl-7 col-xl-6 col-lg-7 col-md-12">
                                <div class="tp-hero-6-content">
                                    <?php if (!empty($subtitle)): ?>
                                        <span class="tp-hero-6-subtitle wow fadeInUp tp-el-subtitle" data-wow-delay=".3s"><svg
                                                xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15"
                                                fill="none">
                                                <path
                                                    d="M13.1291 14.5H0.525163C0.238074 14.5 0 14.2619 0 13.9748C0 13.6877 0.238074 13.4496 0.525163 13.4496H13.1291C13.4162 13.4496 13.6542 13.6877 13.6542 13.9748C13.6542 14.2619 13.4162 14.5 13.1291 14.5Z"
                                                    fill="#5956E9" />
                                                <path
                                                    d="M11.7432 1.53199C10.3848 0.173566 9.05439 0.138555 7.66096 1.53199L6.8137 2.37925C6.74368 2.44927 6.71567 2.56131 6.74368 2.65934C7.27584 4.51491 8.7603 5.99937 10.6159 6.53153C10.6439 6.53854 10.6719 6.54554 10.6999 6.54554C10.7769 6.54554 10.8469 6.51753 10.903 6.46151L11.7432 5.61425C12.4364 4.92804 12.7725 4.26283 12.7725 3.59062C12.7795 2.89741 12.4434 2.2252 11.7432 1.53199Z"
                                                    fill="#FFC221" />
                                                <path
                                                    d="M9.35439 7.16872C9.15133 7.07069 8.95527 6.97266 8.76621 6.86062C8.61217 6.7696 8.46512 6.67156 8.31807 6.56653C8.19904 6.48951 8.05899 6.37747 7.92595 6.26544C7.91195 6.25844 7.86293 6.21642 7.80692 6.16041C7.57584 5.96435 7.31676 5.71227 7.08569 5.43218C7.06469 5.41818 7.02968 5.36916 6.98066 5.30614C6.91064 5.22212 6.7916 5.08207 6.68657 4.92102C6.60254 4.81599 6.50451 4.66194 6.41348 4.50789C6.30145 4.31884 6.20342 4.12978 6.10539 3.93372C5.97686 3.65829 5.61537 3.57648 5.40045 3.79139L1.46295 7.72889C1.37192 7.81992 1.2879 7.99497 1.26689 8.11401L0.888773 10.7958C0.818751 11.272 0.951793 11.7201 1.24588 12.0212C1.49796 12.2663 1.84807 12.3993 2.22619 12.3993C2.31021 12.3993 2.39424 12.3923 2.47827 12.3783L5.1671 12.0002C5.29314 11.9792 5.46819 11.8952 5.55222 11.8042L9.49622 7.86016C9.70683 7.64954 9.6277 7.28715 9.35439 7.16872Z"
                                                    fill="#5956E9" />
                                            </svg> <?php echo tp_kses($subtitle); ?></span>
                                    <?php endif; ?>
                                    <?php
                                    if (!empty($title)):
                                        printf(
                                            '<%1$s %2$s %3$s>%4$s</%1$s>',
                                            tag_escape($title_tag),
                                            $this->get_render_attribute_string('title_args'),
                                            $this->get_render_attribute_string('title_data'),
                                            tp_kses($title)
                                        );
                                    endif;
                                    ?>
                                    <?php if (!empty($desc)): ?>
                                        <p class="tp-el-content wow fadeInUp" data-wow-delay=".7s"><?php echo tp_kses($desc); ?></p>
                                    <?php endif; ?>
                                    <div class="tp-hero-6-btn-box d-flex align-items-center wow fadeInUp" data-wow-delay=".9s">
                                        <?php if (!empty($links_attrs['href'])): ?>
                                            <div class="tp-hero-6-btn">
                                                <a class="tp-btn-inner tp-el-btn" <?php echo tp_implode_html_attributes($links_attrs); ?>>
                                                    <?php echo tp_kses($button_text); ?>
                                                    <span>
                                                        <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M8.71533 1L13 5.28471L8.71533 9.56941" stroke="currentColor"
                                                                stroke-width="2" stroke-miterlimit="10" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                            <path d="M1 5.28473H12.88" stroke="currentColor" stroke-width="2"
                                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($video_url)): ?>
                                            <div class="tp-hero-6-video">
                                                <a class="video-border-animation popup-video" href="<?php echo esc_url($video_url); ?>">
                                                    <span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="12"
                                                            viewBox="0 0 11 12" fill="none">
                                                            <path
                                                                d="M0.0399028 0.755673C0.0421193 0.177043 0.67266 -0.187 1.17488 0.100395L10.2148 5.27351C10.717 5.56091 10.7142 6.2842 10.2098 6.57543L1.12999 11.8177C0.62556 12.1089 -0.00221065 11.7496 5.85292e-06 11.171L0.0399028 0.755673Z"
                                                                fill="#031F42" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xxl-5 col-xl-4 col-lg-5 col-md-6">
                                <div class="tp-hero-6-wrap p-relative wow fadeInUp" data-wow-delay=".5s">
                                    <div class="tp-hero-6-bg"></div>
                                    <div class="tp-hero-6-shape">
                                        <div class="shape-1">
                                            <img src="<?php echo esc_url($shape_thumb_top['tp_hero_online_shape_thumbnail_top']); ?>"
                                                alt="<?php echo esc_attr($shape_thumb_top['tp_hero_online_shape_thumbnail_top_alt']); ?>">
                                        </div>
                                        <div class="shape-2">
                                            <img src="<?php echo esc_url($shape_thumb_bottom['tp_hero_online_shape_thumbnail_bottom']); ?>"
                                                alt="<?php echo esc_attr($shape_thumb_bottom['tp_hero_online_shape_thumbnail_bottom_alt']); ?>">
                                        </div>
                                        <div class="shape-3">
                                            <img src="<?php echo esc_url($shape_thumb_middle['tp_hero_online_shape_thumbnail_middle']); ?>"
                                                alt="<?php echo esc_attr($shape_thumb_middle['tp_hero_online_shape_thumbnail_middle_alt']); ?>">
                                        </div>
                                    </div>
                                    <?php if ($settings['tp_hero_online_instructor_switcher'] == 'yes'): ?>
                                        <div class="tp-hero-6-user">
                                            <span class="tp-el-ins-title"><?php echo tp_kses($ins_title); ?></span>
                                            <div class="tp-hero-6-user-content d-flex align-items-center">
                                                <div class="tp-hero-6-user-thumb">
                                                    <img src="<?php echo esc_url($ins_img['tp_hero_online_instructor_media']); ?>"
                                                        alt="<?php echo esc_attr($ins_img['tp_hero_online_instructor_media_alt']); ?>">
                                                </div>
                                                <div class="tp-hero-6-user-text">
                                                    <p class="tp-el-ins-desc"><i class="tp-el-ins-number"><?php echo tp_kses($ins_number); ?></i> <br>
                                                        <?php echo tp_kses($ins_desc); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <div class="tp-hero-6-thumb">
                            <img src="<?php echo esc_url($img['tp_hero_online_image']); ?>"
                                alt="<?php echo esc_attr($img['tp_hero_online_image_alt']); ?>">
                        </div>
                    </div>
                </div>
                <div class="tp-hero-2-shape">
                    <div class="tp-hero-2-shape-2">
                        <img src="<?php echo esc_url($shape_top_left['tp_hero_online_shape_top_left']); ?>"
                            alt="<?php echo esc_attr($shape_top_left['tp_hero_online_shape_top_left_alt']); ?>">
                    </div>
                    <div class="tp-hero-2-shape-3">
                        <img src="<?php echo esc_url($shape_bottom_left['tp_hero_online_shape_bottom_left']); ?>"
                            alt="<?php echo esc_attr($shape_bottom_left['tp_hero_online_shape_bottom_left_alt']); ?>">
                    </div>
                </div>
            </div>

        <?php endif;
    }
}

$widgets_manager->register(new TP_Hero_Online());