<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Hero_Quran extends Widget_Base
{

    use \TPCore\Widgets\TP_Style_Trait;
    use \TPCore\Widgets\TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-hero-quran';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Hero Quran', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        // layout Panel
        $this->tp_design_layout('Layout Style', 1);


        // title/content
        $this->tp_section_title_render_controls('section', 'Section Title');


        //  main image
        $this->start_controls_section(
            'tp_hero_main_image_sec',
            [
                'label' => esc_html__('Main Image', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'tp_hero_main_image',
            [
                'label' => esc_html__('Main Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // shape image
        $this->add_control(
            'tp_hero_main_shape_image',
            [
                'label' => esc_html__('Shape Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Shape Image Section
        $this->start_controls_section(
            'tp_hero_online_shape_sec',
            [
                'label' => esc_html__('Shape Image Section', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'left_leap_image',
            [
                'label' => esc_html__('Left Leap', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_responsive_control(
            'tp_hero_shape_image',
            [
                'label' => esc_html__('Shape Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_responsive_control(
            'tp_hero_sun_image',
            [
                'label' => esc_html__('Sun Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();


        // Social Section
        $this->start_controls_section(
            'tp_social_sec',
            [
                'label' => esc_html__('Social', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tp_social_text',
            [
                'label' => esc_html__('Social Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Follow Us', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'repeater_condition',
            [
                'label' => __('Field condition', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'tpcore'),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'hero_social_link',
            [
                'label' => esc_html__('Link', 'tpcore'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        tp_rep_render_icon_controls($repeater, 'hero_social_btn_icon', 'style_1');

        $this->add_control(
            'tp_social_list',
            [
                'label' => esc_html__('Section Label', 'tpcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'hero_social_link' => 'url',
                    ],
                ],
                'title_field' => '{{{ hero_social_link.url }}}',
            ]
        );

        $this->end_controls_section();

        // button
        $this->start_controls_section(
            'tp_hero_online_button_sec',
            [
                'label' => esc_html__('Button', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        tp_render_icon_controls($this, 'button_icon');

        $this->add_control(
            'tp_button_text',
            [
                'label' => esc_html__('Button text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Button Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );

        tp_render_links_controls($this, 'button_url');

        $this->end_controls_section();

    }

    protected function style_tab_content()
    {
        $this->tp_section_style_controls('heading_online_section', 'Section - Style', '.tp-el-section');
        $this->tp_basic_style_controls('heading_online_subtitle', 'Section - Subtitle', '.tp-el-subtitle');
        $this->tp_basic_style_controls('heading_online_title', 'Section - Title', '.tp-el-title');
        $this->tp_basic_style_controls('heading_online_desc', 'Section - Description', '.tp-el-content', 'layout-1');
        $this->tp_link_controls_style('layout-1', 'btn1_style', 'Button', '.tp-el-btn');

        // icon box 
        $this->tp_basic_style_controls('heading_online_info_title', 'Social Title', '.tp-el-social-title');
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $subtitle = $settings['tp_section_sub_title'];
        $title = $settings['tp_section_title'];
        $title_tag = $settings['tp_section_title_tag'];
        $desc = $settings['tp_section_description'];

        $this->add_render_attribute('title_args', 'class', 'tp-hero-quran-title mb-20 tp-el-title wow fadeInUp');
        $this->add_render_attribute('title_args', 'data-delay', '.5s');

        ?>
        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>

        <?php else:

            // thumbnail
            $img = tp_get_img($settings, 'tp_hero_sun_image', 'full', false);
            $img2 = tp_get_img($settings, 'tp_hero_main_image', 'full', false);
            $img3 = tp_get_img($settings, 'tp_hero_main_shape_image', 'full', false);
            $img4 = tp_get_img($settings, 'left_leap_image', 'full', false);
            $img5 = tp_get_img($settings, 'tp_hero_shape_image', 'full', false);


            $button_text = $settings['tp_button_text'];

            $attrs = tp_get_repeater_links_attr($settings, 'button_url');
            extract($attrs);

            $links_attrs = [
                'href' => $link,
                'target' => $target,
                'rel' => $rel,
                'class' => 'tp-quran-btn tp-quran-btn-lg tp-el-btn wow fadeInUp'
            ];

            ?>

            <!-- hero-area-start -->
            <div class="tp-hero-quran-wrap p-relative bg-position z-index-1 tp-el-section">

                <?php if (!empty($img4['left_leap_image'])): ?>
                    <img class="tp-hero-quran-shape-3 d-none d-xl-block" data-depth="0.3"
                        src="<?php echo esc_url($img4['left_leap_image']); ?>" alt="">
                <?php endif; ?>

                <?php if (!empty($img5['tp_hero_shape_image'])): ?>
                    <img class="tp-hero-quran-shape-4 d-none d-xl-block" src="<?php echo esc_url($img5['tp_hero_shape_image']); ?>"
                        alt="">
                <?php endif; ?>

                <div class="container">
                    <div class="tp-hero-chef-social tp-hero-quran-social d-none d-xl-block">
                        <?php if (!empty($settings['tp_social_text'])): ?>
                            <span class="tp-el-social-title">
                                <?php echo tp_kses($settings['tp_social_text']); ?>
                            </span>
                        <?php endif; ?>

                        <ul>
                            <?php foreach ($settings['tp_social_list'] as $item): ?>
                                <li>
                                    <a href="<?php echo esc_url($item['hero_social_link']['url']); ?>">
                                        <?php tp_render_single_icon_html($item, 'rep_hero_social_btn_icon', ); ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="row align-items-end">
                        <div class="col-xl-6 col-lg-6">
                            <div class="tp-hero-quran-content p-relative">
                                <?php if (!empty($img['tp_hero_sun_image'])): ?>
                                    <img class="tp-hero-quran-shape d-none d-md-block"
                                        src="<?php echo esc_url($img['tp_hero_sun_image']); ?>" alt="">
                                <?php endif; ?>

                                <?php if (!empty($subtitle)): ?>
                                    <span class="tp-hero-quran-subtitle d-inline-block mb-10 tp-el-subtitle wow fadeInUp" data-wow-delay=".3s">
                                        <?php echo tp_kses($subtitle); ?>
                                    </span>
                                <?php endif; ?>

                                <?php
                                if (!empty($title)):
                                    printf(
                                        '<%1$s %2$s %3$s>%4$s</%1$s>',
                                        tag_escape($title_tag),
                                        $this->get_render_attribute_string('title_args'),
                                        $this->get_render_attribute_string('title_data'),
                                        tp_kses($title)
                                    );
                                endif;
                                ?>

                                <?php if (!empty($desc)): ?>
                                    <p class="tp-el-content tp-hero-quran-text mb-35 wow fadeInUp" data-wow-delay=".7s">
                                        <?php echo tp_kses($desc); ?>
                                    </p>
                                <?php endif; ?>

                                <?php if (!empty($links_attrs['href'])): ?>
                                    <a data-wow-delay=".9s" <?php echo tp_implode_html_attributes($links_attrs); ?>>
                                        <?php echo tp_kses($button_text); ?>
                                        <?php tp_render_signle_icon_html($settings, 'button_icon'); ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-xl-6 col-lg-6">
                            <div class="tp-hero-quran-thumb-wrap p-relative z-index-1">

                                <?php if (!empty($img3['tp_hero_main_shape_image'])): ?>
                                    <div class="tp-hero-quran-shape-2 p-absolute d-none d-xl-inline-block wow fadeInRight" data-wow-delay=".4s">
                                        <img src="<?php echo esc_url($img3['tp_hero_main_shape_image']); ?>" alt="">
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($img2['tp_hero_main_image'])): ?>
                                    <div class="tp-hero-quran-thumb ml-80 wow fadeInRight" data-wow-delay=".6s">
                                        <img class="w-100" src="<?php echo esc_url($img2['tp_hero_main_image']); ?>" alt="">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- hero-area-end -->
        <?php endif;
    }
}

$widgets_manager->register(new TP_Hero_Quran());