<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;

if (!defined('ABSPATH'))
	exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Image_Content_Box extends Widget_Base
{

	use \TPCore\Widgets\TP_Style_Trait;
	use \TPCore\Widgets\TP_Animation_Trait;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'tp-image-content-box';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('Image Content Box', 'tpcore');
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['tpcore'];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends()
	{
		return ['tpcore'];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

	protected function register_controls()
	{
		$this->register_controls_section();
		$this->style_tab_content();
	}

	protected function register_controls_section()
	{
		// layout Panel
		$this->tp_design_layout('Layout Style', 3);

		// image
		$this->start_controls_section(
			'tp_image_animatedsection',
			[
				'label' => esc_html__('Image Section', 'tpcore'),

			]
		);

		$this->add_control(
			'tp_main_image',
			[
				'label' => esc_html__('Main Image', 'tpcore'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'tp_main_image2',
			[
				'label' => esc_html__('Main Image 2', 'tpcore'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'tp_shape_image',
			[
				'label' => esc_html__('Shape Image', 'tpcore'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'tp_design_style' => ['layout-1', 'layout-3'],
				],
			]
		);

		$this->add_control(
			'tp_shape_image2',
			[
				'label' => esc_html__('Shape Image 2', 'tpcore'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'tp_design_style' => ['layout-1', 'layout-3'],
				],
			]
		);
		$this->end_controls_section();

		// content
		$this->start_controls_section(
			'tps_section_id',
			[
				'label' => esc_html__('Content', 'tpcore'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'tp_experince_shape_svg',
			[
				'label' => esc_html__('Shape SVG Code', 'tpcore'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Add Your SVG Code', 'tpcore'),
				'label_block' => true,
				'condition' => [
					'tp_design_style' => ['layout-3'],
				],
			]
		);

		$this->add_control(
			'tp_experince_title',
			[
				'label' => esc_html__('Experince Title', 'tpcore'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Years of Experince', 'tpcore'),
				'label_block' => true,
				'condition' => [
					'tp_design_style' => ['layout-2', 'layout-3'],
				],
			]
		);

		$this->add_control(
			'tp_experince_number',
			[
				'label' => esc_html__('Experince Number', 'tpcore'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('14', 'tpcore'),
				'label_block' => true,
				'condition' => [
					'tp_design_style' => ['layout-1', 'layout-3'],
				],
			]
		);

		$this->add_control(
			'tp_number_suffix',
			[
				'label' => esc_html__('Number Suffix', 'tpcore'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('K', 'tpcore'),
				'label_block' => true,
				'condition' => [
					'tp_design_style' => ['layout-3'],
				],
			]
		);

		$this->end_controls_section();

		// creative animation
		$this->tp_creative_animation();
	}

	protected function style_tab_content()
	{

		$this->tp_basic_style_controls('icon_box_title', 'Title', '.tp-el-title');
		$this->tp_basic_style_controls('icon_box_number', 'Number', '.tp-el-number', ['layout-1', 'layout-3']);
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();

		$animation = $this->tp_animation_show($settings);
		?>

		<?php if ($settings['tp_design_style'] == 'layout-3'):
			$img = tp_get_img($settings, 'tp_main_image', 'full', false);
			$img2 = tp_get_img($settings, 'tp_main_image2', 'full', false);
			$img3 = tp_get_img($settings, 'tp_shape_image', 'full', false);
			$img4 = tp_get_img($settings, 'tp_shape_image2', 'full', false);

			$svg = $settings['tp_experince_shape_svg'];
			$title = $settings['tp_experince_title'];
			$number = $settings['tp_experince_number'];
			$suffix = $settings['tp_number_suffix'];
			?>

			<div class="tp-chose-11-thumb mb-30 p-relative <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>

				<div class="tp-about-shape">

					<?php if (!empty($img3['tp_shape_image'])): ?>
						<div class="tp-about-shape-1">
							<img class="tp-about-quran-shape d-none d-xl-block" src="<?php echo esc_url($img3['tp_shape_image']); ?>"
								alt="">
						</div>
					<?php endif; ?>

					<?php if (!empty($img4['tp_shape_image2'])): ?>
						<div class="tp-about-shape-2">
							<img src="<?php echo esc_url($img4['tp_shape_image2']); ?>" alt="">
						</div>
					<?php endif; ?>
				</div>

				<?php if (!empty($img['tp_main_image'])): ?>
					<div class="thumb mr-120">
						<img class="w-100" src="<?php echo esc_url($img['tp_main_image']); ?>" alt="">
					</div>
				<?php endif; ?>

				<?php if (!empty($img2['tp_main_image2'])): ?>
					<div class="thumb-2 p-absolute">
						<img class="w-100" src="<?php echo esc_url($img2['tp_main_image2']); ?>" alt="">
					</div>
				<?php endif; ?>

				<div class="thumb-3 p-absolute">
					<div class="tp-chose-11-counter">
						<div class="tp-chose-11-counter-thumb p-relative">

							<?php if (!empty($svg)): ?>
								<?php echo tp_kses($svg); ?>
							<?php endif; ?>

							<div class="tp-chose-11-counter-content">

								<h4 class="tp-chose-11-counter-title tp-el-number">
									<i class="purecounter" data-purecounter-duration="2"
									data-purecounter-end="<?php echo esc_attr($number); ?>">0</i>
									<?php echo tp_kses($suffix); ?>
								</h4>

								<?php if (!empty($title)): ?>
									<span class="tp-el-title">
										<?php echo tp_kses($title); ?>
									</span>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-2'):
			$img = tp_get_img($settings, 'tp_main_image', 'full', false);
			$img2 = tp_get_img($settings, 'tp_main_image2', 'full', false);

			?>

			<div class="tp-chose-yoga-thumb p-relative <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<?php if (!empty($settings['tp_experince_title'])): ?>
					<span class="tp-chose-yoga-text tp-el-title">
						<?php echo tp_kses($settings['tp_experince_title']); ?>
					</span>
				<?php endif; ?>
				<?php if (!empty($img['tp_main_image'])): ?>
					<div class="thumb mr-100">
						<img class="w-100" src="<?php echo esc_url($img['tp_main_image']); ?>" alt="">
					</div>
				<?php endif; ?>
				<?php if (!empty($img2['tp_main_image2'])): ?>
					<div class="thumb-2 p-absolute" data-parallax='{"y": -160, "smoothness": 20}'>
						<img class="w-100" src="<?php echo esc_url($img2['tp_main_image2']); ?>" alt="">
					</div>
				<?php endif; ?>
			</div>
		<?php else:
			$img = tp_get_img($settings, 'tp_main_image', 'full', false);
			$img2 = tp_get_img($settings, 'tp_main_image2', 'full', false);
			$img3 = tp_get_img($settings, 'tp_shape_image', 'full', false);
			$img4 = tp_get_img($settings, 'tp_shape_image2', 'full', false);
			?>

			<div class="tp-about-quran-thumb-wrap mb-30 p-relative z-index-1 <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>

				<?php if (!empty($img3['tp_shape_image'])): ?>
					<img class="tp-about-quran-shape d-none d-xl-block" src="<?php echo esc_url($img3['tp_shape_image']); ?>" alt="">
				<?php endif; ?>

				<?php if (!empty($img4['tp_shape_image2'])): ?>
					<img class="tp-about-quran-shape-2 d-none d-xl-block" src="<?php echo esc_url($img4['tp_shape_image2']); ?>" alt="">
				<?php endif; ?>

				<div class="tp-about-quran-counter d-flex align-items-center">

					<?php if (!empty($settings['tp_experince_number'])): ?>
						<h2 class="mr-10 tp-el-number">
							<?php echo tp_kses($settings['tp_experince_number']); ?>
						</h2>
					<?php endif; ?>

					<?php if (!empty($settings['tp_experince_title'])): ?>
						<span class="tp-el-title">
							<?php echo tp_kses($settings['tp_experince_title']); ?>
						</span>
					<?php endif; ?>
				</div>

				<?php if (!empty($img2['tp_main_image2'])): ?>
					<div class="tp-about-quran-thumb">
						<img class="w-100" src="<?php echo esc_url($img2['tp_main_image2']); ?>" alt="">
					</div>
				<?php endif; ?>

				<?php if (!empty($img['tp_main_image'])): ?>
					<div class="tp-about-quran-thumb-2" data-parallax='{"y": -50, "smoothness": 20}'>
						<img class="w-100" src="<?php echo esc_url($img['tp_main_image']); ?>" alt="">
					</div>
				<?php endif; ?>
			</div>

		<?php endif;
	}
}

$widgets_manager->register(new TP_Image_Content_Box());
