<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Skill_Tab extends Widget_Base
{

    use \TPCore\Widgets\TP_Style_Trait;
    use \TPCore\Widgets\TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-skill-tab';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Skill Tab', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }


    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }
    protected function register_controls_section()
    {

        // layout section
        $this->tp_design_layout('Layout', 1);


        // section title 
        $this->tp_section_title_render_controls('tab_section_heading', 'Section Heading', 'layout-1');


        // About Tab group
        $this->start_controls_section(
            'tp_about_tab_rep_section',
            [
                'label' => esc_html__('About List', 'tpcore'),
                'description' => esc_html__('Control all the style settings from Style tab', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tp_shape_switcher',
            [
                'label' => esc_html__('Image shape', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'tpcore'),
                'label_off' => esc_html__('No', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
                'condition' => [
                    'tp_design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'tp_skill_shape_img',
            [
                'label' => esc_html__('Shape Left Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_shape_switcher' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'tp_content_shape_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __('Image Content Shape', 'tpcore'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'repeater_condition',
            [
                'label' => __('Field condition', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'tpcore'),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'tp_about_tab_active',
            [
                'label' => esc_html__('Active This', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'tpcore'),
                'label_off' => esc_html__('No', 'tpcore'),
                'return_value' => 'yes',
                'default' => 0,
                'separator' => 'before',
            ]
        );

        $repeater->start_controls_tabs(
            'tp_about_tab_tabs'
        );

        // tab heading 
        $repeater->start_controls_tab(
            'tp_about_tab_normal_tab',
            [
                'label' => esc_html__('Heading', 'tpcore'),
            ]
        );

        $repeater->add_control(
            'tp_about_tab_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Title here', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tp_about_tab_desc',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Description here', 'tpcore'),
                'label_block' => true,
                'rows' => 5,
            ]
        );

        $repeater->end_controls_tab();


        // Tab content 
        $repeater->start_controls_tab(
            'tp_about_content_tab',
            [
                'label' => esc_html__('Content', 'tpcore'),
            ]
        );

        $repeater->add_control(
            'tp_about_content_tab_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __('Main Image', 'tpcore'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'tp_content_video_link',
            [
                'label' => esc_html__('Video Link', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('https://www.youtube.com/watch?v=SHptCWeDjD4', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->end_controls_tab();

        $repeater->end_controls_tabs();

        $this->add_control(
            'tp_about_lists',
            [
                'label' => esc_html__('About Tab List', 'tpcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tp_about_tab_title' => esc_html__('Gorki Campus', 'tpcore'),
                    ],
                    [
                        'tp_about_tab_title' => esc_html__('Skolkovo Campus', 'tpcore')
                    ],
                    [
                        'tp_about_tab_title' => esc_html__('Saint Petersburg Campus', 'tpcore')
                    ]
                ],
                'title_field' => '{{{ tp_about_tab_title }}}',
            ]
        );

        $this->end_controls_section();
    }

    // style_tab_content
    protected function style_tab_content()
    {
        $this->tp_section_style_controls('heading_online_section', 'Section - Style', '.tp-el-section');
        $this->tp_basic_style_controls('about_sec_title', 'Heading Title', '.tp-el-sec-title', 'layout-1');
        $this->tp_basic_style_controls('about_tab_subtitle', 'Heading Description', '.tp-el-sec-subtitle', 'layout-1');
        $this->tp_basic_style_controls('about_tab_title', 'Tab Title', '.tp-el-tab-title');
        $this->tp_basic_style_controls('about_sec_content', 'Tab Content', '.tp-el-tab-content');
        $this->tp_link_controls_style('', 'btn1_style', 'Tab Button', '.tp-els-btn', );

    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>

            <div class="tp-campus-student-content">
                <div class="tab-content" id="myTabContent">
                    <?php foreach ($settings['tp_about_lists'] as $key => $item):

                        $active_show = $item['tp_about_tab_active'] ? 'active show' : NULL;

                        // thumbnail
                        $img = tp_get_img($item, 'tp_about_content_tab_image', 'content_thumb');
                        $content_img = tp_get_img($item, 'tp_about_content_item_image', 'content_thumb');

                        $tp_button_title = $item['tp_about_content_tab_btn_title'];
                        $tp_address = $item['tp_about_tab_content'];

                        ?>
                        <div class="tab-pane fade <?php echo esc_attr($active_show); ?>" id="home-<?php echo esc_attr($key + 1); ?>"
                            role="tabpanel" aria-labelledby="home-tab-<?php echo esc_attr($key + 1); ?>">
                            <div class="tp-campus-student-wrap p-relative">

                                <?php if (!empty($img['tp_about_content_tab_image'])): ?>
                                    <div class="tp-campus-student-thumb">
                                        <img src="<?php echo esc_url($img['tp_about_content_tab_image']) ?>"
                                            alt="<?php echo esc_url($img['tp_about_content_tab_image_alt']) ?>">
                                    </div>
                                <?php endif; ?>


                                <div class="tp-campus-student-item">

                                    <?php if (!empty($item['tp_about_content_tab_title'])): ?>
                                        <h4 class="tp-campus-student-item-title tp-el-tab-title">
                                            <?php echo esc_html($item['tp_about_content_tab_title']); ?>
                                        </h4>
                                    <?php endif; ?>

                                    <?php if (!empty($item['tp_about_tab_content'])): ?>
                                        <p class="tp-el-tab-content">
                                            <?php echo esc_html($item['tp_about_tab_content']); ?>
                                        </p>
                                    <?php endif; ?>

                                    <?php if (!empty($content_img['tp_about_content_item_image'])): ?>
                                        <div class="tp-campus-student-item-thumb">
                                            <img src="<?php echo esc_url($content_img['tp_about_content_item_image']) ?>"
                                                alt="<?php echo esc_url($content_img['tp_about_content_item_image_alt']) ?>">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>

            <div class="tp-campus-student-list">
                <ul class="nav nav-tabs " id="myTab" role="tablist">
                    <?php foreach ($settings['tp_about_lists'] as $key => $item):

                        $active_title = $item['tp_about_tab_active'] ? 'active' : NULL;
                        $tp_title = $item['tp_about_tab_title'];
                        ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link tp-els-btn <?php echo esc_attr($active_title); ?>"
                                id="home-tab-<?php echo esc_attr($key + 1); ?>" data-bs-toggle="tab"
                                data-bs-target="#home-<?php echo esc_attr($key + 1); ?>" type="button" role="tab" aria-controls="home"
                                aria-selected="true"><?php echo esc_html($tp_title); ?></button>
                        </li>
                    <?php endforeach; ?>

                </ul>
            </div>

        <?php else:
            $img = tp_get_img($settings, 'tp_skill_shape_img', 'full', false);
            $img2 = tp_get_img($settings, 'tp_content_shape_image', 'full', false);

            $this->add_render_attribute('title_args', 'class', 'tp-chef-section-title mb-30 tp-el-sec-title');

            $tp_shape_switcher = $settings['tp_shape_switcher'];
            ?>

            <!-- tp-skill-area-start -->
            <div class="tp-skill-area p-relative pt-140 tp-el-section">
                <?php if ($tp_shape_switcher): ?>
                    <div class="tp-skill-chef-shape d-none d-xxl-block" data-parallax='{"y": 100, "smoothness": 30}'>
                        <img src="<?php echo esc_url($img['tp_skill_shape_img']); ?>" alt="">
                    </div>
                <?php endif ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="tp-skill-chef-wrap mb-30 wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">

                                <?php if (!empty($settings['tp_tab_section_heading_sub_title'])): ?>
                                    <span class="tp-chef-section-subtitle d-inline-block mb-15 tp-el-sec-subtitle">
                                        <?php echo tp_kses($settings['tp_tab_section_heading_sub_title']); ?>
                                    </span>
                                <?php endif; ?>

                                <?php
                                if (!empty($settings['tp_tab_section_heading_title'])):
                                    printf(
                                        '<%1$s %2$s>%3$s</%1$s>',
                                        tag_escape($settings['tp_tab_section_heading_title_tag']),
                                        $this->get_render_attribute_string('title_args'),
                                        tp_kses($settings['tp_tab_section_heading_title'])
                                    );
                                endif;
                                ?>

                                <div class="nav tp-skill-chef-tabwrap" id="nav-tab" role="tablist">
                                    <?php foreach ($settings['tp_about_lists'] as $key => $item):
                                        $active_title = $item['tp_about_tab_active'] ? 'active' : NULL;
                                        $tp_title = $item['tp_about_tab_title'];
                                        ?>
                                        <div class="nav-link tp-skill-chef-tabbtn pb-15 <?php echo esc_attr($active_title); ?>"
                                            id="home-tab-<?php echo esc_attr($key + 1); ?>" data-bs-toggle="tab"
                                            data-bs-target="#home-<?php echo esc_attr($key + 1); ?>" role="tab" aria-controls="nav-all"
                                            aria-selected="true">

                                            <h3 class="tp-skill-chef-title tp-el-tab-title">
                                                <?php echo esc_html($tp_title); ?>
                                            </h3>

                                            <?php if (!empty($item['tp_about_tab_desc'])): ?>
                                                <span class="tp-skill-chef-text">
                                                    <?php echo tp_kses($item['tp_about_tab_desc']); ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="tp-skill-chef-thumb-wrap ml-20 mb-30 p-relative z-index-1">
                                <div class="tp-skill-chef-thumb-bg z-index-m-1 d-none d-md-block">
                                    <img src="<?php echo esc_url($img2['tp_content_shape_image']); ?>" alt="">
                                </div>

                                <div class="tab-content z-index-11 p-relative" id="nav-tabContent">
                                    <?php foreach ($settings['tp_about_lists'] as $key => $item):
                                        $active_show = $item['tp_about_tab_active'] ? 'active show' : NULL;
                                        $img = tp_get_img($item, 'tp_about_content_tab_image', 'full', false);
                                        ?>
                                        <div class="tab-pane fade <?php echo esc_attr($active_show); ?> wow fadeInUp" data-wow-delay=".3s" id="home-<?php echo esc_attr($key + 1); ?>"
                                            role="tabpanel" aria-labelledby="home-tab-<?php echo esc_attr($key + 1); ?>" tabindex="0">
                                            <div class="tp-skill-chef-thumb p-relative">
                                                <img class="w-100" src="<?php echo esc_url($img['tp_about_content_tab_image']); ?>" alt="">
                                                <a class="tp-hero-chef-video popup-video mr-10"
                                                    href="<?php echo esc_url($item['tp_content_video_link']); ?>">
                                                    <span>
                                                        <i class="fa-solid fa-play"></i>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- tp-skill-area-end -->
        <?php endif;
    }
}
$widgets_manager->register(new TP_Skill_Tab());