<?php

namespace TPCore;

use Elementor\Controls_Manager;

/**
 * Class Plugin
 *
 * Main Plugin class
 * @since 1.2.0
 */
class TP_Core_Plugin
{

	/**
	 * Instance
	 *
	 * @since 1.2.0
	 * @access private
	 * @static
	 *
	 * @var TP_Core_Plugin The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.2.0
	 * @access public
	 *
	 * @return TP_Core_Plugin An instance of the class.
	 */
	public static function instance()
	{
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Add Category
	 */

	public function tp_core_elementor_category($manager)
	{
		$manager->add_category(
			'tpcore',
			array(
				'title' => esc_html__('TP Addons', 'tpcore'),
				'icon' => 'eicon-banner',
			)
		);
	}

	/**
	 * widget_scripts
	 *
	 * Load required plugin core files.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function widget_scripts()
	{
		wp_register_script('tpcore', plugins_url('/assets/js/hello-world.js', __FILE__), ['jquery'], false, true);
	}

	/**
	 * Editor scripts
	 *
	 * Enqueue plugin javascripts integrations for Elementor editor.
	 *
	 * @since 1.2.1
	 * @access public
	 */
	public function editor_scripts()
	{
		add_filter('script_loader_tag', [$this, 'editor_scripts_as_a_module'], 10, 2);

		wp_enqueue_script(
			'tpcore-editor',
			plugins_url('/assets/js/editor/editor.js', __FILE__),
			[
				'elementor-editor',
			],
			'1.2.1',
			true
		);
	}

	/**
	 * tp_enqueue_editor_scripts
	 */
	function tp_enqueue_editor_scripts()
	{
		wp_enqueue_style('tp-element-addons-editor', TPCORE_ADDONS_URL . 'assets/css/editor.css', [], '1.0');
	}

	/**
	 * tp_enqueue_scripts
	 */
	function tp_enqueue_scripts()
	{
		wp_enqueue_script('ac-learnpress-ajax', plugins_url('/assets/js/learnpress-ajax.js', __FILE__), ['jquery'], false, true);
	}

	/**
	 * Force load editor script as a module
	 *
	 * @since 1.2.1
	 *
	 * @param string $tag
	 * @param string $handle
	 *
	 * @return string
	 */
	public function editor_scripts_as_a_module($tag, $handle)
	{
		if ('tpcore-editor' === $handle) {
			$tag = str_replace('<script', '<script type="module"', $tag);
		}

		return $tag;
	}

	/**
	 * Register Widgets
	 *
	 * Register new Elementor widgets.
	 *
	 * @since 1.2.0
	 * @access public
	 *
	 * @param  \Elementor\Widgets_Manager $widgets_manager Elementor widgets manager.
	 */
	public function register_widgets($widgets_manager)
	{

		foreach ($this->tpcore_widget_list() as $key => $widgets) {
			foreach ($widgets as $widget) {
				$widget_file = TPCORE_ELEMENTS_PATH . '/' . $key . '/' . $widget . '.php';
				if (file_exists($widget_file)) {
					require_once $widget_file;
				}
			}
		}


		// for woocommerce plugin
		if (class_exists('woocommerce')) {
			foreach ($this->tpcore_widget_list_woo() as $key => $widgets) {
				foreach ($widgets as $widget) {
					$widget_file = TPCORE_ELEMENTS_PATH . '/' . $key . '/' . $widget . '.php';
					if (file_exists($widget_file)) {
						require_once $widget_file;
					}
				}
			}
		}

		// for event plugin
		if (class_exists('Wpeventin')) {
			foreach ($this->tpcore_widget_list_event() as $key => $widgets) {
				foreach ($widgets as $widget) {
					$widget_file = TPCORE_ELEMENTS_PATH . '/' . $key . '/' . $widget . '.php';
					if (file_exists($widget_file)) {
						require_once $widget_file;
					}
				}
			}
		}

		// for tutor lms plugin
		if (function_exists('tutor')) {
			foreach ($this->tpcore_widget_list_tutor_lms() as $key => $widgets) {
				foreach ($widgets as $widget) {
					$widget_file = TPCORE_ELEMENTS_PATH . '/' . $key . '/' . $widget . '.php';
					if (file_exists($widget_file)) {
						require_once $widget_file;
					}
				}
			}
		}

		// for tutor lms plugin
		if ( class_exists( 'LearnPress' ) ) {
			foreach ($this->tpcore_widget_list_lp_lms() as $key => $widgets) {
				foreach ($widgets as $widget) {
					$widget_file = TPCORE_ELEMENTS_PATH . '/' . $key . '/' . $widget . '.php';
					if (file_exists($widget_file)) {
						require_once $widget_file;
					}
				}
			}
		}

		// for tutor lms plugin
		if ( function_exists( 'masterstudy_lms_pre_get_document_title' ) ) {
			foreach ($this->tpcore_widget_list_ms_lms() as $key => $widgets) {
				foreach ($widgets as $widget) {
					$widget_file = TPCORE_ELEMENTS_PATH . '/' . $key . '/' . $widget . '.php';
					if (file_exists($widget_file)) {
						require_once $widget_file;
					}
				}
			}
		}
	}

	// tpcore_widget_list
	public function tpcore_widget_list()
	{
		return [
			// all header widgest
			'header' => [
				'header-builder',
				'header-builder-2',
				'header-builder-3',
				'header-builder-4',
				'header-builder-5',
				'header-builder-6',
				'header-ecommerce',
				'header-inner',
				'header-quran',
				'header-kitchen',
				'header-yoga',
				'header-lang-academy',
				'header-art-design',
				'header-marketing',
			],

			'header-master-study' => [
				'header-1',
				'header-2',
				'header-3',
				'header-4',
			],

			'header-side' => [
				'search',
			],

			'breadcrumb' => [
				'default-breadcrumb',
			],

			// all footer widgets
			'footer' => [
				'footer-social',
				'footer-links',
			],

			// all blog widgets
			'blog' => [
				'blog-post',
				'blog-hero',
				'blog-grid',
				'blog-post-list',
				'blog-category',
			],

			// all offcanvas widgets
			'offcanvas' => [
				'offcanvas-mobile-menu',
			],

			// menu widgets
			'menu' => [
				'home-demo',
			],

			// all buttons widgets
			'buttons' => [
				'button',
				'button-1',
			],

			'banner' => [
				'banner',
			],

			'instagram' => [
				'instagram',
			],

			'price' => [
				'price-box'
			],
			'faq' => [
				'faq',
			],

			'about' => [
				'about-year-slider',
				'about-tab',
				'about-team-single',
			],

			'common' => [
				'counter',
				'language',
				'academic-programs',
				'icon-box',
				'image-box',
				'kindergarten',
				'text-slider',
				'advanced-tab',
				'mission-sticky',
				'link-text',
				'link-list',
				'repeater-box',
				'progress',
				'image-circle',
				'art-design-process',
			],

			// all services widgets
			'services' => [
				'services',
			],

			// all heading widgets
			'heading' => [
				'heading',
			],

			// all video widgets
			'video' => [
				'video-play-mp4',
				'video-pop-up',
			],

			// all brand widgets
			'brand' => [
				'brand-slider',
			],

			// accordion
			'accordion' => [
				'yoga-accordion',
			],

			// all team widgets
			'team' => [
				'team-box',
			],

			// all testimonial widgets
			'testimonial' => [
				'testimonial-slider',
			],

			// all image widgets
			'image' => [
				'image',
				'image-shape',
				'image-content-box',
				'image-parallax',
			],

			// all hero widgets
			'hero' => [
				'hero-banner',
				'hero-slider',
				'hero-shop',
				'hero-online',
				'hero-quran',
				'hero-yoga',
				'hero-kitchen-coach',
				'hero-lang-academy',
				'hero-art-design',
				'hero-marketing',
			],

			'contact' => [
				'contact-plan',
				'contact-box',
			],
			'skill' => [
				'skill-tab',
			],

			// lanzu 
			'university' => [
				'campus-slider',
				'campus-link',
				'university-instructor',
				'university-tab'
			],
		];
	}

	// tpcore_widget_list_woo
	public function tpcore_widget_list_woo()
	{
		return [
			'woocommerce' => [
				'product-card',
			],
		];
	}

	// tpcore_widget_list_event
	public function tpcore_widget_list_event()
	{
		return [
			'event' => [
				'events',
			],
		];
	}

	// tpcore_widget_list_tutor_lms
	public function tpcore_widget_list_tutor_lms()
	{
		return [
			'course' => [
				'course-tab',
				'course-card',
				'course-instructor',
				'course-search',
				'course-slider',
			],
		];
	}

	// tpcore_widget_list_lp_lms
	public function tpcore_widget_list_lp_lms()
	{
		return [
			'learnpress' => [
				'lp-course-card',
				'lp-course-tab',
			],
		];
	}

	// tpcore_widget_list_ms_lms
	public function tpcore_widget_list_ms_lms()
	{
		return [
			'masterstudy' => [
				'ms-course-card',
				'ms-course-tab',
			],
		];
	}

	/**
	 * Add page settings controls
	 *
	 * Register new settings for a document page settings.
	 *
	 * @since 1.2.1
	 * @access private
	 */
	// private function add_page_settings_controls() {
	// 	require_once( __DIR__ . '/page-settings/manager.php' );
	// 	new Page_Settings();
	// }


	/**
	 * Register controls
	 *
	 * @param Controls_Manager $controls_Manager
	 */

	public function register_controls(Controls_Manager $controls_Manager)
	{
		include_once(TPCORE_ADDONS_DIR . '/controls/tpgradient.php');
		$tpgradient = 'TPCore\Elementor\Controls\Group_Control_TPGradient';
		$controls_Manager->add_group_control($tpgradient::get_type(), new $tpgradient());

		include_once(TPCORE_ADDONS_DIR . '/controls/tpbggradient.php');
		$tpbggradient = 'TPCore\Elementor\Controls\Group_Control_TPBGGradient';
		$controls_Manager->add_group_control($tpbggradient::get_type(), new $tpbggradient());
	}




	public function tp_add_custom_icons_tab($tabs = array())
	{

		// Append new icons
		$feather_icons = array(
			'feather-activity',
			'feather-airplay',
			'feather-alert-circle',
			'feather-alert-octagon',
			'feather-alert-triangle',
			'feather-align-center',
			'feather-align-justify',
			'feather-align-left',
			'feather-align-right',
		);

		$tabs['tp-feather-icons'] = array(
			'name' => 'tp-feather-icons',
			'label' => esc_html__('TP - Feather Icons', 'tpcore'),
			'labelIcon' => 'tp-icon',
			'prefix' => '',
			'displayPrefix' => 'tp',
			'url' => TPCORE_ADDONS_URL . 'assets/css/feather.css',
			'icons' => $feather_icons,
			'ver' => '1.0.0',
		);


		// Append flaticon fonts icons
		$flat_icons = array(
			'flaticon-next',
			'flaticon-diagonal-arrow',
			'flaticon-blueprint',
			'flaticon-renovation',
			'flaticon-building',
			'flaticon-interior-design',
			'flaticon-quality',
			'flaticon-worker',
			'flaticon-check',
			'flaticon-unfold',
			'flaticon-project-management',
			'flaticon-management',
			'flaticon-satisfaction',
			'flaticon-process',
			'flaticon-help',
			'flaticon-blueprint-1',
			'flaticon-play-button',
			'flaticon-3d-model',
			'flaticon-livingroom',
			'flaticon-laser-cutting-machine',
			'flaticon-renovation-1',
			'flaticon-3d',
			'flaticon-brickwall',
			'flaticon-color-adjustment',
			'flaticon-roof',
			'flaticon-worker-1',
			'flaticon-broken-house',
			'flaticon-solar-system',
			'flaticon-review',
			'flaticon-bed',
			'flaticon-relax',
			'flaticon-kitchen',
			'flaticon-electric-panel',
			'flaticon-heater',
			'flaticon-lamp',
			'flaticon-vimeo',
			'flaticon-facebook',
			'flaticon-instagram',
			'flaticon-twitter',
			'flaticon-youtube',
			'flaticon-location',
			'flaticon-message',
			'flaticon-mail',
			'flaticon-search',
			'flaticon-shopping-cart',
			'flaticon-down-arrow',
			'flaticon-share',
			'flaticon-tick',
			'flaticon-user',
			'flaticon-phone-call',
			'flaticon-view',
			'flaticon-tag',
			'flaticon-clock',
			'flaticon-heart',
			'flaticon-badge',
			'flaticon-solution',
			'flaticon-menu',

		);

		$tabs['tp-flat-icon-icons'] = array(
			'name' => 'tp-flat-icon-icons',
			'label' => esc_html__('TP - Flaticons', 'tpcore'),
			'labelIcon' => 'tp-icon',
			'prefix' => '',
			'displayPrefix' => 'tp',
			'url' => TPCORE_ADDONS_URL . 'assets/css/flaticon.css',
			'icons' => $flat_icons,
			'ver' => '1.0.0',
		);

		$fontawesome_icons = array(
			'angle-up',
			'check',
			'times',
			'calendar',
			'language',
			'shopping-cart',
			'bars',
			'search',
			'map-marker',
			'arrow-right',
			'arrow-left',
			'arrow-up',
			'arrow-down',
			'angle-right',
			'angle-left',
			'angle-up',
			'angle-down',
			'phone',
			'users',
			'user',
			'map-marked-alt',
			'trophy-alt',
			'envelope',
			'marker',
			'globe',
			'broom',
			'home',
			'bed',
			'chair',
			'bath',
			'tree',
			'laptop-code',
			'cube',
			'cog',
			'play',
			'trophy-alt',
			'heart',
			'truck',
			'user-circle',
			'map-marker-alt',
			'comments',
			'award',
			'bell',
			'book-alt',
			'book-open',
			'book-reader',
			'graduation-cap',
			'laptop-code',
			'music',
			'ruler-triangle',
			'user-graduate',
			'microscope',
			'glasses-alt',
			'theater-masks',
			'atom'
		);

		$tabs['tp-fontawesome-icons'] = array(
			'name' => 'tp-fontawesome-icons',
			'label' => esc_html__('TP - Fontawesome Pro Light', 'tpcore'),
			'labelIcon' => 'tp-icon',
			'prefix' => 'fa-',
			'displayPrefix' => 'fal',
			'url' => TPCORE_ADDONS_URL . 'assets/css/fontawesome-all.min.css',
			'icons' => $fontawesome_icons,
			'ver' => '1.0.0',
		);

		return $tabs;
	}

	/**
	 *  Plugin class constructor
	 *
	 * Register plugin action hooks and filters
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function __construct()
	{

		// Register widget scripts
		add_action('elementor/frontend/after_register_scripts', [$this, 'widget_scripts']);

		// Register widgets
		add_action('elementor/widgets/register', [$this, 'register_widgets']);

		// Register editor scripts
		add_action('elementor/editor/after_enqueue_scripts', [$this, 'editor_scripts']);

		add_action('elementor/elements/categories_registered', [$this, 'tp_core_elementor_category']);

		// Register custom controls
		add_action('elementor/controls/controls_registered', [$this, 'register_controls']);
		add_action('elementor/controls/register_style_controls', [$this, 'register_style_rols']);

		add_filter('elementor/icons_manager/additional_tabs', [$this, 'tp_add_custom_icons_tab']);

		// $this->tp_add_custom_icons_tab();

		add_action('elementor/editor/after_enqueue_scripts', [$this, 'tp_enqueue_editor_scripts']);
		// add_action('wp_enqueue_scripts', [$this, 'tp_enqueue_scripts']);

		// $this->add_page_settings_controls();

	}
}

// Instantiate Plugin Class
TP_Core_Plugin::instance();
