<?php
/**
 * 
 * Demo Imports
 */

function tp_ocdi_import_files()
{

  return array(
    array(
      'import_file_name' => 'Language Academy (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-12.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/language-academy/',
    ),
    array(
      'import_file_name' => 'Art & Design School (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-13.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/art-design-school/',
    ),
    array(
      'import_file_name' => 'Marketing (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-14.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/marketing/',
    ),
    array(
      'import_file_name' => 'University Classic (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-1.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/',
    ),
    array(
      'import_file_name' => 'Online Course (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-2.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/online-course/',
    ),
    array(
      'import_file_name' => 'Kids Education (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-3.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/kids-education/',
    ),
    array(
      'import_file_name' => 'Gym Coaching (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-4.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/gym-coaching/',
    ),
    array(
      'import_file_name' => 'High School (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-5.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/high-school/',
    ),
    array(
      'import_file_name' => 'Books Shop (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-6.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/books-shop/',
    ),
    array(
      'import_file_name' => 'Online Academy (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-7.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/online-academy/',
    ),
    array(
      'import_file_name' => 'Course Hub (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-8.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/course-hub/',
    ),
    array(
      'import_file_name' => 'Yoga Instructor (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-9.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/yoga-instructor/',
    ),
    array(
      'import_file_name' => 'Quran Learning (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-10.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/quran-learning/',
    ),
    array(
      'import_file_name' => 'Kitchen Coach (Tutor)',
      'categories'       => [ 'Tutor LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-11.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/kitchen-coach/',
    ),

    // rtl
    array(
      'import_file_name' => 'Acadia RTL Demo (Tutor)',
      'categories'       => [ 'Tutor RTL LMS' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/rtl/contents-demo-rtl.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/rtl/widget-settings-rtl.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/rtl/customizer-data-rtl.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-2-rtl.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-rtl/online-course/',
    ),
    
    // learnpress
    array(
      'import_file_name' => 'University Classic (LearnPress)',
      'categories'       => [ 'LearnPress' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-1.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/',
    ),
    array(
      'import_file_name' => 'Online Course (LearnPress)',
      'categories'       => [ 'LearnPress' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-2.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/online-course/',
    ),
    array(
      'import_file_name' => 'Kids Education (LearnPress)',
      'categories'       => [ 'LearnPress' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-3.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/kids-education/',
    ),
    array(
      'import_file_name' => 'Gym Coaching (LearnPress)',
      'categories'       => [ 'LearnPress' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-4.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/gym-coaching/',
    ),
    array(
      'import_file_name' => 'High School (LearnPress)',
      'categories'       => [ 'LearnPress' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-5.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/high-school/',
    ),
    array(
      'import_file_name' => 'Books Shop (LearnPress)',
      'categories'       => [ 'LearnPress' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-6.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/books-shop/',
    ),
    array(
      'import_file_name' => 'Online Academy (LearnPress)',
      'categories' => ['LearnPress'],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-7.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/online-academy/',
    ),
    array(
      'import_file_name' => 'Course Hub (LearnPress)',
      'categories' => ['LearnPress'],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-8.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/course-hub/',
    ),    
    
    // MasterStudy
    array(
      'import_file_name' => 'University Classic (MasterStudy)',
      'categories'       => [ 'MasterStudy' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-1.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-masterstudy/',
    ),
    array(
      'import_file_name' => 'Online Course (MasterStudy)',
      'categories'       => [ 'MasterStudy' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-2.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-masterstudy/online-course/',
    ),
    array(
      'import_file_name' => 'Kids Education (MasterStudy)',
      'categories'       => [ 'MasterStudy' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-3.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-masterstudy/kids-education/',
    ),
    array(
      'import_file_name' => 'Gym Coaching (MasterStudy)',
      'categories'       => [ 'MasterStudy' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-4.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-masterstudy/gym-coaching/',
    ),
    array(
      'import_file_name' => 'High School (MasterStudy)',
      'categories'       => [ 'MasterStudy' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-5.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-masterstudy/high-school/',
    ),
    array(
      'import_file_name' => 'Books Shop (MasterStudy)',
      'categories'       => [ 'MasterStudy' ],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-6.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-masterstudy/books-shop/',
    ),
    array(
      'import_file_name' => 'Online Academy (MasterStudy)',
      'categories' => ['MasterStudy'],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-7.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-masterstudy/online-academy/',
    ),
    array(
      'import_file_name' => 'Course Hub (MasterStudy)',
      'categories' => ['MasterStudy'],
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/ms/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-8.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-masterstudy/course-hub/',
    ),
  );
}
add_filter('ocdi/import_files', 'tp_ocdi_import_files');

function tp_ocdi_register_plugins( $plugins ) {
  $tp_theme_plugins = [];

  if ( isset( $_GET['step'] ) && $_GET['step'] === 'import' && isset( $_GET['import'] ) ) :

    // Tutor LMS
    if ( $_GET['import'] === '0' || $_GET['import'] === '1' || $_GET['import'] === '2' || $_GET['import'] === '3' || $_GET['import'] === '4' || $_GET['import'] === '5' || $_GET['import'] === '6' || $_GET['import'] === '7' || $_GET['import'] === '8' || $_GET['import'] === '9' || $_GET['import'] === '10' || $_GET['import'] === '11' || $_GET['import'] === '12' || $_GET['import'] === '13' || $_GET['import'] === '14' ) :
        $tp_theme_plugins = [
            [
                'name'     => 'Tutor LMS',
                'slug'     => 'tutor',
                'required' => true
            ],
        ];
    endif;

    // Tutor RTL LMS
    if ( $_GET['import'] === '14' ) :
        $tp_theme_plugins = [
            [
                'name'     => 'Tutor RTL LMS',
                'slug'     => 'rtl',
                'required' => true
            ],
        ];
    endif;

    // LearnPress
    if ( $_GET['import'] === '15' || $_GET['import'] === '16' || $_GET['import'] === '17' ||  $_GET['import'] === '18' || $_GET['import'] === '19' || $_GET['import'] === '20' || $_GET['import'] === '21' || $_GET['import'] === '22' ) :
        $tp_theme_plugins = [
            [
                'name'     => 'LearnPress LMS',
                'slug'     => 'learnpress',
                'required' => true
            ],
            [
                'name'     => 'LearnPress - Course Review',
                'slug'     => 'learnpress-course-review',
                'required' => true
            ],
        ];
    endif;

    // MasterStudy
    if ( $_GET['import'] === '23' || $_GET['import'] === '24' || $_GET['import'] === '25' || $_GET['import'] === '26' || $_GET['import'] === '27' || $_GET['import'] === '28' || $_GET['import'] === '29' || $_GET['import'] === '30' ) :
        $tp_theme_plugins = [
          [
              'name'     => 'MasterStudy LMS WordPress Plugin',
              'slug'     => 'masterstudy-lms-learning-management-system',
              'required' => true
          ],
        ];
    endif;

  endif; 
 
  return array_merge( $plugins, $tp_theme_plugins );
}
add_filter( 'ocdi/register_plugins', 'tp_ocdi_register_plugins' );


function tp_ocdi_page($tp_page_name = 'Home')
{
  $posts = get_posts(
    array(
      'post_type' => 'page',
      'title' => $tp_page_name,
      'post_status' => 'all',
      'posts_per_page' => 1,
      'no_found_rows' => true,
      'ignore_sticky_posts' => true,
      'update_post_term_cache' => false,
      'update_post_meta_cache' => false,
      'orderby' => 'post_date ID',
      'order' => 'ASC',
    )
  );

  if (!empty($posts)) {
    $page_got_by_title = $posts[0];
  } else {
    $page_got_by_title = null;
  }

  return $page_got_by_title;

}

// after demo imports
function tp_ocdi_after_import_setup($demo)
{
  $front_page_id = "";
  $blog_page_id = "";
  if ("University Classic (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('University Classic');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Online Course (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Course');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Kids Education (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Kids Education');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Gym Coaching (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Gym Coaching');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("High School (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('High School');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Books Shop (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Books Shop');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Online Academy (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Academy');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Course Hub (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Course Hub');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Yoga Instructor (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Yoga Instructor');
    $blog_page_id = tp_ocdi_page('Blog');
  }else if ("Quran Learning (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Quran Learning');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Kitchen Coach (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Kitchen Coach');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Language Academy (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Language Academy');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Art & Design School (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Art Design School');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Marketing (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Marketing');
    $blog_page_id = tp_ocdi_page('Blog');
  }  else if ("Acadia RTL Demo (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Course');
    $blog_page_id = tp_ocdi_page('Blog');
  }  elseif ("University Classic (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('University Classic');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Online Course (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Course');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Kids Education (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Kids Education');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Gym Coaching (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Gym Coaching');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("High School (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('High School');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Books Shop (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Books Shop');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Online Academy (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Academy');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Course Hub (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Course Hub');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("University Classic (MasterStudy)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('University Classic');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Online Course (MasterStudy)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Course');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Kids Education (MasterStudy)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Kids Education');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Gym Coaching (MasterStudy)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Gym Coaching');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("High School (MasterStudy)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('High School');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Books Shop (MasterStudy)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Books Shop');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Online Academy (MasterStudy)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Academy');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Course Hub (MasterStudy)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Course Hub');
    $blog_page_id = tp_ocdi_page('Blog');
  }

  update_option('show_on_front', 'page');
  update_option('page_on_front', $front_page_id->ID);
  update_option('page_for_posts', $blog_page_id->ID);

  // Assign menus to their locations.
  $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

  set_theme_mod(
    'nav_menu_locations',
    [
      'main-menu' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function in your theme.
    ]
  );

  // woocommerce default settings reset
  if (class_exists('woocommerce')) {
    update_option('woocommerce_shop_page_id', '970');                                                                          
    update_option('woocommerce_cart_page_id', '971');
    update_option('woocommerce_checkout_page_id', '972');
    update_option('woocommerce_myaccount_page_id', '973');
  }

  // Import Elementor kit data.
  $tp_kit_zip = trailingslashit(get_template_directory()) . 'sample-data/elementor-kit.zip';
  $import_export_module = \Elementor\Plugin::$instance->app->get_component('import-export');
  $import_settings['referrer'] = 'remote';
  $import_export_module->import_kit($tp_kit_zip, $import_settings);
}
add_action('ocdi/after_import', 'tp_ocdi_after_import_setup');

function tp_ocdi_plugin_page_setup($default_settings)
{
  $default_settings['parent_slug'] = 'themes.php';
  $default_settings['page_title'] = esc_html__('One Click Demo Import', 'one-click-demo-import');
  $default_settings['menu_title'] = esc_html__('Import Theme Demos', 'one-click-demo-import');
  $default_settings['capability'] = 'import';
  $default_settings['menu_slug'] = 'one-click-demo-import';

  return $default_settings;
}
add_filter('ocdi/plugin_page_setup', 'tp_ocdi_plugin_page_setup');