<?php
class Tp_Breadcrumb_Post
{

    private static $type = 'tp-breadcrumb';
    private static $slug;
    private static $name;
    private static $plural_name;

    public function __construct()
    {
        self::$name = __('Breadcrumb', 'tpcore');
        self::$slug = 'tp-breadcrumb';
        self::$plural_name = __('Breadcrumb', 'tpcore');
    }


    public static function register_custom_post_type()
    {
        $icon = TPCORE_ADDONS_URL . '/assets/img/themepure-logo.png';
        $labels = array(
            'name' => self::$name,
            'singular_name' => self::$name,
            'add_new' => sprintf(__('Add New Template', 'tpcore'), self::$name),
            'add_new_item' => sprintf(__('Add New %s', 'tpcore'), self::$name),
            'edit_item' => sprintf(__('Edit %s', 'tpcore'), self::$name),
            'new_item' => sprintf(__('New %s', 'tpcore'), self::$name),
            'all_items' => sprintf(__('All Templates', 'tpcore'), self::$plural_name),
            'view_item' => sprintf(__('View %s', 'tpcore'), self::$name),
            'search_items' => sprintf(__('Search %s', 'tpcore'), self::$name),
            'not_found' => sprintf(__('No %s found', 'tpcore'), strtolower(self::$name)),
            'not_found_in_trash' => sprintf(__('No %s found in Trash', 'tpcore'), strtolower(self::$name)),
            'parent_item_colon' => '',
            'menu_name' => self::$name,
        );


        $args = array(
            'labels' => $labels,
            'public' => true,
            'exclude_from_search' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'rewrite' => ['slug' => self::$slug],
            'menu_position' => 10,
            'supports' => ['title', 'editor', 'thumbnail', 'page-attributes', 'elementor'],
            'menu_icon' =>  esc_url($icon),
        );

        register_post_type(self::$type, $args);

        $cpt_support = get_option('elementor_cpt_support');
        if (!$cpt_support) {
            $cpt_support = ['page', 'post', 'tp-header', 'tp-footer', 'elementor_disable_color_schemes']; //create array of our default supported post types
            update_option('elementor_cpt_support', $cpt_support); //write it to the database
        }
    }

    

}


add_action('init', function(){
    new Tp_Breadcrumb_Post();
    Tp_Breadcrumb_Post::register_custom_post_type();
});