<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;



if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Art_Process extends Widget_Base
{

    use TP_Style_Trait, TP_Icon_Trait;
    use \TPCore\Widgets\TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-design-art-process';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Art Design Process', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        // layout Panel
        $this->tp_design_layout('Select Layout', 1);

        // title/content
        $this->tp_section_title_render_controls('section', 'Section Title', ['layout-1']);


        $this->start_controls_section(
            'tp_list_sec',
            [
                'label' => esc_html__('List Items', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tp_shape_enable',
            [
                'label' => esc_html__('Enable Shape Line?', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tpcore'),
                'label_off' => esc_html__('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->tp_single_icon_control('tp_shape_line', 'tp_shape_enable', 'yes');

        $repeater = new Repeater();

        $repeater->add_control(
            'repeater_condition',
            [
                'label' => __('Field condition', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'tpcore'),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'tp_rep_image',
            [
                'label' => esc_html__('Shape Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'tp_text_number',
            [
                'label' => esc_html__('Number', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('01', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tp_text_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Tp Slide Title', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tp_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'tpcore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'tpcore'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'tpcore'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'tpcore'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'tpcore'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'tpcore'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'tpcore'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $repeater->add_control(
            'tp_description',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Once your application is reviewed and approved, you’ll receive an official.', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_responsive_control(
            'tp_align',
            [
                'label' => esc_html__('Alignment', 'tpcore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'tpcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'tpcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'tpcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}} .tp-align' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_responsive_control(
            'tp_section_margin',
            [
                'label' => esc_html__('Iteam Margin', 'tpcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .tp-el-process-items' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $repeater->add_control(
            'tp_num_bg_color',
            [
                'label' => esc_html__('Number Bg Color', 'tpcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .tp-el-num-color' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tp_slider_list',
            [
                'label' => esc_html__('Text List', 'tpcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tp_text_title' => esc_html__('Art Direction', 'tpcore'),
                    ],

                ],
                'title_field' => '{{{ tp_text_title }}}',
            ]
        );

        $this->end_controls_section();

        // shape image controls
        $this->start_controls_section(
            'tp_shape_sec',
            [
                'label' => esc_html__('Shape Image Controls', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tp_theme_shape_switch',
            [
                'label' => esc_html__('Shape Switch', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tpcore'),
                'label_off' => esc_html__('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tp_shape_class_name',
            [
                'label' => esc_html__('Class Name Add', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Your class name', 'tpcore'),
            ]
        );

        $repeater->add_control(
            'tp_hero_shape_image',
            [
                'label' => esc_html__('Shape Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'tp_hero_shape_section',
            [
                'label' => esc_html__('Section Label', 'tpcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tp_shape_class_name' => esc_html__('Default Class', 'tpcore'),
                    ],
                ],
                'title_field' => '{{{ tp_shape_class_name }}}',
            ]
        );

        $this->end_controls_section();


        // button
        $this->start_controls_section(
            'tp_hero_online_button_sec',
            [
                'label' => esc_html__('Button', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-1'],
                ]
            ]
        );

        $this->add_control(
            'tp_button_text',
            [
                'label' => esc_html__('Button text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Button Text', 'tpcore'),
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
            ]
        );

        $this->add_control(
            'tp_theme_btn_icon_show',
            [
                'label' => esc_html__('Add Icon ?', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tpcore'),
                'label_off' => esc_html__('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->tp_single_icon_control('theme_btn', 'tp_theme_btn_icon_show', 'yes');

        tp_render_links_controls($this, 'button_url');

        $this->end_controls_section();

    }

    // style_tab_content
    protected function style_tab_content()
    {
        $this->tp_section_style_controls('section', 'Section - Style', '.tp-el-section');
        $this->tp_basic_style_controls('heading_title', 'Section - Title', '.tp-el-title');
        $this->tp_basic_style_controls('heading_subtitle', 'Section - Subtitle', '.tp-el-subtitle');
        $this->tp_basic_style_controls('heading_desc', 'Section - Description', '.tp-el-content');

        $this->tp_basic_style_controls('item_title', 'Item Title', '.tp-el-item-title');
        $this->tp_basic_style_controls('item_desc', 'Item Description', '.tp-el-item-desc');
        $this->tp_link_controls_style('', 'btn1_style', 'Button', '.tp-el-btn');
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $btn_id = 'theme_btn';
        ?>

        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>

        <?php else:
            $button_text = $settings['tp_button_text'];

            $attrs = tp_get_repeater_links_attr($settings, 'button_url');
            extract($attrs);

            $links_attrs = [
                'href' => $link,
                'target' => $target,
                'rel' => $rel,
                'class' => 'tp-el-btn'
            ];

            $this->add_render_attribute('title_args', 'class', 'tp-section-12-title mb-15 tp-el-title');
            ?>

            <!-- process-area-start -->
            <section class="process-area tp-process-3-bg fix tp-el-section">
                <div class="container">
                    <div class="row">
                        <div class="col-xxl-6 col-lg-8">
                            <div class="tp-process-3-wrap">
                                <div class="tp-section-2">
                                    <?php
                                    if (!empty($settings['tp_section_title'])):
                                        printf(
                                            '<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape($settings['tp_section_title_tag']),
                                            $this->get_render_attribute_string('title_args'),
                                            tp_kses($settings['tp_section_title'])
                                        );
                                    endif;
                                    ?>

                                    <?php if (!empty($settings['tp_section_description'])): ?>
                                        <p class="tp-el-content">
                                            <?php echo tp_kses($settings['tp_section_description']); ?>
                                        </p>
                                    <?php endif; ?>
                                </div>

                                <?php if (!empty($links_attrs['href'])): ?>
                                    <div class="tp-process-3-btn">
                                        <a <?php echo tp_implode_html_attributes($links_attrs); ?>>
                                            <?php echo tp_kses($button_text); ?>

                                            <?php tp_render_signle_icon_html($settings, 'theme_btn', 'icon'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="tp-process-3-wrapper">
                        <div class="row">

                            <?php foreach ($settings['tp_slider_list'] as $key => $item):
                                $this->add_render_attribute('item_title_args', 'class', 'tp-process-3-title tp-el-item-title');

                                $img = tp_get_img($item, 'tp_rep_image', 'full', false);
                                $number = $item['tp_text_number'];
                                $desc = $item['tp_description'];
                                ?>
                                <div class="col-lg-4 col-sm-6 elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>">
                                    <div class="tp-process-3-item tp-process-3-item-1 wow fadeInUp tp-align tp-el-process-items"
                                        data-wow-delay=".3s">
                                        <div class="tp-process-3-icon tp-process-12-icon">
                                            <?php if (!empty($number)): ?>
                                                <span class="blue tp-el-num-color">
                                                    <?php echo tp_kses($number); ?>
                                                </span>
                                            <?php endif; ?>

                                            <?php if (!empty($img['tp_rep_image'])): ?>
                                                <img src="<?php echo esc_url($img['tp_rep_image']); ?>" alt="">
                                            <?php endif; ?>
                                        </div>
                                        <div class="tp-process-3-content">

                                            <?php
                                            if (!empty($item['tp_text_title'])):
                                                printf(
                                                    '<%1$s %2$s><a %4$s>%3$s</a></%1$s>',
                                                    tag_escape($item['tp_title_tag']),
                                                    $this->get_render_attribute_string('item_title_args'),
                                                    tp_kses($item['tp_text_title']),
                                                    $this->get_render_attribute_string('tp-button-arg')
                                                );
                                            endif;
                                            ?>

                                            <?php if (!empty($item['tp_description'])): ?>
                                                <p class="tp-el-item-desc">
                                                    <?php echo tp_kses($item['tp_description']); ?>
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                        </div>

                        <?php if (!empty($settings['tp_shape_enable'])): ?>
                            <div class="tp-process-3-shape-1 wow fadeInUp" data-wow-delay=".5s">
                                <?php tp_render_signle_icon_html($settings, 'tp_shape_line', ''); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="tp-process-3-shape tp-process-12-shapes">

                    <?php foreach ($settings['tp_hero_shape_section'] as $key => $item):
                        $class = $item['tp_shape_class_name'];
                        $img = tp_get_img($item, 'tp_hero_shape_image', 'full', false);
                        ?>
                        <div class="<?php echo esc_attr($class); ?>">
                            <img src="<?php echo esc_url($img['tp_hero_shape_image']); ?>" alt="">
                        </div>
                    <?php endforeach; ?>

                    <?php if (!empty($settings['tp_theme_shape_switch'])): ?>
                        <div class="tp-process-3-shape-12"></div>
                        <div class="tp-process-3-shape-13"></div>
                        <div class="tp-process-3-shape-14"></div>
                        <div class="tp-process-3-shape-15"></div>
                        <div class="tp-process-3-shape-16"></div>
                        <div class="tp-process-3-shape-17"></div>
                    <?php endif; ?>
                </div>
            </section>


            <!-- process-area-end -->

        <?php endif;

    }
}

$widgets_manager->register(new TP_Art_Process());