<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Image_Circle extends Widget_Base
{

    use TP_Style_Trait, TP_Icon_Trait, TP_Offcanvas_Trait, TP_Menu_Trait, TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-image-circle';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Image Circle', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {
        $this->tp_design_layout('Layout', 1);

        $this->start_controls_section(
            'tp_image_box_section',
            [
                'label' => esc_html__('Image Circle', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tp_circle_image',
            [
                'label' => esc_html__('Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'tp_circle_text_image',
            [
                'label' => esc_html__('Text Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

    }

    // style_tab_content
    protected function style_tab_content()
    {
        $this->start_controls_section(
         'content_style_id',
             [
               'label' => esc_html__( 'Content Style', 'textdomain' ),
               'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
             ]
        );
                
        $this->add_control(
         'tp_content_bg_color',
         [
           'label'       => esc_html__( 'Content Background Color', 'textdomain' ),
           'type'     => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
           '{{WRAPPER}} .tp-el-content' => 'background: {{VALUE}}',
           ],
         ]
        );
        $this->end_controls_section();

    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>

        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>

        <?php else:

            $img = tp_get_img($settings, 'tp_circle_image', 'full', false);
            $img2 = tp_get_img($settings, 'tp_circle_text_image', 'full', false);
            ?>


            <div class="tp-testimonial-yoga-shape tp-el-content">
                <div class="p-relative text-center">
                    <div class="shape-img p-absolute">
                        <img src="<?php echo esc_url($img['tp_circle_image']); ?>" alt="">
                    </div>
                    <div class="shape-text">
                        <img src="<?php echo esc_url($img2['tp_circle_text_image']); ?>" alt="">
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php
    }
}

$widgets_manager->register(new TP_Image_Circle());