<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use \Etn\Utils\Helper as Helper;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly


/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Progress_bar extends Widget_Base
{

    use TP_Style_Trait, TP_Column_Trait, TP_Query_Trait, TP_Animation_Trait;
    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'progress-bar';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Progress Bar', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */



    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        $this->tp_design_layout('Select Layout', 1);

        $this->start_controls_section(
            'tp_progress_section_id',
            [
                'label' => esc_html__('Progress Bar', 'tpcore'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tp_progress_label',
            [
                'label'   => esc_html__('Label', 'tpcore'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Label Text', 'tpcore'),
                'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'tp_progress_number',
            [
                'label'   => esc_html__('Number', 'tpcore'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('70%', 'tpcore'),
                'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'tp_progress_section_list',
            [
                'label'       => esc_html__('Section Label', 'tpcore'),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'tp_progress_label'   => esc_html__('Label Text', 'tpcore'),
                    ],
                ],
                'title_field' => '{{{ tp_progress_label }}}',
            ]
        );

        $this->end_controls_section();


        // animation
        $this->tp_creative_animation(['layout-1', 'layout-3']);
    }

    protected function style_tab_content() {}
    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>

        <?php else:
            $animation = $this->tp_animation_show($settings);

        ?>

            <div class="tp-expertise-quran-progress-inner <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
                <?php foreach ($settings['tp_progress_section_list'] as $item) :
                    $title = $item['tp_progress_label'];
                    $number = $item['tp_progress_number'];
                ?>
                    <div class="tp-expertise-quran-progress-wrapper p-relative fix mb-25">

                        <?php if (!empty($title)): ?>
                            <div class="tp-expertise-quran-progress-title mb-10">
                                <?php echo tp_kses($title); ?>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($number)): ?>
                            <span class="tp-expertise-quran-counter">
                                <?php echo tp_kses($number); ?>
                            </span>
                        <?php endif; ?>

                        <div class="tp-expertise-quran-progress">
                            <div class="progress-bar wow slideInLeft" data-wow-duration="2s" data-wow-delay=".1s" role="progressbar" data-width="<?php echo esc_attr($number); ?>" aria-valuenow="<?php echo esc_attr($number); ?>" aria-valuemin="0" aria-valuemax="100">
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php
        endif; ?>
<?php
    }
}
$widgets_manager->register(new TP_Progress_bar());
