<?php

namespace TPCore\Widgets;

$img = tp_get_img($settings, 'tp_offcanvas_logo', 'full', false);

?>

<!-- offcanvas area start -->
<div class="offcanvas__area offcanvas__2">
   <div class="offcanvas__wrapper">
      <div class="offcanvas__close">
         <button class="offcanvas__close-btn offcanvas-close-btn">
            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
               <path d="M11 1L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                  stroke-linejoin="round" />
               <path d="M1 1L11 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                  stroke-linejoin="round" />
            </svg>
         </button>
      </div>
      <div class="offcanvas__content">
         <div class="offcanvas__top mb-70 d-flex justify-content-between align-items-center">
            <div class="offcanvas__logo logo tp-el-off-logo">
               <a href="<?php echo esc_url(home_url('/')); ?>">
                  <img src="<?php echo esc_url($img['tp_offcanvas_logo']); ?>"
                     alt="<?php echo esc_attr($img['tp_offcanvas_logo_alt']); ?>">
               </a>
            </div>
         </div>
         <div class="offcanvas-main">
            <?php
            if (!empty($settings['tp_offcanvas_template'])) {
               echo \Elementor\Plugin::$instance->frontend->get_builder_content($settings['tp_offcanvas_template']);
            }
            ?>
         </div>
      </div>
   </div>
</div>
<div class="body-overlay"></div>
<!-- offcanvas area end -->