<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
	exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Heading extends Widget_Base
{

	use \TPCore\Widgets\TP_Style_Trait;
	use \TPCore\Widgets\TP_Animation_Trait;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'tp-heading';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('Heading', 'tpcore');
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['tpcore'];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends()
	{
		return ['tpcore'];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

	protected function register_controls()
	{
		$this->register_controls_section();
		$this->style_tab_content();
	}

	protected function register_controls_section()
	{

		// layout Panel
		$this->tp_design_layout('Design Layout', 6);

		// title/content
		$this->tp_section_title_render_controls('section', 'Section Title');

		// animation
		$this->tp_creative_animation();
	}

	protected function style_tab_content()
	{
		$this->tp_section_style_controls('section', 'Section - Style', '.tp-el-section');
		$this->tp_basic_style_controls('heading_title', 'Section - Title', '.tp-el-title');
		$this->tp_basic_style_controls('heading_subtitle', 'Section - Subtitle', '.tp-el-subtitle');
		$this->tp_basic_style_controls('heading_desc', 'Section - Description', '.tp-el-content');
		$this->start_controls_section(
			'tp_heading_span_style',
			[
				'label' => esc_html__('Span', 'tpcore'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'tp_heading_span_color',
			[
				'label' => esc_html__('Span Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-title span' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'tp_heading_span_width',
			[
				'label' => esc_html__('Width', 'tpcore'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
				],
				'selectors' => [
					'{{WRAPPER}} .tp-el-span-image span img' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'tp_heading_span_spacing',
			[
				'label' => esc_html__('Horizontal Position', 'tpcore'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%',],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .tp-el-span-image span svg, .tp-el-span-image span img' => 'bottom: {{SIZE}}{{UNIT}} !important;'
				],
			]
		);

		$this->add_responsive_control(
			'tp_heading_left_spacing',
			[
				'label' => esc_html__('Virtical Position', 'tpcore'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%',],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .tp-el-span-image span svg, .tp-el-span-image span img' => 'left: {{SIZE}}{{UNIT}} !important;'
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		?>

		<?php if ($settings['tp_design_style'] == 'layout-6'):
			$animation = $this->tp_animation_show($settings);

			$this->add_render_attribute('title_args', 'class', 'tp-section-12-title mb-20 tp-el-title');
			?>

			<div class="tp-heading-12-title align-box <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>

				<?php if (!empty($settings['tp_section_sub_title'])): ?>
					<span class="tp-section-12-subtitle tp-el-subtitle">
						<?php echo tp_kses($settings['tp_section_sub_title']); ?>
					</span>
				<?php endif; ?>

				<?php
				if (!empty($settings['tp_section_title'])):
					printf(
						'<%1$s %2$s>%3$s</%1$s>',
						tag_escape($settings['tp_section_title_tag']),
						$this->get_render_attribute_string('title_args'),
						tp_kses($settings['tp_section_title'])
					);
				endif;
				?>

				<?php if (!empty($settings['tp_section_description'])): ?>
					<p class="tp-yoga-text tp-el-content">
						<?php echo tp_kses($settings['tp_section_description']); ?>
					</p>
				<?php endif; ?>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-5'):
			$animation = $this->tp_animation_show($settings);

			$this->add_render_attribute('title_args', 'class', 'tp-section-11-title mb-20 tp-el-title');
			?>

			<div class="tp-heading-11-title align-box <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>

				<?php if (!empty($settings['tp_section_sub_title'])): ?>
					<span class="tp-section-11-subtitle tp-el-subtitle">
						<?php echo tp_kses($settings['tp_section_sub_title']); ?>
					</span>
				<?php endif; ?>

				<?php
				if (!empty($settings['tp_section_title'])):
					printf(
						'<%1$s %2$s>%3$s</%1$s>',
						tag_escape($settings['tp_section_title_tag']),
						$this->get_render_attribute_string('title_args'),
						tp_kses($settings['tp_section_title'])
					);
				endif;
				?>

				<?php if (!empty($settings['tp_section_description'])): ?>
					<p class="tp-yoga-text tp-el-content mb-40">
						<?php echo tp_kses($settings['tp_section_description']); ?>
					</p>
				<?php endif; ?>
			</div>


		<?php elseif ($settings['tp_design_style'] == 'layout-4'):
			$animation = $this->tp_animation_show($settings);

			$this->add_render_attribute('title_args', 'class', 'tp-yoga-title tp-el-title');
			?>

			<div class="align-box <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<?php if (!empty($settings['tp_section_sub_title'])): ?>
					<span
						class="tp-yoga-subtitle tp-el-subtitle d-inline-block mb-10"><?php echo tp_kses($settings['tp_section_sub_title']); ?></span>
				<?php endif; ?>

				<?php
				if (!empty($settings['tp_section_title'])):
					printf(
						'<%1$s %2$s>%3$s</%1$s>',
						tag_escape($settings['tp_section_title_tag']),
						$this->get_render_attribute_string('title_args'),
						tp_kses($settings['tp_section_title'])
					);
				endif;
				?>

				<?php if (!empty($settings['tp_section_description'])): ?>
					<p class="tp-yoga-text tp-el-content mb-40">
						<?php echo tp_kses($settings['tp_section_description']); ?>
					</p>
				<?php endif; ?>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-3'):
			$animation = $this->tp_animation_show($settings);

			$this->add_render_attribute('title_args', 'class', 'tp-chef-section-title tp-el-title');
			?>
			<div class="tp-feature-chef-title-wrap tp-el-section align-box <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>

				<?php if (!empty($settings['tp_section_sub_title'])): ?>
					<span class="tp-chef-section-subtitle d-inline-block mb-15 tp-el-subtitle">
						<?php echo tp_kses($settings['tp_section_sub_title']); ?>
					</span>
				<?php endif; ?>

				<?php
				if (!empty($settings['tp_section_title'])):
					printf(
						'<%1$s %2$s>%3$s</%1$s>',
						tag_escape($settings['tp_section_title_tag']),
						$this->get_render_attribute_string('title_args'),
						tp_kses($settings['tp_section_title'])
					);
				endif;
				?>

				<?php if (!empty($settings['tp_section_description'])): ?>
					<p class="tp-el-content">
						<?php echo tp_kses($settings['tp_section_description']); ?>
					</p>
				<?php endif; ?>

			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-2'):
			$animation = $this->tp_animation_show($settings);

			$this->add_render_attribute('title_args', 'class', 'tp-section-title tp-el-acadia-title tp-el-title');
			?>

			<div class="tp-section tp-el-section mb-40 align-box <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>

				<?php if (!empty($settings['tp_section_sub_title'])): ?>
					<h5 class="tp-section-subtitle tp-el-subtitle">
						<?php echo tp_kses($settings['tp_section_sub_title']); ?>
					</h5>
				<?php endif; ?>

				<?php
				if (!empty($settings['tp_section_title'])):
					printf(
						'<%1$s %2$s>%3$s</%1$s>',
						tag_escape($settings['tp_section_title_tag']),
						$this->get_render_attribute_string('title_args'),
						tp_kses($settings['tp_section_title'])
					);
				endif;
				?>

				<?php if (!empty($settings['tp_section_description'])): ?>
					<p class="tp-el-content">
						<?php echo tp_kses($settings['tp_section_description']); ?>
					</p>
				<?php endif; ?>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-3'):
			$animation = $this->tp_animation_show($settings);
			$this->add_render_attribute('title_args', 'class', 'tp-section-title-40 tp-el-title ' . $animation['animation']);
			?>

			<div class="tp-service-2-title-box align-box">

				<?php if (!empty($settings['tp_heading3_sub_title'])): ?>
					<span class="tp-section-subtitle-3">
						<span>
							<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M12 0C12 3.0432 9.53292 5.5102 6.48975 5.5102C6.48975 2.46701 8.95677 0 12 0Z"
									fill="currentcolor" />
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M0.0231934 0.0231209C3.06639 0.0231209 5.5334 2.49015 5.5334 5.53333C2.4902 5.53333 0.0231934 3.0663 0.0231934 0.0231209Z"
									fill="currentcolor" />
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M6.48975 6.4898C9.53294 6.4898 12 8.95682 12 12C8.95675 12 6.48975 9.53297 6.48975 6.4898Z"
									fill="currentcolor" />
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M5.5102 6.48981C5.5102 9.533 3.04318 12 0 12C0 8.95681 2.46703 6.48981 5.5102 6.48981Z"
									fill="currentcolor" />
							</svg>
						</span>
						<?php echo tp_kses($settings['tp_heading3_sub_title']); ?>
					</span>
				<?php endif; ?>
				<?php
				if (!empty($settings['tp_heading3_title'])):
					printf(
						'<%1$s %2$s>%3$s</%1$s>',
						tag_escape($settings['tp_heading3_title_tag']),
						$this->get_render_attribute_string('title_args'),
						tp_kses($settings['tp_heading3_title'])
					);
				endif;
				?>

				<?php if (!empty($settings['tp_heading3_description'])): ?>
					<p><?php echo tp_kses($settings['tp_heading3_description']); ?></p>
				<?php endif; ?>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-4'):
			$this->add_render_attribute('title_args', 'class', 'tp-award-2-title tp-award-title-1 tp-el-title ');
			?>

			<div class="tp-award-2-area">
				<div class="tp-award-2-title-box p-relative">
					<?php if (!empty($settings['tp_sub_title_2'])): ?>
						<span class="tp-award-2-subtitle"><?php echo tp_kses($settings['tp_sub_title_2']); ?></span>
					<?php endif; ?>

					<?php
					if (!empty($settings['tp_title_2'])):
						printf(
							'<%1$s %2$s>%3$s <h2 class="tp-award-2-title tp-award-title-2"><span>%4$s</span></h2></%1$s>',
							tag_escape($settings['tp_title_tag_2']),
							$this->get_render_attribute_string('title_args'),
							tp_kses($settings['tp_title_2']),
							tp_kses($settings['tp_second_title'])
						);
					endif;
					?>

					<?php if (!empty($settings['tp_description_2'])): ?>
						<p><?php echo tp_kses($settings['tp_description_2']); ?></p>
					<?php endif; ?>
				</div>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-5'):
			$animation = $this->tp_animation_show($settings);
			$this->add_render_attribute('title_args', 'class', 'tp-section-title-200 tp-el-title ' . $animation['animation']);

			// shape image
			if (!empty($settings['tp_shape_image_1']['url'])) {
				$tp_shape_image = !empty($settings['tp_shape_image_1']['id']) ? wp_get_attachment_image_url($settings['tp_shape_image_1']['id'], 'full') : $settings['tp_shape_image_1']['url'];
				$tp_shape_image_alt = get_post_meta($settings["tp_shape_image_1"]["id"], "_wp_attachment_image_alt", true);
			}
			?>

			<div class="tp-hero-4-content black-bg-2 tp-el-section">
				<?php
				if (!empty($settings['tp_section_title'])):
					printf(
						'<%1$s %2$s>%3$s</%1$s>',
						tag_escape($settings['tp_section_title_tag']),
						$this->get_render_attribute_string('title_args'),
						tp_kses($settings['tp_section_title'])
					);
				endif;
				?>
				<div class="tp-hero-4-text tp_fade_right">
					<?php if (!empty($tp_shape_image)): ?>
						<span><img class="tp-zoom-in-out" src="<?php echo esc_url($tp_shape_image); ?>"
								alt="<?php echo esc_attr($tp_shape_image_alt); ?>"></span>
					<?php endif; ?>
					<?php if (!empty($settings['tp_section_description'])): ?>
						<p><?php echo tp_kses($settings['tp_section_description']); ?></p>
					<?php endif; ?>
				</div>
			</div>

		<?php else:
			$animation = $this->tp_animation_show($settings);

			$this->add_render_attribute('title_args', 'class', 'tp-section-3-title tp-el-span-image  tp-el-acadia-title tp-hero-2-title tp-el-title');
			?>

			<div class="tp-section tp-el-section align-box mb-40 <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>

				<?php if (!empty($settings['tp_section_sub_title'])): ?>
					<h5 class="tp-section-3-subtitle tp-el-subtitle">
						<?php echo tp_kses($settings['tp_section_sub_title']); ?>
					</h5>
				<?php endif; ?>

				<?php
				if (!empty($settings['tp_section_title'])):
					printf(
						'<%1$s %2$s>%3$s</%1$s>',
						tag_escape($settings['tp_section_title_tag']),
						$this->get_render_attribute_string('title_args'),
						tp_kses($settings['tp_section_title'])
					);
				endif;
				?>

				<?php if (!empty($settings['tp_section_description'])): ?>
					<p class="tp-el-content">
						<?php echo tp_kses($settings['tp_section_description']); ?>
					</p>
				<?php endif; ?>
			</div>

		<?php endif;
	}
}

$widgets_manager->register(new TP_Heading());