<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Hero_Yoga_Banner extends Widget_Base
{

    use TP_Style_Trait, TP_Icon_Trait, TP_Offcanvas_Trait, TP_Menu_Trait, TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-hero-yoga-banner';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Hero Yoga Banner', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        // layout Panel
        $this->tp_design_layout('Layout Style', 1);

        $this->start_controls_section(
            'tp_hero_bg-sec',
            [
                'label' => esc_html__('Background Image', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tp_yoga_bg_image',
            [
                'label' => esc_html__('Add Image', 'textdomain'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );



        $this->end_controls_section();

        // Hero title/content
        $this->start_controls_section(
            'hero_yoga_content_sec',
            [
                'label' => esc_html__('Content', 'tpcore'),
            ]
        );

        $this->add_control(
            'tp_yoga_image',
            [
                'label' => esc_html__('Choose Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'tp_yoga_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'description' => esc_html__('This is title'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('TP Title Here', 'tpcore'),
                'placeholder' => esc_html__('Type Heading Text', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tp_yoga_description',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'description' => esc_html__(
                    'This is description'
                ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('This is description', 'tpcore'),
                'placeholder' => esc_html__('Type section description here', 'tpcore'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'tp_btn_link_switcher',
            [
                'label' => esc_html__('Button', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'tpcore'),
                'label_off' => esc_html__('No', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'tp_btn_text',
            [
                'label' => esc_html__('Button Text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Button Text', 'tpcore'),
                'title' => esc_html__('Enter button text', 'tpcore'),
                'label_block' => false,
                'condition' => [
                    'tp_btn_link_switcher' => 'yes',
                ],
            ]
        );

        // $this->tp_single_icon_control('yoga_hero_btn_icon', 'tp_btn_link_switcher','');

        tp_render_links_controls($this, 'tp_yoga_btn_icon');

        $this->end_controls_section();


        // Hero About
        $this->start_controls_section(
            'hero_yoga_about_sec',
            [
                'label' => esc_html__('Hero About', 'tpcore'),
            ]
        );

        $this->add_control(
            'tp_yoga_about_image',
            [
                'label' => esc_html__('About Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'tp_yoga_about_shape',
            [
                'label' => esc_html__('About Shape', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'tp_yoga_about_title',
            [
                'label' => esc_html__('About Title', 'tpcore'),
                'description' => esc_html__('This is title'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('TP Title Here', 'tpcore'),
                'placeholder' => esc_html__('Type Heading Text', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tp_yoga_about_btn_text',
            [
                'label' => esc_html__('About Button Text', 'tpcore'),
                'description' => esc_html__('This is title'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Button Text', 'tpcore'),
                'placeholder' => esc_html__('Type Button Text', 'tpcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
         'tp_yoga_about_url',
         [
           'label'   => esc_html__( 'Add video url', 'textdomain' ),
           'type'        => \Elementor\Controls_Manager::URL,
           'default'     => [
               'url'               => '#',
               'is_external'       => true,
               'nofollow'          => true,
               'custom_attributes' => '',
             ],
             'placeholder' => esc_html__( 'Placeholder Text', 'textdomain' ),
             'label_block' => true,
           ]
         );


        $this->tp_single_icon_control('yoga_about_hero_btn', 'tp_design_style', 'layout-1');

        $this->end_controls_section();
    }

    protected function style_tab_content()
    {
        $this->tp_section_style_controls('section', 'Section - Style', '.tp-el-section');
        $this->tp_basic_style_controls('heading_title', 'Section - Title', '.tp-el-title');
        $this->tp_basic_style_controls('heading_desc', 'Section - Description', '.tp-el-content', 'layout-1');
        $this->tp_link_controls_style('', 'btn1_style', 'Button', '.tp-els-btn');
        $this->tp_basic_style_controls('about_btn_title', 'About Button Text', '.tp-el-about-btn');
        $this->tp_basic_style_controls('about-title', 'About Title', '.tp-el-about-title');
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // $button_control_id = 'banner';
        ?>

        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>


        <?php else:
            // thumbnail
            $bg_img = tp_get_img($settings, 'tp_yoga_bg_image', 'full', false);
            $hero_img = tp_get_img($settings, 'tp_yoga_image', 'full', false);
            $about_img = tp_get_img($settings, 'tp_yoga_about_image', 'full', false);
            $about_shape = tp_get_img($settings, 'tp_yoga_about_shape', 'full', false);


            $title = $settings['tp_yoga_title'];
            $about_title = $settings['tp_yoga_about_title'];
            $desc = $settings['tp_yoga_description'];
            $about_btn_text = $settings['tp_yoga_about_btn_text'];
            $button_switcher = $settings['tp_btn_link_switcher'];
            
            $btn_text = $settings['tp_btn_text'];
            $about_btn_url = $settings['tp_yoga_about_url']['url'];

            // $this->tp_link_attributes_render($button_control_id, 'tp-els-btn', $this->get_settings());


            $attrs = tp_get_repeater_links_attr($settings, 'tp_yoga_btn_icon');
            extract($attrs);

            $links_attrs = [
                'href' => $link,
                'target' => $target,
                'rel' => $rel,
                'class' => 'tp-yoga-btn tp-els-btn'
            ];

            ?>

            <!-- hero-area-start -->

            <div class="tp-hero-yoga-ptb scene include-bg pb-40"
                style="background-image: url(<?php echo esc_url($bg_img['tp_yoga_bg_image']); ?>);">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tp-hero-yoga-content">
                                <?php if (!empty($title)): ?>
                                    <h2 class="tp-hero-yoga-title tp-el-title wow fadeInUp" data-wow-delay=".3s">
                                        <?php echo tp_kses($title); ?>
                                    </h2>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tp-hero-yoga-bottom">
                    <div class="container custom-container-1590">
                        <div class="row align-items-end">
                            <div class="col-lg-3 col-md-5 order-2 order-md-0">
                                <div class="tp-hero-yoga-about mb-80 p-relative z-index-1 wow fadeInLeft" data-wow-delay=".3s">
                                    <?php if (!empty($about_shape['tp_yoga_about_shape'])): ?>
                                        <img class="tp-hero-yoga-shape p-absolute"
                                            src="<?php echo esc_url($about_shape['tp_yoga_about_shape']); ?>"
                                            alt="<?php echo esc_attr($about_shape['tp_yoga_about_shape_alt']); ?>">
                                    <?php endif; ?>
                                    <div class="row">
                                        <div class="col-6">
                                            <?php if (!empty($about_img['tp_yoga_about_image'])): ?>
                                                <div class="tp-hero-yoga-bottom-thumb">
                                                    <img src="<?php echo esc_url($about_img['tp_yoga_about_image']); ?>"
                                                        alt="<?php echo esc_attr($about_img['tp_yoga_about_image_alt']); ?>">
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-6">
                                            <div class="tp-hero-yoga-bottom-content">
                                                <div class="tp-video-icon d-flex align-items-center justify-content-end mb-85">
                                                    <?php if (!empty($about_btn_text)): ?>
                                                        <p class="tp-el-about-btn"><?php echo tp_kses($about_btn_text); ?></p>
                                                    <?php endif; ?>
                                                    <a class="video-border-animation popup-video"
                                                        href="<?php echo esc_url($about_btn_url); ?>">
                                                        <?php tp_render_signle_icon_html($settings, 'yoga_about_hero_btn'); ?>
                                                    </a>
                                                </div>
                                                <?php if (!empty($about_title)): ?>
                                                    <p class="titles text-end tp-el-about-title"><?php echo tp_kses($about_title); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-7">
                                <?php if (!empty($hero_img['tp_yoga_image'])): ?>
                                    <div class="tp-hero-yoga-thumb wow fadeInUp" data-wow-delay=".3s">
                                        <img class="layer" data-depth="0.2" src="<?php echo esc_url($hero_img['tp_yoga_image']); ?>"
                                            alt="<?php echo esc_attr($hero_img['tp_yoga_image_alt']); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-3">
                                <div class="tp-hero-yoga-right-content mb-80 wow fadeInRight" data-wow-delay=".3s">
                                    <?php if (!empty($desc)): ?>
                                        <p class="mb-30 tp-el-content"><?php echo tp_kses($desc); ?></p>
                                    <?php endif; ?>
                                    <?php if (!empty($link) && ($button_switcher == 'yes')): ?>
                                        <div class="tp-yoga-btn-wrap">
                                            <a <?php echo tp_implode_html_attributes($links_attrs); ?>>
                                                <?php echo tp_kses($btn_text); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- hero-area-end -->



        <?php endif;
    }
}

$widgets_manager->register(new TP_Hero_Yoga_Banner());
