<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;

use \Etn\Utils\Helper as Helper;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_MS_Course_Tab extends Widget_Base
{

    use TP_Style_Trait, TP_Column_Trait, TP_Query_Trait;
    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'ms-course-tab';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('MS Course Tab', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */



    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        $this->tp_design_layout('Select Layout', 1);

        $this->start_controls_section(
            'course_sec',
                [
                  'label' => esc_html__( 'Content Controls', 'tpcore' ),
                  'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
           );
           
           $this->add_control(
           'tp_course_btn_text',
            [
               'label'       => esc_html__( 'Button Text', 'tpcore' ),
               'type'        => \Elementor\Controls_Manager::TEXT,
               'default'     => esc_html__( 'Preview This Course', 'tpcore' ),
               'placeholder' => esc_html__( 'Your Text', 'tpcore' ),
               'label_block' => true
            ]
           );
   
           $this->add_control(
            'tp_course_tab_shape_switch',
            [
              'label'        => esc_html__( 'Add Tab Shape?', 'tpcore' ),
              'type'         => \Elementor\Controls_Manager::SWITCHER,
              'label_on'     => esc_html__( 'Show', 'tpcore' ),
              'label_off'    => esc_html__( 'Hide', 'tpcore' ),
              'return_value' => 'yes',
              'default'      => 'no',
            ]
           );
   
           $this->add_control(
            'tp_course_tab_shape',
            [
              'label'   => esc_html__( 'Tab Shape', 'tpcore' ),
              'type'    => Controls_Manager::MEDIA,
               'default' => [
                  'url' => \Elementor\Utils::get_placeholder_image_src(),
              ],
                 'condition' => [
                   'tp_course_tab_shape_switch' => 'yes',
                 ],	
            ]
           );
   
           $this->add_responsive_control(
            'tp_course_tab_alignment',
            [
             'label'   => esc_html__( 'Tab Alignment', 'tpcore' ),
              'type'    => \Elementor\Controls_Manager::CHOOSE,
              'options' => [
                'start'   => [
                  'title' => esc_html__( 'Left', 'tpcore' ),
                  'icon'  => 'eicon-text-align-left',
              ],
                'center' => [
                'title' => esc_html__( 'Center', 'tpcore' ),
                'icon'  => 'eicon-text-align-center',
                ],
                'end'  => [
                  'title' => esc_html__( 'Right', 'tpcore' ),
                  'icon'  => 'eicon-text-align-right',
                ],
              ],
              'default' => 'center',
              'toggle'  => true,
              'selectors' => [
                '{{WRAPPER}} .tp-course-tab' => 'justify-content: {{VALUE}};',
              ],
            ]
           );
   
           $this->end_controls_section();

        $this->tp_query_controls('course_tab', 'Course Controls', 'stm-courses', 'stm_lms_course_taxonomy');

    }

    protected function style_tab_content()
    {
        $this->tp_section_style_controls('portfolio_section', 'Section - Style', '.tp-el-section');
    }
    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $posts_per_page = !empty($settings['posts_per_page']) ? $settings['posts_per_page'] : -1;
        $order = !empty($settings['order']) ? $settings['order'] : 'DESC';
        $order_by = !empty($settings['order_by']) ? $settings['order_by'] : 'date';
        $post_exclude = !empty($settings['post__not_in']) ? $settings['post__not_in'] : [];
        $post_include = !empty($settings['post__in']) ? $settings['post__in'] : [];
        $ignore_sticky_posts = (!empty( $settings['ignore_sticky_posts'] ) && 'yes' == $settings['ignore_sticky_posts']) ? true : false ;

        ?>

<?php if ($settings['tp_design_style'] == 'layout-2'): ?>

<?php else: ?>

<section class="msac-course-tab">

    <?php if( !empty($settings['category'] || !empty($settings['exclude_category']))) : 
                    
        if($settings['tp_course_tab_shape_switch'] == 'yes') :
            $shape_img = tp_get_img($settings, 'tp_course_tab_shape', 'full', false);
        endif;
    ?>
    <div class="row align-items-end">
        <div class="col-xxl-12 col-xl-12 col-lg-12">
            <div class="tp-course-tab d-flex justify-content-lg-end mb-40">
                <nav>
                    <div class="nav" id="nav-tab" role="tablist">
                        <button class="nav-link active" id="nav-all-tab" data-bs-toggle="tab" data-bs-target="#nav-all" type="button" role="tab" aria-controls="nav-all" aria-selected="true">
                            <?php echo esc_html__('All Courses', 'tpcore'); ?>

                            <?php if(!empty($shape_img['tp_course_tab_shape']) && $settings['tp_course_tab_shape_switch'] == 'yes') : ?>
                            <span>
                                <img src="<?php echo esc_url($shape_img['tp_course_tab_shape']); ?>" alt="<?php echo esc_attr($shape_img['tp_course_tab_shape_alt']); ?>">
                            </span>
                            <?php endif; ?>
                        </button>
                        
                        <?php foreach ( $settings['category'] as $list ): 

                        $attrs = [
                            'class' => 'nav-link',
                            'id' => 'nav-'.$list.'-tab',
                            'data-bs-toggle' => 'tab',
                            'data-bs-target' => '#nav-'.$list,
                            'type' => 'button',
                            'role' => 'tab',
                            'aria-controls' => 'nav-'.$list,
                            'aria-selected' => 'false'
                        ];
                        ?>
                        <button <?php echo tp_implode_html_attributes($attrs); ?>>
                        <?php // echo esc_html( ucwords( $list ) ); ?>
                        <?php echo esc_html(tp_get_categories('stm_lms_course_taxonomy')[$list]); ?>

                        <?php if(!empty($shape_img['tp_course_tab_shape'])) : ?>
                        <span>
                            <img src="<?php echo esc_url($shape_img['tp_course_tab_shape']); ?>" alt="<?php echo esc_attr($shape_img['tp_course_tab_shape_alt']); ?>">
                        </span>
                        <?php endif; ?>
                        </button>
                        <?php endforeach; ?>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="tab-content wow fadeInUp" data-wow-delay=".3s" id="nav-tabContent">

                <div class="tab-pane fade show active" id="nav-all" role="tabpanel" aria-labelledby="nav-all-tab"
                    tabindex="0">
                    <div class="row">

                        <?php
                                    
                            $args = array(
                                'post_type' => 'stm-courses',
                                'post_status' => 'publish',
                                'order' => $order,
                                'orderby' => $order_by,
                                'post__not_in'=> $post_exclude,
                                'post__in' => $post_include,
                                'posts_per_page' => $posts_per_page,
                                'ignore_sticky_posts' => $ignore_sticky_posts
                            );

                            $main_query = new \WP_Query($args); 
                        ?>
                        <?php 
                        if ( $main_query->have_posts() ) : 
                            while ( $main_query->have_posts() ) : 
                                $main_query->the_post();
                                $post_id = get_the_ID();
                                $instructor_img = get_avatar( get_the_author_meta('ID') );
                                $instructor_name = get_the_author_meta('display_name');
                                $categories = get_the_terms( get_the_ID(), 'stm_lms_course_taxonomy' );
                                $lectures    = \STM_LMS_Course::curriculum_info( get_the_ID() );
                                $lessons = $lectures['lessons'];
                                $current_students = get_post_meta( get_the_ID(), 'current_students', true );
                                $rating = get_post_meta(get_the_ID(), 'course_marks', true);
                                if (!empty($rating)) {
                                    $rates = \STM_LMS_Course::course_average_rate($rating);
                                    $average = $rates['average'];
                                    $percent = $rates['percent'];
                                    $total = count($rating);
                                }
                                $is_course_coming_soon = \STM_LMS_Helpers::masterstudy_lms_is_course_coming_soon( $post_id );
                                $price      = get_post_meta( $post_id, 'price', true );
                                $sale_price = \STM_LMS_Course::get_sale_price( $post_id );
                        ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="tp-course-item p-relative fix mb-30">
                                <div class="tp-course-teacher mb-15">
                                    <span>
                                        <?php if( !empty( $instructor_img ) ) : ?>
                                            <?php echo $instructor_img; ?>
                                        <?php endif; ?>
                                        <?php echo !empty($instructor_name) ? ucwords( $instructor_name ) : ''; ?>
                                    </span>
                                </div>
                                <div class="tp-course-thumb sidebar">
                                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                                </div>
                                <div class="tp-course-content">
                                    <div class="tp-course-tag mb-10">
                                        <?php foreach( $categories as $key => $cat ) : ?>
                                        <span><?php echo esc_html( $cat->name ); ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                    <div class="tp-course-meta">
                                        <span>
                                            <span>
                                                <svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M7.46118 2.81787V12.4506" stroke="#94928E" stroke-width="1.2"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </span>
                                            <?php echo esc_html( $lessons ) . esc_html__( ' Lessons', 'acadia' ); ?>
                                        </span>
                                        <span>
                                            <span>
                                                <svg width="13" height="15" viewBox="0 0 13 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                                    <path
                                                        d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </span>
                                            <?php echo esc_html( $current_students ) . esc_html__( ' Student', 'acadia' ); ?>
                                        </span>
                                    </div>
                                    <h4 class="tp-course-title">
                                        <a href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), $settings['tp_post_title_word'], ''); ?></a>
                                    </h4>
                                    <div class="tp-course-rating d-flex align-items-end justify-content-between">
                                        <?php if( !empty( $rating ) ) : ?>
                                        <div class="tp-course-rating-star">
                                            <p><?php echo esc_html( $average ); ?><span> <?php echo esc_html__( '/5', 'acadia' ); ?></span></p>
                                            <div class="tp-course-rating-icon">
                                                <?php if( !empty( $rating ) ) : ?>
                                                <div class="ms_lms_courses_card_item_info_rating_stars">
                                                    <div class="ms_lms_courses_card_item_info_rating_stars_filled" style="width: <?php echo floatval( $percent ); ?>%;"></div>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php else : ?>
                                        <div class="tp-course-rating-star">
                                            <p><?php echo esc_html__( '0', 'acadia' ); ?><span> <?php echo esc_html__( '/5', 'acadia' ); ?></span></p>
                                            <div class="tp-course-rating-icon">
                                                <i class="fa-regular fa-star"></i>
                                                <i class="fa-regular fa-star"></i>
                                                <i class="fa-regular fa-star"></i>
                                                <i class="fa-regular fa-star"></i>
                                                <i class="fa-regular fa-star"></i>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <div class="tp-course-pricing">
                                            <span>
                                                <?php
                                                    if ( ! $is_course_coming_soon ) {
                                                        do_action( 'stm_lms_archive_card_price', compact( 'price', 'sale_price', 'post_id' ) );
                                                    }
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="tp-course-btn">
                                    <a href="<?php the_permalink(); ?>"><?php echo esc_html($settings['tp_course_btn_text']); ?></a>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; wp_reset_query(); endif; ?>	

                    </div>
                </div>

                <?php foreach ( $settings['category'] as $category ): 

                    $args = array(
                    'post_type' => 'stm-courses',
                    'post_status' => 'publish',
                    'order' => $order,
                    'orderby' => $order_by,
                    'post__not_in'=> $post_exclude,
                    'post__in' => $post_include,
                    'posts_per_page' => $posts_per_page,
                    'ignore_sticky_posts' => $ignore_sticky_posts,
                    'tax_query' => [
                        [
                            'taxonomy' => 'stm_lms_course_taxonomy',
                            'field' => 'slug',
                            'terms' => $category
                        ]
                    ]
                    );

                    $main_query = new \WP_Query($args);

                    $attrs = [
                    'class' => 'tab-pane fade',
                    'id'    =>  'nav-'.$category,
                    'role'  => 'tabpanel',
                    'aria-labelledby' => 'nav-'.$category.'-tab',
                    'tabindex' => '0'
                    ];

                ?>
                <div <?php echo tp_implode_html_attributes($attrs); ?> >
                    <div class="row">

                        <?php 
                        if ( $main_query->have_posts() ) : 
                            while ( $main_query->have_posts() ) : 
                                $main_query->the_post();
                                $post_id = get_the_ID();
                                $instructor_img = get_avatar( get_the_author_meta('ID') );
                                $instructor_name = get_the_author_meta('display_name');
                                $categories = get_the_terms( get_the_ID(), 'stm_lms_course_taxonomy' );
                                $lectures    = \STM_LMS_Course::curriculum_info( get_the_ID() );
                                $lessons = $lectures['lessons'];
                                $current_students = get_post_meta( get_the_ID(), 'current_students', true );
                                $rating = get_post_meta(get_the_ID(), 'course_marks', true);
                                if (!empty($rating)) {
                                    $rates = \STM_LMS_Course::course_average_rate($rating);
                                    $average = $rates['average'];
                                    $percent = $rates['percent'];
                                    $total = count($rating);
                                }
                                $is_course_coming_soon = \STM_LMS_Helpers::masterstudy_lms_is_course_coming_soon( $post_id );
                                $price      = get_post_meta( $post_id, 'price', true );
                                $sale_price = \STM_LMS_Course::get_sale_price( $post_id );
                        ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="tp-course-item p-relative fix mb-30">
                                <div class="tp-course-teacher mb-15">
                                    <span>
                                        <?php if( !empty( $instructor_img ) ) : ?>
                                            <?php echo $instructor_img; ?>
                                        <?php endif; ?>
                                        <?php echo !empty($instructor_name) ? ucwords( $instructor_name ) : ''; ?>
                                    </span>
                                </div>
                                <div class="tp-course-thumb sidebar">
                                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                                </div>
                                <div class="tp-course-content">
                                    <div class="tp-course-tag mb-10">
                                        <?php foreach( $categories as $key => $cat ) : ?>
                                        <span><?php echo esc_html( $cat->name ); ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                    <div class="tp-course-meta">
                                        <span>
                                            <span>
                                                <svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M7.46118 2.81787V12.4506" stroke="#94928E" stroke-width="1.2"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </span>
                                            <?php echo esc_html( $lessons ) . esc_html__( ' Lessons', 'acadia' ); ?>
                                        </span>
                                        <span>
                                            <span>
                                                <svg width="13" height="15" viewBox="0 0 13 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                                    <path
                                                        d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                                        stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </span>
                                            <?php echo esc_html( $current_students ) . esc_html__( ' Student', 'acadia' ); ?>
                                        </span>
                                    </div>
                                    <h4 class="tp-course-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h4>
                                    <div class="tp-course-rating d-flex align-items-end justify-content-between">
                                        <?php if( !empty( $rating ) ) : ?>
                                        <div class="tp-course-rating-star">
                                            <p><?php echo esc_html( $average ); ?><span> <?php echo esc_html__( '/5', 'acadia' ); ?></span></p>
                                            <div class="tp-course-rating-icon">
                                                <?php if( !empty( $rating ) ) : ?>
                                                <div class="ms_lms_courses_card_item_info_rating_stars">
                                                    <div class="ms_lms_courses_card_item_info_rating_stars_filled" style="width: <?php echo floatval( $percent ); ?>%;"></div>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php else : ?>
                                        <div class="tp-course-rating-star">
                                            <p><?php echo esc_html__( '0', 'acadia' ); ?><span> <?php echo esc_html__( '/5', 'acadia' ); ?></span></p>
                                            <div class="tp-course-rating-icon">
                                                <i class="fa-regular fa-star"></i>
                                                <i class="fa-regular fa-star"></i>
                                                <i class="fa-regular fa-star"></i>
                                                <i class="fa-regular fa-star"></i>
                                                <i class="fa-regular fa-star"></i>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <div class="tp-course-pricing">
                                            <span>
                                                <?php
                                                    if ( ! $is_course_coming_soon ) {
                                                        do_action( 'stm_lms_archive_card_price', compact( 'price', 'sale_price', 'post_id' ) );
                                                    }
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="tp-course-btn">
                                    <a href="<?php the_permalink(); ?>"><?php echo esc_html($settings['tp_course_btn_text']); ?></a>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; wp_reset_query(); endif; ?>	
                        
                    </div>
                </div>
                <?php endforeach; ?>

            </div>
        </div>
    </div>

</section>

<?php endif; 
    }
}

$widgets_manager->register(new TP_MS_Course_Tab());