<?php

namespace TPCore\Widgets;

use Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;

trait TP_Offcanvas_Trait
{

    protected function tp_offcanvas_controls($control_id = null, $control_name = null)
    {
        $this->start_controls_section(
            'tp_offcanvas_section',
            [
                'label' => esc_html__('Offcanvas', 'tpcore'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tp_offcanvas_logo',
            [
                'label' => esc_html__('Choose Logo', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'tp_off_logo_width',
            [
                'label' => esc_html__('Logo Width', 'tpcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 125,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tp-el-off-logo img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $offcanvas = array(
            'post_type'      => 'tp-offcanvas',
            'posts_per_page' => -1,
        );
        $offcanvas_loop = get_posts($offcanvas);

        $offcanvas_obj = array();
        foreach ($offcanvas_loop as $post) {
            $offcanvas_obj[$post->ID] = $post->post_title;
        }

        $this->add_control(
            'tp_offcanvas_template',
            [
                'label'   => esc_html__('Select Template', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => $offcanvas_obj,
                'default' => 'default',
            ]
        );

        $this->end_controls_section();
    }
}
