<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package acadia
 */
?>

<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <?php if (is_singular() && pings_open(get_queried_object())): ?>
    <?php endif; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<?php
$get_acadia_lp_archive = get_theme_mod( 'acadia_lp_archive', 'style_1' );
$get_acadia_lp_details = get_theme_mod( 'acadia_lp_details', 'style_1' );
$ac_lp_class = '';
$ac_lp_details_class = '';

if( is_post_type_archive( 'lp_course' ) ) {   
    if( $get_acadia_lp_archive == 'style_1' ) {
        $ac_lp_class = 'ac-lp-archive-1';
    } elseif( $get_acadia_lp_archive == 'style_2' ) {
        $ac_lp_class = 'ac-lp-archive-2';
    } elseif( $get_acadia_lp_archive == 'style_3' ) {
        $ac_lp_class = 'ac-lp-archive-3';
    } elseif( $get_acadia_lp_archive == 'style_4' ) {
        $ac_lp_class = 'ac-lp-archive-4';
    } elseif( $get_acadia_lp_archive == 'style_5' ) {
        $ac_lp_class = 'ac-lp-archive-5';
    }
}

if( is_singular( 'lp_course' ) ) {
    if( $get_acadia_lp_details == 'style_1' ) {
        $ac_lp_details_class = 'ac-lp-details-1';
    } elseif( $get_acadia_lp_details == 'style_2' ) {
        $ac_lp_details_class = 'ac-lp-details-2';
    }
}

?>

<body <?php body_class(' tp-magic-cursor ' . $ac_lp_class . ' ' . $ac_lp_details_class ); ?> id="body">

    <?php wp_body_open(); ?>


    <?php
    $acadia_preloader = get_theme_mod('acadia_preloader_switch', false);
    $acadia_preloader_loading_text = get_theme_mod('acadia_preloader_loading_text', __('Loading', 'acadia'));
    $acadia_preloader_logo = get_theme_mod('acadia_preloader_logo', get_template_directory_uri() . '/assets/img/logo/preloader/preloader-icon.png');

    $acadia_backtotop = get_theme_mod('acadia_backtotop_switch', false);

    ?>

    <?php if ($acadia_preloader): ?>
        <!-- pre loader area start -->
        <div id="loading" class="preloader-wrap">
            <div id="loading-center">
                <div id="loading-center-absolute">
                    <!-- loading content here -->
                    <div class="tp-preloader-content">
                        <div class="tp-preloader-logo">
                            <div class="tp-preloader-circle">
                                <svg width="190" height="190" viewBox="0 0 380 380" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <circle stroke="#D9D9D9" cx="190" cy="190" r="180" stroke-width="6"
                                        stroke-linecap="round">
                                    </circle>
                                    <circle stroke="red" cx="190" cy="190" r="180" stroke-width="6" stroke-linecap="round">
                                    </circle>
                                </svg>
                            </div>
                            <?php if (!empty($acadia_preloader_logo)): ?>
                                <img src="<?php echo esc_url($acadia_preloader_logo); ?>"
                                    alt="<?php echo esc_attr__('acadia preloader Logo', 'acadia'); ?>">
                            <?php endif; ?>
                        </div>
                        <p class="tp-preloader-subtitle">
                            <?php echo esc_html($acadia_preloader_loading_text); ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!-- pre loader area end -->
    <?php endif; ?>

    <?php if ($acadia_backtotop): ?>
        <!-- back to top start -->
        <div class="back-to-top-wrapper">
            <button id="back_to_top" type="button" class="back-to-top-btn">
                <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M11 6L6 1L1 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
        </div>
        <!-- back to top end -->
    <?php endif; ?>



    <!-- header start -->
    <?php do_action('acadia_header_style'); ?>
    <!-- header end -->

    <?php
    if ( !is_singular('etn') && !is_singular( 'lp_course' ) && !is_post_type_archive( 'lp_course' ) && !is_tax( 'course_category' ) && !is_tax( 'course_tag' ) && !is_singular( 'stm-courses' ) ) {
        do_action('acadia_before_main_content');
    }
    ?>