<?php
$course = LP_Global::course();
$instructor = $course->get_instructor();

$user = get_user_by( 'id', $instructor->get_id());
$pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
$base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
$profile_link =  $base_url.'/'.$pro_link;

$categories = get_the_terms(get_the_ID(), 'course_category');
$tags = get_the_terms(get_the_ID(), 'course_tag');
$modified = get_the_modified_date('j M, Y');

$get_lp_offline_course = get_post_meta( get_the_ID(), '_lp_offline_course', true );
?>
<!-- course details breadcrumb start -->
<section class="tp-breadcrumb__area pt-25 pb-55 p-relative z-index-1 fix">
    <div class="tp-breadcrumb__bg" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/breadcrumb/breadcrumb-bg-2.jpg"></div>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-sm-12">
                <div class="tp-breadcrumb__content">
                    <div class="tp-breadcrumb__list course-details mb-70">
						<?php
						if( function_exists( 'acadia_learnpress_course_breadcrumb' ) ) {
							echo acadia_learnpress_course_breadcrumb();
						}
						?>
                    </div>
                    <div class="tp-course-details-2-header">
                        <?php if( !empty( $tags ) ) : foreach( $tags as $key => $tag ) : ?>
                        <span class="tp-course-details-2-category"><?php echo esc_html( $tag->name ); ?></span>
                        <?php endforeach; endif; ?>
                        <h3 class="tp-course-details-2-title"><?php the_title(); ?></h3>
                        <div class="tp-course-details-2-meta-wrapper d-flex align-items-center flex-wrap">
                            <?php if( !empty( $instructor ) ) : ?>
                            <div class="tp-course-details-2-meta ">
                                <div class="tp-course-details-2-author d-flex align-items-center">
                                    <div class="tp-course-details-2-author-avater">
                                        <?php echo acadia_kses($instructor->get_profile_picture()); ?>
                                    </div>
                                    <div class="tp-course-details-2-author-content">
                                        <span class="tp-course-details-2-author-designation"><?php echo esc_html__( 'Teacher', 'acadia' ); ?></span>
                                        <h3 class="tp-course-details-2-meta-title"><a href="<?php echo esc_url( $instructor->get_url_instructor() ); ?>"><?php echo esc_html($instructor->get_display_name()); ?></a></h3>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( !empty( $categories ) ) : ?>
                            <div class="tp-course-details-2-meta">
                                <span class="tp-course-details-2-meta-subtitle"><?php echo esc_html__( 'Category', 'acadia' ); ?></span>
                                <h3 class="tp-course-details-2-meta-title">
                                    <?php 
                                    foreach( $categories as $key => $cat ) :
                                        $cot = ''; 
                                        $cat_count = count( $categories );
                                        if( $cat_count > $key+1 ) {
                                            $cot = ',';
                                        }
                                    ?>
                                    <?php echo esc_html( $cat->name . $cot ); ?>
                                    <?php endforeach; ?>
                                </h3>
                            </div>
                            <?php endif; ?>
                            <?php if( !empty( $modified ) ) : ?>
                            <div class="tp-course-details-2-meta">
                                <span class="tp-course-details-2-meta-subtitle"><?php echo esc_html__( 'Last updated', 'acadia' ); ?></span>
                                <h3 class="tp-course-details-2-meta-title"><?php echo esc_html( $modified ); ?></h3>
                            </div>
                            <?php endif; ?>

                            <?php 
                            if( function_exists( 'learn_press_get_course_rate' ) ) {
                            $course_rate_res = learn_press_get_course_rate( get_the_ID(), false );
                            $rated = $course_rate_res['rated'] ?? 0;
                            ?>

                            <div class="tp-course-details-2-meta text-end">
                                <div class="tp-course-details-2-meta-rating-wrapper">
                                    <div class="tp-course-rating-icon">
                                        <?php
                                        LP_Addon_Course_Review_Preload::$addon->get_template(
                                            'rating-stars.php',
                                            array( 'rated' => $course_rate_res['rated'] )
                                        );
                                        ?>
                                    </div>
                                    <span class="tp-course-details-2-meta-subtitle"><?php echo esc_html__( 'Reviews', 'acadia' ); ?></span>
                                </div>
                            </div>
                            <?php 	
                            }
                            ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- course details breadcrumb end -->


<!-- course details area start -->
<section class="tp-course-details-2-area pt-50 pb-80">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <?php
                    if( 'yes' == $get_lp_offline_course ) {
                        get_template_part( 'learnpress/course-details/off-info' ); 
                    } else {
                        get_template_part( 'learnpress/course-details/tabs' ); 
                    }
                ?>
            </div>
            <div class="col-lg-4">
                <?php
                    if( 'yes' == $get_lp_offline_course ) {
                        get_template_part( 'learnpress/course-details/sidebar-info', 'off' ); 
                    } else {
                        get_template_part( 'learnpress/course-details/sidebar', 'info' ); 
                    }
                ?>
            </div>
        </div>
    </div>
</section>
<!-- course details area end -->


<!-- course details area start -->
<?php if( function_exists( 'get_related_courses' ) ) : ?>
<section class="tp-course-details-2-related-area pb-80">
    <div class="container">
        <div class="tp-course-details-2-related-border"></div>
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-course-details-2-related-heading pt-80">
                    <h3 class="tp-course-details-2-related-title"><?php echo esc_html__( 'Related Courses', 'acadia' ); ?></h3>
                </div>
            </div>
        </div>
        <?php get_related_courses( get_the_ID() ); ?>
    </div>
</section>
<?php endif; ?>
<!-- course details area end -->