<?php

$ac_ms_load_more_sw   = get_theme_mod( 'ac_ms_load_more_sw', 'on' );
$ac_ms_search_sw      = get_theme_mod( 'ac_ms_search_sw', 'on' );
$course_order_by      = 'DESC';
$get_ac_ms_course_per = get_theme_mod( 'ac_ms_course_per', 12 );
$args                 = array( 
    'post_type'      => 'stm-courses',
    'orderby'        => 'modified',
    'order'          => $course_order_by,
    'posts_per_page' => $get_ac_ms_course_per,
    'status'         => 'publish'
);

$get_sort_by       = isset($_GET['sort_by']) ? sanitize_text_field( $_GET['sort_by'] ) : array();
$get_categories    = isset($_GET['categories']) ? explode( ',', sanitize_text_field( $_GET['categories'] ) ) : array();
$get_instructors   = isset($_GET['instructors']) ? array_map( 'intval', explode( ',', sanitize_text_field( $_GET['instructors'] ) ) ) : array();
$get_sort_by_price = isset($_GET['sort_by_price']) ? explode( ',', sanitize_text_field( $_GET['sort_by_price'] ) ) : array();
$get_skills        = isset($_GET['skills']) ? explode( ',', sanitize_text_field( $_GET['skills'] ) ) : array();
$get_search_for    = isset($_GET['search_for'])? sanitize_text_field($_GET['search_for']) : '';

$filter_args = array(
    'sort_by'       => $get_sort_by,
    'categories'    => $get_categories,
    'instructors'   => $get_instructors,
    'sort_by_price' => $get_sort_by_price,
    'skills'        => $get_skills,
    'post_status'   => 'publish',
);

// latest
if( !empty( $get_sort_by ) && 'latest' == $get_sort_by ) {
    $args['orderby'] = 'date';
}
// trending
if( !empty( $get_sort_by ) && 'trending' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'current_students';
}
// popular
if( !empty( $get_sort_by ) && 'popularity' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'course_mark_average';
}
// low to high
if( !empty( $get_sort_by ) && 'low_high' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'price';
    $args['order'] = 'ASC';
}
// hight to low
if( !empty( $get_sort_by ) && 'high_low' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'price';
    $args['order'] = 'DESC';
}

// filter by course category
if( !empty( $get_categories ) ) {
    $args['tax_query'] = array(
        'relation' => 'OR',
        array(
            'taxonomy' => 'stm_lms_course_taxonomy',
            'field'    => 'slug',
            'terms'    => $get_categories
        )
    );
}

// filter by course instructor
if( !empty( $get_instructors ) ) {
    $args['author__in'] = $get_instructors;
}

// filter by price
if( !empty( $get_sort_by_price ) && 'on_all' != $get_sort_by_price[0] ) {
    $compare = ( $get_sort_by_price[0] == 'on_free' ) ? '=' : '!=';
    $args['meta_query'] = array(
        array(
            'key'     => 'price',
            'value'   => '',
            'compare' => $compare
        )
    );
}

// filter by skill
if( !empty( $get_skills ) ) {
    $args['meta_query'][] = array(
        array(
            'key'     => 'level',
            'value'   => $get_skills,
            'compare' => 'IN'
        )
    );
}

if(!empty($get_search_for)){
    $args['s'] = $get_search_for;
}

$query = new WP_Query($args);
$total = $query->found_posts;
if ( $total == 0 ) {
    $message = '<p class="message message-error">' . esc_html__( 'No courses found!', 'acadia' ) . '</p>';
    $index   = esc_html__( 'There are no available courses!', 'acadia' );
} elseif ( $total == 1 ) {
    $index = esc_html__( 'Showing only one result', 'acadia' );
} else {

    $course_per   = $get_ac_ms_course_per;
    $course_count = $total;

    if( $course_count <= $course_per ) {
        $index = sprintf(
            esc_html__( 'Showing all courses of %s results', 'acadia' ),
            $course_count
        );
    } else {
        $index = sprintf(
            esc_html__( 'Showing 1 - %s courses of %s results', 'acadia' ),
            $course_per,
            $course_count
        );
    }
}
?>

<?php get_template_part('stm-lms-templates/courses/archive-filter/filter-feature', 'res', $filter_args); ?>
<?php acadia_breadcrumb_func_2(); ?>
<main class='ms-acadia-archive-filter'>

    <!-- course filter area start -->
    <section class="pt-80">
        <div class="container">

            <div class="tp-course-filter-wrap p-relative">

                <div class="row">
                    <div class="col-lg-6">
                        <div class="tp-course-filter-top-left d-flex align-items-center">
                            <div class="tp-course-filter-top-tab tp-tab mb-30">
                                <ul class="nav nav-tabs" id="filterTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                                            data-bs-target="#home" type="button" role="tab" aria-controls="home"
                                            aria-selected="true">
                                            <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M5.66667 1H1V5.66667H5.66667V1Z" stroke="#031F42"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M12.9997 1H8.33301V5.66667H12.9997V1Z" stroke="#031F42"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M12.9997 8.33337H8.33301V13H12.9997V8.33337Z"
                                                    stroke="#031F42" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path d="M5.66667 8.33337H1V13H5.66667V8.33337Z"
                                                    stroke="#031F42" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg>
                                            <?php echo esc_html__( 'Grid', 'acadia' ); ?>
                                        </button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="profile-tab" data-bs-toggle="tab"
                                            data-bs-target="#profile" type="button" role="tab"
                                            aria-controls="profile" aria-selected="false">
                                            <svg width="14" height="14" viewBox="0 0 16 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M15 7.11108H1" stroke="#031F42" stroke-width="1"
                                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M15 1H1" stroke="#031F42" stroke-width="1"
                                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M15 13.2222H1" stroke="#031F42" stroke-width="1"
                                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                            </svg>
                                            <?php echo esc_html__( 'List', 'acadia' ); ?>
                                        </button>
                                    </li>
                                </ul>
                            </div>
                            <div class="tp-course-filter-top-result ms-filter-result mb-30" data-total-courses>
                                <p><?php echo esc_html($index); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="tp-course-filter-top-right d-flex align-items-center justify-content-start justify-content-lg-end">
                            <div class="tp-course-filter-top-right-search style-2 d-none d-lg-block mb-30">

                                <?php if( $ac_ms_search_sw == 'on' ) : ?>
                                <form action="" class="ac-archive-filter-search-form">
                                    <?php $nonce = wp_create_nonce('_nonce2'); ?>
                                    <input type="hidden" id="nonce" name="nonce" value="<?php echo esc_html( $nonce ); ?>">
                                    <input type="text" class="course_search" placeholder="<?php echo esc_attr__( 'Search for Courses...', 'acadia' ); ?>" value="<?php echo esc_attr( $get_search_for ); ?>" name="search_for">
                                    <button class="tp-course-filter-top-right-search-btn" type="submit">
                                        <span>
                                            <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12.625 12.625L16 16" stroke="#8B8B8B" stroke-width="1.5"
                                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path
                                                    d="M14.5 7.75C14.5 4.02208 11.4779 1 7.75 1C4.02208 1 1 4.02208 1 7.75C1 11.4779 4.02208 14.5 7.75 14.5C11.4779 14.5 14.5 11.4779 14.5 7.75Z"
                                                    stroke="#8B8B8B" stroke-width="1.5" stroke-linejoin="round">
                                                </path>
                                            </svg>
                                        </span>
                                    </button>
                                </form>
                                <?php endif; ?>

                            </div>
                            <div class="tp-course-filter-btn mb-30">
                                <button type="button" class="tp-filter-btn archive-filter-btn filter-open-dropdown-btn">
                                    <span>
                                        <svg width="16" height="15" viewBox="0 0 16 15" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M14.9998 3.44995H10.7998" stroke="#5169F1"
                                                stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path d="M3.8 3.44995H1" stroke="#5169F1" stroke-width="1.5"
                                                stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M6.60039 5.9C7.95349 5.9 9.05039 4.8031 9.05039 3.45C9.05039 2.0969 7.95349 1 6.60039 1C5.24729 1 4.15039 2.0969 4.15039 3.45C4.15039 4.8031 5.24729 5.9 6.60039 5.9Z"
                                                stroke="#5169F1" stroke-width="1.5" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M15.0002 11.15H12.2002" stroke="#5169F1" stroke-width="1.5"
                                                stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path d="M5.2 11.15H1" stroke="#5169F1" stroke-width="1.5"
                                                stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M9.4002 13.6C10.7533 13.6 11.8502 12.503 11.8502 11.15C11.8502 9.79685 10.7533 8.69995 9.4002 8.69995C8.0471 8.69995 6.9502 9.79685 6.9502 11.15C6.9502 12.503 8.0471 13.6 9.4002 13.6Z"
                                                stroke="#5169F1" stroke-width="1.5" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </span>
                                    <?php echo esc_html__( 'Filter', 'acadia' ); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <?php get_template_part('stm-lms-templates/courses/archive-filter/filter', 'features', $filter_args); ?>

            </div>

            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                    <div class="row" data-ac-course-filter-content>
                        <?php 
                        if($query->have_posts()):
                            while ($query->have_posts()) : $query->the_post();
                                get_template_part('stm-lms-templates/courses/archive-filter/content-course', 'grid', $filter_args);
                            endwhile;
                            wp_reset_postdata();
                        else:
                            echo '<div class="alert alert-danger" role="alert">'.__('No course found!', 'acadia').'</div>';
                        endif;
                        ?> 
                    </div>
                </div>
                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab" data-ac-course-filter-content-list>
                    <?php 
                    if($query->have_posts()):
                        while ($query->have_posts()) : $query->the_post();
                            get_template_part('stm-lms-templates/courses/archive-filter/content-course', 'list', $filter_args);
                        endwhile;
                        wp_reset_postdata();
                    else:
                        echo '<div class="alert alert-danger" role="alert">'.__('No course found!', 'acadia').'</div>';
                    endif;
                    ?>
                </div>
            </div>

            <?php if( 'on' == $ac_ms_load_more_sw ) : ?>
            <div class="row">
                <div class="col-lg-12">
                    <div class="tp-event-inner-pagination pb-100">
                        <div class="tp-dashboard-pagination pt-20">
                            <div class="load-pagi-wrap text-center">
                                <input class="ac-lp-archive-load-more-2 tp-btn-round mt-20" type="button" value="Load More">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section>
    <!-- course filter area end -->

</main>