<?php
/**
 * Quiz context
 *
 * @package Tutor\Views
 * @subpackage Tutor\Quiz
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

$contexts = array(
	'attempt-table'           => array(
		'columns'  => array(
			'checkbox'         => '<div class="tutor-d-flex"><input type="checkbox" id="tutor-bulk-checkbox-all" class="tutor-form-check-input" /></div>',
			'date'             => __( 'Date', 'acadia' ),
			'quiz_info'        => __( 'Quiz Info', 'acadia' ),
			'course'           => __( 'Course', 'acadia' ),
			'question'         => __( 'Question', 'acadia' ),
			'total_marks'      => __( 'Total Marks', 'acadia' ),
			'correct_answer'   => __( 'Correct Answer', 'acadia' ),
			'incorrect_answer' => __( 'Incorrect Answer', 'acadia' ),
			'earned_marks'     => __( 'Earned Marks', 'acadia' ),
			'result'           => __( 'Result', 'acadia' ),
			'details'          => __( 'Details', 'acadia' ),
		),
		'contexts' => array(
			'frontend-dashboard-my-attempts'       => array(
				'quiz_info',
				'question',
				'total_marks',
				'correct_answer',
				'incorrect_answer',
				'earned_marks',
				'result',
				'details',
			),
			'frontend-dashboard-students-attempts' => 'frontend-dashboard-my-attempts',
			'course-single-previous-attempts'      => array(
				'date',
				'question',
				'total_marks',
				'correct_answer',
				'incorrect_answer',
				'earned_marks',
				'result',
				'details',
			),
			'backend-dashboard-students-attempts'  => array(
				'checkbox',
				'quiz_info',
				'course',
				'question',
				'total_marks',
				'correct_answer',
				'incorrect_answer',
				'earned_marks',
				'result',
				'details',
			),
		),
	),
	'attempt-details-summary' => array(
		'columns'  => array(
			'user'             => __( 'Attempt By', 'acadia' ),
			'date'             => __( 'Date', 'acadia' ),
			'qeustion_count'   => __( 'Question', 'acadia' ),
			'quiz_time'        => __( 'Quiz Time', 'acadia' ),
			'attempt_time'     => __( 'Attempt Time', 'acadia' ),
			'total_marks'      => __( 'Total Marks', 'acadia' ),
			'pass_marks'       => __( 'Pass Marks', 'acadia' ),
			'correct_answer'   => __( 'Correct Answer', 'acadia' ),
			'incorrect_answer' => __( 'Incorrect Answer', 'acadia' ),
			'earned_marks'     => __( 'Earned Marks', 'acadia' ),
			'result'           => __( 'Result', 'acadia' ),
		),
		'contexts' => array(
			'frontend-dashboard-my-attempts'       => array(
				'date',
				'qeustion_count',
				'total_marks',
				'pass_marks',
				'correct_answer',
				'incorrect_answer',
				'earned_marks',
				'result',
			),
			'frontend-dashboard-students-attempts' => 'frontend-dashboard-my-attempts',
			'course-single-previous-attempts'      => 'frontend-dashboard-my-attempts',
			'backend-dashboard-students-attempts'  => true,
		),
	),
	'attempt-details-answers' => array(
		'columns'  => array(
			'no'             => __( 'No', 'acadia' ),
			'type'           => __( 'Type', 'acadia' ),
			'questions'      => __( 'Questions', 'acadia' ),
			'given_answer'   => __( 'Given Answer', 'acadia' ),
			'correct_answer' => __( 'Correct Answer', 'acadia' ),
			'result'         => __( 'Result', 'acadia' ),
			'manual_review'  => __( 'Review', 'acadia' ),
		),
		'contexts' => array(
			'frontend-dashboard-my-attempts'       => array(
				'no',
				'type',
				'questions',
				'given_answer',
				'correct_answer',
				'result',
			),
			'frontend-dashboard-students-attempts' => array(
				'no',
				'type',
				'questions',
				'given_answer',
				'correct_answer',
				'result',
				'manual_review',
			),
			'backend-dashboard-students-attempts'  => 'frontend-dashboard-students-attempts',
			'course-single-previous-attempts'      => 'frontend-dashboard-my-attempts',
		),
	),
);

return tutor_utils()->get_table_columns_from_context( $page_key, $context, $contexts, 'tutor/quiz/attempts/table/column' );
