<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);

 $total_download = count(WC()->customer->get_downloadable_products());
 $custom_avater = get_the_author_meta( 'acadia_author_avater' );
?>


<div class="profile__tab-content">
	<div class="profile__main">
		<div class="profile__main-top pb-80">
			<div class="row align-items-center">
				<div class="col-md-6">
					<div class="profile__main-inner d-flex flex-wrap align-items-center">
						<div class="profile__main-thumb">

							<?php if(!empty($custom_avater)) : ?>
								<img src="<?php echo esc_url($custom_avater); ?>" alt="<?php echo esc_attr($author_name) ?>">
							<?php else: ?>
								<?php print get_avatar( get_the_author_meta( 'user_email' ), 80, '', '', [ 'class' => 'media-object img-circle' ] );?>  
							<?php endif; ?>
						</div>
						<div class="profile__main-content">
							<h4 class="profile__main-title"><?php echo esc_html__('Welcome', 'acadia'); ?> <?php echo esc_html( $current_user->display_name ); ?></h4>
							<p class="text-capitalize"><?php echo esc_html($current_user->roles[0]); ?></p>
						</div>
					</div>
				</div>
				<div class="col-md-6">
					<div class="profile__main-logout text-sm-end">
						<a href="<?php echo esc_url(wc_logout_url()); ?>" class="tp-logout-btn"><?php echo esc_html__('Logout', 'acadia'); ?></a>
					</div>
				</div>
			</div>
		</div>
		<div class="profile__main-info">
			<div class="row gx-3">
				<div class="col-md-3 col-sm-6">
					<div class="profile__main-info-item">
						<div class="profile__main-info-icon">
							<span>
								<span class="profile-icon-count profile-download"><?php echo esc_html($total_download); ?></span>
								<svg enable-background="new 0 0 512 512" viewBox="0 0 512 512"><path d="m334.52 286.41c3.21 3.21 3.21 8.42 0 11.63l-71.73 71.73c-1.48 2.16-3.97 3.59-6.79 3.59-.03 0-.07 0-.1 0s-.07 0-.1 0c-2.11 0-4.21-.8-5.82-2.41l-72.5-72.5c-3.21-3.21-3.21-8.42 0-11.63s8.42-3.21 11.63 0l58.66 58.66v-198.62c0-4.54 3.68-8.23 8.23-8.23 4.54 0 8.23 3.68 8.23 8.23v198.21l58.66-58.66c3.21-3.21 8.42-3.21 11.63 0zm117.29-226.22c39.34 38.21 58.47 100.39 60.19 195.66v.3c-1.72 95.28-20.85 157.46-60.19 195.66-38.21 39.34-100.39 58.47-195.66 60.19-.05 0-.1 0-.15 0s-.1 0-.15 0c-95.28-1.72-157.46-20.85-195.66-60.19-39.34-38.21-58.47-100.38-60.19-195.66 0-.1 0-.2 0-.3 1.72-95.28 20.85-157.46 60.19-195.66 38.21-39.34 100.39-58.47 195.66-60.19h.3c95.27 1.72 157.45 20.85 195.66 60.19zm43.73 195.81c-1.65-90.63-19.22-149.13-55.28-184.09-.06-.06-.12-.12-.18-.18-34.95-36.06-93.45-53.62-184.08-55.27-90.63 1.65-149.13 19.22-184.09 55.28-.06.06-.12.12-.18.18-36.06 34.95-53.62 93.44-55.27 184.08 1.65 90.63 19.22 149.13 55.28 184.09l.18.18c34.95 36.06 93.45 53.62 184.09 55.28 90.63-1.65 149.13-19.22 184.09-55.28l.18-.18c36.04-34.96 53.61-93.45 55.26-184.09z"></path></svg>
							</span>
						</div>
						<h4 class="profile__main-info-title">
							<a href="<?php echo esc_url( wc_get_endpoint_url( 'downloads' ) );?>"><?php echo esc_html__('Downlaods', 'acadia'); ?></a>
						</h4>
	
					</div>
				</div>
				
				<div class="col-md-3 col-sm-6">
					<div class="profile__main-info-item">
						<div class="profile__main-info-icon">
							<span>
								<span class="profile-icon-count profile-order"><?php echo esc_html(wc_get_customer_order_count($current_user->ID)); ?></span>
								<svg viewBox="0 0 512 512"><path d="M472.916,224H448.007a24.534,24.534,0,0,0-23.417-18H398V140.976a6.86,6.86,0,0,0-3.346-6.062L207.077,26.572a6.927,6.927,0,0,0-6.962,0L12.48,134.914A6.981,6.981,0,0,0,9,140.976V357.661a7,7,0,0,0,3.5,6.062L200.154,472.065a7,7,0,0,0,3.5.938,7.361,7.361,0,0,0,3.6-.938L306,415.108v41.174A29.642,29.642,0,0,0,335.891,486H472.916A29.807,29.807,0,0,0,503,456.282v-202.1A30.2,30.2,0,0,0,472.916,224Zm-48.077-4A10.161,10.161,0,0,1,435,230.161v.678A10.161,10.161,0,0,1,424.839,241H384.161A10.161,10.161,0,0,1,374,230.839v-.678A10.161,10.161,0,0,1,384.161,220ZM203.654,40.717l77.974,45.018L107.986,185.987,30.013,140.969ZM197,453.878,23,353.619V153.085L197,253.344Zm6.654-212.658-81.668-47.151L295.628,93.818,377.3,140.969ZM306,254.182V398.943l-95,54.935V253.344L384,153.085V206h.217A24.533,24.533,0,0,0,360.8,224H335.891A30.037,30.037,0,0,0,306,254.182Zm183,202.1A15.793,15.793,0,0,1,472.916,472H335.891A15.628,15.628,0,0,1,320,456.282v-202.1A16.022,16.022,0,0,1,335.891,238h25.182a23.944,23.944,0,0,0,23.144,17H424.59a23.942,23.942,0,0,0,23.143-17h25.183A16.186,16.186,0,0,1,489,254.182Z"/><path d="M343.949,325h7.327a7,7,0,1,0,0-14H351V292h19.307a6.739,6.739,0,0,0,6.655,4.727A7.019,7.019,0,0,0,384,289.743v-4.71A7.093,7.093,0,0,0,376.924,278H343.949A6.985,6.985,0,0,0,337,285.033v32.975A6.95,6.95,0,0,0,343.949,325Z"/><path d="M344,389h33a7,7,0,0,0,7-7V349a7,7,0,0,0-7-7H344a7,7,0,0,0-7,7v33A7,7,0,0,0,344,389Zm7-33h19v19H351Z"/><path d="M351.277,439H351V420h18.929a7.037,7.037,0,0,0,14.071.014v-6.745A7.3,7.3,0,0,0,376.924,406H343.949A7.191,7.191,0,0,0,337,413.269v32.975A6.752,6.752,0,0,0,343.949,453h7.328a7,7,0,1,0,0-14Z"/><path d="M393.041,286.592l-20.5,20.5-6.236-6.237a7,7,0,1,0-9.9,9.9l11.187,11.186a7,7,0,0,0,9.9,0l25.452-25.452a7,7,0,0,0-9.9-9.9Z"/><path d="M393.041,415.841l-20.5,20.5-6.236-6.237a7,7,0,1,0-9.9,9.9l11.187,11.186a7,7,0,0,0,9.9,0l25.452-25.452a7,7,0,0,0-9.9-9.9Z"/><path d="M464.857,295H420.891a7,7,0,0,0,0,14h43.966a7,7,0,0,0,0-14Z"/><path d="M464.857,359H420.891a7,7,0,0,0,0,14h43.966a7,7,0,0,0,0-14Z"/><path d="M464.857,423H420.891a7,7,0,0,0,0,14h43.966a7,7,0,0,0,0-14Z"/></svg>
							</span>
						</div>
						<h4 class="profile__main-info-title">
							<a href="<?php echo esc_url( wc_get_endpoint_url( 'orders' ) );?>"> <?php echo esc_html__('Orders', 'acadia'); ?></a>
						</h4>
					</div>
				</div>
	

				<div class="col-md-3 col-sm-6">
					<div class="profile__main-info-item">
						<div class="profile__main-info-icon">
							<span>
								<svg viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m43.3 60.7h-42.3c-.5 0-1-.4-1-1s.4-1 1-1h42.3c.5 0 1 .4 1 1s-.5 1-1 1z"/></g><g><g><path d="m43.3 60.7h-36.2c-.5 0-1-.4-1-1v-25.5c0-.5.4-1 1-1s1 .4 1 1v24.5h35.2c.5 0 1 .4 1 1s-.5 1-1 1z"/></g><g><path d="m4.5 36.2c-1.2 0-2.3-.4-3.2-1.3-.8-.8-1.3-2-1.3-3.2 0-1.1.5-2.2 1.2-3.1l22.9-22.9c3.2-3.2 8.3-3.2 11.5 0l9.8 9.8c.4.4.4 1 0 1.4s-1 .4-1.4 0l-9.8-9.8c-2.4-2.4-6.3-2.4-8.7 0l-22.8 22.8c-.4.5-.7 1.2-.7 1.8 0 .5.1 1.2.7 1.8 1 1 2.7 1 3.7 0l22.8-22.8c.4-.4 1-.4 1.4 0l8.3 8.3c.4.4.4 1 0 1.4s-1 .4-1.4 0l-7.6-7.6-22.1 22.1c-.9.9-2.1 1.3-3.3 1.3z"/></g><g><path d="m32.9 60.7h-14.2c-.5 0-1-.4-1-1v-18.2c0-1.6 1.3-3 3-3h10.3c1.6 0 2.9 1.4 2.9 3v18.2c0 .5-.5 1-1 1zm-13.2-2h12.2v-17.2c0-.6-.5-1-.9-1h-10.3c-.6 0-1 .5-1 1z"/></g><g><path d="m49.5 60.6c-1.3 0-2.5-.7-3.2-1.8-3.5-5.8-11.4-19.8-11.4-25.8 0-8 6.5-14.5 14.5-14.5s14.6 6.5 14.6 14.5c0 4.2-3.8 12.8-11.2 25.8-.8 1.1-2 1.8-3.3 1.8zm-.1-40.1c-6.9 0-12.5 5.6-12.5 12.5 0 5.6 8.5 20.4 11.1 24.8.3.5.9.9 1.6.9s1.2-.3 1.6-.9c8.9-15.7 10.8-22.2 10.8-24.8 0-6.9-5.6-12.5-12.6-12.5z"/></g><g><path d="m49.5 42.3c-5.1 0-9.3-4.2-9.3-9.3s4.2-9.3 9.3-9.3 9.3 4.2 9.3 9.3-4.2 9.3-9.3 9.3zm0-16.6c-4 0-7.3 3.3-7.3 7.3s3.3 7.3 7.3 7.3 7.3-3.3 7.3-7.3-3.3-7.3-7.3-7.3z"/></g><g><path d="m21.7 51.4c-.5 0-1-.4-1-1v-1.3c0-.5.4-1 1-1s1 .4 1 1v1.3c0 .5-.5 1-1 1z"/></g></g></g></svg>
							</span>
						</div>
						<h4 class="profile__main-info-title">
							<a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address' ) );?>"> <?php echo esc_html__('Address', 'acadia'); ?></a>
						</h4>
					</div>
				</div>
	
				<div class="col-md-3 col-sm-6">
					<div class="profile__main-info-item">
						<div class="profile__main-info-icon">
							<span>
								<svg viewBox="0 0 410.702 410.702" xmlns="http://www.w3.org/2000/svg"><g><path d="m10.604 353.97v48.004c0 4.849 3.879 8.243 8.728 8.728h259.416c4.849 0 8.243-3.879 8.728-8.728v-48.004c0-57.217-37.821-107.161-92.614-123.162 16.971-9.213 30.548-23.76 38.791-40.731 7.273 5.819 15.516 10.183 23.76 13.092v10.668c0 12.122 9.698 22.305 22.305 22.305h19.396c12.122 0 22.305-9.698 22.305-22.305v-10.668c9.698-3.394 18.426-8.728 26.669-15.032l9.213 5.334c10.668 5.819 24.245 2.424 30.063-8.243l9.698-16.486c6.304-10.668 2.424-24.245-8.243-30.548l-9.213-5.334c.97-4.849 1.455-10.183 1.455-15.032s-.485-10.183-1.455-15.032l9.213-5.334c10.668-5.819 14.547-19.396 8.243-30.063-.485-.485-1.94-2.909-9.698-16.486-6.304-10.668-19.396-14.062-30.063-8.243l-9.213 5.334c-7.758-6.304-16.971-11.637-26.669-15.032v-10.667c0-12.122-9.698-22.305-22.305-22.305h-19.396c-12.122 0-22.305 9.698-22.305 22.305v10.668c-9.698 3.394-18.426 8.728-26.669 15.032l-9.213-5.334c-10.668-5.819-24.245-2.424-30.063 8.243l-6.788 11.637c-11.152-4.849-23.275-6.788-35.397-6.788-51.398 0-93.584 41.216-93.584 92.614 0 33.942 18.426 65.46 48.004 81.946-55.277 16.001-93.099 66.43-93.099 123.647zm194.926-294.328c1.455-2.424 4.364-3.394 7.273-1.94l14.547 8.243c3.394 1.94 7.273 1.455 10.183-.97 8.728-8.243 18.911-14.062 30.548-17.456 3.394-.97 6.304-4.364 6.304-8.243v-16.486c0-2.909 2.424-5.334 5.334-5.334h19.396c2.909 0 5.334 2.424 5.334 5.334v16.486c0 3.879 2.424 7.273 6.304 8.243 11.152 3.394 21.82 9.213 30.548 17.456 2.909 2.424 6.788 2.909 10.183.97l14.547-8.243c2.424-1.455 5.819-.485 7.273 1.94l9.696 16.486c1.455 2.424.485 5.819-1.94 6.788l-14.547 8.243c-3.394 1.94-4.849 5.819-3.879 9.213 2.909 11.637 2.909 23.275 0 34.912-.97 3.879.97 7.758 3.879 9.213l14.547 8.243c2.424 1.455 3.394 4.364 1.94 7.273l-9.698 16.486c-1.455 2.424-4.364 3.394-6.788 1.94l-14.547-8.243c-3.394-1.94-7.273-1.455-10.183.97-8.728 8.243-18.911 14.062-30.548 17.456-3.879.97-6.304 4.364-6.304 8.243v16.486c0 2.909-2.424 5.334-5.334 5.334h-19.396c-2.909 0-5.334-2.424-5.334-5.334v-16.486c0-3.879-2.424-7.273-6.304-8.243-10.668-2.909-20.365-8.243-28.609-15.516 1.94-7.758 2.909-16.971 2.909-23.76 0-32.973-17.456-62.066-43.155-78.552zm-133.345 89.219c0-42.185 34.427-76.128 76.613-76.128s76.613 34.427 76.613 76.128c0 39.761-30.063 76.613-77.098 76.613-41.701 0-76.128-34.427-76.128-76.613zm66.915 93.584c.97 0 20.365 0 19.396 0 61.581 0 111.525 49.944 111.525 111.525v39.276h-242.446v-39.276c0-61.581 49.944-111.525 111.525-111.525z"/><path d="m288.931 165.348c26.184 0 47.034-21.335 47.034-47.519s-21.335-47.034-47.519-47.034-47.034 21.335-47.034 47.519c0 25.698 21.335 47.034 47.519 47.034zm0-77.583c16.971 0 30.063 14.062 30.063 30.548 0 16.971-14.062 30.063-30.548 30.063s-30.063-13.577-30.063-30.548 13.577-30.548 30.548-30.063z"/></g></svg>
							</span>
						</div>
						<h4 class="profile__main-info-title">
							<a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-account' ) );?>"> <?php echo esc_html__('My Account', 'acadia'); ?></a>
						</h4>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
