(function($, window, document, undefined) {
    "use strict";

    var masterAccordion = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterAccordion.prototype = {
        defaults: {

        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            //this.build();
            this.event();
            return this;
        },
        build: function() {
            // var
            // t = this,
            // css = "",
            // cls = "",
            // arr = [],
            // a = t.args.itemMargin,
            // b = t.args.navWidth,
            // c = t.args.navBgColor,
            // d = t.args.navPadding,
            // e = t.args.navMargin,
            // f = t.args.navBorder,
            // g = t.args.navIcon,
            // h = t.args.navIconMargin,
            // i = t.args.navIconColor,
            // //x = t.$elm.find(".master-tab-nav .icon").remove(),
            // //y = t.$elm.find(".master-accordion-item"),
            // z = t.$elm.attr("class").split(" ");

            // $(z).each(function(i, e) { 
            //     e.indexOf("mlr-") == 0 && (cls = "." + z[0] + "." + e)
            // });


            // switch(a) {
            //     case "center":
            //         a = "justify-content: center"
            //         break;
            //     case "center":
            //         a = "justify-content: flex-end"
            //         break;
            //     default:
            //         a = ""
            // }

            // b = b ? "flex-basis:" + ( 100 / y.length ) + "%;" : "",
            // c = c ? "background-color:" + c + ";" : "",
            // d = d ? "padding:" + d + ";" : "",
            // e = e ? "margin:" + e + ";" : "",
            // f = f ? "border:" + f + ";" : "",

            // g && $("<div />").addClass("icon").html('<i class="' + g + '"></i>').prependTo(y),
            // h = h ? "margin:" + h + ";" : "",
            // i = i ? "color:" + i + ";" : "",

            // css += cls + " .tab-nav-wrap {" + a + "}\n",
            // css += cls + " .master-tab-nav {" + b + c + d + e + f + "}\n",
            // css += cls + " .master-tab-nav .icon {" + h + i + "}\n",
            // css && $("#master-dynamic").length
            //     ? ((arr = $("#master-dynamic").html().split("\n")),
            //       $.each(arr, function(i, e) {
            //           e && e.indexOf(cls) > -1 && arr.splice(i, 1)
            //       }),
            //       $("#master-dynamic").empty().append(arr.join("\n")).append(css))
            //     : $("head").append("<style type='text/css' id='master-dynamic'>" + css + "</style>") 
        },
        event: function() {
            // var t = this,
            //     args = {easing:"easeOutExpo", duration:300};

            // t.$elm.children(".master-accordion-item.active").length 
            //     ? t.$elm.children(".master-accordion-item.active").children(".item-content").show()
            //     : t.$elm.children(".master-accordion-item:first").addClass("active").children(".item-content").show()

            // t.$elm.children(".master-accordion-item").find(".item-title").on( "click", function() {
            //     if ( !$(this).parent().is(".active") ) {
            //         $(this).parent().toggleClass("active")
            //             .children(".item-content").slideToggle(args)
            //         .parent().siblings(".active").removeClass("active")
            //             .children(".item-content").slideToggle(args);
            //     } else {
            //         $(this).parent().toggleClass("active");
            //         $(this).next().slideToggle(args);
            //     }
            // } )

            var 
            t = this,
            args = {easing:'easeOutExpo', duration:300};

            t.$elm.children('.item.active').children('.item-content').show();

            t.$elm.children('.item').find('.item-title').on( 'click', function() {
                if ( !$(this).parent().is('.active') ) {
                    $(this).parent().toggleClass('active')
                        .children('.item-content').slideToggle(args)
                    .parent().siblings('.active').removeClass('active')
                        .children('.item-content').slideToggle(args);
                } else {
                    $(this).parent().toggleClass('active');
                    $(this).next().slideToggle(args);
                }
            } )
        }
    };

    masterAccordion.defaults = masterAccordion.prototype.defaults;

    $.fn.masterAccordion = function(opts) {
        return this.each(function() {
            new masterAccordion(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterAnimate = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterAnimate.prototype = {
        defaults: {
            interaction: "inview",
            duration: "0.7s",
            delay: "0s"
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
        },
        build: function() {
            var
            t = this,
            a = t.args.animate,
            b = t.args.interaction,
            c = t.args.duration,
            d = t.args.delay;

            t.$elm.addClass("animate-" + a),
            (b == "inview") && t.$elm.addClass("viewport-loaded"),
            (b == "loaded") && t.$elm.addClass("window-loaded"),
            t.$elm.css({"animation-duration": c + "ms", "animation-delay": d + "ms"});

            (b == "inview") && t.inview();
            (b == "loaded") && t.loaded();
        },
        inview: function() {
            var t = this;
            t.$elm.appear(function() {
                t.$elm.addClass("animated")
            })
        },
        loaded: function() {
            var t = this;
            if ( document.readyState == "complete" ) {
                t.$elm.addClass("animated")
            } else {
                $(window).load(function() {
                    t.$elm.addClass("animated")
                })
            }
        }

    };

    masterAnimate.defaults = masterAnimate.prototype.defaults;

    $.fn.masterAnimate = function(opts) {
        return this.each(function() {
            new masterAnimate(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterAnimatedText = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterAnimatedText.prototype = {
        defaults: {
            interaction: "inview",
            delay: 0,
            split: "",
            effect: "fx1"
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
        },
        build: function() {
            var
            t = this,
            a = t.args.animate,
            b = t.args.interaction,
            c = t.args.split;

            ((c !== "words") && (c !== "lines")) && (c = ""),
            t.$elm.lettering(c),
            t.$elm.children().wrap('<span class="text-animate"></span>');

            //console.log(t.$elm.children())
            (b == "inview") && t.inview();
            (b == "loaded") && t.loaded();
            (b == "hover") && t.hover();
        },
        inview: function() {
            var t = this;
            t.$elm.find(".text-animate > span").css("opacity","0");
            t.$elm.appear(function() {
                setTimeout(function() {
                    t.$elm.textHoverMaster(t.args)
                }, t.args.delay )
            })
        },
        loaded: function() {
            var t = this;
            t.$elm.find(".text-animate > span").css("opacity","0");
            if ( document.readyState == "complete" ) {
                setTimeout(function() {
                    t.$elm.textHoverMaster(t.args)
                }, t.args.delay )
            } else {
                $(window).load(function() {
                    setTimeout(function() {
                        t.$elm.textHoverMaster(t.args)
                    }, t.args.delay )
                })
            }
        },
        hover: function() {
            var t = this,
            a = t.args.parentHover;

            a ? a = t.$elm.closest("." + a) : a = t.$elm,
            a.mouseenter(function() {
                setTimeout(function() {
                    t.$elm.find(".text-animate > span").css("opacity","0");
                    t.$elm.textHoverMaster(t.args)
                }, t.args.delay )
            })
        }

    };

    masterAnimatedText.defaults = masterAnimatedText.prototype.defaults;

    $.fn.masterAnimatedText = function(opts) {
        return this.each(function() {
            new masterAnimatedText(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterSlideText = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterSlideText.prototype = {
        defaults: {
            delay: 3000,
            split: "",
            effect: "fx1"
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
        },
        build: function() {
            var
            t = this,
            current = 0,
            next = 1,
            a = t.args.effect,
            b = t.args.interaction,
            c = t.args.split,
            d = t.args.delay,
            slides = t.$elm.find(".slide");

            slides.first().addClass("slide-current"),
            ((c !== "words") && (c !== "lines")) && (c = ""),
            t.$elm.find(".slide .title").lettering(c),
            t.$elm.find(".slide .title span").wrap('<span class="text-animate"></span>'),
            slides.first().find(".title .text-animate span").css("opacity", 1)

            var loop;
            //console.log(!loop)
            //$(window).focus(function() {
            //    console.log("aaaa")
            //    if (!loop) {
                    loop = setInterval(function() {
                        slides.eq(next).addClass("slide-current"),
                        slides.eq(current).removeClass("slide-current"),

                        t.args.newText = slides.eq(next).find(".title"),
                        slides.eq(current).find(".title").textHoverMaster(t.args),
                        current ++,
                        next ++,
                        (current == slides.length) && (current = 0),
                        (next == slides.length) && (next = 0)
                    }, d);
            //    }
            //});

            // Prevent loop to any time when visit another tab browser
            // $(window).blur(function() {
            //     console.log("bbbb")
            //     clearInterval(loop);
            //     loop = 0;
            // });
            
        },
    };

    masterSlideText.defaults = masterSlideText.prototype.defaults;

    $.fn.masterSlideText = function(opts) {
        return this.each(function() {
            new masterSlideText(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterImageEffect = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterImageEffect.prototype = {
        defaults: {
            displacement: "",
            intensity: 1,
            speedIn: 1.6,
            speedOut: 1.2,
            hover: true,
            easing: "easeOut",
            parent: ""
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
        },
        build: function() {
            var t = this;
            var canvas = t.$elm.find('.canvas');
            var planeElement = t.$elm.find('.inner');
            const navs = t.$elm.find('[data-goto]');
            let slide = new imageEffectMaster({
                canvas,
                planeElement,
                navs
            })
        }
    };

    masterImageEffect.defaults = masterImageEffect.prototype.defaults;

    $.fn.masterImageEffect = function(opts) {
        return this.each(function() {
            new masterImageEffect(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterImageHover = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterImageHover.prototype = {
        defaults: {
            image1: "",
            image2: "",
            displacement: "",
            intensity: 1,
            speedIn: 1.6,
            speedOut: 1.2,
            hover: true,
            easing: "easeOut",
            parent: ""
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
        },
        build: function() {
            var t = this;
            t.$elm.imageHoverMaster(t.args)
        }
    };

    masterImageHover.defaults = masterImageHover.prototype.defaults;

    $.fn.masterImageHover = function(opts) {
        return this.each(function() {
            new masterImageHover(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterSpacer = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterSpacer.prototype = {
        defaults: {
            desktop: "110px",
            mobi: "60px",
            smobi: "60px"
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            var t = this;
            $(window).on('load resize', function() {
                var mode = 'desktop';

                if ( matchMedia( 'only screen and (max-width: 991px)' ).matches )
                    mode = 'mobile';

                if ( matchMedia( 'only screen and (max-width: 767px)' ).matches )
                    mode = 'smobile';

                if ( 'desktop' == mode ) t.$elm.attr( 'style', 'height:' + t.args.desktop )
                if ( 'mobile' == mode ) t.$elm.attr( 'style', 'height:' + t.args.mobile )
                if ( 'smobile'== mode ) t.$elm.attr( 'style', 'height:' + t.args.smobile )
            });
        }
    };

    masterSpacer.defaults = masterSpacer.prototype.defaults;

    $.fn.masterSpacer = function(opts) {
        return this.each(function() {
            new masterSpacer(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterParallaxBG = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterParallaxBG.prototype = {
        defaults: {
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            this.mouseParallax();
        },
        build: function() {
            var
            t = this,
            a = t.args.image,
            b = t.args.xPosition,
            c = t.args.speed,
            d = t.args.minHeight,
            y = t.$elm.find(".fade-scroll"),
            z = t.$elm.find(".background");

            t.$elm.parent().css("overflow", "hidden"),
            t.$elm.css({"min-height": d}),
            t.$elm.find(".background").css({"background-image": "url(" + a + ")"}),
            z.parallax(b, c)
            
            if ( y.length ) {
                y.wrap('<div class="outer"></div>')
                var 
                child = y.children(),
                f = y.outerHeight(),
                g = child.length;
                child.each(function(i, e) {
                    $(e).wrap('<div class="outer"></div>')
                    $(window).on("scroll", function(){
                        // Fade out each children, not parent
                        var 
                        h = window.scrollY - y.closest(".outer").offset().top,
                        j = i/5,
                        op = (f - h)/f - j,
                        sc = window.scrollY - y.closest(".outer").offset().top;
                        if ( sc > 0 ) {
                            y.css({"transform": "translateY(" +  sc + "px)"})
                            $(e).closest(".outer").css({"opacity": op})
                        } else {
                            $(e).closest(".outer").css({"opacity": 1})
                        }

                    });
                })    
            }
        },
        mouseParallax: function() {
            var 
            timeout,
            t = this,
            z = t.$elm.find(".background");
            if (z.is(".mouse-parallax")) {
                z.wrap('<div class="bg-wrap"></div>')
                var wr = z.parent();

                $(window).resize(changePersective);             
                changePersective();             
                function changePersective(){
                    wr.css("perspective", $("body").width())
                }

                t.$elm.on("mousemove", function(e) {
                    if(timeout) clearTimeout(timeout);
                    setTimeout(callParallaxHero.bind(null, e)); 
                })
                function callParallaxHero(e){
                    parallaxItHero(e, z, 0); //5
                    moveItHero(e, z, - 30); //80
                }               
                function parallaxItHero(e, target, movement){
                    var $this = wr;
                    var relX = e.pageX - $this.offset().left;
                    var relY = e.pageY - $this.offset().top;                    
                    TweenMax.to(target, 1, {
                        rotationY: (relX - $this.width()/1.5) / $this.width() * movement,
                        rotationX: (relY - $this.height()/2) / $this.height() * movement,
                    })
                }               
                function moveItHero(e, target, movement){
                    var $this = wr;
                    var relX = e.pageX - $this.offset().left;
                    var relY = e.pageY - $this.offset().top;                    
                    TweenMax.to(target, 1, {
                        x: (relX - $this.width()/2) / $this.width() * movement,
                        y: (relY - $this.height()/2) / $this.height() * movement,
                    })
                }
            }
        }
    };

    masterParallaxBG.defaults = masterParallaxBG.prototype.defaults;

    $.fn.masterParallaxBG = function(opts) {
        return this.each(function() {
            new masterParallaxBG(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterHeroBgList = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterHeroBgList.prototype = {
        defaults: {
            column: 4,
            height: "100vh"
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
        },
        build: function() {
            var
            t = this,
            a = t.args.height,
            b = t.args.column,
            y = t.$elm.find(".hero-bg"),
            z = t.$elm.find(".hero-content");


            t.$elm.css({"height": a})
            z.css({"width":100/b + "%"})

            z.on("mouseenter", function() {
                var idx = $(this).index();
                y.eq(idx).addClass("active").siblings().removeClass("active")
            })
        },
    };

    masterHeroBgList.defaults = masterHeroBgList.prototype.defaults;

    $.fn.masterHeroBgList = function(opts) {
        return this.each(function() {
            new masterHeroBgList(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterHero3D = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterHero3D.prototype = {
        defaults: {
            horizontalThreshold: 15,
            verticalThreshold: 25
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
        },
        build: function() {
            var
            t = this,
            a = t.args.image,
            b = t.args.mapping;

            //var sketch = new Sketch();

            // t.$elm.css({"height": a})
            // z.css({"width":100/b + "%"})

            // z.on("mouseenter", function() {
            //     var idx = $(this).index();
            //     y.eq(idx).addClass("active").siblings().removeClass("active")
            // })
        },
    };

    masterHero3D.defaults = masterHero3D.prototype.defaults;

    $.fn.masterHero3D = function(opts) {
        return this.each(function() {
            new masterHero3D(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterFancyImage = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterFancyImage.prototype = {
        defaults: {
            effect: "reveal-right",
            videoIcon: "no",
            align: "left"
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            return this;
        },
        build: function() {
            var
            t = this,
            css = "",
            cls = "",
            arr = [],
            a = t.args.image,
            b = t.args.effect,
            c = t.args.rounded,
            d = t.args.videoIcon,
            f = t.args.maxWidth,
            g = t.args.stretchLeft,
            h = t.args.stretchRight,
            i = t.args.align,
            z = t.$elm.attr("class").split(" ");

            $(z).each(function(i, e) { 
                e.indexOf("mlr-") == 0 && (cls = "." + z[0] + "." + e)
            }),

            ["corner-left", "corner-right", "corner-top", "corner-bottom"].indexOf(b) > -1
                ? ($("<div />").addClass("corner-bg background-accent").prependTo(t.$elm), 
                   t.$elm.alterClass("effect-*", "effect-corner").alterClass("corner-*", b)
                  )
                : t.$elm.alterClass("effect-*", "effect-reveal").alterClass("reveal-*", b),

            t.$elm.find("img").attr("src", a),
            
            t.$elm.alterClass("video-*", "video-" + d),
            t.$elm.alterClass("align-*", "align-" + i),

            t.$elm.appear(function() {
                t.$elm.addClass("animated");
            });

            c = c ? "border-radius:" + c + " !important;overflow:hidden;" : "",
            f = f ? "max-width:" + f + " !important;overflow:hidden;" : "",
            f && (i == "center") && (f += "margin-left: auto !important; margin-right: auto !important;"),

            css += g ? "@media only screen and (min-width: 1200px) {" + cls + " .wrap {margin-left:" + g + "}}" : "",
            css += h ? "@media only screen and (min-width: 1200px) {" + cls + " .wrap {margin-right:" + h + "}}" : "",

            css += cls + " .wrap {" + c + f + "}\n",
            css && $("#master-dynamic").length
                ? $("#master-dynamic").append(css)
                : $("head").append("<style type='text/css' id='master-dynamic'>" + css + "</style>")
        },
    };

    masterFancyImage.defaults = masterFancyImage.prototype.defaults;

    $.fn.masterFancyImage = function(opts) {
        return this.each(function() {
            new masterFancyImage(this, opts).init();
        });
    };
}(jQuery, window, document));

(function( $, window, document, undefined ) {
    "use strict";

    var masterPortfolio = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterPortfolio.prototype = {
        defaults: {
            filters: ".projects-filter",
            layoutMode: "grid",
            defaultFilter: "*",
            gapHorizontal: 30,
            gapVertical: 30,
            showNavigation: !0,
            showPagination: !0,
            gridAdjustment: "responsive",
            rewindNav: !1,
            auto: !1,
            mediaQueries: [{
                width: 1200,
                cols: 4,
            }, {
                width: 992,
                cols: 3,
            }, {
                width: 768,
                cols: 2,
            }, {
                width: 480,
                cols: 1,
            }],
            columns: "5,3,2,1",
            displayType: 'bottomToTop',
            displayTypeSpeed: 100
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            return this;
        },
        build: function() {
            var
            t = this,
            a = t.config.columns,
            b = t.args.mediaQueries;

            b = a == "3,3,2,1" ? [{"width": 1200, "cols": 3},{"width": 992, "cols": 3},{"width": 768, "cols": 2},{"width": 480, "cols": 1}] : b,
            b = a == "4,3,2,1" ? [{"width": 1200, "cols": 4},{"width": 992, "cols": 3},{"width": 768, "cols": 2},{"width": 480, "cols": 1}] : b,
            b = a == "5,3,2,1" ? [{"width": 1200, "cols": 5},{"width": 992, "cols": 3},{"width": 768, "cols": 2},{"width": 480, "cols": 1}] : b,
            b = a == "6,4,3,2" ? [{"width": 1200, "cols": 6},{"width": 992, "cols": 4},{"width": 768, "cols": 3},{"width": 480, "cols": 2}] : b,

            t.args.mediaQueries = b,
            t.$elm.find(".projects").cubeportfolio(t.args)
        },
    };

    masterPortfolio.defaults = masterPortfolio.prototype.defaults;

    $.fn.masterPortfolio = function(opts) {
        return this.each(function() {
            new masterPortfolio(this, opts).init();
        });
    };
}(jQuery, window, document));

(function( $, window, document, undefined ) {
    "use strict";

    var masterPortfolioSlider = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterPortfolioSlider.prototype = {
        defaults: {
            filters: ".projects-filter",
            layoutMode: "grid",
            defaultFilter: "*",
            gapHorizontal: 10,
            gapVertical: 10,
            showNavigation: !1,
            showPagination: !0,
            gridAdjustment: "responsive",
            sortByDimension: false,
            rewindNav: !1,
            auto: !1,
            mediaQueries: [{
                width: 1200,
                cols: 8,
            }, {
                width: 992,
                cols: 3,
            }, {
                width: 768,
                cols: 2,
            }, {
                width: 480,
                cols: 1,
            }],
            columns: "5,3,2,1",
            displayType: 'bottomToTop',
            displayTypeSpeed: 100,
            itemWidth: 2,
            rows: 2,
            colsView: 4.5
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            this.event();
            return this;
        },
        build: function() {
            var
            t = this,
            a = t.config.columns,
            b = t.args.mediaQueries;
            t.$elm.wrap('<div class="scroll-wrap"></div>')

            // b = a == "8,6,2,1" ? [{"width": 1200, "cols": 8},{"width": 992, "cols": 6},{"width": 768, "cols": 2},{"width": 480, "cols": 1}] : b,
            b = a == "12,6,2,1" ? [{"width": 1200, "cols": 12},{"width": 992, "cols": 6},{"width": 768, "cols": 2},{"width": 480, "cols": 1}] : b,
            // b = a == "5,3,2,1" ? [{"width": 1200, "cols": 5},{"width": 992, "cols": 3},{"width": 768, "cols": 2},{"width": 480, "cols": 1}] : b,
            // b = a == "6,4,3,2" ? [{"width": 1200, "cols": 6},{"width": 992, "cols": 4},{"width": 768, "cols": 3},{"width": 480, "cols": 2}] : b

            
            t.args.mediaQueries = b
            var ww = t.args.mediaQueries[0].cols / t.args.colsView * 100;
            (ww < 100) && (ww = 100)
            t.$elm.css("width", ww + "vw")

            if (t.$elm.is(".infinite-scroll")) {
                var
                wo = t.$elm.parent(), 
                wr = t.$elm;
                wr.clone().addClass("clone-before").insertBefore(wr);
                wr.clone().addClass("clone-after").insertAfter(wr);

                var left = t.$elm.siblings(".clone-before");
                var right = t.$elm.siblings(".clone-after");
                left.find(".projects").cubeportfolio(t.args)
                right.find(".projects").cubeportfolio(t.args)
            }

            t.$elm.find(".projects").cubeportfolio(t.args)
        },
        event: function() {
            var t = this;
            
            if (t.$elm.is(".infinite-scroll")) {
                var 
                wo = t.$elm.parent(),
                aw = wo.get(0).scrollWidth - wo.width();

                //Center scroll
                wo.scrollLeft(wo.get(0).scrollWidth / 3)

                wo.on("scroll", function(event) {
                    var sl = wo.scrollLeft();
                    if (sl >= aw) {
                        var scrollPos = wo.get(0).scrollWidth/3 + (wo.get(0).scrollWidth/3 - wo.width());
                        console.log(aw, scrollPos, wo.get(0).scrollWidth, wo.width())
                        wo.scrollLeft(scrollPos)
                    }
                    if (sl <= 0) {
                        wo.scrollLeft(wo.get(0).scrollWidth/3)
                    }
                })
            }

            if (t.$elm.is(".hover-scroll")) {
                // Auto Scroll
                var timeout;
                var scroll = 0;
                var requestId;
                var request20;
                var requestArr = [];
                var wr = t.$elm.parent();

                wr.on("mouseover", function() {
                    requestId = requestAnimationFrame(function animate(time) {
                        scroll += 2;
                        wr.scrollLeft(scroll);
                        request20 = requestAnimationFrame(animate);
                        requestArr.push(request20);
                    });
                })

                wr.on("mouseout", function() {
                    for (var req of requestArr) {
                      cancelAnimationFrame(req);
                    }
                    cancelAnimationFrame(requestId);
                    requestArr.length = 0;
                })
            }
        }
    };

    masterPortfolioSlider.defaults = masterPortfolioSlider.prototype.defaults;

    $.fn.masterPortfolioSlider = function(opts) {
        return this.each(function() {
            new masterPortfolioSlider(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterHeroNav = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterHeroNav.prototype = {
        defaults: {
            dots: true,
            fade: true,
            speed: 500,
            cssEase: "ease-in-out",
            arrows: false,
            infinite: true,
            slidesToShow: 1,
            centerMode: false,
            autoplay: false,
            autoplaySpeed: 5500,
            pauseOnDotsHover: false,
            pauseOnHover: false,

            screenHeight: "no",
            screenHeightReduce: "0px",
            navStyle: "style-1",
            navAlign: "center",
            kenburns: false
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            this.event();
            return this;
        },
        build: function() {
            var 
            t = this,
            cw = t.$elm.find(".hero-carousel-wrap"),
            nw = t.$elm.find(".hero-nav-wrap"),
            sl = t.$elm.find(".master-hero-nav-slide"),
            a = t.args.screenHeight,
            b = t.args.screenHeightReduce,
            e = t.args.kenburns,
            f = t.args.overlays,
            g = t.args.parallax;

            (a == "yes") && cw.find(".hero-slide, .hero-content").css("height", "calc(100vh - " + b + ")"),
            e && t.$elm.addClass("kenburns"),
            f && t.$elm.alterClass("overlays-*", "overlays-" + f),
            g ? t.$elm.find(".hero-image").addClass("parallax") : t.$elm.find(".hero-image").removeClass("parallax"),

            t.args.customPaging = function(e, i) {
                var m = $(e.$slides[i]).find(".hero-nav"),
                n = m.find(".hero-nav-progress").css("transition-duration" , e.options.autoplaySpeed + e.options.speed + "ms"),
                o = m.find(".svg-nav .nav-progress").css("animation-duration" , e.options.autoplaySpeed + "ms");
                m.css("display", "none")
                return ''
                + '<div class="hero-nav">'
                + m.html()
                + '</div>'
            };

            t.args.appendDots = nw,
            cw.slick(t.args, t.$elm.on("init", function() {
                nw.addClass("slide-count-" + nw.find("li").length);
                t.$elm.find("li").addClass("transition-active");
                t.$elm.find(".slick-slide").addClass("transition-active");
            }));

            sl.each(function(idx, el) {
                var 
                t = $(el),
                bg = t.find('.hero-image'),
                args = t.data("config"),
                a = args.bg;

                bg.css("background-image","url(" + a + ")")
            })
        },
        event: function() {
            var 
            t = this;

            t.$elm.on('beforeChange', function(e, slick, currentSlide, nextSlide) {
                var 
                next = t.$elm.find(".hero-slide").eq(nextSlide),
                a = $(next).find(".window-loaded").removeClass("animated");

                // Animated text
                if ( $(next).find(".master-animated-text").length ) {
                    var text = $(next).find(".master-animated-text");
                    text.each(function(i, e) {
                        $(e).find(".text-animate > span").css("opacity","0")
                    })  
                }
            });

            t.$elm.on('afterChange', function(e, slick, currentSlide, prevSlide) {
                var 
                current = t.$elm.find(".hero-slide").eq(currentSlide),
                a = $(current).find(".window-loaded").addClass("animated");

                // Animated text
                if ( $(current).find(".master-animated-text").length ) {
                    var text = $(current).find(".master-animated-text");
                    text.each(function(i, e) {
                        var args = $(e).data("config");
 
                        setTimeout(function() {
                            $(e).textHoverMaster(args)
                        }, args.delay )
                    })  
                }
            });
        }
    };

    masterHeroNav.defaults = masterHeroNav.prototype.defaults;

    $.fn.masterHeroNav = function(opts) {
        return this.each(function() {
            new masterHeroNav(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterHeroSwiper = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterHeroSwiper.prototype = {
        defaults: {
            dots: false,
            fade: false,
            speed: 100,
            cssEase: "ease-in-out",
            arrows: false,
            infinite: true,
            slidesToShow: 1,
            centerMode: false,
            autoplay: false,
            autoplaySpeed: 5500,
            pauseOnDotsHover: false,
            pauseOnHover: false,
            swipeToSlide: true,
            swipe: true,

            screenHeight: "no",
            screenHeightReduce: "0px",
            navStyle: "style-1",
            navAlign: "center",
            kenburns: false,
            interaction: "click",
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            this.event();
            return this;
        },
        build: function() {
            var 
            t = this,
            id = (new Date).getTime(),
            cw = t.$elm.find(".hero-carousel-wrap"),
            nw = t.$elm.find(".hero-nav-wrap"),
            sl = t.$elm.find(".hero-carousel-wrap, .hero-nav-wrap"),
            na = t.$elm.find(".hero-nav"),
            a = t.args.screenHeight,
            b = t.args.screenHeightReduce,
            e = t.args.kenburns,
            f = t.args.overlays,
            g = t.args.parallax,
            h = t.args.interaction;

            na.appendTo(nw),
            cw.attr({"id": "carousel-" + id, "data-nav-target": "#nav-" + id}),
            nw.attr({"id": "nav-" + id, "data-nav-target": "#carousel-" + id}),
            
            (a == "yes") && cw.find(".hero-slide, .hero-content").css("height", "calc(100vh - " + b + ")"),
            e && t.$elm.addClass("kenburns"),
            f && t.$elm.alterClass("overlays-*", "overlays-" + f),
            g ? t.$elm.find(".hero-image").addClass("parallax") : t.$elm.find(".hero-image").removeClass("parallax")

            if ( h !== "hover" ) {
                var navOpts = {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    speed: 100,
                    infinite: true,
                    focusOnSelect: true,
                    centerMode: true,
                    dots: false,
                    arrows: false,
                    swipeToSlide: true,
                    swipe: true
                };

                sl.each(function() {
                    var $slider = $(this);
                    
                    var options;
                    if ( $(this).is(".hero-nav-wrap") ) {
                        options = navOpts;
                    } else {
                        options = t.args;
                    }
                    if ($slider.data('navTarget') !== undefined && $slider.data('navTarget').length) {
                        options.asNavFor = $($slider.data('navTarget'));
                    }
                    var instance = $slider.slick(options);
                    //////
                    // Adding slider instance to object
                    //////
                    if (this.unifato === undefined) this.unifato = {};
                    this.unifato.slick = {};
                    this.unifato.slick.instance = instance;
                }) 
            } else {
                t.args.fade = true,
                t.args.speed = 700,
                cw.slick(t.args),
                nw.addClass("nav-scroll")
            }        
        },
        event: function() {
            var 
            t = this,
            nav = t.$elm.find(".hero-nav"),
            a = t.args.interaction;

            if ( a === "hover" ) {
                t.$elm.addClass("hover-effect")
                nav.each(function(i, e) {
                    var 
                    pos = (t.$elm.width() / 4.5) * i;
                    $(e).css({"left": pos + "px", "width": (100 / 4.5) + "%"})
                })
                nav.on("mouseenter", function() {
                    $(this).addClass("slick-current").siblings().removeClass("slick-current")
                    var current = $(this).index() + 1,
                        slickObj = t.$elm.find(".hero-carousel-wrap").slick("getSlick");
                    slickObj.slickGoTo(current)
                })
            }
        }
    };

    masterHeroSwiper.defaults = masterHeroSwiper.prototype.defaults;

    $.fn.masterHeroSwiper = function(opts) {
        return this.each(function() {
            new masterHeroSwiper(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterProgress = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterProgress.prototype = {
        defaults: {
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            //this.build();
            this.event();
            return this;
        },
        // build: function() {
        //     var
        //     t = this,
        //     css = "",
        //     cls = "",
        //     arr = [],
        //     a = t.args.percent,
        //     b = t.args.height,
        //     c = t.args.color1,
        //     d = t.args.color2,
        //     e = t.args.barMargin,
        //     f = t.args.rounded,
        //     g = t.args.desktopSize,
        //     h = t.args.desktopLineHeight,
        //     i = t.args.fontWeight,
        //     j = t.args.letterSpacing,
        //     k = t.args.mobiSize,
        //     l = t.args.smobiSize,
        //     m = t.args.mobiLineHeight,
        //     n = t.args.smobiLineHeight,
        //     o = t.args.numberMargin,
        //     p = t.args.showNumber,
        //     q = t.args.align,
        //     r = t.args.desc,
        //     s = t.args.headlineSize,
        //     u = t.args.headlineColor,
        //     v = t.args.descColor,
        //     w = t.args.headlineMargin,
        //     x = t.args.descMargin,
        //     y = t.args.contentMargin,
        //     z = t.$elm.attr("class").split(" ");

        //     $(z).each(function(i, e) { 
        //         e.indexOf("mlr-") == 0 && (cls = "." + z[0] + "." + e)
        //     });

        //     a && ( t.$elm.find(".progress-animate").attr("data-valuenow", a + "%"),
        //         t.$elm.find(".perc .number").text(a),
        //         t.$elm.find(".perc .number").attr("data-to", a) ),

        //     b = b ? "height:" + b + ";" : "",
        //     c = c ? "background-color:" + c + ";" : "",
        //     d = d ? "background-color:" + d + ";" : "",
        //     e = e ? "margin:" + e + ";" : "",
        //     f = f ? "border-radius:" + f + ";" : "",
        //     g = g ? "font-size:" + g + ";" : "",
        //     h = h ? "line-height:" + h + ";" : "",
        //     i = i ? "font-weight:" + i + ";" : "",
        //     j = j ? "letterSpacing:" + j + ";" : "",
        //     k = k ? "font-size:" + k + ";" : "",
        //     l = l ? "line-height:" + l + ";" : "",
        //     m = m ? "font-size:" + m + ";" : "",
        //     n = n ? "line-height:" + n + ";" : "",
        //     o = o ? "margin:" + o + ";" : "",
        //     w = w ? "margin:" + w + ";" : "",
        //     x = x ? "margin:" + x + ";" : "",
        //     y = y ? "margin:" + y + ";" : "",
            
        //     t.$elm.alterClass("number-*", "number-" + p),
        //     t.$elm.alterClass("align-*", "align-" + q),
        //     t.$elm.alterClass("desc-*", "desc-" + r),
        //     t.$elm.find(".headline-2").alterClass("size-*", "size-" + s),
        //     t.$elm.find(".headline-2").alterClass("color-*", "color-" + u),
        //     t.$elm.find(".desc").alterClass("color-*", "color-" + v),

        //     (k || m) && (css += "@media screen and (max-width: 1200px) and (min-width: 768px) {" + cls + " .perc {" + k + m + "}}"),
        //     (l || n) && (css += "@media only screen and (max-width: 767px) {" + cls + " .perc {" + l + n + "}}"),

        //     css += cls + " {" + y + "}",
        //     css += cls + " .progress-bar {" + b + c + e + f + "}",
        //     css += cls + " .perc {" + g + h + i + j + o + "}",
        //     css += cls + " .headline-2 {" + w + "}",
        //     css += cls + " .desc {" + x + "}",
        //     css += cls + " .progress-animate {" + b + d + f + "}\n",
            
        //     css && $("#master-dynamic").length
        //         ? ((arr = $("#master-dynamic").html().split("\n")),
        //           $.each(arr, function(i, e) {
        //               e && e.indexOf(cls) > -1 && arr.splice(i, 1)
        //           }),
        //           $("#master-dynamic").empty().append(arr.join("\n")).append(css))
        //         : $("head").append("<style type='text/css' id='master-dynamic'>" + css + "</style>") 
        //},
        event: function() {
            var t = this;
            if ( $().appear ) {
                t.$elm.appear( function() {
                
                    function init() {
                        var bar = $('.progress-animate'),
                            bar_width = $(this);
                        $(function(){
                            $(bar).each( function() {
                                bar_width = $(this).data('valuenow');
                                $(this).width(bar_width);

                                $(this).parents('.master-progress').find('.perc').addClass('show');
                            });
                        });
                    }

                    init();
                } );
            }
        }
    };

    masterProgress.defaults = masterProgress.prototype.defaults;

    $.fn.masterProgress = function(opts) {
        return this.each(function() {
            new masterProgress(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterHeroCarousel = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterHeroCarousel.prototype = {
        defaults: {
            dots: true,
            speed: 500,
            cssEase: "ease-in-out",
            arrows: true,
            infinite: true,
            slidesToShow: 3,
            slidesToScroll: 1,
            centerMode: true,
            centerPadding: 0,
            autoplay: true,
            autoplaySpeed: 5500,
            pauseOnDotsHover: false,
            pauseOnHover: false,

            screenHeight: "no",
            screenHeightReduce: "0px",
            navStyle: "style-1",
            navAlign: "center",
            kenburns: false
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            this.event();
            return this;
        },
        build: function() {
            var 
            t = this,
            cw = t.$elm.find(".hero-carousel-wrap"),
            nw = t.$elm.find(".hero-nav-wrap"),
            sl = t.$elm.find(".master-hero-nav-slide"),
            a = t.args.screenHeight,
            b = t.args.screenHeightReduce,
            e = t.args.kenburns,
            f = t.args.overlays,
            g = t.args.parallax;

            (a == "yes") && cw.find(".hero-slide, .hero-content").css("height", "calc(100vh - " + b + ")"),
            e && t.$elm.addClass("kenburns"),
            f && t.$elm.alterClass("overlays-*", "overlays-" + f),
            g ? t.$elm.find(".hero-image").addClass("parallax") : t.$elm.find(".hero-image").removeClass("parallax"),

            // t.args.customPaging = function(e, i) {
            //     var m = $(e.$slides[i]).find(".hero-nav"),
            //     n = m.find(".hero-nav-progress").css("transition-duration" , e.options.autoplaySpeed + e.options.speed + "ms"),
            //     o = m.find(".svg-nav .nav-progress").css("animation-duration" , e.options.autoplaySpeed + "ms");
            //     m.css("display", "none")
            //     return ''
            //     + '<div class="hero-nav">'
            //     + m.html()
            //     + '</div>'
            // };

            t.args.appendDots = nw,
            cw.slick(t.args, t.$elm.on("init", function() {
                // nw.addClass("slide-count-" + nw.find("li").length);
                // t.$elm.find("li").addClass("transition-active");
                // t.$elm.find(".slick-slide").addClass("transition-active");
            }));

            // sl.each(function(idx, el) {
            //     var 
            //     t = $(el),
            //     bg = t.find('.hero-image'),
            //     args = t.data("config"),
            //     a = args.bg;

            //     bg.css("background-image","url(" + a + ")")
            // })
        },
        event: function() {
            var 
            t = this;

            t.$elm.on('beforeChange', function(e, slick, currentSlide, nextSlide) {
                var 
                next = t.$elm.find(".hero-slide").eq(nextSlide),
                a = $(next).find(".window-loaded").removeClass("animated");
                console.log(next)

                // Animated text
                //if ( t.$elm.find(".master-animated-text").length ) {
                    var text = t.$elm.find(".master-animated-text");
                    text.each(function(i, e) {
                        $(e).find(".text-animate > span").css("opacity","0")
                    })  
                //}
            });

            t.$elm.on('afterChange', function(e, slick, currentSlide, prevSlide) {
                var 
                current = t.$elm.find(".hero-slide.slick-current"),
                a = $(current).find(".window-loaded").addClass("animated");
                $(current).addClass("currenttt")

                // Animated text
                if ( $(current).find(".master-animated-text").length ) {
                    var text = $(current).find(".master-animated-text");
                    text.each(function(i, e) {
                        var args = $(e).data("config");
 
                        setTimeout(function() {
                            $(e).textHoverMaster(args)
                        }, args.delay )
                    })  
                }
            });
        }
    };

    masterHeroCarousel.defaults = masterHeroCarousel.prototype.defaults;

    $.fn.masterHeroCarousel = function(opts) {
        return this.each(function() {
            new masterHeroCarousel(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterCarouselBox = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterCarouselBox.prototype = {
        defaults: {
            contain: !1,
            imagesLoaded: !0,
            arrowShape: "M10.6,6.1c0.3,0,0.6,0.1,0.8,0.3l6.8,6.9c0.4,0.4,0.4,1.2,0,1.6l-6.8,6.8c-0.4,0.4-1.2,0.4-1.6,0c-0.4-0.4-0.4-1.2,0-1.6l6.1-6l-6-6c-0.4-0.4-0.4-1.2,0-1.6C10,6.2,10.3,6.1,10.6,6.1z",
            percentPosition: !1,
            prevNextButtons: !1,
            pageDots: !1,
            adaptiveHeight: !1,
            cellAlign: "left",
            groupCells: !0,
            dragThreshold: 20,
            wrapAround: !1,
            autoPlay: !1,
            navArrow: 1,
            filters: !1,
            equalHeightCells: !1,
            randomVerOffset: !1,
            draggable: !1,

            column: 3,
            gap: "30px",
            fullRight: !1,
            arrows : false,
            arrowSize: "52px",
            arrowRounded: "0px",
            arrowStyle: "arrow-style-1",
            arrowPosition: "middle",
            arrowMiddleOffsetX: "0px",
            arrowMiddleOffsetY: "0px",
            arrowTopOffset: "40px",
            dots: true,
            dotStyle: "dot-style-1",
            dotOffset: "40px"
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            this.event();
            return this;
        },
        build: function() {
            var
            t = this,
            a = t.args.column,
            b = t.args.gap,
            c = t.args.fullRight,

            d = t.args.arrows,
            e = t.args.arrowSize,
            f = t.args.arrowRounded,
            g = t.args.arrowStyle,
            h = t.args.arrowPosition,
            m = t.args.arrowMiddleOffsetX,
            n = t.args.arrowMiddleOffsetY,
            o = t.args.arrowTopOffset,
            i = t.args.arrowShape,

            j = t.args.dots,
            k = t.args.dotStyle,
            l = t.args.dotOffset;

            t.args.prevNextButtons = d,
            t.args.pageDots = j,
            j && t.$elm.addClass("has-dots"),

            t.$elm.alterClass("column-*", "column-" + a + "-gap-" + b),
            t.$elm.alterClass("arrow-size-*", "arrow-size-" + e),
            t.$elm.alterClass("arrow-rounded-*", 'arrow-rounded-' + f),
            t.$elm.alterClass("arrow-style-*",  g),
            t.$elm.alterClass("arrow-position-*", "arrow-position-" + h),
            t.$elm.alterClass("arrow-middle-x-*", "arrow-middle-x-" + m),
            t.$elm.alterClass("arrow-middle-y-*", "arrow-middle-y-" + n),
            t.$elm.alterClass("arrow-top-*", "arrow-top-" + o),
            t.$elm.alterClass("dot-offset-*", "dot-offset-" + l),

            t.$elm.children().addClass("item-carousel");
            t.$elm.flickity(t.args);

            var
            u = $(t.elm).data("flickity"),
            v = u.size.width,
            w = $(u.viewport),
            x = window.innerWidth - (v + w.offset().left),
            y = $("<div />").addClass("flickity-aside-wrap");

            c && ( w.wrap(y).css("overflow", "visible")
               .parent().css({"padding-right": x, "margin-right": -x, "overflow": "hidden"}),
               t.$elm.addClass("full-right")
            )

            $(t.elm).on("select.flickity", function() {
                d && ("arrow-style-1" == g) && (
                    u.nextButton.isEnabled == true 
                        ? $(u.nextButton.element).removeClass("background-white").addClass("background-accent")
                          .find("path").attr("class", "text-white")
                        : $(u.nextButton.element).addClass("background-white").removeClass("background-accent")
                          .find("path").attr("class", "text-dark"),
                    u.prevButton.isEnabled == true 
                        ? $(u.prevButton.element).removeClass("background-white").addClass("background-accent")
                          .find("path").attr("class", "text-white")
                        : $(u.prevButton.element).addClass("background-white").removeClass("background-accent")
                          .find("path").attr("class", "text-dark")
                ),
                d && ("arrow-style-2" == g) && (
                    $(u.nextButton.element).addClass("border-light").find("path").attr("class", "text-dark"),
                    $(u.prevButton.element).addClass("border-light").find("path").attr("class", "text-dark")
                ),
                j && ("dot-style-1" == k) && (
                    $(u.pageDots.dots).addClass("border-light").filter(".is-selected").removeClass("background-accent border-accent border-light"),
                    $(u.pageDots.dots).eq(u.selectedIndex).addClass("background-accent border-accent")
                ),
                j && ("dot-style-2" == k) && (
                    $(u.pageDots.dots).addClass("border-light").filter(".is-selected").removeClass("border-accent border-light"),
                    $(u.pageDots.dots).eq(u.selectedIndex).addClass("border-accent")
                )
            })
        },
        event: function() {
            var 
            t = this;

            // Filter
            $(".carousel-filter .filter-item").on("click", function() {
                var 
                a = $(this).parent().attr("id"),
                b = $(this).data("filter");
                
                if (b !== "*") {
                    var
                    c = $("." + a + " .item-carousel").not("." + b),
                    d = $("." + a + " .item-carousel." + b);
                    c.hide()
                    d.show()
                } else {
                    $("." + a + " .item-carousel").show()
                }

                // Remove other element before destroy
                $("." + a).find(".ctr-edit").remove(),
                t.args.fullRight && t.$elm.find(".flickity-viewport").unwrap()

                t.$elm.flickity("destroy");
                t.$elm.waitForImages(function() {
                    t.$elm.flickity(t.args);
                })
                
                t.$elm.waitForImages(function() { 
                    if (t.args.fullRight) {
                        var
                        u = $(t.elm).data("flickity"),
                        v = u.size.width,
                        w = $(u.viewport),
                        x = window.innerWidth - (v + w.offset().left),
                        y = $("<div />").addClass("flickity-aside-wrap");

                        var z = $("<div />").addClass("flickity-aside-wrap");
                        t.$elm.find(".flickity-viewport").wrap(y).css("overflow", "visible")
                            .parent().css({"padding-right": x, "margin-right": -x, "overflow": "hidden"})
                    }
                })           
            })

            // Position
            var selected = t.$elm.find('.item-carousel.is-selected');
            selected.first().addClass('left');
            selected.last().addClass('right');

            // Selected change
            t.$elm.on( 'select.flickity', function( event, index ) {
                var selected = t.$elm.find('.item-carousel.is-selected'),
                    item = t.$elm.find('.item-carousel');

                item.removeClass('left right');
                selected.first().addClass('left');
                selected.last().addClass('right');                  
            });

            // Center
            if ( t.args.cellAlign == 'center' ) {
                var selected = t.$elm.find('.item-carousel.is-selected'),
                    item = t.$elm.find('.item-carousel');

                // Init
                if ( selected.length > 1 ) {
                    var column = selected.length,
                        centerIndex = selected.index() + Math.floor(column/2);
                    item.removeClass('center');
                    item.eq(centerIndex).addClass('center');
                } else {
                    item.removeClass('center');
                    selected.addClass('center');
                }

                // Selected change
                t.$elm.on( 'select.flickity', function( event, index ) {
                    var selected = t.$elm.find('.item-carousel.is-selected'),
                        item = t.$elm.find('.item-carousel');

                    if ( selected.length > 1 ) {
                        var column = selected.length,
                        centerIndex = selected.index() + Math.floor(column/2);
                        item.removeClass('center');
                        item.eq(centerIndex).addClass('center');
                    } else {
                        $(item).removeClass('center');
                        $(selected).addClass('center');
                    }                    
                });
            }
        }
    };

    masterCarouselBox.defaults = masterCarouselBox.prototype.defaults;

    $.fn.masterCarouselBox = function(opts) {
        return this.each(function() {
            new masterCarouselBox(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterCounter = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterCounter.prototype = {
        defaults: {
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            //this.build();
            this.event();
            return this;
        },
        // build: function() {
        //     var
        //     t = this,
        //     css = "",
        //     cls = "",
        //     arr = [],
        //     a = t.args.number,
        //     b = t.args.format,
        //     c = t.args.speed,
        //     d = t.args.prefix,
        //     e = t.args.suffix,
        //     f = t.args.align,
        //     g = t.args.desc,
        //     h = t.args.descColor,
        //     i = t.args.headlineSize,
        //     j = t.args.headlineColor,
        //     k = t.args.contentPadding,
        //     l = t.args.contentMargin,
        //     a1 = t.args.numberColor,
        //     b1 = t.args.desktopSize,
        //     c1 = t.args.mobiSize,
        //     d1 = t.args.smobiSize,
        //     e1 = t.args.desktopLineHeight,
        //     f1 = t.args.mobiLineHeight,
        //     g1 = t.args.smobiLineHeight,
        //     h1 = t.args.fontWeight,
        //     i1 = t.args.letterSpacing,

        //     a2 = t.args.prefixColor, 
        //     a3 = t.args.suffixColor, 
        //     x = t.$elm.find(".counter-wrap"),
        //     y = t.$elm.find(".number"),
        //     z = t.$elm.attr("class").split(" ");

        //     $(z).each(function(i, e) { 
        //         e.indexOf("mlr-") == 0 && (cls = "." + z[0] + "." + e)
        //     });

        //     a && y.attr("data-to", a),
        //     b && y.attr("data-format", b),
        //     c && y.attr("data-speed", c),
        //     d && $("<span />").text(d).addClass("prefix").prependTo(x),
        //     e && $("<span />").text(e).addClass("suffix").appendTo(x),
        //     t.$elm.alterClass("align-*", "align-" + f),
        //     t.$elm.alterClass("desc-*", "desc-" + g),
        //     t.$elm.find(".headline-2").alterClass("size-*", "size-" + i),
        //     t.$elm.find(".headline-2").alterClass("color-*", "color-" + j),
        //     t.$elm.find(".desc").alterClass("color-*", "color-" + h),
        //     k = k ? "padding:" + k + ";" : "", 
        //     l = l ? "margin:" + l + ";" : "", 

        //     a1 = a1 ? "color:" + a1 + ";" : "",
        //     b1 = b1 ? "font-size:" + b1 + ";" : "",
        //     e1 = e1 ? "line-height:" + e1 + ";" : "",
        //     h1 = h1 ? "font-weight:" + h1 + ";" : "",
        //     i1 = i1 ? "letter-spacing:" + i1 + ";" : "",

        //     a2 = a2 ? "color:" + a2 + ";" : "",

        //     a3 = a3 ? "color:" + a3 + ";" : "",

        //     css += cls + " {" + k + l + "}",
        //     css += cls + " .counter-wrap {" + a1 + b1 + e1 + h1 + i1 + "}",
        //     css += cls + " .prefix {" + a2 + "}",
        //     css += cls + " .suffix {" + a3 + "}\n",
            

        //     css && $("#master-dynamic").length
        //         ? ((arr = $("#master-dynamic").html().split("\n")),
        //           $.each(arr, function(i, e) {
        //               e && e.indexOf(cls) > -1 && arr.splice(i, 1)
        //           }),
        //           $("#master-dynamic").empty().append(arr.join("\n")).append(css))
        //         : $("head").append("<style type='text/css' id='master-dynamic'>" + css + "</style>") 
        // },
        event: function() {
            var t = this;
            if ( $().countTo ) {
                t.$elm.appear( function() {
                    var $this = $(this);

                    function init() {
                        $this.find('.number').each(function() {
                            var to = $(this).data('to'),
                                speed = $(this).data('speed'),
                                format = $(this).data('format');

                            switch ( format ) {
                                case 'ts':
                                    $(this).countTo({
                                        to: to,
                                        speed: speed,
                                        formatter: function (value, options) {
                                            value.toLocaleString(undefined, {maximumFractionDigits:2});
                                            return value;
                                        }
                                    });
                                    break;
                                case 'd1':
                                    $(this).countTo({
                                        to: to,
                                        speed: speed,
                                        formatter: function (value, options) {
                                            value = value.toFixed(1);
                                            return value;
                                        }
                                    });
                                    break;
                                case 'd2':
                                    $(this).countTo({
                                        to: to,
                                        speed: speed,
                                        formatter: function (value, options) {
                                            value = value.toFixed(2);
                                            return value;
                                        }
                                    });
                                    break;
                                default: 
                                    $(this).countTo({
                                        to: to,
                                        speed: speed
                                    });
                            }
                            
                        });
                    }

                    init();
                });
            }
        }
    };

    masterCounter.defaults = masterCounter.prototype.defaults;

    $.fn.masterCounter = function(opts) {
        return this.each(function() {
            new masterCounter(this, opts).init();
        });
    };
}(jQuery, window, document));

(function($, window, document, undefined) {
    "use strict";

    var masterWrap = function(elm, opts) {
        this.elm = elm;
        this.$elm = $(elm);
        this.opts = opts;
        this.config = this.$elm.data("config");
    };

    masterWrap.prototype = {
        defaults: {
            cae: false
        },
        init: function() {
            this.args = $.extend({}, this.defaults, this.opts, this.config);
            this.build();
            return this;
        },
        build: function() {
            var
            t = this,
            css = "",
            css1 = "",
            cls = "",
            arr = [],
            id = "mlr-" + (new Date).getTime(),
            a = t.args.bg,
            b = t.args.border,
            c = t.args.boxShadow,
            d = t.args.transform,
            e = t.args.desktopPadding,
            f = t.args.desktopMargin,
            h = t.args.mobiPadding,
            i = t.args.smobiPadding,
            j = t.args.mobiMargin,
            k = t.args.smobiMargin,
            l = t.args.bgHover,
            m = t.args.borderHover,
            n = t.args.boxShadowHover,
            o = t.args.transformHover,
            p = t.args.rounded,
            q = t.args.roundedHover,
            
            z = t.$elm.attr("class").split(" ");
            t.$elm.addClass(id),
            cls = "." + id,
            // $(z).each(function(i, e) { 
            //     e.indexOf("mlr-") == 0 && (cls = "." + z[0] + "." + e)
            // });
            (t.args.cae || t.args.pse || t.args.moe) &&
                t.$elm.alterClass("position-", "position-relative"),
            // Canvas Item
            t.args.cae && (css += t.canvas()),

            a = a ? cssBG(a) : "",
            b = b ? cssBorder(b) : "",
            c = c ? "box-shadow:" + c + ";" : "",
            d = d ? "transform:" + d + ";" : "",
            p = p ? "border-radius:" + p + ";" : "",
            // Responsive
            e = e ? cssPadding(e) : "",
            f = f ? cssMargin(f) : "",
            h = h ? cssPadding(h) : "",
            i = i ? cssPadding(i) : "",
            j = j ? cssMargin(j) : "",
            k = k ? cssMargin(k) : "",
            // Hover
            l = l ? cssBG(l) : "",
            m = m ? cssBorder(m) : "",
            n = n ? "box-shadow:" + n + ";" : "",
            o = o ? "transform:" + o + ";" : "",
            q = q ? "border-radius:" + q + ";" : "",

            css1 = a + b + c + d + e + f + p,
            css1 && (css += cls + " {" + css1 + "}"),
            css1 = l + m + n + o + q,
            css1 && (css += cls + ":hover {" + css1 + "}"),
            css1 = h + j,
            css1 && (css += "@media screen and (max-width: 1200px) and (min-width: 768px) {" + cls + " {" + css1 + "}}"),
            css1 = i + k,
            css1 && (css += "@media only screen and (max-width: 767px) {" + cls + " {" + css1 + "}}"),
            css += "\n",
            css && $("#master-dynamic").length
                ? $("#master-dynamic").append(css)
                : $("head").append("<style type='text/css' id='master-dynamic'>" + css + "</style>")
            // css && $("#master-dynamic").length
            //     ? ((arr = $("#master-dynamic").html().split("\n")),
            //       $.each(arr, function(i, e) {
            //           e && e.indexOf(cls) > -1 && arr.splice(i, 1)
            //       }),
            //       $("#master-dynamic").empty().append(arr.join("\n")).append(css))
            //     : $("head").append("<style type='text/css' id='master-dynamic'>" + css + "</style>") 
        },
        canvas: function() {
            var
            t = this,
            css = "",
            canvas = t.args.canvas,
            container = $("<div />").prependTo(t.$elm).addClass("canvas-bg")

            $(canvas).each(function(idx, el) {
                var 
                id = "mlr-" + (new Date).getTime(),
                css1 = "",
                cls = "." + id,
                arr = [],
                a = el.image,
                b = el.width,
                c = el.top,
                d = el.right,
                e = el.bottom,
                f = el.left,
                g = el.rounded,
                h = el.shadow,
                i = el.animeStyle,
                j = el.animeName,
                k = el.animeDuration,
                l = el.animeLoop,
                m = el.animeDelay,
                o = el.desktopVisibility,
                p = el.mobiVisibility,
                q = el.smobiVisibility,
                a2 = el.mobiWidth,
                b2 = el.mobiTop,
                c2 = el.mobiRight,
                d2 = el.mobiBottom,
                e2 = el.mobiLeft,
                a3 = el.smobiWidth,
                b3 = el.smobiTop,
                c3 = el.smobiRight,
                d3 = el.smobiBottom,
                e3 = el.smobiLeft,
                pa = {},
                pb = el.smooth,
                pc = el.parallaxX,
                pd = el.parallaxY,
                pe = el.parallaxZ,
                pf = el.rotateX,
                pg = el.rotateY,
                ph = el.rotateZ,
                pi = el.scale,
                
                ani = "",
                kf = "",
                step = "",
                item = $("<div />").addClass("canvas-item " + id),
                z = t.$elm.attr("class").split(" "); 

                $(z).each(function(i, e) { 
                    e.indexOf("mlr-") == 0 && (cls = "." + z[0] + "." + e + " .canvas-item." + id)
                });               
                
                if (a) {
                    item.appendTo(container),
                    $("<img />").attr({ "alt": "image", "src": "../assets/" + a }).appendTo(item),
                    o && item.alterClass("desktop-visible-*", "desktop-visible-" + o),
                    p && item.alterClass("mobi-visible-*", "mobi-visible-" + p),
                    q && item.alterClass("smobi-visible-*", "smobi-visible-" + q),
                    b = b ? "width:" + b + ";" : "",
                    c = c ? "top:" + c + ";" : "",
                    d = d ? "right:" + d + ";" : "",
                    e = e ? "bottom:" + e + ";" : "",
                    f = f ? "left:" + f + ";" : "",
                    g = g ? "overflow:hidden;border-radius:" + g + ";" : "",
                    h = h ? "box-shadow:" + h + ";" : "",

                    a2 = a2 ? "width:" + a2 + ";" : "",
                    b2 = b2 ? "top:" + b2 + ";" : "",
                    c2 = c2 ? "right:" + c2 + ";" : "",
                    d2 = d2 ? "bottom:" + d2 + ";" : "",
                    e2 = e2 ? "left:" + e2 + ";" : "",
                    a3 = a3 ? "width:" + a3 + ";" : "",
                    b3 = b3 ? "top:" + b3 + ";" : "",
                    c3 = c3 ? "right:" + c3 + ";" : "",
                    d3 = d3 ? "bottom:" + d3 + ";" : "",
                    e3 = e3 ? "left:" + e3 + ";" : ""


                    if (i == "keyframes") {
                        !j && (j = id),
                        ani = k + " " + j,
        
                        l ? ani += " infinite" : ani += " forward",
                        m ? ani += " linear " + m + ";" : ani += "linear;",
                    
                        kf = "",
                        step = el.anime
                        for ( var i1 = 0; i1 < step.length; i1++ ) {
                            var a1 = step[i1].percent,
                                b1 = step[i1].opacity,
                                c1 = step[i1].margin,
                                d1 = step[i1].transform;
                            a1 = a1 ? a1 + "%" : "",
                            b1 = b1 ? "opacity:" + b1 + ";" : "",
                            c1 = c1 ? "margin:" + c1 + ";" : "",
                            d1 = d1 ? "transform:" + d1 + ";" : "",

                            a1 &&
                                ((i1 == 0)
                                    ? kf += a1 + "{" + b1 + c1 + d1 + "}"
                                    : kf += " " + a1 + "{" + b1 + c1 + d1 + "}")
                        }
                        kf = "@keyframes " + j + " { " + kf + " }"
                    } else {
                        pb = pb ? '"smoothness":' + parseInt(pb) : '"smoothness":30',
                        pc = pc ? '"x":' + parseInt(pc) + "," : "",
                        pd = pd ? '"y":' + parseInt(pd) + "," : "",
                        pe = pe ? '"z":' + parseInt(pe) + "," : "",
                        pf = pf ? '"rotateX":' + parseInt(pf) + "," : "",
                        pg = pg ? '"rorateY":' + parseInt(pg) + "," : "",
                        ph = ph ? '"rorateZ":' + parseInt(ph) + "," : "",
                        pi = pi ? '"scale":' + parseInt(pi) + "," : "",
                        $(item).attr('data-parallax', '{' + pc + pd + pe + pf + pg + ph + pi + pb + '}')

                    }
                     
                    ani = ani ? "animation:" + ani + "opacity:0;": "", 
                    kf && (css += kf),
                    css += cls + " {" + b + c + d + e + f + g + h + ani + "}",
                    css1 = a2 + b2 + c2 + d2 + e2,
                    (css1) && (css += "@media screen and (max-width: 1200px) and (min-width: 768px) {" + cls + " {" + css1 + "}}"),
                    css1 = a3 + b3 + c3 + d3 + e3,
                    (css1) && (css += "@media only screen and (max-width: 767px) {" + cls + " {" + css1 + "}}")
                }
            })  

            return css;         
        },
    };

    masterWrap.defaults = masterWrap.prototype.defaults;

    $.fn.masterWrap = function(opts) {
        return this.each(function() {
            new masterWrap(this, opts).init();
        });
    };
}(jQuery, window, document));


function cssBG(bg) {
    var css = "";
    bg.color && (css += "background-color:" + bg.color + ";"),
    bg.image && (
        css += "background-image:url(" + bg.image + ");",
        bg.size && (
            (bg.size == "length") 
                ? ( bg.length && (css += "background-size:" + bg.length + ";" ) )
                : ( css += "background-size:" + bg.size + ";" )
        ),
        bg.repeat && (css += "background-repeat:" + bg.repeat + ";"),
        bg.position && (css += "background-position:" + bg.position + ";"),
        bg.blendMode && (css += "background-blend-mode:" + bg.blendMode + ";")
    )
    return css;
}

function cssBorder(border) {
    var css = "";
    border.style && (css += "border-style:" + border.style + ";"),
    border.color && (css += "border-color:" + border.color + ";"),
    border.top && (css += "border-top-width:" + border.top + ";"),
    border.right && (css += "border-right-width:" + border.right + ";"),
    border.bottom && (css += "border-bottom-width:" + border.bottom + ";"),
    border.left && (css += "border-left-width:" + border.left + ";")
    return css;
}

function cssMargin(margin) {
    var css = "";
    margin.top ? ( css += "margin-top:" + margin.top + ";" )
               : (( margin.top === 0 ) && (css += "margin-top:0px;")),
    margin.right ? ( css += "margin-right:" + margin.right + ";" )
               : (( margin.right === 0 ) && (css += "margin-right:0px;")),
    margin.bottom ? ( css += "margin-bottom:" + margin.bottom + ";" )
               : (( margin.bottom === 0 ) && (css += "margin-bottom:0px;")),
    margin.left ? ( css += "margin-left:" + margin.left + ";" )
               : (( margin.left === 0 ) && (css += "margin-left:0px;"))

    return css;
}

function cssPadding(padding) {
    var css = "";
    padding.top ? ( css += "padding-top:" + padding.top + ";" )
               : (( padding.top === 0 ) && (css += "padding-top:0px;")),
    padding.right ? ( css += "padding-right:" + padding.right + ";" )
               : (( padding.right === 0 ) && (css += "padding-right:0px;")),
    padding.bottom ? ( css += "padding-bottom:" + padding.bottom + ";" )
               : (( padding.bottom === 0 ) && (css += "padding-bottom:0px;")),
    padding.left ? ( css += "padding-left:" + padding.left + ";" )
               : (( padding.left === 0 ) && (css += "padding-left:0px;"))

    return css;
}


function cssPosition(position) {
    var css = "";
    position.top ? ( css += "top:" + position.top + ";" )
               : (( position.top === 0 ) && (css += "top:0px;")),
    position.right ? ( css += "right:" + padding.right + ";" )
               : (( position.right === 0 ) && (css += "right:0px;")),
    position.bottom ? ( css += "bottom:" + padding.bottom + ";" )
               : (( position.bottom === 0 ) && (css += "bottom:0px;")),
    position.left ? ( css += "left:" + padding.left + ";" )
               : (( position.left === 0 ) && (css += "left:0px;"))

    return css;
}

function cssTypography(typography, cls) {
    var css = "",
    css1 = "",
    t = typography,
    a = t.desktopSize,
    b = t.desktopLineHeight,
    c = t.fontWeight,
    d = t.letterSpacing,
    e = t.mobiSize,
    f = t.mobiLineHeight,
    g = t.smobiSize,
    h = t.smobiLineHeight;

    a = a ? "font-size:" + a + ";" : "",
    b = b ? "line-height:" + b + ";" : "",
    c = c ? "font-weight:" + c + ";" : "",
    d = d ? "letter-spacing:" + d + ";" : "",
    e = e ? "font-size:" + e + ";" : "",
    f = f ? "line-height:" + f + ";" : "",
    g = g ? "font-size:" + g + ";" : "",
    h = h ? "line-height:" + h + ";" : "",

    css1 = a + b + c + d,
    css1 && (css += cls + " {" + css1 + "}"),
    css1 = e + f,
    css1 && (css += "@media screen and (max-width: 1200px) {" + cls + " {" + css1 + "}}"),
    css1 = g + h,
    css1 && (css += "@media screen and (max-width: 767px) {" + cls + " {" + css1 + "}}")

    return css;
}


function cssAdvanced(el, attr) {
    var
    a = attr.id,
    b = attr.classes;
    a && el.attr("id", a),
    b && el.addClass(b)
}
