<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class LQD_Spline extends Widget_Base {

	public function get_script_depends() {
		return [ 'spline' ];
	}

	public function get_name() {
		return 'lqd-spline';
	}

	public function get_title() {
		return __( 'Liquid Spline', 'aihub-core' );
	}

	public function get_icon() {
		return 'eicon-shape lqd-element';
	}

	public function get_categories() {
		return [ 'liquid-core' ];
	}

	public function get_keywords() {
		return [ 'spline', 'animation', '3d' ];
	}

	public function get_behavior() {

		$behavior = [];
		$settings = $this->get_settings_for_display();

		return $behavior;
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => __( 'General', 'aihub-core' ),
			]
		);

        $this->add_control(
			'spline_source',
			[
				'label' => esc_html__( 'Source', 'aihub-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'external'  => esc_html__( 'External URL', 'aihub-core' ),
				],
				'default' => 'external',
			]
		);

        $this->add_control(
			'spline_url',
			[
				'label' => esc_html__( 'Spline url', 'aihub-core' ),
                'placeholder' => esc_html__( 'Add the url pointing to the .splinecode file', 'aihub-core' ),
				'type' => Controls_Manager::URL,
				'options' => false,
				'dynamic' => [
					'active' => true,
				],
                'condition' => [
					'spline_source' => 'external',
				],
			]
		);

		$this->add_control(
			'onload_script',
			[
				'label' => esc_html__( 'OnLoad Script', 'aihub-core' ),
				'description' => __( 'Add a script to run after the spline has loaded. You have access to <kbd><u>scene</u></kbd> variable for the loaded scene in this code block.', 'aihub-core' ),
				'default' => 'console.log(scene);',
				'type' => Controls_Manager::CODE,
				'language' => 'javascript',
				'rows' => 20,
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();
        extract( $settings );

		$id = 'lqd-spline-' . $this->get_id();

		if ( $spline_source === 'internal' ){
            $spline_src = isset( $settings['spline_file']['url'] ) ? esc_url( $settings['spline_file']['url'] ) : '';
        } else {
        	$spline_src = isset( $settings['spline_url']['url'] ) ? esc_url( $settings['spline_url']['url'] ) : '';
        }

        if ( empty( $spline_src ) ){
            return;
        }

        ?>
		<canvas id="<?php esc_attr_e( $id ); ?>" class="lqd-spline-canvas"></canvas>

		<script type="module">
			import {Application} from "<?php echo (get_template_directory_uri() . '/assets/vendors/spline/runtime.js') ?>";

			(async () => {
				const scene = new Application(document.getElementById("<?php echo $id ?>"));
				scene.load("<?php echo $spline_src ?>")<?php if ( !empty( $onload_script ) ) : ?>.then(() => {
					<?php echo $onload_script; ?>
				});<?php endif; ?>
			})();
		</script>
		<?php

	}

}
\Elementor\Plugin::instance()->widgets_manager->register( new LQD_Spline() );