const STATE_CLASSNAMES={ACTIVE:"lqd-is-active",DEACTIVE:"lqd-is-deactive",OPEN:"lqd-is-open",OPENING:"lqd-is-opening",CLOSE:"lqd-is-close",CLOSING:"lqd-is-closing",EXPANDING:"lqd-is-expanding",EXPANDED:"lqd-is-expanded",HIDDEN:"lqd-is-hidden",SHOWN:"lqd-is-shown",INVISIBLE:"lqd-is-invisible",DISABLED:"lqd-is-disabled",LOADING:"lqd-is-loading",LOADED:"lqd-is-loaded",ERROR:"lqd-is-error"},DATA_ATTRS={STICKY_HEADER:{HTML_ATTR:"data-lqd-header-is-sticky",JS_DATASET:"lqdHeaderIsSticky"},STICKY_EL:{HTML_ATTR:"data-lqd-is-sticky",JS_DATASET:"lqdIsSticky"},STICKY_CONTAINER:{HTML_ATTR:"data-lqd-container-is-sticky",JS_DATASET:"lqdContainerIsSticky"},STICKY_WIDGET:{HTML_ATTR:"data-lqd-widget-is-sticky",JS_DATASET:"lqdWidgetIsSticky"},INTERACTIVE_COLOR:{HTML_ATTR:"data-lqd-interactive-color",JS_DATASET:"lqdInteractiveColor"},SHOW_ON_STICKY:{HTML_ATTR:"data-lqd-show-on-sticky",JS_DATASET:"lqdShowOnSticky"},HIDE_ON_STICKY:{HTML_ATTR:"data-lqd-hide-on-sticky",JS_DATASET:"lqdHideOnSticky"},COLOR_SCHEME:{HTML_ATTR:"data-lqd-color-scheme",JS_DATASET:"lqdColorScheme"},PAGE_COLOR_SCHEME:{HTML_ATTR:"data-lqd-page-color-scheme",JS_DATASET:"lqdPageColorScheme"},ALIGN_H:{HTML_ATTR:"data-lqd-align-h",JS_DATASET:"lqdAlignH"},ALIGN_V:{HTML_ATTR:"data-lqd-align-v",JS_DATASET:"lqdAlignV"}};function isColliding(d,e){return!(d.bottom<e.y||d.y>e.bottom||d.right<e.x||d.x>e.right)}function modulo(d,e){return(d%e+e)%e}const measurements=["paddingLeft","paddingRight","paddingTop","paddingBottom","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth"];function getZeroSize(){const d=measurements.length;for(var e={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},t=0;t<d;t++){var i=measurements[t];e[i]=0}return e}function getStyleSize(d){var e=parseFloat(d),t=d.indexOf("%")==-1&&!isNaN(e);return t&&e}function getSize(d){if(!d)return{};const e=getComputedStyle(d);if(e.display==="none")return getZeroSize();const t=measurements.length,i={};i.width=d.offsetWidth,i.height=d.offsetHeight;for(var s=0;s<t;s++){var n=measurements[s],o=e[n],r=parseFloat(o);i[n]=isNaN(r)?0:r}var a=i.paddingLeft+i.paddingRight,l=i.paddingTop+i.paddingBottom,h=i.marginLeft+i.marginRight,g=i.marginTop+i.marginBottom,c=i.borderLeftWidth+i.borderRightWidth,u=i.borderTopWidth+i.borderBottomWidth,p=getStyleSize(e.width);p!==!1&&(i.width=p);var m=getStyleSize(e.height);return m!==!1&&(i.height=m),i.innerWidth=i.width-(a+c),i.innerHeight=i.height-(l+u),i.outerWidth=i.width+h,i.outerHeight=i.height+g,i}function getBrightness(d){if(!d)return null;const e=d.indexOf("#")>=0,t=d.indexOf("rgb")>=0;if(e){const l=d.length===7,h=d.substr(1).match(l?/(\S{2})/g:/(\S{1})/g);if(h)var i=parseInt(h[0]+(l?"":h[0]),16),s=parseInt(h[1]+(l?"":h[1]),16),n=parseInt(h[2]+(l?"":h[2]),16)}if(t){var o=d.match(/(\d+)/g);if(o)var i=o[0],s=o[1],n=o[2]}const r=Math.max(i,s,n),a=Math.min(i,s,n);return parseFloat(((r+a)/2/255).toFixed(2))}function getAlpha(d){if(d.startsWith("#")){var e=parseInt(d.substring(1),16),t=e>>24&255;return t/255}else if(d.startsWith("rgb")){var i=d.substring(4).split(",");return i.length===4?parseFloat(i[3]):1}else if(d.startsWith("hsl")){var i=d.substring(4).split(",");return i.length===4?parseFloat(i[3]):1}else return}function getElementFromString(d,e){let t;return d==="html"?t=document.documentElement:d==="body"?t=document.body:d&&e?t=e.querySelector(d):t=document.querySelector(d),t}class LiquidBaseModel extends Backbone.Model{}LiquidBaseModel.prototype.emittedEvents=[],LiquidBaseModel.prototype.trigger=function(d,...e){return d.includes(":")&&!this.emittedEvents.includes(d)&&this.emittedEvents.push(d),Backbone.Model.prototype.trigger.call(this,d,...e)},LiquidBaseModel.urlRoot=LiquidBaseModel.url=LiquidBaseModel.save=LiquidBaseModel.sync=LiquidBaseModel.fetch=_.noop;class LiquidWidgetBaseModel extends LiquidBaseModel{get defaults(){return{...super.defaults,layoutRegion:"liquidPageContent"}}}const BackboneView=Backbone.NativeViewMixin?Backbone.View.extend(Backbone.NativeViewMixin):Backbone.View;class LiquidBaseView extends BackboneView{destroy(){this.el.removeAttribute("data-lqd-model-cid"),this.el.removeAttribute("data-lqd-view-cid"),this.model.get("ghost")?.el?.remove(),this.model.unset("ghost"),this.model.get("behaviors")?.forEach(e=>{e.destroy()}),this.off(),this.model.off(),this.model.stopListening(),this.model.destroy()}}class LiquidWidgetsCollection extends Backbone.Collection{get model(){return LiquidWidgetBaseModel}}class LiquidBehavior{static behaviorName="liquidBase";static initialModelProps={};static initializeConditions=[];static willEmitInitializeTriggerEvents=[];static appEvents={};static regionsEvents={};static modelEvents={};static viewEvents={};static viewModelEvents={};static parentsCollectionEvents={};static topParentContainerEvents={};static topParentChildrenCollectionEvents={};static childrenCollectionEvents={};static domEvents={};static docEvents={};static windowEvents={};constructor(e,t){_.extend(this,Backbone.Events),this.model=new Backbone.Model(this.initialModelProps),this.view=e,this._ui={},this._allEvents={domEvents:[],docEvents:[],windowEvents:[]},this._options={...this.options(),...t},this.initializeTriggers=new Set,this.isDestroyed=!1,this.liquidApp=window.liquid.app,this.preInitialize()}preInitialize(){this.addUi(),this.addAllEvents()}initialize(){}options(){return{}}get behaviorName(){return this.constructor.behaviorName}get initialModelProps(){return this.constructor.initialModelProps}get willEmitInitializeTriggerEvents(){return this.constructor.willEmitInitializeTriggerEvents}get ui(){return{}}get appEvents(){return this.constructor.appEvents}get regionsEvents(){return this.constructor.regionsEvents}get modelEvents(){return this.constructor.modelEvents}get viewEvents(){return this.constructor.viewEvents}get viewModelEvents(){return this.constructor.viewModelEvents}get parentsCollectionEvents(){return this.constructor.parentsCollectionEvents}get topParentContainerEvents(){return this.constructor.topParentContainerEvents}get topParentChildrenCollectionEvents(){return this.constructor.topParentChildrenCollectionEvents}get childrenCollectionEvents(){return this.constructor.childrenCollectionEvents}get domEvents(){return this.constructor.domEvents}get docEvents(){return this.constructor.docEvents}get windowEvents(){return this.constructor.windowEvents}get throttledFunctions(){return{}}get debouncedFunctions(){return{}}get bindToThis(){return[]}get initializeConditions(){return this.constructor.initializeConditions}addUi(){Object.entries({...this.ui,...this.getOption("ui")||{}}).forEach(([e,t])=>{this._ui[e]=[...this.view.el.querySelectorAll(t)]})}addAllEvents(){this.bindAllEvents(),this.listenToAppEvents(),this.listenToRegionsEvents(),this.buildThrottledAndDebouncedFunctions(this.throttledFunctions,"throttle"),this.buildThrottledAndDebouncedFunctions(this.debouncedFunctions,"debounce"),this.listenToModelsAndViewEvents("parentsCollectionEvents",this.view.model.get("parentsCollection")),this.listenToModelsAndViewEvents("topParentContainerEvents",this.view.model.get("topParentContainer")||this.view.model),this.listenToModelsAndViewEvents("topParentChildrenCollectionEvents",this.view.model.get("topParentContainer")?.get("childrenCollection")||this.view.model.get("childrenCollection")),this.listenToModelsAndViewEvents("modelEvents",this.model),this.listenToModelsAndViewEvents("viewEvents",this.view),this.listenToModelsAndViewEvents("viewModelEvents",this.view.model),this.listenToModelsAndViewEvents("childrenCollectionEvents",this.view.model.get("childrenCollection")),this.addDomEvents(),this.addDocEvents(),this.addWindowEvents()}bindAllEvents(){this.bindToThis?.length&&_.bindAll(this,...this.bindToThis)}getChangeProp(e="openedItems"){const t=this.getOption("changePropPrefix");return t?`${e}@${t}`:e}listenToModelsAndViewEvents(e,t){if(!t)return;const i=this[e];if(!i)return;const s=Object.entries(i),n=this.view.model.get("childrenCollection");s.length&&s.forEach(([o,r])=>{const a=[];Array.isArray(r)?r.forEach(l=>{if(typeof l=="string")a.push(this.buildFunction(l,o,t));else if(typeof l=="object"){const h=Object.keys(l)[0],g=Object.values(l)[0];a.push(()=>this.listenTo(t,h,this.buildFunction(g,o,t)))}}):a.push(this.buildFunction(r,o,t)),a.filter(l=>l).forEach(l=>{if(!t?.models){const h=new Backbone.Collection;if(r.listenToChildrenToo){if(n){const g=n.where(c=>c.get("behaviors")?.find(u=>u.willEmitInitializeTriggerEvents.includes(o)));g.length&&h.add(g)}if(t?.get("behaviors")?.find(g=>g.willEmitInitializeTriggerEvents.includes(o))&&h.add(t),h.length)return l=_.after(h.length,l),this.listenTo(h,o,l);if(!this.view.model.get("behaviors")?.find(g=>g.willEmitInitializeTriggerEvents.includes(o)))return l()}}this.listenTo(t,o,l)})})}listenToAppEvents(){this.liquidApp&&Object.entries(this.appEvents).forEach(([e,t])=>{const i=this.buildFunction(t,e);i&&this.listenTo(this.liquidApp,e,i)})}listenToRegionsEvents(){this.liquidApp&&Object.entries(this.regionsEvents).forEach(([e,t])=>{const i=this.liquidApp.layoutRegions[e]?.model;i&&t.forEach(s=>{const n=Object.keys(s)[0],o=this.buildFunction(Object.values(s)[0],n);o&&this.listenTo(i,n,o)})})}addDomEvents(){this.domEvents&&Object.entries(this.domEvents).forEach(([e,t])=>{const i=e.split(" "),s=i[0],n=i[1],o=this.buildFunction(t,s);let r;if(!o)return;let a;if(n)if(n.startsWith("@"))a=this.getUI(n.replace("@",""));else if(n.includes("<")){const l=n.replace("<","");l==="document"?a=[document]:a=document.querySelectorAll(l)}else a=this.view.el.querySelectorAll(n);else a=[this.view.el];s==="inview"?(r=new IntersectionObserver(([l],h)=>{o(l,h)}),a.forEach(l=>r.observe(l))):a.forEach(l=>l.addEventListener(s,o)),this._allEvents.domEvents.push({els:a,eventType:s,fn:o,io:r})})}addDocEvents(){this.docEvents&&Object.entries(this.docEvents).forEach(([e,t])=>{const i=this.buildFunction(t,e);if(i){if(e==="DOMContentLoaded"&&document.readyState==="complete")return i();document.addEventListener(e,i),this._allEvents.docEvents.push({event:e,fn:i})}})}addWindowEvents(){this.windowEvents&&Object.entries(this.windowEvents).forEach(([e,t])=>{const i=this.buildFunction(t,e);i&&(window.addEventListener(e,i),this._allEvents.windowEvents.push({event:e,fn:i}))})}buildFunction(e,t,i){const s=e.func||e;if(typeof s=="string"&&!this[s])return console.warn("Could not find the handler",this,s);if(e.ifHasOption&&!this.getOption(e.ifHasOption)||e.conditions?.length&&!e.conditions.every(o=>o))return!1;let n=typeof s=="string"?this[s].bind(this):s.bind(this);return e.once&&(n=_.once(n)),e.throttle?n=_.throttle(n,e.throttle.wait,{...e.throttle.options}):e.debounce&&(n=_.debounce(n,e.debounce.wait,e.debounce?.options?.immediate)),i&&s==="initialize"&&!i?.emittedEvents?.includes(t)&&this.initializeTriggers.add({eventName:t,modelOrView:i}),n}buildThrottledAndDebouncedFunctions(e,t){Object.entries(e).forEach(([i,s])=>{if(!this[i])return console.warn("Could not find the handler",this,i);this[i]=_[t](this[i].bind(this),s.wait,t==="throttle"?{..._.omit(s,"wait")}:s.immediate)})}getUI(e){let t=this._ui[e]||[];const i=e.split(/:|\[/);if(i.length<2)return t;const s=i[0],n=e.replace(s,"");return t=this._ui[s].filter(o=>o.matches(n)),t}getOption(e){return this._options[e]}setOption(e,t,i=!0){if(this._options[e]&&i&&typeof this._options[e]=="object")return this._options[e]=_.extend(this._options[e],t);this._options[e]=t}destroy(){this.handleDestroy(),this.isInitialized=!1}handleDestroy(){this.offAllEvents(),this.view.model.set({behaviors:this.view.model.get("behaviors").filter(e=>e.model.cid!==this.model.cid)}),this.isDestroyed=!0}offAllEvents(){this.offDomEvents(),this.offDocEvents(),this.offWindowEvents(),this.model.off(),this.off(),this.stopListening()}offDomEvents(){this._allEvents.domEvents.forEach(({els:e,eventType:t,fn:i,io:s})=>{s?s.disconnect():e.forEach(n=>n.removeEventListener(t,i,!1))})}offDocEvents(){this._allEvents.docEvents.forEach(({event:e,fn:t})=>document.removeEventListener(e,t,!1))}offWindowEvents(){this._allEvents.windowEvents.forEach(({event:e,fn:t})=>window.removeEventListener(e,t,!1))}}class LiquidAdaptiveColorBehavior extends LiquidBehavior{static behaviorName="liquidAdaptiveColor";static regionsEvents={liquidPageContent:[{"change:computedStyles":"initialize"}]};static windowEvents={scroll:{func:"onScroll",throttle:{wait:150,options:{leading:!0}}}};get bindToThis(){return["init","initWatch","detectCollision","onPageContentBgChange"]}get throttledFunctions(){return{onPageContentBgChange:{wait:150}}}initialize(){this.init(),this.onScroll()}init(){if(this.handleWidgetViewColorSchemeChange(),this.liquidApp.layoutRegions?.liquidPageContent?.model?.get("behaviors")?.findIndex(t=>t.behaviorName==="liquidAdaptiveBackground")>=0||!1)return this.listenToPageContentBgChange();this.initWatch()}handleWidgetViewColorSchemeChange(){this.view.model.on("change:colorScheme",(e,t)=>{t?this.view.el.setAttribute(DATA_ATTRS.COLOR_SCHEME.HTML_ATTR,t):this.view.el.removeAttribute(DATA_ATTRS.COLOR_SCHEME.HTML_ATTR)})}listenToPageContentBgChange(){const e=this.liquidApp.layoutRegions?.liquidPageContent?.model;e&&this.listenTo(e,"change:adaptiveBg",this.onPageContentBgChange)}onPageContentBgChange(e,{currentColor:t}){this.setWidgetModelColorScheme(this.getLuminosity(t.brightness))}initWatch(){if(!this.liquidApp.layoutRegions?.liquidPageContent)return;const e=new Backbone.Collection;this.liquidApp.layoutRegions.liquidPageContent&&e.add(this.liquidApp.layoutRegions.liquidPageContent.model?.get("childrenCollection").filter(t=>t.get("isContainer"))),this.liquidApp.layoutRegions.liquidPageFooter&&e.add(this.liquidApp.layoutRegions.liquidPageFooter.model?.get("childrenCollection").filter(t=>t.get("isContainer"))),this.pageContentContainers=e,this.scrollDirection=1,this.lastScrollPos=window.scrollY}onScroll(){this.isDestroyed||!this.pageContentContainers?.length||(this.scrollDirection=this.lastScrollPos<=window.scrollY?1:-1,this.detectCollision(),this.lastScrollPos=window.scrollY)}detectCollision(){const{scrollY:e}=window,t=this.view.model.get("rect")||this.view.el.getBoundingClientRect(),i=this.pageContentContainers.map(r=>{const a=r.get("rect")||{};return{cid:r.cid,rect:{...a,y:(a?.y||0)-e,bottom:(a?.bottom||0)-e}}}),s=i.filter(({rect:r})=>(this.scrollDirection>0?r.y>=t.y:r.y<=t.y)&&r.right>=t.right&&r.x<=t.x),n=i.filter(({rect:r})=>(this.scrollDirection>0?r.y<=t.y:r.y>=t.y)&&r.right>=t.right&&r.x<=t.x),o=this.scrollDirection>0?n[n.length-1]:s[s.length-1];o&&this.setWidgetModelColorScheme(this.getLuminosity(this.pageContentContainers.find(r=>r.cid===o.cid)?.get("brightness")?.backgroundColor))}getLuminosity(e){let t="light";return(e&&!isNaN(e)&&e<=.5||e==="dark")&&(t="dark"),t}setWidgetModelColorScheme(e){this.liquidApp.fastdom.mutate(()=>this.view.model.set({colorScheme:e}))}destroy(){this.setWidgetModelColorScheme(null),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidAdaptiveColorBehavior]):window.liquid?.loadedBehaviors?.push(LiquidAdaptiveColorBehavior));class LiquidDrawShapeBehavior extends LiquidBehavior{static behaviorName="liquidDrawShape";options(){return{drawSVG:"0% 0%",duration:5,stagger:1,delay:0,start:"top bottom",end:"center center",scrub:!0,ease:"linear"}}get ui(){return{svgEl:"svg"}}initialize(){if(this.isDestroyed)return;const e=this.getOption("drawSVG"),t=this.getOption("duration"),i=this.getOption("stagger"),s=this.getOption("delay"),n=this.getOption("ease"),o=this.getOption("start"),r=this.getOption("end"),a=this.getOption("scrub"),l=this.getUI("svgEl");l.length&&(this.timeline=gsap.from(l[0].querySelectorAll(":scope > *"),{drawSVG:e,duration:t,delay:s,stagger:i,ease:n,scrollTrigger:{trigger:this.view.el,start:o,end:r,scrub:a}}))}destroy(){this.timeline?.revert(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidDrawShapeBehavior]):window.liquid?.loadedBehaviors?.push(LiquidDrawShapeBehavior));class LiquidCarouselAutoplayBehavior extends LiquidBehavior{static behaviorName="liquidCarouselAutoplay";static viewEvents={"carousel:activate":[{"carousel:uiChange":"stopPlayer"},{"carousel:pointerDown":"stopPlayer"},"onCarouselActivate"]};options(){return{autoplayTimeout:3e3,pauseAutoPlayOnHover:!1}}get bindToThis(){return["onCarouselActivate","onmouseenter","onmouseleave","stopPlayer"]}onCarouselActivate(){this.playerState="stopped",this.onTick=()=>{this.view.trigger("carousel:next",!0)},this.onVisibilityChange=this.visibilityChange.bind(this),this.onVisibilityPlay=this.visibilityPlay.bind(this),this.activatePlayer()}play(){if(this.playerState==="playing")return;if(document.hidden){document.addEventListener("visibilitychange",this.onVisibilityPlay);return}this.playerState="playing",document.addEventListener("visibilitychange",this.onVisibilityChange),this.tick()}tick(){if(this.playerState!=="playing")return;let e=this.getOption("autoplayTimeout");this.clearPlayer(),this.timeout=setTimeout(()=>{this.onTick(),this.tick()},parseFloat(e))}stop(){this.playerState="stopped",this.clearPlayer(),document.removeEventListener("visibilitychange",this.onVisibilityChange)}clearPlayer(){clearTimeout(this.timeout)}pause(){this.playerState==="playing"&&(this.playerState="paused",this.clearPlayer())}unpause(){this.playerState==="paused"&&this.play()}visibilityChange(){let e=document.hidden;this[e?"pause":"unpause"]()}visibilityPlay(){this.play(),document.removeEventListener("visibilitychange",this.onVisibilityPlay)}activatePlayer(){this.play(),this.view.el.addEventListener("mouseenter",this.onmouseenter)}playPlayer(){this.play()}stopPlayer(){this.stop()}pausePlayer(){this.pause()}unpausePlayer(){this.unpause()}onmouseenter(){this.getOption("pauseAutoPlayOnHover")&&(this.pause(),this.view.el.addEventListener("mouseleave",this.onmouseleave))}onmouseleave(){this.unpause(),this.view.el.removeEventListener("mouseleave",this.onmouseleave)}destroy(){this.clearPlayer(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidCarouselAutoplayBehavior]):window.liquid?.loadedBehaviors?.push(LiquidCarouselAutoplayBehavior));class LiquidLookAtMouseBehavior extends LiquidBehavior{static behaviorName="liquidLookAtMouse";static docEvents={mousemove:"onDocMouseMove"};pageX=0;pageY=0;options(){return{}}get ui(){return{items:"[data-lqd-look-at-mouse]"}}get bindToThis(){return["onTick"]}initialize(){gsap.ticker.add(this.onTick)}onTick(){this.getUI("items").forEach(e=>{const t=e.getBoundingClientRect(),i={x:t.left+t.width/2,y:t.top+window.scrollY+t.height/2},n=Math.atan2(this.pageX-i.x,this.pageY-i.y)*(180/Math.PI)*-1+180;gsap.set(e,{transition:"none"}),gsap.to(e,{rotation:`${n}_short`})})}onDocMouseMove(e){this.pageX=e.pageX,this.pageY=e.pageY}destroy(){gsap.ticker.remove(this.onTick),this.getUI("items").forEach(e=>{gsap.killTweensOf(e)}),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidLookAtMouseBehavior]):window.liquid?.loadedBehaviors?.push(LiquidLookAtMouseBehavior));class LiquidSlideshowBehavior extends LiquidBehavior{static behaviorName="liquidSlideshow";static windowEvents={resize:{func:"onResize",debounce:{wait:100}}};options(){return{slideDelay:3,slideDuration:.85,animationType:"fade"}}get ui(){return{slides:".lqd-slideshow-item",images:"img"}}initialize(){this.proxy=document.createElement("div"),this.slidesCount=this.getUI("slides").length,this.slideAnimation=gsap.to({},{}),this.imageAnimation=gsap.to({},{}),this.slideWidth=0,this.wrapWidth=0,this.playNext()}playNext(){const e=this.getUI("slides"),t=this.getUI("images"),s={duration:1,ease:"none",paused:!0,repeat:-1,modifiers:{xPercent:gsap.utils.wrap(-100,(this.slidesCount-1)*100)}};gsap.set(e,{xPercent:n=>n*100}),gsap.set(t,{xPercent:n=>n*-100}),this.slidesAnimation=gsap.to(e,{...s,xPercent:`+=${this.slidesCount*100}`}),this.imagesAnimation=gsap.to(t,{...s,xPercent:`+=${this.slidesCount*-100}`}),this.timer=gsap.delayedCall(this.getOption("slideDelay"),this.autoplay.bind(this)),this.onResize()}autoplay(){this.animateSlides(-1)}updateProgress(){const e=gsap.utils.wrap(0,1);this.slidesAnimation.progress(e(gsap.getProperty(this.proxy,"x")/this.wrapWidth)),this.imagesAnimation.progress(e(gsap.getProperty(this.proxy,"x")/this.wrapWidth))}animateSlides(e){const i=(s=>gsap.utils.snap(this.slideWidth,s))(gsap.getProperty(this.proxy,"x")+e*this.slideWidth);this.timer.restart(!0),this.slideAnimation.kill(),this.imageAnimation.kill(),this.slideAnimation=gsap.to(this.proxy,{x:i,ease:"power2.out",duration:this.getOption("slideDuration"),onUpdate:this.updateProgress.bind(this)})}onResize(){var e=gsap.getProperty(this.proxy,"x")/this.wrapWidth||0;this.slideWidth=this.getUI("slides")[0].offsetWidth,this.wrapWidth=this.slideWidth*this.slidesCount,gsap.set(this.proxy,{x:e*this.wrapWidth}),this.animateSlides(0),this.slideAnimation.progress(1)}destroy(){this.slidesAnimation.kill(),this.slideAnimation.kill(),this.proxy.remove()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidSlideshowBehavior]):window.liquid?.loadedBehaviors?.push(LiquidSlideshowBehavior));class LiquidFilterBehavior extends LiquidBehavior{static behaviorName="liquidFilter";static viewModelEvents={"change:items":"onChangeItems","change:filteredItems":"onChangeFilteredItems"};static viewEvents={"change:filter":"onChangeFilter"};static domEvents={"click .lqd-filter-trigger":"onClickFilterTrigger"};get ui(){return{filterItems:".lqd-filter-item",filterTriggers:".lqd-filter-trigger"}}initialize(){this.on("filter:began",this.onFilterBegan),this.on("filter:done",this.onFilterDone),this.view.model.set({currentFilter:"*"},{silent:!0})}onChangeItems(e,t){const i=t.map(s=>s.el);this.trigger("filter:began",i)}onChangeFilteredItems(e,t){const i=t.map(s=>s.el);this.trigger("filter:done",i)}onClickFilterTrigger(e){const i=e.currentTarget.dataset.lqdFilterTrigger;this.view.model.get("currentFilter")!==i&&(this.view.model.set({currentFilter:i}),this.view.trigger("change:filter",i))}onChangeFilter(e){const t=this.view.model.get("items");let i=t;e!=="*"&&(i=t.filter(n=>n.filterCat.find(o=>o===e)));const s=t.map(n=>{const o=i.findIndex(r=>r.el===n.el);return n.isFiltered=o>=0,n});this.view.model.set({items:[...s]}),this.view.model.hasChanged("items")||this.view.model.trigger("change:items",this.view.model,t),this.view.model.get("items").forEach(n=>{n.el.style.display=n.isFiltered?"":"none"}),this.view.trigger("before:filter:animation"),this.view.model.set({filteredItems:[...i]}),this.view.model.hasChanged("filteredItems")||this.view.model.trigger("change:filteredItems",this.view.model,i),this.view.trigger("after:filter:animation")}onFilterBegan(e){e&&(this.elementsState=Flip.getState(e))}onFilterDone(e){const i="power2.inOut";this.containerState&&Flip.from(this.containerState,{duration:.56,simple:!0}),this.elementsState&&e?.length&&Flip.from(this.elementsState,{duration:.56,ease:i,scale:!0,absolute:!0,zIndex:5,onEnter:s=>gsap.fromTo(s,{opacity:0,scale:0},{opacity:1,scale:1,duration:.56,ease:i}),onLeave:s=>gsap.to(s,{opacity:0,scale:0,duration:.56,ease:i}),onComplete:()=>{this.view.trigger("finished:filter:animation")}})}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidFilterBehavior]):window.liquid?.loadedBehaviors?.push(LiquidFilterBehavior));class LiquidHover3dBehavior extends LiquidBehavior{static behaviorName="liquidHover3d";static domEvents={"mousemove @items":"onItemsMouseMove","mouseleave @items":"onItemsMouseLeave"};currentRect=null;currentTarget=null;options(){return{maxRotation:8,maxTranslation:4,intensity:1}}get ui(){return{items:"[data-lqd-hover3d-el]"}}animate(e,t=!1){this.currentTarget&&(gsap.set(this.currentTarget,{transitionProperty:"opacity,filter,background,color,border,box-shadow,text-shadow,fill,stroke,border-radius"}),gsap.killTweensOf(this.currentTarget),gsap.to(this.currentTarget,{x:e.xTranslationPercentage*-1*e.maxTranslationX,y:e.yTranslationPercentage*-1*e.maxTranslationY,rotateX:e.xRotationPercentage*-1*e.maxRotationX,rotateY:e.yRotationPercentage*-1*e.maxRotationY,transformPerspective:"1200",duration:.8,ease:"power2.out",onComplete:()=>{t&&this.killAllTweens()}}))}calculateRotationPercentage(e,t){return-2/t*e+1}calculateTranslationPercentage(e,t){return-2/t*e+1}onItemsMouseMove(e){const t=this.getOption("intensity"),i=this.getOption("maxRotation");if(this.currentTarget||(this.currentTarget=e.currentTarget),!this.currentRect){const o=this.currentTarget.getBoundingClientRect();this.currentRect={x:o.x,y:o.y+window.scrollY,width:o.width,height:o.height}}const s={x:e.pageX-this.currentRect.x,y:e.pageY-this.currentRect.y},n={xRotationPercentage:this.calculateRotationPercentage(s.y,this.currentRect.height),yRotationPercentage:this.calculateRotationPercentage(s.x,this.currentRect.width)*-1,xTranslationPercentage:this.calculateTranslationPercentage(s.x,this.currentRect.width),yTranslationPercentage:this.calculateTranslationPercentage(s.y,this.currentRect.height)};this.animate({maxTranslationX:this.maxTranslation*t,maxTranslationY:this.maxTranslation*t,maxRotationX:i*t,maxRotationY:i*t,xRotationPercentage:n.xRotationPercentage,yRotationPercentage:n.yRotationPercentage,xTranslationPercentage:n.xTranslationPercentage,yTranslationPercentage:n.yTranslationPercentage})}onItemsMouseLeave(e){this.animate({maxTranslationX:0,maxTranslationY:0,maxRotationX:0,maxRotationY:0,xRotationPercentage:0,yRotationPercentage:0,xTranslationPercentage:0,yTranslationPercentage:0},!0),this.currentTarget=null,this.currentRect=null}killAllTweens(){this.currentTarget&&gsap.killTweensOf(this.currentTarget)}destroy(){this.killAllTweens(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidHover3dBehavior]):window.liquid?.loadedBehaviors?.push(LiquidHover3dBehavior));class Slide{constructor(e,t,i){this.beginMargin=e,this.endMargin=t,this.itemAlign=i,this.items=[],this.outerWidth=0,this.height=0}addItem(e){this.items.push(e),this.outerWidth+=e.size.outerWidth,this.height=Math.max(e.size.outerHeight,this.height),this.items.length===1&&(this.x=e.x,this.firstMargin=e.size[this.beginMargin])}updateTarget(){let e=this.getLastItem(),t=e?e.size[this.endMargin]:0,i=this.outerWidth-(this.firstMargin+t);this.target=this.x+this.firstMargin+i*this.itemAlign}getLastItem(){return this.items[this.items.length-1]}select(){this.items.forEach(e=>{e.el.classList.add("lqd-carousel-cell-active"),e.el.removeAttribute("aria-hidden")})}unselect(){this.items.forEach(e=>{e.el.classList.remove("lqd-carousel-cell-active"),e.el.setAttribute("aria-hidden","true")})}getItemElements(){return this.items.map(e=>e.el)}}class LiquidCarouselBehavior extends LiquidBehavior{static behaviorName="liquidCarousel";static viewEvents={"carousel:ready":"onCarouselReady","carousel:prev":"previous","carousel:next":"next","carousel:select":"select","carousel:focus":"focus","carousel:startAnimation":"startAnimation","before:filter:animation":"onBeforeFilterAnimation"};static windowEvents={resize:{func:"onResize",debounce:{wait:150}}};keyboardHandlers={ArrowLeft:function(){this.view.trigger("carousel:uiChange");let e=this.view.rightToLeft?"next":"previous";this[e]()},ArrowRight:function(){this.view.trigger("carousel:uiChange");let e=this.view.rightToLeft?"previous":"next";this[e]()}};options(){return{accessibility:!0,adaptiveHeight:!1,equalHeight:!1,itemAlign:"start",contain:!1,friction:.28,selectedAttraction:.025,initialIndex:0,setGallerySize:!0,wrapAround:!1,groupItems:!1,connectedCarousels:""}}get ui(){return{items:".lqd-carousel-cell"}}initialize(){this.view.selectedIndex=0,this.restingFrames=0,this.view.carouselX=0,this.view.carouselVelocity=0,this.view.rightToLeft=this.getOption("rightToLeft"),this.beginMargin=this.view.rightToLeft?"marginRight":"marginLeft",this.endMargin=this.view.rightToLeft?"marginLeft":"marginRight",this.view.contain=this.getOption("contain"),this.view.freeScrollFriction=this.getOption("freeScrollFriction"),this.view.friction=this.getOption("friction"),this.view.wrapAround=this.getOption("wrapAround"),this.view.carouselViewport=this.view.el.querySelector(".lqd-carousel-viewport"),this.view.carouselSlider=this.view.el.querySelector(".lqd-carousel-slider"),this.view.focusableElems=[this.view.el];const e=this._itemize(this.getUI("items"));this.view.model.set({items:e,visibleItems:e},{silent:!0}),this.view.el.classList.add("lqd-carousel-initiated"),this.view.rightToLeft&&this.view.el.classList.add("lqd-carousel-rtl"),this.initCarousel()}async initCarousel(){if(this.isDestroyed)return;const e=this.getOption("accessibility");await this.liquidApp.fastdom.measure(()=>{this.isDestroyed||this._sizing()}),!this.isDestroyed&&await this.liquidApp.fastdom.mutate(()=>{this.isDestroyed||(this.setItemAlign(),this.cursorPosition=this.size.innerWidth*this.itemAlign,this.positionItems(),e&&(this.view.el.tabIndex=0,this.view.el.addEventListener("keydown",this.onkeydown.bind(this))),this.view.trigger("carousel:activate"),this.selectInitialIndex(),this.view.trigger("carousel:ready",this.onCarouselReady))})}onCarouselReady(){this.handleConnectedCarousels()}_itemize(e){return e.map(t=>{const i=t.dataset.lqdFilterCat;return{el:t,x:0,isFiltered:!0,filterCat:i?i.split(" "):[]}})}positionItems(){this._positionItems(),this._updateWrapShiftItems(),this.setGallerySize()}getLastItem(){const e=this.view.model.get("items");return e[e.length-1]}_positionItems(e=0){this.maxItemHeight=e&&this.maxItemHeight||0;const t=this.view.model.get("visibleItems");let i=0;if(e>0){let s=t[e-1];i=s.x+s.size.outerWidth}t.slice(e).forEach(s=>{s.x=i,this._renderItemPosition(s,i),i+=s.size.outerWidth,this.maxItemHeight=Math.max(s.size.outerHeight,this.maxItemHeight)}),this.view.slideableWidth=i,this.updateSlides(),this._containSlides(),this.view.carouselSlidesWidth=t.length?this.view.carouselSlides[this.view.carouselSlides.length-1].target-this.view.carouselSlides[0].target:0}_renderItemPosition(e,t){const i=this.view.rightToLeft?"right":"left",s=this.getOption("equalHeight");e.el.style.position="absolute",e.el.style.insetInlineStart=`${t}px`,e.el.style.setProperty("--lqd-carousel-cell-x",`${t}px`),e.el.style.setProperty("--lqd-carousel-cell-width",`${e.size.width}px`),e.el.style.setProperty("--lqd-carousel-cell-height",`${e.size.height}px`),e.el.style.setProperty("--lqd-carousel-cell-outerWidth",`${e.size.outerWidth}px`),e.el.style.setProperty("--lqd-carousel-cell-outerHeight",`${e.size.outerHeight}px`),s&&(e.el.style.height=`${this.maxItemHeight}px`)}updateSlides(){this.view.carouselSlides=[];const e=this.view.model.get("visibleItems");if(!e.length)return;let{beginMargin:t,endMargin:i,itemAlign:s}=this,n=new Slide(t,i,s);this.view.carouselSlides.push(n);let o=this._getCanItemFit();e.forEach(r=>{if(!n.items.length)return n.addItem(r);const a=n.outerWidth-n.firstMargin+(r.size.outerWidth-r.size[i]);o(a)||(n.updateTarget(),n=new Slide(t,i,s),this.view.carouselSlides.push(n)),n.addItem(r)}),n.updateTarget(),this.updateSelectedSlide()}_getCanItemFit(){const e=this.getOption("groupItems");if(!e)return()=>!1;if(typeof e=="number"){let n=parseInt(e,10);return o=>o%n!==0}let t=1,i=typeof e=="string"&&e.match(/^(\d+)%$/);i&&(t=parseInt(i[1],10)/100);let s=(this.size.innerWidth+1)*t;return n=>n<=s}_sizing(){if(this.isDestroyed)return;const e=this.view.model.get("items");this.windowWidth=window.innerWidth,this.size=getSize(this.view.el),this._itemsSizing(e),this.view.model.set({items:e},{silent:!0})}_itemsSizing(e){e.forEach(t=>t.size=getSize(t.el))}setItemAlign(){let e={start:0,center:.5,end:1};const t=this.getOption("itemAlign");let i=e[t];this.itemAlign=i!==void 0?i:t,this.view.rightToLeft&&(this.itemAlign=1-this.itemAlign)}setGallerySize(){if(!this.getOption("setGallerySize"))return;const i={height:`${this.getOption("adaptiveHeight")&&this.selectedSlide?this.selectedSlide.height:this.maxItemHeight}px`},s={height:"100%",position:"absolute",top:0,right:0,bottom:0,left:0};Object.entries(i).forEach(([n,o])=>this.view.carouselViewport.style[n]=o),Object.entries(s).forEach(([n,o])=>this.view.carouselSlider.style[n]=o),this.view.carouselSlider.style.setProperty("--lqd-carousel-slider-width",`${this.size.width}px`)}_updateWrapShiftItems(){if(this.view.isCarouselWrapping=this.getIsWrapping(),!this.view.isCarouselWrapping)return;this._unshiftItems(this.beforeShiftItems),this._unshiftItems(this.afterShiftItems);const e=this.view.model.get("visibleItems");let t=this.cursorPosition,i=e.length-1;this.beforeShiftItems=this._getGapItems(t,i,-1);let s=this.size.innerWidth-this.cursorPosition;this.afterShiftItems=this._getGapItems(s,0,1)}getIsWrapping(){if(!this.view.wrapAround||this.view.carouselSlides.length<2)return!1;if(this.view.wrapAround!=="fill")return!0;let e=this.view.slideableWidth-this.size.innerWidth;if(e>this.size.innerWidth)return!0;for(let t of this.view.model.get("visibleItems"))if(t.size.outerWidth>e)return!1;return!0}_getGapItems(e,t,i){let s=[];for(;e>0;){let n=this.view.model.get("visibleItems")[t];if(!n)break;s.push(n),t+=i,e-=n.size.outerWidth}return s}_containSlides(){const e=this.view.model.get("visibleItems");if(!(this.view.contain&&!this.view.isCarouselWrapping&&e.length))return;const i=this.view.slideableWidth-this.getLastItem().size[this.endMargin];if(i<this.size.innerWidth)this.view.carouselSlides.forEach(n=>{n.target=i*this.itemAlign});else{const n=this.cursorPosition+e[0].size[this.beginMargin],o=i-this.size.innerWidth*(1-this.itemAlign);this.view.carouselSlides.forEach(r=>{r.target=Math.max(r.target,n),r.target=Math.min(r.target,o)})}}select(e,t,i){if(e=parseInt(e,10),this._wrapSelect(e),(this.view.isCarouselWrapping||t)&&(e=modulo(e,this.view.carouselSlides.length)),!this.view.carouselSlides[e])return;let s=this.view.selectedIndex;this.view.selectedIndex=e,this.updateSelectedSlide(),i?this.positionSliderAtSelected():this.startAnimation(),this.getOption("adaptiveHeight")&&this.setGallerySize(),e!==s&&(this.view.trigger("carousel:change",e),this.view.model.set({activeCarouselItem:e}),this.view.model.get("topParentContainer")?.set({activeCarouselItem:e}))}_wrapSelect(e){if(!this.view.isCarouselWrapping)return;const{slideableWidth:t,selectedIndex:i}=this.view,s=this.view.carouselSlides.length;if(!this.view.isDragSelect){let n=modulo(e,s),o=Math.abs(n-i),r=Math.abs(n+s-i),a=Math.abs(n-s-i);r<o?e+=s:a<o&&(e-=s)}e<0?this.view.carouselX-=t:e>=s&&(this.view.carouselX+=t)}previous(e,t){this.view.trigger("carousel:select",this.view.selectedIndex-1,e,t)}next(e,t){this.view.trigger("carousel:select",this.view.selectedIndex+1,e,t)}updateSelectedSlide(){let e=this.view.carouselSlides[this.view.selectedIndex];e&&(this.unselectSelectedSlide(),this.selectedSlide=e,this.view.carouselSlides.filter(t=>t!==e).forEach(t=>t.unselect()),e.select(),this.selectedItems=e.items,this.selectedElements=e.getItemElements())}unselectSelectedSlide(){this.selectedSlide&&this.selectedSlide.unselect()}selectInitialIndex(){const e=this.getOption("initialIndex");if(e&&typeof e=="string"&&this.queryItem(e)){this.selectItem(e,!1,!0);return}let t=0;e&&this.view.carouselSlides[e]&&(t=e),this.view.trigger("carousel:select",t,!1,!0)}selectItem(e,t,i){let s=this.queryItem(e);if(!s)return;let n=this.getItemSlideIndex(s);this.view.trigger("carousel:select",n,t,i)}getItemSlideIndex(e){let t=this.view.carouselSlides.find(i=>i.items.includes(e));return this.view.carouselSlides.indexOf(t)}getItem(e){for(let t of this.view.model.get("items"))if(t.el===e)return t}getItemElements(){return this.view.model.get("items").map(e=>e.el)}queryItem(e){return typeof e=="number"?this.view.model.get("items")[e]:(typeof e=="string"&&!e.match(/^[#.]?[\d/]/)&&(e=this.view.el.querySelector(e)),this.getItem(e))}handleConnectedCarousels(){const e=this.getOption("connectedCarousels");if(!e||e==="")return;e.split(",").forEach(i=>{const s=i.trim(),n=this.liquidApp.elementsCollection.find(r=>r.view.el.getAttribute("id")===s),o=n?.get("behaviors")?.find(r=>r.behaviorName===this.behaviorName);o&&(this.view.on("carousel:select",o.select.bind(o)),n.view.on("carousel:select",this.select.bind(this)))})}positionSliderAtSelected(){this.view.carouselX=-this.selectedSlide.target,this.view.carouselVelocity=0,this.positionSlider()}reposition(){this.positionItems(),this.positionSliderAtSelected()}onResize(){this.isAnimating||this.isDragging||window.innerWidth===this.windowWidth||getSize(this.view.el).width!==this.size.width&&this.resize()}resize(){this._sizing(),this.view.isCarouselWrapping&&(this.view.carouselX=modulo(this.view.carouselX,this.view.slideableWidth)),this.cursorPosition=this.size.innerWidth*this.itemAlign,this.positionItems(),this.view.trigger("carousel:resize");let e=this.selectedElements&&this.selectedElements[0];this.selectItem(e,!1,!0)}onkeydown(e){let{activeElement:t}=document,i=this.keyboardHandlers[e.key];if(!this.getOption("accessibility")||!t||!i)return;this.view.focusableElems.some(n=>t===n)&&i.call(this)}focus(){this.view.carouselViewport.focus({preventScroll:!0})}startAnimation(){this.isAnimating||(this.isAnimating=!0,this.restingFrames=0,this.view.carouselViewport.classList.add("lqd-carousel-is-sliding"),this.animate())}animate(){this.applyDragForce(),this.applySelectedAttraction();let e=this.view.carouselX;this.integratePhysics(),this.positionSlider(),this.settle(e),this.isAnimating&&requestAnimationFrame(()=>this.animate())}positionSlider(){let e=this.view.carouselX;this.view.isCarouselWrapping&&(e=modulo(e,this.view.slideableWidth)-this.view.slideableWidth,this.shiftWrapItems(e)),this.setTranslateX(e),this.dispatchScrollEvent()}setTranslateX(e){let t=e+this.cursorPosition;this.view.rightToLeft&&(t=-t);const i=this.getPositionValue(t);this.view.carouselSlider.style.transform=this.isAnimating?`translate3d(${i}, 0, 0)`:`translateX(${i})`,this.view.carouselSlider.style.setProperty("--lqd-carousel-slider-translate-x",`${Math.round(t)}px`)}dispatchScrollEvent(){let e=this.view.carouselSlides[0];if(!e)return;let t=-this.view.carouselX-e.target,i=t/this.view.carouselSlidesWidth;this.view.trigger("carousel:scroll",null,[i,t])}getPositionValue(e){return Math.round(e/this.size.innerWidth*1e4)*.01+"%"}settle(e){!this.view.isPointerDown&&Math.round(this.view.carouselX*100)===Math.round(e*100)&&this.restingFrames++,this.restingFrames>2&&(this.isAnimating=!1,delete this.view.isFreeScrolling,this.positionSlider(),this.view.trigger("carousel:settle",this.view.selectedIndex),this.view.carouselViewport.classList.remove("lqd-carousel-is-sliding"))}shiftWrapItems(e){let t=this.cursorPosition+e;this._shiftItems(this.beforeShiftItems,t,-1);let i=this.size.innerWidth-(e+this.view.slideableWidth+this.cursorPosition);this._shiftItems(this.afterShiftItems,i,1)}_shiftItems(e,t,i){e.forEach(s=>{let n=t>0?i:0;this._wrapShiftItem(s,n),t-=s.size.outerWidth})}_unshiftItems(e){!e||!e.length||e.forEach(t=>this._wrapShiftItem(t,0))}_wrapShiftItem(e,t){this._renderItemPosition(e,e.x+this.view.slideableWidth*t)}integratePhysics(){this.view.carouselX+=this.view.carouselVelocity,this.view.carouselVelocity*=this.getFrictionFactor()}applyForce(e){this.view.carouselVelocity+=e}getFrictionFactor(){return 1-this.view.friction}applyDragForce(){if(!this.view.isDraggable||!this.view.isPointerDown)return;let t=this.view.carouselDragX-this.view.carouselX-this.view.carouselVelocity;this.applyForce(t)}applySelectedAttraction(){if(this.view.isDraggable&&this.view.isPointerDown||this.view.isFreeScrolling||!this.view.carouselSlides.length)return;let i=(this.selectedSlide.target*-1-this.view.carouselX)*this.getOption("selectedAttraction");this.applyForce(i)}onBeforeFilterAnimation(){const e=this.view.model.get("items");this.view.model.set({visibleItems:e.filter(t=>t.isFiltered)}),this.resize(),this.view.trigger("carousel:select",0)}deactivate(){this.view.el.classList.remove("lqd-carousel-initiated"),this.view.el.classList.remove("lqd-carousel-rtl"),this.unselectSelectedSlide(),this.getOption("accessibility")&&(this.view.el.removeAttribute("tabIndex"),this.view.el.removeEventListener("keydown",this.onkeydown)),this.view.trigger("carousel:deactivate")}destroy(){this.deactivate(),window.removeEventListener("resize",this.resize),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidCarouselBehavior]):window.liquid?.loadedBehaviors?.push(LiquidCarouselBehavior));class LiquidSplitTextBehavior extends LiquidBehavior{static behaviorName="liquidSplitText";static appEvents={"after:windowResize":{func:"afterWindowResize",ifHasOption:"splitDoneFromBackend"}};options(){return{splitDoneFromBackend:!1,tag:"span",splitType:"words",classnamePrefix:"lqd-split-text-",elements:[{els:"[data-lqd-split-text-el]"}]}}async initialize(){this.isDestroyed||(this.getOption("splitDoneFromBackend")||(this.widthBeforeResize=await this.liquidApp.fastdom.measure(()=>this.view.el.offsetWidth)),this.isDestroyed)||(this.elements=this.getElements(),this.beginSplit())}getElements(){const e=this.getOption("elements"),t=this.getOption("splitType");return e.map(({els:i,splitType:s})=>({els:this.view.el.querySelectorAll(i),splitType:s||t}))}beginSplit(){const e=this.getOption("splitDoneFromBackend");this.elements.forEach(t=>e?this.split(t):_.defer(this.split.bind(this,t)))}split({els:e,splitType:t}){const i=this.getOption("classnamePrefix");if(!e.length||this.getOption("splitDoneFromBackend"))return this.splitText={lines:this.view.el.querySelectorAll(`.${i}lines`),words:this.view.el.querySelectorAll(`.${i}words`),chars:this.view.el.querySelectorAll(`.${i}chars`),revert:_.noop},this.onSplitDone(t);gsap.registerPlugin(SplitText);const s=this.getOption("tag");this.splitText=new SplitText(e,{type:t,position:t==="chars"?"absolute":"relative",tag:s,linesClass:`${i}lines`,wordsClass:`${i}words`,charsClass:`${i}chars`}),this.onSplitDone(t)}onSplitDone(e){this.setSplitUnitsAttrs(e),this.setAnimatableElements(e),this.view.model.set({splitText:"done"})}setSplitUnitsAttrs(e){const t=e==="chars,words"?"words":e,i=this.splitText[t];i.forEach((s,n)=>{s.style.setProperty("--split-text-index",n),s.style.setProperty("--split-text-last-index",i.length-1-n)})}setAnimatableElements(e){const t=e==="chars,words"?"chars":e,i=this.splitText[t];this.view.model.set({animatableElements:[...i]})}revertSplitText(){this.splitText?.revert()}reInit(){this.revertSplitText(),this.beginSplit()}async afterWindowResize(e){const t=await this.liquidApp.fastdom.measure(()=>this.view.el.offsetWidth);this.isDestroyed||(e.prevSize.width!==e.currentSize.width&&this.widthBeforeResize!==t&&this.reInit(),this.widthBeforeResize=t)}update(e){super.update(e),this.reInit()}destroy(){this.revertSplitText(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidSplitTextBehavior]):window.liquid?.loadedBehaviors?.push(LiquidSplitTextBehavior));class LiquidLocalScrollBehavior extends LiquidBehavior{static behaviorName="liquidLocalScroll";static domEvents={"click @links":"onLinkClicked"};options(){return{ease:"power2.inOut",duration:null,offset:null}}get ui(){return{links:"[data-lqd-local-scroll-el]"}}initialize(){super.initialize(),this.watchers=[],this.initWatcher(),typeof elementorFrontend<"u"&&(elementorFrontend?.config?.experimentalFeatures?.e_css_smooth_scroll?elementorFrontend?.utils?.anchor_scroll_margin?.setSettings("selectors.targets",".to-disabled-el-local"):elementorFrontend?.utils?.anchors?.setSettings("selectors.targets",".to-disabled-el-local"))}toggleLinkActive(e){this.getUI("links").forEach(i=>i.classList.remove("lqd-is-active")),e.classList.add("lqd-is-active")}initWatcher(){this.getUI("links").forEach((t,i)=>{const s=t.getAttribute("href");if(!s||s==="")return;const n=new URL(s,window.location.href).hash;if(!n)return;const o=document.querySelector(n);if(!o)return;if(!o.closest(".elementor-widget-lqd-stack")){const a=ScrollTrigger.create({trigger:o,start:"top center",end:"bottom center+=10px",onToggle:l=>{l.isActive&&this.toggleLinkActive(t)}});this.watchers.push(a)}})}onLinkClicked(e){const t=e.currentTarget,i=t?.getAttribute("href");if(!i||i==="")return;const s=new URL(i,window.location.href).hash;if(!s)return;const n=document.querySelector(s);if(!n)return;e.preventDefault(),e.stopPropagation();const o=this.getOption("offset")||this.liquidApp.globalOptions.localScroll?.offset,r=this.getOption("duration")||this.liquidApp.globalOptions.localScroll?.duration||1,a=this.getOption("ease"),l=this.view.model.get("behaviors")?.filter(c=>c.behaviorName==="liquidToggle"),h=this.view.model.get("parentsCollection")?.find(c=>c.get("behaviors")?.find(u=>u.behaviorName==="liquidToggle")),g=n.closest(".elementor-widget-lqd-stack");if(!g)window.document.documentElement.style.scrollBehavior="auto",this.scrollTween=gsap.to(window,{duration:r,ease:a,scrollTo:{y:n,offsetY:o,autoKill:!this.liquidApp.touchMatchMedia.matches},onComplete:()=>{window.document.documentElement.style.scrollBehavior=""}});else{const c=this.liquidApp.elementsCollection.get(g.getAttribute("data-lqd-model-cid"))?.get("behaviors")?.find(u=>u.behaviorName==="liquidStack");if(c){const u=n.closest(".lqd-stack-item"),p=parseInt(u.getAttribute("data-stack-index"),10);c.setCurrentIndex({index:p}),this.toggleLinkActive(t)}}h&&h.get("behaviors")?.filter(u=>u.behaviorName==="liquidToggle")?.forEach(u=>{const p=u.getChangeProp();h.set({[p]:[-1]})}),this.liquidApp.touchMatchMedia.matches&&l?.forEach(c=>{const u=c.getChangeProp();this.view.model.set({[u]:[-1]})})}destroy(){this.scrollTween?.kill(),this.watchers?.forEach(e=>e.kill()),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidLocalScrollBehavior]):window.liquid?.loadedBehaviors?.push(LiquidLocalScrollBehavior));class LiquidCounterBehavior extends LiquidBehavior{static behaviorName="liquidCounter";options(){return{countFrom:0,countTo:1069,countStep:1,duration:1.5,delay:0,useLocaleString:!0}}get ui(){return{counterEl:"[data-lqd-counter-el]"}}initialize(){this.IO=new IntersectionObserver(([e],t)=>{e.isIntersecting&&(t.disconnect(),this.animate())}),this.IO.observe(this.view.el)}animate(){const e=this.getOption("countFrom"),t=this.getOption("countTo"),i={value:e},s=this.getUI("counterEl")[0];if(this.counterAnimation?.kill(),isNaN(t))return s.innerHTML=this.getString(t);this.counterAnimation=gsap.to(i,{value:t,duration:this.getOption("duration"),ease:"power2.out",delay:this.getOption("delay"),snap:{value:this.getOption("countStep")},onUpdate:()=>{s.innerHTML=this.getString(i.value)}})}getString(e){return!this.getOption("useLocaleString")||isNaN(e)?e:Number(e).toLocaleString()}destroy(){this.IO?.disconnect(),this.counterAnimation?.kill(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidCounterBehavior]):window.liquid?.loadedBehaviors?.push(LiquidCounterBehavior));class LiquidCarouselSlidesIndicatorBehavior extends LiquidBehavior{static behaviorName="liquidCarouselSlidesIndicator";static viewEvents={"carousel:activate":"onCarouselActivate","carousel:select":"setCurrentIndex"};options(){return{leadingZero:!1}}get ui(){return{wrapper:".lqd-carousel-slides-ind",current:".lqd-carousel-slides-ind-current",total:".lqd-carousel-slides-ind-total"}}onCarouselActivate(){this.setTotal()}setTotal(){const e=this.getOption("leadingZero"),t=this.view.carouselSlides.length;this.getUI("total")[0]&&(this.getUI("total")[0].innerText=`${e&&t<10?"0":""}${t}`),this.getUI("wrapper")[0].style.setProperty("--lqd-carousel-slides-total",t)}setCurrentIndex(){const e=this.getOption("leadingZero"),t=this.view.selectedIndex+1;this.getUI("current")[0]&&(this.getUI("current")[0].innerText=`${e&&t<10?"0":""}${t}`),this.getUI("wrapper")[0].style.setProperty("--lqd-carousel-slides-current",t)}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidCarouselSlidesIndicatorBehavior]):window.liquid?.loadedBehaviors?.push(LiquidCarouselSlidesIndicatorBehavior));class LiquidMoveElementBehavior extends LiquidBehavior{static behaviorName="liquidMoveElement";options(){return{elementsToMove:null,moveElementsTo:"body",matchFirstParent:!1,withElementorWrapper:!1,appendingType:"append"}}get bindToThis(){return["moveElement"]}initialize(){this.getOption("elementsToMove")&&(this.view.trigger("before:move"),_.defer(this.moveElement))}moveElement(){if(this.isDestroyed)return;const e=this.getOption("moveElementsTo"),t=this.getOption("withElementorWrapper");let i=this.view.el.querySelectorAll(this.getOption("elementsToMove")),s=document.querySelector(e);if(this.getOption("matchFirstParent")&&(s=this.view.el.parentElement.closest(e)),t){const n=document.createElement("div"),o=this.view.el.parentElement?.closest(".elementor");o&&([...o.attributes].forEach(({name:r,value:a})=>{n.setAttribute(r,a)}),n.append(...i),i=[n])}e==="parent"?s=this.view.model.get("parentsCollection")?.at(0)?.view?.el||this.view.el.parentElement:e==="topParent"&&(s=this.view.model.get("topParentContainer")?.view?.el||this.view.el.parentElement),s[this.getOption("appendingType")](...i),this.view.model.set({isMoved:!0}),this.view.trigger("done:elementMove")}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidMoveElementBehavior]):window.liquid?.loadedBehaviors?.push(LiquidMoveElementBehavior));class LiquidEffectsFadeToggleBehavior extends LiquidBehavior{static behaviorName="liquidEffectsFadeToggle";get viewEvents(){const e=this.getChangeProp(),t=this.getChangeProp("closedItems");return{[`change:${e}`]:"onOpenedElements",[`change:${t}`]:"onClosedElements"}}options(){return{duration:.7,changePropPrefix:null}}onOpenedElements({targets:e}){e?.length&&this.fade(e,"in")}onClosedElements({targets:e}){e?.length&&this.fade(e,"out")}fade(e,t){e.forEach(i=>{i.animate([{opacity:t==="in"?0:1},{opacity:t==="in"?1:0}],{duration:this.getOption("duration")*1e3})})}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidEffectsFadeToggleBehavior]):window.liquid?.loadedBehaviors?.push(LiquidEffectsFadeToggleBehavior));class LiquidDropdownBehavior extends LiquidBehavior{static behaviorName="liquidDropdown";static viewModelEvents={"change:computedStyles":"measure","change:dropdownsRects":"onDropdownsRectsAdded","done:positionDropdowns":"onDonePositionDropdowns"};get ui(){return{dropdownTriggers:".lqd-menu-dropdown-trigger",dropdownElements:".lqd-menu-dropdown"}}get bindToThis(){return["measure","events","getRect","onDropdownsRectsAdded"]}initialize(){this.triggersRects=[],this.dropdownsRects=[],this.liquidApp.on("start",this.events)}events(){this.view.model.get("layoutRegion")==="liquidPageHeader"&&this.listenTo(this.liquidApp.layoutRegions.liquidPageHeader.model,"change:isSticky",this.measure)}async measure(){this.isDestroyed||(this.windowSize={width:window.innerWidth,height:window.innerHeight},this.windowScroll={x:window.scrollX,y:window.scrollY},await this.liquidApp.fastdom.measure(()=>{this.isDestroyed||(this.getUI("dropdownTriggers").forEach((e,t)=>this.triggersRects[t]=this.getRect(e)),this.getUI("dropdownElements").forEach((e,t)=>this.dropdownsRects[t]=this.getRect(e)))}),!this.isDestroyed&&this.view.model.set({triggersRects:[...this.triggersRects],dropdownsRects:[...this.dropdownsRects]}))}getRect(e){if(this.isDestroyed)return;e.style.insetInlineStart="";let{x:t,y:i}=this.windowScroll;const s=e.getBoundingClientRect();return{y:s.y+i,x:s.x+t,width:s.width,height:s.height,bottom:s.bottom+i,right:s.right+t,preferedHorizontalAlign:e.getAttribute("data-lqd-align-h")}}onDropdownsRectsAdded(e,t){t.forEach((i,s)=>this.positionDropdown(s)),this.view.model.trigger("done:positionDropdowns")}positionDropdown(e){const t=this.getUI("dropdownElements")[e],i=this.triggersRects[e],s=this.dropdownsRects[e];if(!t||!i||!s)return;const{preferedHorizontalAlign:n}=s;let o=0;n==="center"?o=s.width/2*-1:n==="end"&&(o=s.width*-1+i.width),s.right+o>this.windowSize.width?o=(s.right-this.windowSize.width)*-1:s.x+o<0&&(o=i.x*-1),o!==0&&(t.style.insetInlineStart=`${o}px`)}onDonePositionDropdowns(){this.view.el.setAttribute("data-lqd-menu-dropdown-position-applied",!0)}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidDropdownBehavior]):window.liquid?.loadedBehaviors?.push(LiquidDropdownBehavior));class LiquidEffectsSlideToggleBehavior extends LiquidBehavior{static behaviorName="liquidEffectsSlideToggle";defaultActiveDisplay=":flex";options(){return{duration:.7,changePropPrefix:null,keepHiddenClassname:!0}}get viewEvents(){const e=this.getChangeProp(),t=this.getChangeProp("closedItems");return{[`change:${e}`]:"onOpenedElements",[`change:${t}`]:"onClosedElements"}}onOpenedElements({targets:e}){e?.length&&e.forEach(t=>{if((getComputedStyle(t).display!=="none"||t.offsetHeight>0)&&!gsap.isTweening(t))return;gsap.killTweensOf(t),this.setInitialState(t);const s=this.getActiveDisplay(t);gsap.set(t,{display:s}),t.classList.remove("hidden"),gsap.from(t,{duration:this.getOption("duration"),ease:"power4.out",height:0,paddingTop:0,paddingBottom:0,onComplete:()=>{gsap.set(t,{height:"",overflow:"",paddingTop:"",paddingBottom:""})}})})}onClosedElements({targets:e}){if(!e?.length)return;const t=this.getOption("keepHiddenClassname");gsap.killTweensOf(e),e.forEach(i=>{this.setInitialState(i,!1),gsap.to(i,{duration:this.getOption("duration"),ease:"power4.out",height:0,paddingTop:0,paddingBottom:0,onComplete:()=>{t&&i.classList.add("hidden"),gsap.set(i,{display:"",height:"",overflow:"",paddingTop:"",paddingBottom:""})}})})}getActiveDisplay(e){const t=this.view.model.get("lastActiveDisplay");if(t)return t;const n=(e.className.split(" ").find(o=>o.startsWith("[&.lqd-is-active"))||this.defaultActiveDisplay).split(":")[1].replace("]","");return this.view.model.set({lastActiveDisplay:n}),n}setInitialState(e,t=!0){const i={overflow:"hidden"};t&&(i.height="auto"),gsap.set(e,i)}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidEffectsSlideToggleBehavior]):window.liquid?.loadedBehaviors?.push(LiquidEffectsSlideToggleBehavior));class LiquidLiquidSwapBehavior extends LiquidBehavior{static behaviorName="liquidDynamicSwap";static domEvents={mouseenter:"transitionIn",touchstart:"transitionIn",mouseleave:"transitionOut",touchend:"transitionOut"};static appEvents={"after:windowResize":"afterWindowResize"};options(){return{dispImage:null,image1:null,image2:null,imagesRatio:1,intensity1:1,intensity2:1,commonAngle:Math.PI/4,angle1:Math.PI/4,angle2:Math.PI/4,speedIn:1.6,speedOut:1.2,easing:"expo.out",video:!1}}get ui(){return{canvas:"canvas"}}get bindToThis(){return["animate","render"]}initialize(){if(this.isDestroyed)return;var e="varying vec2 vUv;void main() {vUv = uv;gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );}",t="varying vec2 vUv;uniform float dispFactor;uniform float dpr;uniform sampler2D disp;uniform sampler2D texture1;uniform sampler2D texture2;uniform float angle1;uniform float angle2;uniform float intensity1;uniform float intensity2;uniform vec4 res;uniform vec2 parent;mat2 getRotM(float angle) {  float s = sin(angle);  float c = cos(angle);  return mat2(c, -s, s, c);}void main() {  vec4 disp = texture2D(disp, vUv);  vec2 dispVec = vec2(disp.r, disp.g);  vec2 uv = 0.5 * gl_FragCoord.xy / (res.xy) ;  vec2 myUV = (uv - vec2(0.5))*res.zw + vec2(0.5);  vec2 distortedPosition1 = myUV + getRotM(angle1) * dispVec * intensity1 * dispFactor;  vec2 distortedPosition2 = myUV + getRotM(angle2) * dispVec * intensity2 * (1.0 - dispFactor);  vec4 _texture1 = texture2D(texture1, distortedPosition1);  vec4 _texture2 = texture2D(texture2, distortedPosition2);  gl_FragColor = mix(_texture1, _texture2, dispFactor);}";const i=this.getOption("image1"),s=this.getOption("image2"),n=this.getOption("dispImage"),o=this.getUI("canvas")[0],r=this.getOption("video"),a=this.getOption("angle1"),l=this.getOption("angle2"),h=this.getOption("intensity1"),g=this.getOption("intensity2"),c=this.view.el.offsetWidth,u=this.view.el.offsetHeight;if(!(i&&s&&n)){console.warn("One or more images missing for interactive swap on this element",this.view.el);return}this.scene=new THREE.Scene,this.camera=new THREE.OrthographicCamera(c/-2,c/2,u/2,u/-2,1,1e3),this.camera.position.z=1,this.renderer=new THREE.WebGLRenderer({canvas:o,antialias:!1,alpha:!0}),this.renderer.setPixelRatio(2),this.renderer.setClearColor(16777215,0),this.renderer.setSize(c,u),this.renderer.domElement.classList.add("w-full","h-full","absolute","top-0","start-0");var p=new THREE.TextureLoader;p.crossOrigin="";var m=p.load(n,this.render);if(m.magFilter=m.minFilter=THREE.LinearFilter,r){this.IO=new IntersectionObserver(([E])=>{this.isDestroyed||(E.isIntersecting?this.animate():this.raf&&cancelAnimationFrame(this.raf))}),this.IO.observe(this.view.el);var f=document.createElement("video");f.autoplay=!0,f.loop=!0,f.playsInline=!0,f.muted=!0,f.src=i,f.load();var v=document.createElement("video");v.autoplay=!0,v.loop=!0,v.playsInline=!0,v.muted=!0,v.src=s,v.load();var w=new THREE.VideoTexture(f),y=new THREE.VideoTexture(v);w.magFilter=y.magFilter=THREE.LinearFilter,w.minFilter=y.minFilter=THREE.LinearFilter,v.addEventListener("loadeddata",()=>{this.isDestroyed||(v.play(),y=new THREE.VideoTexture(v),y.magFilter=THREE.LinearFilter,y.minFilter=THREE.LinearFilter,this.mat.uniforms.texture2.value=y)},!1),f.addEventListener("loadeddata",()=>{this.isDestroyed||(f.play(),w=new THREE.VideoTexture(f),w.magFilter=THREE.LinearFilter,w.minFilter=THREE.LinearFilter,this.mat.uniforms.texture1.value=w)},!1)}else{var w=p.load(i,this.render),y=p.load(s,this.render);w.magFilter=y.magFilter=THREE.LinearFilter,w.minFilter=y.minFilter=THREE.LinearFilter}this.a1=1,this.a2=1,this.mat=new THREE.ShaderMaterial({uniforms:{intensity1:{type:"f",value:h},intensity2:{type:"f",value:g},dispFactor:{type:"f",value:0},angle1:{type:"f",value:a},angle2:{type:"f",value:l},texture1:{type:"t",value:w},texture2:{type:"t",value:y},disp:{type:"t",value:m},res:{type:"vec4",value:new THREE.Vector4(c,u,this.a1,this.a2)},dpr:{type:"f",value:window.devicePixelRatio}},vertexShader:e,fragmentShader:t,transparent:!0,opacity:1}),this.geometry=new THREE.PlaneBufferGeometry(c,u,1),this.object=new THREE.Mesh(this.geometry,this.mat),this.scene.add(this.object),this.next=this.transitionIn,this.previous=this.transitionOut}animate(){this.isDestroyed||(this.raf=requestAnimationFrame(this.animate),this.renderer.render(this.scene,this.camera))}render(){this.isDestroyed||this.renderer.render(this.scene,this.camera)}transitionIn(){gsap.to(this.mat.uniforms.dispFactor,{value:1,duration:this.getOption("speedIn"),ease:this.getOption("easing"),onUpdate:this.render,onComplete:this.render})}transitionOut(){gsap.to(this.mat.uniforms.dispFactor,{value:0,duration:this.getOption("speedOut"),ease:this.getOption("easing"),onUpdate:this.render,onComplete:this.render})}afterWindowResize(){this.isDestroyed||(this.object.material.uniforms.res.value=new THREE.Vector4(this.view.el.offsetWidth,this.view.el.offsetHeight,this.a1,this.a2),this.renderer.setSize(this.view.el.offsetWidth,this.view.el.offsetHeight),this.render())}destroy(){this.scene?.remove(this.object),this.scene=null,this.camera=null,this.object=null,this.mat=null,this.raf&&cancelAnimationFrame(this.raf),this.IO&&this.IO.disconnect(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidLiquidSwapBehavior]):window.liquid?.loadedBehaviors?.push(LiquidLiquidSwapBehavior));class LiquidThrowableBehavior extends LiquidBehavior{static behaviorName="liquidThrowable";static windowEvents={resize:{func:"onWindowResize",debounce:{wait:100}}};get ui(){return{items:".lqd-throwable-element"}}bodies=[];options(){return{roundness:"sharp",scrollGravity:!0}}initialize(){this.createWorld(),this.createBoundries(),this.createBodies(),this.enableRunner(),this.makeItRain()}enableRunner(){this.runnerObserver=new IntersectionObserver(([e])=>{this.runner.enabled=e.isIntersecting}).observe(this.view.el)}makeItRain(){new IntersectionObserver(([e],t)=>{e.isIntersecting&&(this.startRain(),gsap.to(this.getUI("items"),{opacity:1,duration:1,stagger:.2}),t.disconnect())}).observe(this.view.el)}createWorld(){this.height=this.view.el.offsetHeight,this.width=this.view.el.offsetWidth,this.engine=Matter.Engine.create(),this.runner=Matter.Runner.create(),this.mouse=Matter.Mouse.create(this.view.el),this.view.el.removeEventListener("mousewheel",this.mouse.mousewheel),this.view.el.addEventListener("mouseleave",this.mouse.mouseup),this.mouseConstraint=Matter.MouseConstraint.create(this.engine,{mouse:this.mouse,constraint:{render:{visible:!1}}}),this.engine.gravity.y=.8,Matter.Composite.add(this.engine.world,[this.mouseConstraint]),Matter.Runner.start(this.runner,this.engine),Matter.Events.on(this.mouseConstraint,"mousedown",()=>{this.view.el.style.pointerEvents="auto"}),Matter.Events.on(this.mouseConstraint,"mouseup",()=>{this.view.el.style.pointerEvents=""}),this.runner.enabled=!1}createBoundries(){this.boundStart=Matter.Bodies.rectangle(-250,this.height/2,500,4*this.height,{isStatic:!0}),this.boundEnd=Matter.Bodies.rectangle(this.width+250,this.height/2,500,4*this.height,{isStatic:!0}),this.boundBottom=Matter.Bodies.rectangle(0,this.height+250,2*this.width,500,{isStatic:!0}),Matter.Composite.add(this.engine.world,[this.boundBottom,this.boundStart,this.boundEnd])}createBodies(){this.getUI("items").forEach((e,t)=>{const i=e.querySelector("span");if(!i)return;const s=e.getBoundingClientRect(),n=gsap.quickSetter(e,"x","px"),o=gsap.quickSetter(e,"y","px"),r=gsap.utils.random(.2*-Math.PI,.2*Math.PI),a=gsap.utils.random(s.width/2,this.width-s.width/2),l=-100,h=this.getOption("roundness")==="sharp"?0:s.height/2,g=Matter.Bodies.rectangle(a,l,s.width,s.height,{chamfer:{radius:h},angle:r,isStatic:!0,restitution:.3});this.bodies.push(g),Matter.Composite.add(this.engine.world,[g]),Matter.Events.on(this.runner,"tick",()=>{this.runner.enabled&&(i.style.transform="translate(-50%, -50%) rotate("+g.angle.toFixed(2)+"rad)",o(g.position.y.toFixed(1)),n(g.position.x.toFixed(1)))})})}createTopBound(){this.boundTop=Matter.Bodies.rectangle(this.width/2,-20,this.width,50,{isStatic:!0}),Matter.Composite.add(this.engine.world,[this.boundTop])}makeScrollGravity(){let e=0;Matter.Events.on(this.runner,"tick",()=>{const t=document.documentElement.scrollTop-document.documentElement.clientTop,i=t-e;this.engine.gravity.y=.7-gsap.utils.clamp(-2,4,i*.1),e=t})}updateBoundries(){this.boundTop&&Matter.Body.setVertices(this.boundTop,Matter.Bodies.rectangle(0,-250,2*this.width,500,{isStatic:!0}).vertices),this.boundStart&&(Matter.Body.setPosition(this.boundStart,{x:-250,y:this.height/2}),Matter.Body.setVertices(this.boundStart,Matter.Bodies.rectangle(-250,this.height/2,500,4*this.height,{isStatic:!0}).vertices)),this.boundEnd&&(Matter.Body.setPosition(this.boundEnd,{x:this.width+250,y:this.height/2}),Matter.Body.setVertices(this.boundEnd,Matter.Bodies.rectangle(this.width+250,this.height/2,500,4*this.height,{isStatic:!0}).vertices)),this.boundBottom&&(Matter.Body.setPosition(this.boundBottom,{x:0,y:this.height+250}),Matter.Body.setVertices(this.boundBottom,Matter.Bodies.rectangle(0,this.height+250,2*this.width,500,{isStatic:!0}).vertices))}updateBodies(){this.getUI("items").forEach((e,t)=>{const i=this.bodies[t],s=e.getBoundingClientRect(),n=this.getOption("roundness")==="sharp"?0:s.height/2,o=Matter.Bodies.rectangle(i.position.x,i.position.y,s.width,s.height,{chamfer:{radius:n},angle:i.angle});if(Matter.Body.setVertices(i,o.vertices),i.position.y>this.height&&Matter.Body.setPosition(i,{y:this.height/2,x:i.position.x}),i.position.x>this.width){var r=gsap.utils.random(s.width/2,this.width-s.width/2);Matter.Body.setPosition(i,{y:i.position.y,x:r})}})}startRain(){this.bodies.forEach((t,i)=>{const s=setTimeout(()=>{Matter.Body.setStatic(t,!1),clearTimeout(s)},i*80)});let e=!1;Matter.Events.on(this.runner,"tick",()=>{!e&&this.bodies[this.bodies.length-1].position.y>this.view.el.offsetHeight/2&&(this.createTopBound(),this.getOption("scrollGravity")&&this.makeScrollGravity(),e=!0)})}refresh(){if(this.height===this.view.el.offsetHeight&&this.width===this.view.el.offsetWidth)return!1;this.height=this.view.el.offsetHeight,this.width=this.view.el.offsetWidth;const e=setTimeout(()=>{this.updateBoundries(),this.updateBodies(),clearTimeout(e)})}onWindowResize(){this.refresh()}destroy(){this.runner.enabled=!1,Matter.Runner.stop(this.runner),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidThrowableBehavior]):window.liquid?.loadedBehaviors?.push(LiquidThrowableBehavior));class LiquidTypewriterBehavior extends LiquidBehavior{static behaviorName="liquidTypewriter";options(){return{loop:!1,delay:"natural",deleteSpeed:"natural",actions:[]}}get ui(){return{writer:".lqd-tw-writer"}}initialize(){this.isDestroyed||(this.buildTypewriter(),this.addTypewriterActions(),this.buildIO())}buildTypewriter(){this.typewriter=new Typewriter(this.getUI("writer")[0],{wrapperClassName:"lqd-tw-wrapper",cursorClassName:"lqd-tw-cursor inline-block",delay:this.getOption("delay"),deleteSpeed:this.getOption("deleteSpeed"),loop:this.getOption("loop")})}addTypewriterActions(){this.getOption("actions").forEach(t=>{this.typewriter[t[0]](t[1])})}buildIO(){this.IO=new IntersectionObserver(([e])=>{this.isDestroyed||(e.isIntersecting?this.typewriter.start():this.typewriter.stop())}),this.IO.observe(this.view.el)}destroy(){this.IO&&this.IO.disconnect(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidTypewriterBehavior]):window.liquid?.loadedBehaviors?.push(LiquidTypewriterBehavior));class LiquidStickyHeaderBehavior extends LiquidBehavior{static behaviorName="liquidStickyHeader";static viewModelEvents={"change:computedStyles":"initialize","change:isSticky":"setHeaderAttrs"};options(){return{end:"max",offset:0}}get bindToThis(){return["handleContainerOnEnter","handleContainerOnLeaveBack"]}initialize(){this.scrollTriggers=[],this.containerModels=[],this.stopListening(),this.alwaysVisibleContainersModels=this.view.model.get("childrenCollection").filter(e=>e.get("isTopLevelContainer")).filter(e=>!e.view.el.dataset[DATA_ATTRS.SHOW_ON_STICKY.JS_DATASET]&&!e.view.el.dataset[DATA_ATTRS.HIDE_ON_STICKY.JS_DATASET]),this.alwaysVisibleContainersModels.length&&this.alwaysVisibleContainersModels.forEach((e,t)=>_.defer(this.initStickyContainers.bind(this,e,t)))}setHeaderAttrs(e,t){this.view.el.dataset[DATA_ATTRS.STICKY_HEADER.JS_DATASET]=t}setContainerAttrs(e,t){e.view.el.dataset[DATA_ATTRS.STICKY_CONTAINER.JS_DATASET]=t,e.view.el.dataset[DATA_ATTRS.STICKY_EL.JS_DATASET]=t}initStickyContainers(e,t){this.setContainerAttrs(e,!1),this.containerModelEventHandler(e),this.buildScrollTrigger(e,t)}buildScrollTrigger(e,t){const i=ScrollTrigger.create({trigger:e.view.el,pin:!0,pinSpacing:!1,start:`top-=${this.getOption("offset")+(document.body.classList.contains("admin-bar")&&window.innerWidth>=601?32:0)} top`,endTrigger:document.body,end:"bottom top",onEnter:()=>this.handleContainerOnEnter(e,t),onLeaveBack:()=>this.handleContainerOnLeaveBack(e,t)});e.view.el.style.zIndex=this.alwaysVisibleContainersModels.length-t,this.scrollTriggers.push(i)}handleContainerOnEnter(e,t){t===this.alwaysVisibleContainersModels.length-1&&this.handleHeaderStickyChange(!0),this.handleContainerStickyChange(e,!0),e.view.el.style.zIndex=this.alwaysVisibleContainersModels.length-t}handleContainerOnLeaveBack(e,t){t===0&&this.handleHeaderStickyChange(!1),this.handleContainerStickyChange(e,!1),e.view.el.style.zIndex=this.alwaysVisibleContainersModels.length-t}containerModelEventHandler(e){this.listenTo(e,"change:isSticky",(t,i)=>this.setContainerAttrs(e,i))}handleContainerStickyChange(e,t){e.set({isSticky:t})}handleHeaderStickyChange(e){this.view.model.set({isSticky:e})}destroy(){this.scrollTriggers?.forEach(e=>e.kill()),this.alwaysVisibleContainersModels?.forEach(e=>e.el&&(e.el.style.zIndex="")),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidStickyHeaderBehavior]):window.liquid?.loadedBehaviors?.push(LiquidStickyHeaderBehavior));class Rect{defaults={x:0,y:0,width:0,height:0};constructor(e){for(var t in Rect.defaults)this[t]=Rect.defaults[t];for(t in e)this[t]=e[t]}contains(e){var t=e.width||0,i=e.height||0;return this.x<=e.x&&this.y<=e.y&&this.x+this.width>=e.x+t&&this.y+this.height>=e.y+i}overlaps(e){var t=this.x+this.width,i=this.y+this.height,s=e.x+e.width,n=e.y+e.height;return this.x<s&&t>e.x&&this.y<n&&i>e.y}getMaximalFreeRects(e){if(!this.overlaps(e))return!1;var t=[],i,s=this.x+this.width,n=this.y+this.height,o=e.x+e.width,r=e.y+e.height;return this.y<e.y&&(i=new Rect({x:this.x,y:this.y,width:this.width,height:e.y-this.y}),t.push(i)),s>o&&(i=new Rect({x:o,y:this.y,width:s-o,height:this.height}),t.push(i)),n>r&&(i=new Rect({x:this.x,y:r,width:this.width,height:n-r}),t.push(i)),this.x<e.x&&(i=new Rect({x:this.x,y:this.y,width:e.x-this.x,height:this.height}),t.push(i)),t}canFit(e){return this.width>=e.width&&this.height>=e.height}}class Packer{constructor(e,t){this.width=e||0,this.height=t||0,this.reset()}reset(){this.spaces=[];var e=new Rect({x:0,y:0,width:this.width,height:this.height});this.spaces.push(e),this.sorter=(t,i)=>t.y-i.y||t.x-i.x}pack(e){for(var t=0;t<this.spaces.length;t++){var i=this.spaces[t];if(i.canFit(e)){this.placeInSpace(e,i);break}}}placeInSpace(e,t){e.x=t.x,e.y=t.y,this.placed(e)}placed(e){for(var t=[],i=0;i<this.spaces.length;i++){var s=this.spaces[i],n=s.getMaximalFreeRects(e);n?t.push.apply(t,n):t.push(s)}this.spaces=t,this.mergeSortSpaces()}mergeSortSpaces(){this.mergeRects(this.spaces),this.spaces.sort(this.sorter)}mergeRects(e){var t=0,i=e[t];e:for(;i;){for(var s=0,n=e[t+s];n;){if(n==i)s++;else if(n.contains(i)){e.splice(t,1),i=e[t];continue e}else i.contains(n)?e.splice(t+s,1):s++;n=e[t+s]}t++,i=e[t]}return e}}class LiquidMasonryBehavior extends LiquidBehavior{static behaviorName="liquidMasonry";static viewEvents={"before:filter:animation":"onBeforeFilterAnimation"};static windowEvents={resize:{func:"onResize",debounce:{wait:100}}};options(){return{originLeft:!0,originTop:!0}}get ui(){return{container:".lqd-masonry-container",items:".lqd-masonry-item"}}get bindToThis(){return["layout"]}initialize(){this.packer=new Packer,this._getElements(),_.defer(this.layout)}_getElements(){this.container={el:this.getUI("container")[0]},this.view.model.set({items:this._itemize(this.getUI("items"))},{silent:!0})}_itemize(e){const t=[];return e.forEach(i=>{const s=i.dataset.lqdFilterCat,n={el:i,position:{x:0,y:0},isFiltered:!0,filterCat:s?s.split(" "):[]};t.push(n)}),t}async layout(){this.isDestroyed||(await this.liquidApp.fastdom.measure(()=>{this.isDestroyed||this._resetLayout()}),!this.isDestroyed&&await this.liquidApp.fastdom.mutate(()=>{this.isDestroyed||this.layoutItems()}))}_resetLayout(){this.isDestroyed||(this._sizing(),this.packer.width=this.container.size.innerWidth,this.packer.height=1/0,this.packer.reset(),this.maxY=0,this.maxX=0)}_sizing(){const e=this.view.model.get("items");if(this.container.size=getSize(this.container.el),!e||!e.length)return;const t=e.map(i=>(i.size=getSize(i.el),i.rect=new Rect,i));this.view.model.set({items:t})}layoutItems(){this.isDestroyed||(this._layoutItems(),this._postLayout())}_layoutItems(){this.view.model.get("items").filter(t=>t.isFiltered).forEach(t=>{var i=this._getItemLayoutPosition(t);this._positionItem(t,i.x,i.y)})}_getItemLayoutPosition(e){return this._setRectSize(e),this.packer.pack(e.rect),this._setMaxXY(e.rect),e.rect}_setMaxXY(e){this.maxX=Math.max(e.x+e.width,this.maxX),this.maxY=Math.max(e.y+e.height,this.maxY)}_setRectSize(e){var t=e.size.outerWidth,i=e.size.outerHeight;(t||i)&&(t=this._applyGridGutter(t,this.columnWidth),i=this._applyGridGutter(i,0)),e.rect.width=Math.min(t,this.packer.width),e.rect.height=Math.min(i,this.packer.height)}_applyGridGutter(e,t){if(!t)return e;var i=e%t,s=i&&i<1?"round":"ceil";return e=Math[s](e/t)*t,e}_positionItem(e,t,i){this.itemSetPosition(e,t,i),this.itemLayoutPosition(e)}itemSetPosition(e,t,i){e.position.x=parseFloat(t),e.position.y=parseFloat(i)}itemLayoutPosition(e){var t=this.container.size,i={},s=this.getOption("originLeft"),n=this.getOption("originTop");e.el.style.position="",e.el.style.left="",e.el.style.right="",e.el.style.top="",e.el.style.bottom="";var o=s?"paddingLeft":"paddingRight",r=s?"left":"right",a=s?"right":"left",l=e.position.x+t[o];i[r]=this.itemGetXValue(l),i[a]="";var h=n?"paddingTop":"paddingBottom",g=n?"top":"bottom",c=n?"bottom":"top",u=e.position.y+t[h];i[g]=this.itemGetYValue(u),i[c]="",e.el.style.position="absolute",Object.entries(i).forEach(([p,m])=>{m&&(e.el.style[p]=m)})}itemGetXValue(e){return`${e/this.container.size.width*100}%`}itemGetYValue(e){return`${e}px`}_postLayout(){this._setContainerMeasure(this.maxY)}_setContainerMeasure(e){if(e!==void 0){this.container.el.style.height="";var t=this.container.size;e+=t.paddingBottom+t.paddingTop+t.borderTopWidth+t.borderBottomWidth,e=Math.max(e,0),this.container.el.style.height=`${e}px`}}async onResize(){const e=await this.needsResizeLayout();this.isDestroyed||!e||this.layout()}needsResizeLayout(){return this.liquidApp.fastdom.measure(()=>{const e=this.container.size.innerWidth,t=getSize(this.container.el).innerWidth;return e!==t})}onBeforeFilterAnimation(){this._resetLayout(),this.layoutItems()}destroy(){["height","position","width"].forEach(e=>{this.container.el.style[e]=""}),this.itemsDestroy(),super.destroy()}itemsDestroy(){this.view.model.get("items").forEach(e=>{["position","left","right","top","bottom","transition","transform"].forEach(t=>{e.el.style[t]=""})})}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidMasonryBehavior]):window.liquid?.loadedBehaviors?.push(LiquidMasonryBehavior));class LiquidToggleBehavior extends LiquidBehavior{static behaviorName="liquidToggle";static initialModelProps={firstToggle:!0};options(){return{openedItems:[-1],toggleOffActiveItem:!1,keepOneItemActive:!1,toggleAllTriggers:!1,disableOnTouch:!1,changeTriggerClassname:[],changeTargetClassname:[],parentToChangeClassname:"",changePropPrefix:null,toggleOffOnEscPress:!1,toggleOffOnOutsideClick:!1,ignoreEnterOnFocus:!1,onChangeOpenedItems:null,triggerElements:["click @togglableTriggers"]}}get ui(){return{togglableTriggers:".lqd-togglable-trigger",togglableElements:".lqd-togglable-element"}}get viewModelEvents(){return{[`change:${this.getChangeProp()}`]:"onChangeOpenedItems"}}get domEvents(){const e=this.getOption("triggerElements");if(!e?.length)return;const t={};return e.forEach(i=>{t[i]="onLqdWidgetChangeOpenedItems"}),{...t,"click <document":{ifHasOption:"toggleOffOnOutsideClick",func:"onDocClick"}}}get windowEvents(){return{keyup:{ifHasOption:"toggleOffOnEscPress",func:"onKeyUp"}}}initialize(){const e=this.getOption("openedItems").filter(t=>t>=0);e?.length||this.view.model.set({[this.getChangeProp()]:e},{silent:!0})}changeOpenedItems(e){const t=this.getChangeProp(),i=this.getOption("toggleOffActiveItem"),s=this.getOption("toggleAllTriggers"),n=this.getOption("keepOneItemActive"),o=[...this.view.model.get(t)||[]];let r=_.uniq([...o,e]);i&&(r=[e]),o.includes(e)&&!n&&(r=r.filter(a=>a!==e)),s&&(r=this.getUI("togglableTriggers").map((a,l)=>l).filter((a,l)=>!o.includes(l))),this.view.model.set({[t]:r})}onLqdWidgetChangeOpenedItems(e){if(this.getOption("ignoreEnterOnFocus")&&e.pointerType===""&&this.getUI("togglableTriggers").findIndex(n=>n===document.activeElement)<0||this.getOption("disableOnTouch")&&this.liquidApp.touchMatchMedia.matches)return;e.preventDefault(),e.stopPropagation();const i=e.currentTarget,s=this.getUI("togglableTriggers").findIndex(n=>n===i);s<0||this.changeOpenedItems(s)}onChangeOpenedItems(){const e=this.view.model.get("parentsCollection")?.at(0);this.handleClassnames(),this.view.trigger(`change:${this.getChangeProp()}`,this.openedElements),this.view.trigger(`change:${this.getChangeProp("closedItems")}`,this.closedElements),e&&(e.set("toggle:open",{openedElements:this.openedElements,firstToggle:this.model.get("firstToggle")}),e.set("toggle:close",{closedElements:this.closedElements,firstToggle:this.model.get("firstToggle")})),this.model.set({firstToggle:!1}),this.getOption("onChangeOpenedItems")&&this.getOption("onChangeOpenedItems").apply(this,[this.openedElements,this.closedElements])}handleClassnames(){const e=this.getOption("changeTriggerClassname"),t=this.getOption("changeTargetClassname"),i=this.getOption("parentToChangeClassname"),s=[...this.openedElements.triggers,...this.closedElements.triggers],n=[...this.openedElements.targets,...this.closedElements.targets],o=[...this.openedElements.triggers,...this.openedElements.targets],r=[...this.closedElements.triggers,...this.closedElements.targets];i!==""&&(o.forEach(a=>a?.parentElement?.closest(i)?.classList?.add(STATE_CLASSNAMES.ACTIVE)),r.forEach(a=>a?.parentElement?.closest(i)?.classList?.remove(STATE_CLASSNAMES.ACTIVE))),e.length&&s.forEach(a=>e.forEach(l=>a?.classList?.toggle(l))),t.length&&n.forEach(a=>t.forEach(l=>a?.classList?.toggle(l))),o.forEach(a=>a.classList.add(STATE_CLASSNAMES.ACTIVE)),r.forEach(a=>a.classList.remove(STATE_CLASSNAMES.ACTIVE))}onDocClick(e){const t=[...this.openedElements.targets,...this.openedElements.triggers];if(!t.length)return;const i=e.composedPath();let s=!1;t.forEach(n=>{if(i.includes(n))return s=!0}),!s&&this.view.model.set({[this.getChangeProp()]:[]})}onKeyUp(e){e.code!=="Escape"||![...this.openedElements.targets,...this.openedElements.triggers].length||this.view.model.set({[this.getChangeProp()]:[]})}get openedElements(){const e=this.view.model.get(this.getChangeProp());return{targets:this.getUI("togglableElements").filter((t,i)=>e.includes(i)),triggers:this.getUI("togglableTriggers").filter((t,i)=>e.includes(i))}}get closedElements(){const e=this.view.model.get(this.getChangeProp());return{targets:this.getUI("togglableElements").filter((t,i)=>!e.includes(i)),triggers:this.getUI("togglableTriggers").filter((t,i)=>!e.includes(i))}}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidToggleBehavior]):window.liquid?.loadedBehaviors?.push(LiquidToggleBehavior));class LiquidPinBehavior extends LiquidBehavior{static behaviorName="liquidPin";static viewModelEvents={"change:computedStyles":"initialize","change:isPinned":"onChangePinned"};get bindToThis(){return["onEnter","onLeave","onEnterBack","onLeaveBack"]}mm=gsap.matchMedia();options(){return{start:"top top",end:"bottom top",trigger:"self",endTrigger:"self",pin:"self",animation:null,horizontal:!1,pinnedContainer:null,pinReparent:null,pinSpacer:null,pinSpacing:!0,pinType:"fixed",onEnter:null,onLeave:null,onEnterBack:null,onLeaveBack:null,onBeforeInit:null,onAfterDestroy:null,breakpoints:{all:{},tablet:{},mobile:{}}}}initialize(){gsap.registerPlugin(ScrollTrigger);const e=this.getOption("breakpoints"),t=this.getOption("onBeforeInit"),i=this.getOption("onAfterDestroy"),s=this.view.model.get("isContainer"),o={..._.uniq(Object.keys({...e})).sort((a,l)=>this.liquidApp.breakpointsOrder.indexOf(a)-this.liquidApp.breakpointsOrder.indexOf(l)).reduce((a,l)=>{const h=window.liquid.breakpoints[l];return a[l]={direction:h.direction,value:h.value,mq:h?`(${h.direction}-width: ${h.value}px)`:"all"},a},{})};let r=Object.keys(o);this.view.el.dataset[DATA_ATTRS.STICKY_EL.JS_DATASET]="false",this.view.el.dataset[s?DATA_ATTRS.STICKY_CONTAINER.JS_DATASET:DATA_ATTRS.STICKY_WIDGET.JS_DATASET]="false",r.forEach((a,l)=>{const h=o[a],g=o[r[l+1]],c=o[r[l-1]];g?.direction==="max"&&h.direction==="max"?o[a].mq=`(min-width: ${g.value+1}px) and (max-width: ${h.value}px)`:c?.direction==="min"&&h.direction==="min"&&(o[a].mq=`(min-width: ${h.value}px) and (max-width: ${c.value-1}px)`)}),this.mm.add(_.mapObject(o,a=>a.mq),a=>{t&&t.apply(this,[this]);const{conditions:l}=a,h=Object.keys(l).find(g=>l[g]);return ScrollTrigger.create(this.buildConfig(h)),()=>{i&&i.apply(this,[this])}}),this.isInitialized=!0}buildConfig(e){e==="desktop"&&(e="all");const i=this.getOption("breakpoints")[e];let s={trigger:this.getTriggerEl(this.getOption("trigger"),this.view.el),endTrigger:this.getTriggerEl(this.getOption("endTrigger")),pin:this.getPinEl(this.getOption("pin")),start:this.getOption("start"),end:this.getOption("end"),animation:this.getOption("animation"),horizontal:this.getOption("horizontal"),pinnedContainer:this.getOption("pinnedContainer"),pinReparent:this.getOption("pinReparent"),pinSpacer:this.getOption("pinSpacer"),pinSpacing:this.getOption("pinSpacing"),pinType:this.getOption("pinType"),onEnter:this.onEnter,onLeave:this.onLeave,onEnterBack:this.onEnterBack,onLeaveBack:this.onLeaveBack};return i&&(i.trigger&&(i.trigger=this.getTriggerEl(i.trigger,this.view.el)),i.endTrigger&&(i.endTrigger=this.getTriggerEl(i.endTrigger)),i.pin&&(i.pin=this.getPinEl(i.pin)),s={...s,...i}),typeof s.start=="function"&&(s.start=s.start.bind(this)),typeof s.end=="function"&&(s.end=s.end.bind(this)),s}getPinEl(e){return typeof e=="string"?e==="self"?this.view.el:this.view.el.querySelector(e):!1}getTriggerEl(e,t=null){if(e==="closestParentContainer"){const i=this.view.model.get("parentsCollection");return i?.length?i.at(0).view.el:this.view.el}else if(e==="topParentContainer"){const i=this.view.model.get("topParentContainer");if(i)return i.view.el;if(this.view.model.get("isTopLevelContainer"))return this.view.el}else if(e==="pageContent"){if(this.liquidApp.layoutRegions?.liquidPageContent?.el)return this.liquidApp.layoutRegions?.liquidPageContent?.el}else if(e==="pageFooter"){if(this.liquidApp.layoutRegions?.liquidPageFooter?.el)return this.liquidApp.layoutRegions?.liquidPageFooter?.el}else return e==="self"?this.view.el:typeof e=="string"?document.querySelector(e):t}onEnter(){this.view.model.set("isPinned",!0),this.getOption("onEnter")?.apply(this,[this])}onLeave(){this.view.model.set("isPinned",!1),this.getOption("onLeave")?.apply(this,[this])}onEnterBack(){this.view.model.set("isPinned",!0),this.getOption("onEnterBack")?.apply(this,[this])}onLeaveBack(){this.view.model.set("isPinned",!1),this.getOption("onLeaveBack")?.apply(this,[this])}onChangePinned(){const e=this.view.model.get("isContainer"),t=this.view.model.get("isPinned"),i=getComputedStyle(this.view.el).transitionProperty;if(this.view.el.dataset[DATA_ATTRS.STICKY_EL.JS_DATASET]=t?"true":"false",this.view.el.dataset[e?DATA_ATTRS.STICKY_CONTAINER.JS_DATASET:DATA_ATTRS.STICKY_WIDGET.JS_DATASET]=t?"true":"false",i.includes("transform")){const s=i.split(",").map(n=>n.trim());this.view.el.style.transitionProperty=s.filter(n=>n!=="transform").join(", ")}}killMM(){this.mm?.kill(!0)}destroy(){this.killMM(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidPinBehavior]):window.liquid?.loadedBehaviors?.push(LiquidPinBehavior));class LiquidMarqueeBehavior extends LiquidBehavior{static behaviorName="liquidMarquee";static appEvents={"after:windowResize":"afterWindowResize"};options(){return{reversed:!1,speed:1,interactWithScroll:!0}}get ui(){return{items:".lqd-marquee-cell",slider:".lqd-marquee-slider"}}get bindToThis(){return["sizing"]}initialize(){this.isPaused=!0,this.size={width:0,height:0},this.items=this.getUI("items").map(e=>({el:e,size:{width:0,height:0},position:{x:0}})),this.getUI("slider")[0].style.direction="ltr",this.init()}async init(){this.isDestroyed||(await this.liquidApp.fastdom.measure(this.sizing),!(this.isDestroyed||this.size.width===0)&&(await this.fill(),!this.isDestroyed&&(this.getStartX(),this.buildTimeline(),this.setIntersectionObserver(),this.getOption("interactWithScroll")&&this.interactWithScroll())))}async sizing(){this.isDestroyed||(this.size.width=this.view.el.offsetWidth,this.items.forEach((e,t)=>{e.size={width:e.el.offsetWidth,height:e.el.offsetHeight},e.position={x:e.el.offsetLeft},t===0&&(this.size.height=e.size.height),t>0&&e.size.height>this.items[t-1].size.height&&(this.size.height=e.size.height)}))}async fill(){const e=this.items.at(-1);e.size.width===0||this.size.width===0||e.size.width+e.position.x>this.size.width||await this.liquidApp.fastdom.mutate(()=>{if(this.isDestroyed)return;const t=this.getUI("slider")[0];let i=!1,s=0;for(;!i;){const o={el:this.items[s].el.cloneNode(!0),size:{...this.items[s].size},position:{...this.items[s].position}};t.insertAdjacentElement("beforeend",o.el),o.position.x=o.el.offsetLeft,this.items.push(o),s++,o.size.width+o.position.x>this.size.width+this.size.width/2&&(i=!0)}})}positioning(){const e=this.getUI("slider")[0];e.style.height=`${this.size.height}px`,this.items.forEach(t=>{t.el.classList.remove("relative"),t.el.classList.add("absolute","top-0"),t.el.style.insetInlineStart=`${t.position.x}px`})}getStartX(){this.startX=this.items[0].position.x-parseInt(getComputedStyle(this.items[0].el).marginInlineEnd,10)}buildTimeline(){const e=this.getItemElements();this.timeline=gsap.timeline({repeat:-1,paused:!0,defaults:{ease:"none"},onReverseComplete:()=>this.timeline.totalTime(this.timeline.rawTime()+this.timeline.duration()*100)});const t=this.items.length,i=this.items[t-1],s=[],n=[],o=this.getOption("speed")*100,r=c=>c;let a,l,h,g;gsap.set(e,{xPercent:(c,u)=>{const p=this.items[c].size.width;return n[c]=r(parseFloat(gsap.getProperty(u,"x","px"))/p*100+gsap.getProperty(u,"xPercent")),n[c]},x:0}),a=i.position.x+n[t-1]/100*i.size.width-this.startX+i.size.width*gsap.getProperty(e[t-1],"scaleX");for(let c=0;c<t;c++){const u=this.items[c];l=n[c]/100*u.size.width,h=u.position.x+l-this.startX,g=h+u.size.width*gsap.getProperty(u.el,"scaleX"),this.timeline.to(u.el,{xPercent:r((l-g)/u.size.width*100),duration:g/o},0).fromTo(u.el,{xPercent:r((l-g+a)/u.size.width*100)},{xPercent:n[c],duration:(l-g+a-l)/o,immediateRender:!1},g/o).add("label"+c,h/o),s[c]=h/o}this.timeline.times=s,this.timeline.progress(1,!0).progress(0,!0),this.getOption("reversed")&&this.timeline.vars.onReverseComplete()}play(){this.setWillChange("transform"),this.getOption("reversed")?this.timeline.reverse():this.timeline.play(),this.isPaused=!1}pause(){this.setWillChange(""),this.timeline.pause(),this.isPaused=!0}setIntersectionObserver(){new IntersectionObserver(([e],t)=>{if(this.isDestroyed)return t.disconnect();e.isIntersecting?this.play():this.pause()}).observe(this.view.el)}interactWithScroll(){const t=this.getOption("reversed")?-1:1,i=gsap.utils.clamp(-6,6);this.STTween=gsap.to(this.timeline,{duration:1.5,timeScale:t,paused:!0}),this.ST=ScrollTrigger.create({start:0,end:"max",onUpdate:s=>{this.isPaused||(this.timeline.timeScale(i(s.getVelocity()/200*t)),this.STTween.invalidate().restart())}})}setWillChange(e){this.getItemElements().forEach(t=>t.style.willChange=e)}getItemElements(){return this.items.map(e=>e.el)}afterWindowResize(){this.destroyTimelines(),this.init()}destroyTimelines(){this.timeline?.revert(),this.STTween?.kill(),this.ST?.kill(),this.setWillChange("")}destroy(){this.destroyTimelines(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidMarqueeBehavior]):window.liquid?.loadedBehaviors?.push(LiquidMarqueeBehavior));class LiquidAnimationsBehavior extends LiquidBehavior{static behaviorName="liquidAnimations";static viewModelEvents={"change:ghost":[{"change:animatableElements":{func:"initialize",once:!0}}],"change:animatableElements":[{"change:ghost":{func:"initialize",once:!0}}],"change:rect":{func:"onChangeRect",debounce:{wait:150}}};static parentsCollectionEvents={"change:toggle:open":"onParentsToggleOpen","change:toggle:close":"onParentsToggleClose","change:rect":{func:"onChangeRect",debounce:{wait:150}},"change:ghost":{func:"onChangeRect",debounce:{wait:150}}};defaultElementsSelector="[data-lqd-animation-el]";options(){return{domain:"inview",trigger:"ghost",endTrigger:null,duration:1,ease:"power4.out",stagger:{each:.075,from:"start"},delay:0,repeat:0,repeatDelay:0,yoyo:!1,yoyoEase:!1,start:"top bottom",end:"bottom top",startElementOffset:0,startViewportOffset:0,endElementOffset:0,endViewportOffset:0,toggleActions:"play none none none",scrub:!1,animations:[{elements:this.defaultElementsSelector,breakpointsKeyframes:{all:{options:{},keyframes:[]},tablet:{options:{},keyframes:[]},mobile:{options:{},keyframes:[]}}}]}}initialize(){this.isDestroyed||(gsap.registerPlugin(ScrollTrigger),this.view.model.get("computedStyles")==="done"?this.initAnimations():this.view.model.on("change:computedStyles",()=>{this.isDestroyed||this.initAnimations()}))}initAnimations(){this.isDestroyed||(this.animations=this.buildAnimationsArray(),this.animationsBreakpoints=this.buildAnimationsBreakpoints(),this.matchMedia=gsap.matchMedia(),this.buildAnimations())}onAnimatablesChange(e,t){const i=this.getOption("domain");if(!e.models&&!Array.isArray(t)){const s=[...e?.changed?.behaviors||[]];if(e.previous&&e.previous("behaviors")?.length&&s.push(...e.previous("behaviors")),!s.find(o=>o.behaviorName===this.behaviorName&&o.getOption("domain")===i))return}this.revertAnimations(),this.initAnimations()}buildAnimationsArray(){const e={duration:this.getOption("duration"),ease:this.getOption("ease"),stagger:this.getOption("stagger"),repeat:this.getOption("repeat"),repeatDelay:this.getOption("repeatDelay"),yoyo:this.getOption("yoyo"),yoyoEase:this.getOption("yoyoEase")};let t=[...this.getOption("animations")];return t.forEach((s,n)=>{const{elements:o,breakpointsKeyframes:r,originalElements:a}=s;Object.entries(r).forEach(([l])=>{const h=this.liquidApp.breakpointsOrder.findIndex(c=>c===l);let g={};for(let c=h;c<this.liquidApp.breakpointsOrder.length;c++)s.breakpointsKeyframes[this.liquidApp.breakpointsOrder[c]]&&(g=s.breakpointsKeyframes[this.liquidApp.breakpointsOrder[c]]);r[l].options={...e,...g?.options||{},...r[l]?.options||{}}}),typeof o=="string"?o==="selfAnimatables"?t.splice(n,0,{elements:this.view.model.get("animatableElements"),breakpointsKeyframes:r}):o==="self"?t[n].elements=[this.view.el]:o!==""&&(t[n].elements=[...this.view.el.querySelectorAll(o)]):t[n].elements=[...this.view.el.querySelectorAll(this.defaultElementsSelector)]}),t.filter(s=>typeof s?.elements!="string"&&s?.elements?.length)}buildAnimationsBreakpoints(){const e=this.animations.flatMap(i=>Object.keys(i.breakpointsKeyframes)),t=_.uniq(e).sort((i,s)=>this.liquidApp.breakpointsOrder.indexOf(i)-this.liquidApp.breakpointsOrder.indexOf(s));return t.forEach((i,s)=>{const n=window.liquid.breakpoints[i];let o=n?`(${n.direction}-width: ${n.value}px)`:"all";t[s]={name:i,value:o},n&&(t[s].direction=n.direction,t[s].screenSize=n.value)}),t}buildAnimations(){const e=[this.animations.length-1>>1],t=this.animations.length%2,i={delay:this.getOption("delay"),repeat:this.getOption("repeat"),repeatDelay:this.getOption("repeatDelay"),yoyo:this.getOption("yoyo"),yoyoEase:this.getOption("yoyoEase")},s={trigger:this.getTrigger(this.getOption("trigger")),endTrigger:this.getTrigger(this.getOption("endTrigger")),toggleActions:this.getOption("toggleActions"),scrub:this.getOption("scrub"),scroller:this.getScroller(),start:this.getStartAndEnd(this.getOption("start"),[this.getOption("startElementOffset"),this.getOption("startViewportOffset")]),end:this.getStartAndEnd(this.getOption("end"),[this.getOption("endElementOffset"),this.getOption("endViewportOffset")])};t||e.push(this.animations.length>>1),this.animationsBreakpoints?.forEach(({name:n,value:o,direction:r,screenSize:a},l)=>{let h=o;const c=Object.entries(this.animations).filter(([m,f])=>!f.isChildAnimation).map(([m,f])=>f.breakpointsKeyframes[n])[0]?.options?.stagger,u=this.animationsBreakpoints[l],p=this.animationsBreakpoints[l-1];if(o==="all"&&p?.direction&&p?.screenSize){const m=p.direction==="max"?"min":"max",f=p.direction==="max"?p.screenSize+1:p.screenSize;h=`(${m}-width: ${f}px)`}u?.direction&&u?.screenSize&&p?.direction&&p.screenSize&&(h=`(min-width: ${p?.screenSize+1}px) and (max-width: ${u.screenSize}px)`),this.matchMedia.add(h,()=>{const m=gsap.timeline({delay:i.repeat!==0?0:i.delay,scrollTrigger:s});this.getBreakpointAnimation(m,n,e,c),u.timeline=m}),i?.repeat!==0&&(this.repeatTimelines=this.repeatTimelines||[],this.repeatTimelines[l]=this.repeatTimelines[l]||{name:n,value:o},this.matchMedia.add(h,()=>{u.timeline.restart();const m=gsap.timeline({paused:!1,...i,scrollTrigger:s});m.add(u.timeline),this.repeatTimelines[l].timeline=m}))})}getBreakpointAnimation(e,t,i,s){const n={...this.getOption("stagger")},o=s||n;let r=[...this.animations];o.from==="random"&&(r=_.shuffle(r)),r.forEach((a,l)=>{if(!a.elements?.length||!a.breakpointsKeyframes[t]?.keyframes)return;const h=_.pick({...n,...a.breakpointsKeyframes[t]?.options},"ease","duration","stagger"),g=this.buildBreakpointStagger(h,a,l,i);let c=a.breakpointsKeyframes[t].keyframes.map(u=>this.buildKeyframe(h,g,u));e.to(a.elements,{stagger:g,delay:h.delay||0,keyframes:c,onUpdate:()=>{a.elements.forEach(u=>u.style.transition="none")},onComplete:()=>{a.elements.forEach(u=>u.style.transition="")}},this.getTweensPositionInTimeline(o,t,l,i))})}buildBreakpointStagger(e,t,i,s){if(t.isChildAnimation)return e.stagger;const n={from:e?.stagger?.from,each:e?.stagger?.each},o=s[0],r=s[s.length-1];if(n.from==="center"){let a=n.from;s.length===1&&i===o?a="center":i<=o?a="end":a="start",n.from=a}if(n.from==="edges"){let a=n.from;s.length===1&&i===o?a="edges":i>=r?a="end":a="start",n.from=a}return n}buildKeyframe(e,t,i){const s={from:i?.stagger?.from||t.from,each:i?.stagger?.each||t.each},n={...this.timelinesDefaultOptions,...e,...i,stagger:s};return _.omit(n,"stagger")}getTweensPositionInTimeline(e,t,i,s){const n={from:e.from,each:e.each},o=n.each||0,r=this.animations[i-1],a=r?.breakpointsKeyframes[t]?r.elements.length:0,l=r?.breakpointsKeyframes[t]?.options?.stagger?.each;let h=`<+=${(i>=1?a:0)*(l||o)}`;if(n.from==="end"){let g=0;for(let c=i;c<this.animations.length;c++){const u=this.animations[c+1];if(u){const p=u?.breakpointsKeyframes[t]?u.elements.length:0,m=u?.breakpointsKeyframes[t]?.options?.stagger?.each||0;g+=p*m}}h=g}if(n.from==="center"&&(s.includes(i)&&(h=0),i<s[0])){const g=this.animations[s[0]].elements.length>>1;h=`${(this.animations.slice(i,s[0]).map(u=>u.elements.length).reduce((u,p)=>u+p,0)+g)*o}`}return n.from==="edges"&&(s.includes(i)||(i===0||i===this.animations.length-1?h=0:i>s[0]?h=this.animations[i].elements.length*o:i<s[0]&&(h=`<+=${this.animations[i===0?0:i-1].elements.length*o}`))),h}getTrigger(e){let t;if(e==="self")t=this.view.el;else if(e==="ghost")t=this.view.model.get("ghost")?.el||this.view.el;else if(e==="topParentContainer"){const i=this.view.model.get("topParentContainer");t=i?i.get("ghost")?.el||i.view?.el:this.view.el}else if(e==="closestParentContainer"){const i=this.view.model.get("parentsCollection")?.at(0);t=i?i.get("ghost")?.el||i.view?.el:this.view.el}else e==="pageContent"&&this.liquidApp.layoutRegions?.liquidPageContent?.el?t=this.liquidApp.layoutRegions?.liquidPageContent?.el:e==="pageFooter"&&this.liquidApp.layoutRegions?.liquidPageFooter?.el?t=this.liquidApp.layoutRegions?.liquidPageFooter?.el:t=e;return t}getStartAndEnd(e,t=[0,0]){if(!e)return 0;if(typeof e=="number")return`${e}%`;if(e==="max")return e;const i=e.split(" ");let s="",n="";return t[0]!==0&&(s=`${t[0]<0?"-":"+"}=${Math.abs(t[0])}%`,i[0]=i[0].split(/[+-]/)[0]),t[1]!==0&&(n=`${t[1]<0?"-":"+"}=${Math.abs(t[1])}%`,i[1]=i[1].split(/[+-]/)[0]),`${i[0]}${s} ${i[1]}${n}`}getScroller(){const e=this.view.model.get("parentsCollection");let t=null;return e?.length&&e.forEach(i=>{const s=i.view.el;if(s.classList.contains("elementor-widget-lqd-modal")){t=s.querySelector(".lqd-modal-inner");return}}),t}onParentsToggleOpen(e,{openedElements:t,firstToggle:i}){this.onParentsToggleChange(t,i,"open")}onParentsToggleClose(e,{closedElements:t,firstToggle:i}){this.onParentsToggleChange(t,i,"close")}onParentsToggleChange({triggers:e,targets:t},i,s){if(!e.length&&!t.length)return;const n=this.getOption("toggleActions").split(" "),o=n[0],r=n[1],a=n[2],l=n[3];let h=o,g;switch(s==="open"&&!i?h=a:s==="close"&&i?h=r:s==="close"&&!i&&(h=l),h==="reset"&&(h="pause"),h){case"restart":g=!0;break;case"reset":g=0;break}this.animationsBreakpoints?.forEach(({name:c,timeline:u})=>{this.liquidApp.activeBreakpoint!==c&&c!=="all"||_.defer(()=>{u.scrollTrigger.refresh(!0),(h==="play"||h==="pause"||h==="reverse"||h==="restart"||h==="reset")&&u[h](g)})})}onChangeRect(){this.isDestroyed||this.animationsBreakpoints?.forEach(({name:e,timeline:t})=>{this.liquidApp.activeBreakpoint!==e&&e!=="all"||_.defer(()=>{t.scrollTrigger.refresh(!0)})})}revertAnimations(){this.repeatTimelines?.filter(e=>e.timeline)?.forEach(e=>{e.timeline.revert()}),this.animationsBreakpoints?.filter(e=>e.timeline)?.forEach(e=>{e.timeline.revert()}),this.repeatTimelines=null,this.animationsBreakpoints=null,this.matchMedia?.revert()}destroy(){this.revertAnimations(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidAnimationsBehavior]):window.liquid?.loadedBehaviors?.push(LiquidAnimationsBehavior));class LiquidTextRotatorBehavior extends LiquidBehavior{static behaviorName="liquidTextRotator";static viewModelEvents={"change:computedStyles":"initialize"};static modelEvents={"change:activeItem":"onActiveItemChange"};options(){return{initialIndex:0,stayDuration:3,leaveDuration:1,enterDuration:1}}get ui(){return{itemsWrapper:".lqd-text-rotator-items",items:".lqd-text-rotator-item"}}initialize(){if(this.isDestroyed)return;const e=this.getOption("initialIndex");this.model.set({activeItem:e}),this.addDelayCall(),this.view.el.setAttribute("data-lqd-text-rotator-initiated","true")}addDelayCall(){if(this.isDestroyed)return;const e=this.getOption("stayDuration"),t=this.getOption("enterDuration"),i=this.getUI("items").length;this.enterCall?.kill(),this.stayCall=gsap.delayedCall(e,()=>{if(this.isDestroyed)return;const s=this.model.get("activeItem")||0,n=s>=i-1?0:s+1;this.model.set({activeItem:n}),this.stayCall?.kill(),this.enterCall=gsap.delayedCall(t,this.addDelayCall.bind(this))})}onActiveItemChange(e,t){const i=this.getUI("itemsWrapper")[0],s=this.getUI("items"),n=this.view.model.get("rect")?.elements[t]?.rect?.width,o=e.previous("activeItem");i.style.setProperty("--lqd-tr-width",`${n}px`),s.forEach(r=>r.classList.remove("lqd-is-active","lqd-was-active")),s[t].classList.add("lqd-is-active"),o!=null&&o>=0&&s[o].classList.add("lqd-was-active")}destroy(){this.stayCall?.kill(),this.enterCall?.kill(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidTextRotatorBehavior]):window.liquid?.loadedBehaviors?.push(LiquidTextRotatorBehavior));class LiquidMagneticMouseBehavior extends LiquidBehavior{static behaviorName="liquidMagneticMouse";static docEvents={mousemove:"onDocMouseMove"};static domEvents={"mousemove @items":"onItemMouseMove","mouseleave @items":"onItemMouseLeave"};magneticCoords={x:0,y:0};clientX=0;clientY=0;currentElement=null;currentElementRect=null;currentDist=null;currentAngle=null;currentHypotenuse=null;options(){return{movingElement:"> a"}}get ui(){return{items:"li"}}initialize(){const e={x:window.innerWidth/2,y:window.innerHeight/2};gsap.ticker.add(()=>{const t=1-Math.pow(.6,gsap.ticker.deltaRatio());e.x+=(this.clientX-e.x)*t,e.y+=(this.clientY-e.y)*t,this.elementQuickTo()})}elementQuickTo(){const e=this.getOption("movingElement"),t=e.startsWith(">")?`:scope ${e}`:e;let i;this.lastActiveitem&&(i=this.lastActiveitem.querySelector(t),i&&(gsap.killTweensOf(i),gsap.to(i,{x:"",y:"",transition:"",duration:.2,ease:"power3.out"}))),!(!this.currentElement||!this.magneticCoords)&&(i=this.currentElement.querySelector(t),i&&(gsap.killTweensOf(i),gsap.set(i,{transition:"none"}),gsap.quickTo(i,"x")(-(Math.sin(this.currentAngle)*this.currentHypotenuse)/5),gsap.quickTo(i,"y")(-(Math.cos(this.currentAngle)*this.currentHypotenuse)/5)))}onDocMouseMove(e){this.clientX=e.clientX,this.clientY=e.clientY}onItemMouseMove(e){this.currentElement=e.currentTarget,this.currentElementRect||(this.currentElementRect=this.currentElement.getBoundingClientRect()),this.currentDist={x:this.currentElementRect.x+this.currentElementRect.width/2-this.clientX,y:this.currentElementRect.y+this.currentElementRect.height/2-this.clientY},this.currentAngle=Math.atan2(this.currentDist.x,this.currentDist.y),this.currentHypotenuse=Math.sqrt(this.currentDist.x*this.currentDist.x+this.currentDist.y*this.currentDist.y),this.magneticCoords={x:this.currentElementRect.x+this.currentElementRect.width/2-Math.sin(this.currentAngle)*this.currentHypotenuse/3,y:this.currentElementRect.y+this.currentElementRect.height/2-Math.cos(this.currentAngle)*this.currentHypotenuse/3}}onItemMouseLeave(e){this.currentElement&&(this.lastActiveitem=this.currentElement,this.currentElement=null,this.currentElementRect=null,this.currentDist=null,this.currentAngle=null,this.currentHypotenuse=null)}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidMagneticMouseBehavior]):window.liquid?.loadedBehaviors?.push(LiquidMagneticMouseBehavior));const cursorNodes=["TEXTAREA","INPUT","SELECT","OPTION"],clickTypes=["radio","checkbox","button","submit","image","file"];function getScrollPosition(){return{x:window.pageXOffset,y:window.pageYOffset}}class LiquidCarouselDragBehavior extends LiquidBehavior{static behaviorName="liquidCarouselDrag";static viewEvents={"carousel:activate":[{"carousel:pointerDown":"handlePointerDown"},{"carousel:pointerDown":"handlePointerDone"},{"carousel:pointerUp":"handlePointerUp"},{"carousel:dragStart":"handleDragStart"},{"carousel:dragMove":"handleDragMove"},{"carousel:dragEnd":"handleDragEnd"},{"carousel:uiChange":"_uiChangeDrag"},{"carousel:itemChange":"updateDraggable"},"onActivateDrag"]};options(){return{freeScroll:!1,freeScrollFriction:.075,draggable:">1",dragThreshold:window.matchMedia("(pointer: coarse)").matches?10:3}}get bindToThis(){return["ontouchstartstart","ontouchmovestart","ontouchendstart","ontouchcancelstart","onpointerdownstart","onpointermovestart","onpointerupstart","onpointercancelstart","onmousedownstart","onmousemovestart","onmouseupstart","onscroll"]}initialize(){this.startEvent=null,this.activeEvents=null,"ontouchstart"in window?(this.startEvent="touchstart",this.activeEvents=["touchmove","touchend","touchcancel"]):window.PointerEvent?(this.startEvent="pointerdown",this.activeEvents=["pointermove","pointerup","pointercancel"]):(this.startEvent="mousedown",this.activeEvents=["mousemove","mouseup"])}getLastSlide(){return this.view.carouselSlides[this.view.carouselSlides.length-1]}bindHandles(){this._bindHandles("addEventListener")}unbindHandles(){this._bindHandles("removeEventListener")}_bindHandles(e){this.view.carouselViewport[e](this.startEvent,this[`on${this.startEvent}start`]),this.view.carouselViewport[e]("click",this.onclick)}bindActivePointerEvents(){this.activeEvents.forEach(e=>{window.addEventListener(e,this[`on${e}start`])})}unbindActivePointerEvents(){this.activeEvents.forEach(e=>{window.removeEventListener(e,this[`on${e}start`])})}withPointer(e,t){t.pointerId==this.pointerIdentifier&&this[e](t,t)}withTouch(e,t){let i;for(let s of t.changedTouches)s.identifier==this.pointerIdentifier&&(i=s);i&&this[e](t,i)}onmousedownstart(e){this.pointerDown(e,e)}ontouchstartstart(e){this.pointerDown(e,e.changedTouches[0])}onpointerdownstart(e){this.pointerDown(e,e)}pointerDown(e,t){const i=cursorNodes.includes(e.target.nodeName),s=clickTypes.includes(e.target.type),n=!i||s;!this.view.isPointerDown&&!e.button&&n&&(this.view.isPointerDown=!0,this.pointerIdentifier=t.pointerId!==void 0?t.pointerId:t.identifier,this.pointerDownPointer={pageX:t.pageX,pageY:t.pageY},this.bindActivePointerEvents(),this.view.trigger("carousel:pointerDown",e))}onmousemovestart(e){this.pointerMove(e,e)}onpointermovestart(e){this.withPointer("pointerMove",e)}ontouchmovestart(e){this.withTouch("pointerMove",e)}pointerMove(e,t){let i={x:t.pageX-this.pointerDownPointer.pageX,y:t.pageY-this.pointerDownPointer.pageY};this.view.trigger("carousel:pointerMove",e,t,i),!this.isDragging&&this.hasDragStarted(i)&&this.dragStart(e,t),this.isDragging&&this.dragMove(e,i)}hasDragStarted(e){const t=this.getOption("dragThreshold");return Math.abs(e.x)>t||Math.abs(e.y)>t}dragStart(e,t){this.isDragging=!0,this.isPreventingClicks=!0,this.view.trigger("carousel:dragStart",e,t)}dragMove(e,t){this.view.trigger("carousel:dragMove",e,t)}onmouseupstart(e){this.pointerUp(e,e)}onpointerupstart(e){this.withPointer("pointerUp",e)}ontouchendstart(e){this.withTouch("pointerUp",e)}pointerUp(e,t){this.pointerDone(),this.view.trigger("carousel:pointerUp",e,t),this.isDragging&&this.dragEnd(e,t)}dragEnd(e,t){this.isDragging=!1,setTimeout(()=>delete this.isPreventingClicks),this.view.trigger("carousel:dragEnd",e,t)}pointerDone(){this.view.isPointerDown=!1,delete this.pointerIdentifier,this.unbindActivePointerEvents(),this.view.trigger("carousel:pointerDone")}onpointercancelstart(e){this.withPointer("pointerCancel",e)}ontouchcancelstart(e){this.withTouch("pointerCancel",e)}pointerCancel(e,t){this.pointerDone(),this.view.trigger("carousel:pointerCancel",[e,t])}onclick(e){this.isPreventingClicks&&e.preventDefault()}onActivateDrag(){this.bindHandles(),this.updateDraggable()}onDeactivateDrag(){this.unbindHandles(),this.view.el.classList.remove("lqd-carousel-is-draggable")}updateDraggable(){const e=this.getOption("draggable");e===">1"?this.view.isDraggable=this.view.carouselSlides.length>1:this.view.isDraggable=e,this.view.el.classList.toggle("lqd-carousel-is-draggable",this.view.isDraggable)}_uiChangeDrag(){delete this.view.isFreeScrolling}handlePointerDown(e){if(!this.view.isDraggable){this.bindActivePointerEvents(e);return}let t=e.type==="touchstart",i=e.pointerType==="touch",s=e.target.matches("input, textarea, select");!t&&!i&&!s&&e.preventDefault(),s||this.view.trigger("carousel:focus"),document.activeElement!==this.view.el&&document.activeElement.blur(),this.view.carouselDragX=this.view.carouselX,this.view.carouselViewport.classList.add("lqd-carousel-pointer-down"),this.pointerDownScroll=getScrollPosition(),window.addEventListener("scroll",this.onscroll),this.bindActivePointerEvents(e)}handlePointerUp(){delete this.isTouchScrolling,this.view.carouselViewport.classList.remove("lqd-carousel-pointer-down")}handlePointerDone(){window.removeEventListener("scroll",this.onscroll),delete this.pointerDownScroll}handleDragStart(){this.view.isDraggable&&(this.dragStartPosition=this.view.carouselX,this.view.trigger("carousel:startAnimation"),window.removeEventListener("scroll",this.onscroll))}handleDragMove(e,t){if(!this.view.isDraggable)return;e.preventDefault(),this.previousDragX=this.view.carouselDragX;let i=this.view.rightToLeft?-1:1;this.view.isCarouselWrapping&&(t.x%=this.view.slideableWidth);let s=this.dragStartPosition+t.x*i;if(!this.view.isCarouselWrapping){let n=Math.max(-this.view.carouselSlides[0].target,this.dragStartPosition);s=s>n?(s+n)*.5:s;let o=Math.min(-this.getLastSlide().target,this.dragStartPosition);s=s<o?(s+o)*.5:s}this.view.carouselDragX=s,this.dragMoveTime=new Date}handleDragEnd(){if(!this.view.isDraggable)return;let e=this.getOption("freeScroll");e&&(this.view.isFreeScrolling=!0);let t=this.dragEndRestingSelect();if(e&&!this.view.isCarouselWrapping){let i=this.getRestingPosition();this.view.isFreeScrolling=-i>this.view.carouselSlides[0].target&&-i<this.getLastSlide().target}else!e&&t===this.view.selectedIndex&&(t+=this.dragEndBoostSelect());delete this.previousDragX,this.view.isDragSelect=this.view.isCarouselWrapping,this.view.trigger("carousel:select",t),delete this.view.isDragSelect}dragEndRestingSelect(){let e=this.getRestingPosition(),t=Math.abs(this.getSlideDistance(-e,this.view.selectedIndex)),i=this._getClosestResting(e,t,1),s=this._getClosestResting(e,t,-1);return i.distance<s.distance?i.index:s.index}_getClosestResting(e,t,i){let s=this.view.selectedIndex,n=1/0,o=this.view.contain&&!this.view.isCarouselWrapping?(r,a)=>r<=a:(r,a)=>r<a;for(;o(t,n)&&(s+=i,n=t,t=this.getSlideDistance(-e,s),t!==null);)t=Math.abs(t);return{distance:n,index:s-i}}getSlideDistance(e,t){let i=this.view.carouselSlides.length,s=this.view.wrapAround&&i>1,n=s?modulo(t,i):t,o=this.view.carouselSlides[n];if(!o)return null;let r=s?this.view.slideableWidth*Math.floor(t/i):0;return e-(o.target+r)}dragEndBoostSelect(){if(this.previousDragX===void 0||!this.dragMoveTime||new Date-this.dragMoveTime>100)return 0;let e=this.getSlideDistance(-this.view.carouselDragX,this.view.selectedIndex),t=this.previousDragX-this.view.carouselDragX;return e>0&&t>0?1:e<0&&t<0?-1:0}getRestingPosition(){return this.view.carouselX+this.view.carouselVelocity/(1-this.getFrictionFactor())}getFrictionFactor(){return 1-(this.view.isFreeScrolling?this.getOption("freeScrollFriction"):this.view.friction)}onscroll(){let e=getScrollPosition(),t=this.pointerDownScroll.x-e.x,i=this.pointerDownScroll.y-e.y;(Math.abs(t)>3||Math.abs(i)>3)&&this.pointerDone()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidCarouselDragBehavior]):window.liquid?.loadedBehaviors?.push(LiquidCarouselDragBehavior));class LiquidEffectsDisplayToggleBehavior extends LiquidBehavior{static behaviorName="liquidEffectsDisplayToggle";options(){return{changePropPrefix:null}}get viewEvents(){const e=this.getChangeProp(),t=this.getChangeProp("closedItems");return{[`change:${e}`]:"onOpenedElements",[`change:${t}`]:"onClosedElements"}}onOpenedElements({targets:e}){e?.length&&e.forEach(t=>t?.classList?.remove("hidden"))}onClosedElements({targets:e}){e?.length&&e.forEach(t=>t?.classList?.add("hidden"))}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidEffectsDisplayToggleBehavior]):window.liquid?.loadedBehaviors?.push(LiquidEffectsDisplayToggleBehavior));class LiquidLottieBehavior extends LiquidBehavior{static behaviorName="liquidLottie";options(){return{animType:"",name:"",autoplay:!1,loop:!1,path:"",className:"lqd-lottie",direction:"",speed:1}}get ui(){return{elements:".lqd-lottie"}}initialize(){const e=this.getOption("name"),t=this.getUI("elements")[0];bodymovin.loadAnimation({wrapper:t,animType:this.getOption("animType"),name:e,autoplay:this.getOption("autoplay"),loop:this.getOption("loop"),path:this.getOption("path"),rendererSettings:{className:this.getOption("className")}}),lottie.setDirection(this.getOption("direction"),e),lottie.setSpeed(this.getOption("speed"),e),lottie.pause(e),this.IO=new IntersectionObserver(([i])=>{i.isIntersecting?lottie.play(e):lottie.pause(e)}),this.IO.observe(t)}destroy(){this.IO?.disconnect(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidLottieBehavior]):window.liquid?.loadedBehaviors?.push(LiquidLottieBehavior));class LiquidGetElementComputedStylesBehavior extends LiquidBehavior{static behaviorName="liquidGetElementComputedStyles";static willEmitInitializeTriggerEvents=["change:computedStyles","change:rect","change:styles","change:brightness","change:ghost"];static appEvents={"after:windowResize":"afterWindowResize"};static parentsCollectionEvents={"change:activeCarouselItem":"resetRect","change:toggle":"resetRect","change:stackIndexComplete":"resetRect"};static childrenCollectionEvents={update:{func:"init",debounce:{wait:285.69,options:{immediate:!1}}}};options(){return{includeSelf:!1,elementsSelector:!1,includeChildren:!1,getOnlyContainers:!1,getOnlyWidgets:!1,getRect:!1,getStyles:[],getBrightnessOf:[],addGhosts:!1}}get bindToThis(){return["setStyles","setBrightness","setRect"]}initialize(){this.isDestroyed||this.init()}init(){this.isDestroyed||(this.childrenCollection=[],this.initElementStyles())}initElementStyles(){if(!this.isDestroyed&&(this.getOption("includeChildren")&&this.childrenCollection.push(...this.view.model.get("childrenCollection")?.models||[]),this.getOption("getOnlyContainers")&&(this.childrenCollection=this.childrenCollection.filter(e=>e.get("isContainer"))),this.getOption("getOnlyWidgets")&&(this.childrenCollection=this.childrenCollection.filter(e=>!e.get("isContainer"))),this.getOption("includeSelf")&&this.childrenCollection.push(this.view.model),!!this.childrenCollection.length))return this.liquidApp.fastdom.measure(()=>{this.isDestroyed||(this.getStyles(),this.getBrightnessOf(),this.getRect(),!this.isDestroyed&&this.view.model.set({computedStyles:"done"}))})}getStyles(){this.getOption("getStyles")?.length&&this.childrenCollection.forEach(e=>this.setStyles(e))}getBrightnessOf(){this.getOption("getBrightnessOf")?.length&&this.childrenCollection.forEach(e=>this.setBrightness(e))}getRect(e=!1){if(!this.getOption("getRect")||this.isDestroyed||this.isDestroyed)return;const t=this.view.model.get("parentsCollection")?.find(n=>n.get("behaviors")?.find(o=>o.behaviorName==="liquidStickyHeader")),i=this.liquidApp.layoutRegions[this.view.model.get("layoutRegion")]?.model?.get("behaviors")?.find(n=>n.behaviorName==="liquidStickyHeader");if(this.childrenCollection?.forEach(n=>this.setRect(n,t||i)),e)return;const s=this.childrenCollection.filter(n=>n.get("layoutRegion")==="liquidPageHeader");s.length&&this.listenTo(this.liquidApp,"start",n=>{const o=n.layoutRegions.liquidPageHeader;o&&this.listenTo(o.model,"change:isSticky",(r,a)=>s.forEach(l=>this.setRect(l,t||i)))})}setStyles(e){const t=this.getOption("getStyles"),i=this.getOption("elementsSelector"),s=window.getComputedStyle(e.view.el),n=e.get("styles")||{},o=e.get("isTopLevelContainer"),r=window.getComputedStyle(document.body);t.forEach(a=>{let l=s[a];a==="backgroundColor"&&getAlpha(s[a])===0&&(o?l=r.backgroundColor:l=e.get("topParentContainer")?.get("styles")?.backgroundColor||r.backgroundColor),n[a]=l}),i&&e.view.el.querySelectorAll(i).forEach(a=>{const l=window.getComputedStyle(a),h={el:a,styles:t.map(g=>({[g]:l[g]}))};n.elements=[...n.elements||[],h]}),e.set({styles:n})}setBrightness(e){const t=this.getOption("getBrightnessOf"),i=e.get("brightness")||{};t.forEach(s=>{let n=e.get("styles")[s];if(s==="backgroundColor"){const o=e.view.el.getAttribute("data-lqd-color-scheme");o&&o==="dark"&&(n="#000")}i[s]=getBrightness(n)}),e.set({brightness:i})}setRect(e,t=!1){const{el:i}=e.view,s=this.getElementRect(i),n=this.getOption("elementsSelector"),o=this.getOption("addGhosts"),r=e.get("rect"),a=r?.__v||0;if(n&&i.querySelectorAll(n).forEach(l=>{const h={el:l,rect:this.getElementRect(l)};s.elements=[...s.elements||[],h]}),o){const l=this.liquidApp.topWrap||document.body;let h;e.get("ghost")?.el?h=e.get("ghost").el:(h=document.createElement("div"),h.className=`${t?"fixed":"absolute"} pointer-events-none -z-1`,h.dataset.id=this.view.el.getAttribute("data-id"),h.style.width=`${s.width}px`,h.style.height=`${s.height}px`,h.style.top=`${s.y}px`,h.style.insetInlineStart=`${s.x}px`,l.insertAdjacentElement("beforeend",h)),this.view.listenTo(e,"change:rect",(g,c)=>{h.style.width=`${c.width}px`,h.style.height=`${c.height}px`,h.style.top=`${c.y}px`,h.style.insetInlineStart=`${c.x}px`}),e.set({ghost:{el:h,rect:s,__v:a+1}})}e.set({rect:{...r||{},...s,__v:a+1}})}getElementRect(e){const t=e.getBoundingClientRect(),i=t.width,s=t.height;let n=!1,o=t.x+window.scrollX,r=t.y+window.scrollY,a=e;for(;a!==null;){if(window.getComputedStyle(a).position==="fixed"){n=!0;break}a=a.offsetParent}return n&&(o=t.x,r=t.y),{width:i,height:s,x:o,y:r,right:i+o,bottom:s+r}}recalcRect(){this.liquidApp.fastdom.mutate(()=>this.getRect())}resetRect(){this.liquidApp.fastdom.measure(()=>this.getRect())}afterWindowResize(){this.liquidApp.fastdom.measure(()=>this.getRect(!0))}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidGetElementComputedStylesBehavior]):window.liquid?.loadedBehaviors?.push(LiquidGetElementComputedStylesBehavior));class LiquidSwitchBehavior extends LiquidBehavior{static behaviorName="liquidSwitch";static initialModelProps={isOn:!1};static domEvents={"click @switcher:not([type=checkbox])":"onSwitcherChange","change @switcher[type=checkbox]":"onSwitcherChange"};static modelEvents={"change:isOn":"onModelChange"};options(){return{useLocalStorage:!1,attrs:[]}}get ui(){return{switcher:"input[type=checkbox]"}}initialize(){this.handleInitialValues()}handleInitialValues(){if(!this.getOption("useLocalStorage"))return;this.getOption("attrs").forEach(({attr:i,val:s,el:n})=>{getElementFromString(n,this.view.el).getAttribute(i)===s.on&&this.getUI("switcher").forEach(r=>{r.classList.add(STATE_CLASSNAMES.ACTIVE),r.checked=!0,this.model.set("isOn",!0)})})}onModelChange(e,t){this.onSwitchChange(t?"on":"off")}onSwitcherChange(e){const t=e.currentTarget;this.model.set({isOn:t?.checked})}onSwitchChange(e){const t=this.getOption("useLocalStorage");this.getOption("attrs").forEach(s=>{this.handleHtmlAttrs(e,s),t&&this.handleLocalStorate(e,s)})}handleHtmlAttrs(e,{attr:t,el:i,val:s}){getElementFromString(i).setAttribute(t,s[e]),e==="on"?this.getUI("switcher").forEach(o=>{o.classList.add(STATE_CLASSNAMES.ACTIVE),o.checked=!0}):this.getUI("switcher").forEach(o=>{o.classList.remove(STATE_CLASSNAMES.ACTIVE),o.checked=!1})}handleLocalStorate(e,{key:t,val:i}){localStorage.setItem(t,i[e])}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidSwitchBehavior]):window.liquid?.loadedBehaviors?.push(LiquidSwitchBehavior));class LiquidCarouselDotsBehavior extends LiquidBehavior{static behaviorName="liquidCarouselDots";static viewEvents={"carousel:activate":"onCarouselActivate","carousel:select":"updateSelectedDots","carousel:itemChange":"updateDots","carousel:resize":"updateDots"};dotClassname="lqd-carousel-dot inline-block flex-shrink-0 flex-grow-0 basis-auto overflow-hidden -indent-full";activeClassname=["lqd-is-active","lqd-carousel-dot-active"];dotTextContent="View slide";dots=[];get ui(){return{dotsHolder:".lqd-carousel-dots",dots:".lqd-carousel-dot"}}get bindToThis(){return["onDotsClick"]}onCarouselActivate(){this.dotTemplate=this.getUI("dots")[0],this.dots=[],this.activateDots()}setDots(){let e=this.view.carouselSlides.length-this.dots.length;e>0?this.addDots(e):e<0&&this.removeDots(-e)}addDots(e){const t=this.getUI("dotsHolder")[0];let i=new Array(e).fill().map((s,n)=>{let o;return this.dotTemplate?(o=this.dotTemplate.cloneNode(!0),o?.classList?.remove(...this.activeClassname,"hidden")):(o=document.createElement("button"),o.setAttribute("type","button"),o.className=this.dotClassname),o.textContent=`${this.dotTextContent} ${n+1+this.dots.length}`,o});t.append(...i),this.dots=this.dots.concat(i),t.classList.remove("lqd-carousel-dots-empty")}removeDots(e){this.dots.splice(this.dots.length-e,e).forEach(i=>i.remove())}updateSelectedDot(e){this.selectedDot&&(this.selectedDot.classList.remove(...this.activeClassname),this.selectedDot.removeAttribute("aria-current")),this.dots.length&&(this.selectedDot=this.dots[e]||this.dots[0],this.selectedDot.classList.add(...this.activeClassname),this.selectedDot.setAttribute("aria-current","step"))}activateDots(){this.setDots(),this.view.focusableElems.push(...this.dots),this.getUI("dotsHolder")[0].addEventListener("click",this.onDotsClick)}onDotsClick(e){let t=this.dots.indexOf(e.target);t!==-1&&(this.view.trigger("carousel:uiChange"),this.view.trigger("carousel:select",t))}updateSelectedDots(){this.updateSelectedDot(this.view.selectedIndex)}updateDots(){this.dots.forEach(e=>{this.view.focusableElems=this.view.focusableElems.filter(t=>t!==e)}),this.setDots(),this.view.focusableElems.push(...this.dots)}destroy(){this.removeDots(this.dots.length),this.getUI("dotsHolder")[0].removeEventListener("click",this.onDotsClick),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidCarouselDotsBehavior]):window.liquid?.loadedBehaviors?.push(LiquidCarouselDotsBehavior));class LiquidCarouselNavBehavior extends LiquidBehavior{static behaviorName="liquidCarouselNav";static viewEvents={"carousel:activate":"onCarouselActivate","carousel:select":"updateNavButtons"};static domEvents={"click .lqd-carousel-nav-prev":"onPrevClick","click .lqd-carousel-nav-next":"onNextClick"};get ui(){return{prevButton:".lqd-carousel-nav-prev",nextButton:".lqd-carousel-nav-next"}}onPrevClick(){this.view.trigger("carousel:uiChange"),this.view.trigger("carousel:prev")}onNextClick(){this.view.trigger("carousel:uiChange"),this.view.trigger("carousel:next")}onCarouselActivate(){this.view.focusableElems.push(this.getUI("prevButton")[0],this.getUI("nextButton")[0])}navButtonEnable(e){e.removeAttribute("disabled")}navButtonDisable(e){e.setAttribute("disabled",!0)}updateNavButtons(){let e=this.view.carouselSlides.length?this.view.carouselSlides.length-1:0;this.updateNavButton("prevButton",0),this.updateNavButton("nextButton",e)}updateNavButton(e,t){const i=this.getUI(e)[0];if(this.view.isCarouselWrapping&&this.view.carouselSlides.length>1){this.navButtonEnable(i);return}let s=this.view.selectedIndex!==t;this[s?"navButtonEnable":"navButtonDisable"](i),!s&&document.activeElement===i&&this.view.trigger("carousel:focus")}activateNavButtons(){}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidCarouselNavBehavior]):window.liquid?.loadedBehaviors?.push(LiquidCarouselNavBehavior));class LiquidRangeBehavior extends LiquidBehavior{static behaviorName="liquidRange";static topParentContainerEvents={"change:range":{func:"onChangeRange",throttle:{wait:185.69,leading:!1}}};static topParentChildrenCollectionEvents={"init:dynamicRange":"initialize"};static docEvents={pointermove:{func:"move",throttle:{wait:150,leading:!0}},pointerup:{func:"drop",throttle:{wait:150,leading:!0}}};static domEvents={"pointerdown @handle":{func:"drag",throttle:{wait:150,leading:!0}}};static windowEvents={resize:{func:"onResize",throttle:{wait:150}}};input=null;slider=null;sliderWidth=0;sliderLeft=0;handleWidth=0;handleR=null;handleL=null;activeHandle=null;selected=null;scale=null;step=0;tooltipL=null;tooltipR=null;timeout=null;valRange=!1;values={start:null,end:null};options(){return{getValuesFrom:"parent",values:[],set:null,range:!1,labels:!0,step:null,disabled:!1}}get ui(){return{rangeInput:".lqd-range-input",container:".lqd-range-container",selected:".lqd-range-selected",handle:".lqd-range-handle",scale:".lqd-range-scale",tooltip:".lqd-range-tooltip"}}initialize(){this.input=this.getUI("rangeInput")[0],this.slider=this.getUI("container")[0],this.selected=this.getUI("selected")[0],this.handleL=this.getUI("handle[data-dir=start]")[0],this.handleR=this.getUI("handle[data-dir=end]")[0],this.scale=this.getUI("scale")[0],this.tooltipL=this.getUI("tooltip[data-dir=start]")[0],this.tooltipR=this.getUI("tooltip[data-dir=end]")[0];const e=this.getOption("getValuesFrom");if(e&&e!==""&&this.setOption("values",this.setValuesOption()),this.valRange=!(this.getOption("values")instanceof Array),this.valRange&&(!this.getOption("values")?.hasOwnProperty("min")||!this.getOption("values")?.hasOwnProperty("max")))return console.log("Missing min or max values...");this.createSlider()}setValuesOption(){const e=this.getOption("getValuesFrom"),t=[];let i=this.view.model.get("topParentContainer")?.get("childrenCollection");if(e!=="parent"){const o=e.split(",").map(r=>r.trim());i=this.liquidApp.elementsCollection.filter(r=>o.includes(r.view.el.getAttribute("id")))}if(!i||!i?.length)return t;const n=i.filter(o=>o.get("behaviors")?.find(r=>r.behaviorName==="liquidDynamicRange")).map(o=>{const r=o.get("behaviors")?.find(l=>l.behaviorName==="liquidDynamicRange");return r?r.getOption("range"):void 0});return n.length&&n.forEach(o=>{Object.keys(o).forEach(r=>{t.includes(r)||t.push(r)})}),t}createElement(e,t,i){var s=document.createElement(e);return t&&(s.className=t),i&&i.length===2&&s.setAttribute("data-"+i[0],i[1]),s}createEvents(e,t,i){for(var s=t.split(" "),n=0,o=s.length;n<o;n++)e.addEventListener(s[n],i)}checkInitial(){const e=this.getOption("set"),t=this.getOption("values"),i=this.getOption("range");return!e||e.length<1||t.indexOf(e[0])<0||i&&(e.length<2||t.indexOf(e[1])<0)?null:!0}createSlider(){return this.sliderLeft=this.slider.getBoundingClientRect().left,this.sliderWidth=this.slider.clientWidth,this.handleWidth=this.handleL.clientWidth,this.setInitialValues()}prepareArrayValues(){var e=[],t=this.getOption("values").max-this.getOption("values").min;if(!this.getOption("step"))return console.log("No step defined..."),[this.getOption("values").min,this.getOption("values").max];for(var i=0,s=t/this.getOption("step");i<s;i++)e.push(this.getOption("values").min+i*this.getOption("step"));return e.indexOf(this.getOption("values").max)<0&&e.push(this.getOption("values").max),e}setInitialValues(){const e=this.getOption("set");if(this.disabled(this.getOption("disabled")),this.valRange&&this.setOption("values",this.prepareArrayValues()),this.values.start=0,this.values.end=this.getOption("range")?this.getOption("values").length-1:0,e&&e.length&&this.checkInitial()){var t=e;this.getOption("range")?(this.values.start=this.getOption("values").indexOf(t[0]),this.values.end=e[1]?this.getOption("values").indexOf(t[1]):null):this.values.end=this.getOption("values").indexOf(t[0])}return this.createScale()}createScale(){const t=this.getOption("values").length;this.step=this.sliderWidth/(t-1);for(var i=0,s=t;i<s;i++){var n=this.createElement("span",`lqd-range-scale-span relative ${i===t-1?"shrink":"shrink grow basis-0"} ${i===t-1?"w-0 text-end":""} h-full`),o=this.createElement("span","lqd-range-scale-span-label inline-block absolute start-0 lqd-transform -translate-y-1/2");n.appendChild(o),this.scale.appendChild(n),this.getOption("labels")?o.innerHTML=this.getOption("values")[i]:(i===0||i===s-1)&&(o.innerHTML=this.getOption("values")[i])}return this.view.el.setAttribute("data-range-steps",t),this.addEvents()}updateScale(){return this.step=this.sliderWidth/(this.getOption("values").length-1),this.setValues()}addEvents(){const e=this.slider.querySelectorAll("span");for(var t=0,i=e.length;t<i;t++)this.createEvents(e[t],"click",this.onClickPiece.bind(this));return this.setValues()}drag(e){if(e.preventDefault(),!this.getOption("disabled")){var t=e.currentTarget.getAttribute("data-dir");t==="start"&&(this.activeHandle=this.handleL),t==="end"&&(this.activeHandle=this.handleR)}}move(e){if(!this.activeHandle||this.getOption("disabled"))return;const t=this.getOption("values").length;var i=e.type==="touchmove"?e.touches[0].clientX:e.pageX,s=i-this.sliderLeft-this.handleWidth/2;return s=Math.round(s/this.step),s<=0&&(s=0),s>t-1&&(s=t-1),this.getOption("range")?(this.activeHandle===this.handleL&&(this.values.start=s),this.activeHandle===this.handleR&&(this.values.end=s)):this.values.end=s,this.view.el.classList.add("lqd-range-sliding"),this.setValues()}drop(){this.activeHandle=null}setValues(e,t){const i=this.getOption("values").length,s=this.getOption("range")?"start":"end";e&&this.getOption("values").indexOf(e)>-1&&(this.values[s]=this.getOption("values").indexOf(e)),t&&this.getOption("values").indexOf(t)>-1&&(this.values.end=this.getOption("values").indexOf(t)),this.getOption("range")&&this.values.start>this.values.end&&(this.values.start=this.values.end);let n=this.values[s]*this.step-this.handleWidth/2;return i===2&&(n=Math.max(this.handleWidth/10,this.values[s]*this.step-this.handleWidth-this.handleWidth/10)),this.handleL.style.left=n+"px",this.getOption("range")?(this.tooltipL.innerHTML=this.getOption("values")[this.values.start],this.tooltipR&&(this.tooltipR.innerHTML=this.getOption("values")[this.values.end]),this.input.value=this.getOption("values")[this.values.start]+","+this.getOption("values")[this.values.end],this.handleR&&(this.handleR.style.left=this.values.end*this.step-this.handleWidth/2+"px")):(this.tooltipL.innerHTML=this.getOption("values")[this.values.end],this.input.value=this.getOption("values")[this.values.end],this.values.end===0||this.values.end===i-1?this.slider.classList.add("lqd-range-tooltip-hide"):this.slider.classList.remove("lqd-range-tooltip-hide")),this.values.end>this.getOption("values").length-1&&(this.values.end=this.getOption("values").length-1),this.values.start<0&&(this.values.start=0),this.selected.style.width=(this.values.end-this.values.start)*this.step+"px",this.selected.style.left=this.values.start*this.step+"px",this.onChange()}onClickPiece(e){if(!this.getOption("disabled")){var t=Math.round((e.clientX-this.sliderLeft)/this.step);return t>this.getOption("values").length-1&&(t=this.getOption("values").length-1),t<0&&(t=0),this.getOption("range")?t-this.values.start<=this.values.end-t?this.values.start=t:this.values.end=t:this.values.end=t,this.view.el.classList.remove("lqd-range-sliding"),this.setValues()}}onChange(){this.view.model.set({currentRangeKey:this.input.value})}onResize(){return this.sliderLeft=this.slider.getBoundingClientRect().left,this.sliderWidth=this.slider.clientWidth,this.updateScale()}disabled(e){this.setOption("disabled",e),this.slider.classList[e?"add":"remove"]("disabled")}onChangeRange(e){const t=this.getOption("getValuesFrom");if(t&&t!==""&&this.setOption("values",this.setValuesOption()),this.valRange=!(this.getOption("values")instanceof Array),this.valRange&&(!this.getOption("values")?.hasOwnProperty("min")||!this.getOption("values")?.hasOwnProperty("max")))return console.log("Missing min or max values...");this.getUI("scale")[0].innerHTML="",this.createSlider()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidRangeBehavior]):window.liquid?.loadedBehaviors?.push(LiquidRangeBehavior));class LiquidDynamicRangeBehavior extends LiquidBehavior{static behaviorName="liquidDynamicRange";elTextAnimations=[];lastValue=0;lastSeparatedText=0;options(){return{range:{},el:null,placeholderEl:null,separator:null,appendSeparatedTo:null,hideElsIfNan:null,showElsIfNan:null,duration:1,useLocaleString:!1,changeExtra:[]}}initialize(){const e=this.view.model.get("topParentContainer");if(!e||!this.getOption("el"))return;const t=e.get("childrenCollection");t?.length&&(this.el=this.view.el.querySelector(this.getOption("el")),this.placeholderEl=this.view.el.querySelector(this.getOption("placeholderEl")),this.el&&(this.range=this.getOption("range"),this.separator=this.getOption("separator"),this.appendSeparatedTo=this.view.el.querySelector(this.getOption("appendSeparatedTo")),this.hideElsIfNan=this.view.el.querySelectorAll(this.getOption("hideElsIfNan")),this.showElsIfNan=this.view.el.querySelectorAll(this.getOption("showElsIfNan")),this.changeExtra=this.getOption("changeExtra"),t.on("change:currentRangeKey",this.onParentChildrenRangeChange.bind(this)),this.view.model.trigger("init:dynamicRange",this)))}onParentChildrenRangeChange(e,t){let i=this.range[t],s;if(!i)return;if(this.separator){const a=i.split(this.separator);a.length>1&&(i=a[0],s=a[1])}const n={value:this.lastValue};if(this.killAnimations(),this.elTextAnimations=[],this.placeholderEl&&(this.placeholderEl.innerText=i),isNaN(parseFloat(i.replace(/,/g,""))))return this.hideElsIfNan?.length&&this.hideElsIfNan.forEach(a=>a.style.display="none"),this.showElsIfNan?.length&&this.showElsIfNan.forEach(a=>a.style.display="block"),this.el.innerText=i,this.lastValue=0;this.hideElsIfNan?.length&&this.hideElsIfNan.forEach(a=>a.style.display=""),this.showElsIfNan?.length&&this.showElsIfNan.forEach(a=>a.style.display="");const o=gsap.to(n,{value:parseFloat(i.replace(/,/g,"")),duration:this.getOption("duration"),ease:"power2.inOut",snap:{value:i.indexOf(".")===-1?1:this.getDecimal(i)},onUpdate:()=>{const a=this.getString(n.value);this.el.innerText=a}});if(this.lastValue=this.range[t],this.elTextAnimations.push(o),this.changeExtra.filter(a=>a.key===t).forEach(a=>{this.view.el.querySelectorAll(a.el).forEach(h=>h.innerText=a.value)}),s&&this.appendSeparatedTo){const a={value:this.lastSeparatedText};if(isNaN(parseFloat(s.replace(/,/g,""))))return this.appendSeparatedTo.innerText=s;const l=gsap.to(a,{value:s,duration:this.getOption("duration"),ease:"power2.inOut",snap:{value:s.indexOf(".")===-1?1:this.getDecimal(s)},onUpdate:()=>{const h=this.getString(a.value);this.appendSeparatedTo.innerText=h}});this.lastSeparatedText=s,this.elTextAnimations.push(l)}}getDecimal(e){e=e.toString();const t=e.split(".")[1];let i;switch(console.log(t),t.length){case 1:i=.1;break;case 2:i=.01;break;case 3:i=.001;break;default:i=1e-4}return i}getString(e){return!this.getOption("useLocaleString")||isNaN(parseFloat(e))?e:parseFloat(e).toLocaleString()}killAnimations(){this.elTextAnimations.forEach(e=>e.kill())}destroy(){this.killAnimations(),super.destroy()}}typeof window<"u"&&(window.liquid?.app?window.liquid?.app?.model?.set("loadedBehaviors",[...window.liquid.app.model.get("loadedBehaviors"),LiquidDynamicRangeBehavior]):window.liquid?.loadedBehaviors?.push(LiquidDynamicRangeBehavior));const ElementsCollection=Backbone.Collection.extend({model:LiquidWidgetBaseModel});class LiquidApp{isStarted=!1;topWrapClassname="lqd-wrap";topWrapSelector=`#${this.topWrapClassname}`;globalBehaviors=[];layoutRegions={};elementsCollection=new ElementsCollection;behaviorsInitializeQueue=[];windowResizeUpdateQueue=[];_windowSize={width:window.innerWidth,height:window.innerHeight};_prevWindowSize=this._windowSize;globalOptions={localScroll:{offset:0,duration:1}};activeBreakpoint="";uninitializedBehaviors=[];deferredBehaviorsQueue=new Map;constructor({layoutRegions:e,containersClassname:t="lqd-container",containersBoxedClassname:i="lqd-container-boxed",widgetsClassname:s="lqd-widget",globalOptions:n,globalBehaviors:o,touchMatchMedia:r}){_.extend(this,Backbone.Events),_.extend(window.liquid,Backbone.Events),this.containersClassname=t,this.containersBoxedClassname=i,this.widgetsClassname=s,this.containersSelector=`.${this.containersClassname}`,this.containersBoxedSelector=`.${this.containersBoxedClassname}`,this.widgetsSelector=`.${this.widgetsClassname}`,this.touchMatchMedia=r||(window.liquidTouchMM?liquidTouchMM:window.matchMedia("(pointer: coarse)")),e&&(this.layoutRegions=e),n&&(this.globalOptions={...this.globalOptions,...n}),o&&(this.globalBehaviors=[...this.globalBehaviors,...o]),this.breakpointsOrder=[window.liquid.breakpoints.desktop?"":"all",...Object.keys(window.liquid.breakpoints).filter(a=>window.liquid.breakpoints[a].is_enabled)],typeof fstdm>"u"?this.fastdom=fastdom.extend(fastdomPromised):this.fastdom=fstdm.extend(fastdomPromised),this.model=new Backbone.Model({loadedBehaviors:window.liquid?.loadedBehaviors||[]}),this.view=new LiquidBaseView({el:"#lqd-wrap"}),this.view.model=this.model,this.model.view=this.view,this.beforeWindowResize=_.debounce(this.beforeWindowResize.bind(this),185.69),this.afterWindowResize=_.debounce(this.afterWindowResize.bind(this),585.69,!1)}get prevWindowSize(){return this._prevWindowSize}set prevWindowSize({width:e,height:t}){this._prevWindowSize={width:e,height:t}}get windowSize(){return this._windowSize}set windowSize({width:e,height:t}){this._windowSize={width:e,height:t}}start(e={isEditor:!1}){this.trigger("app:before:start",this),this.elementsCollection.comparator=(t,i)=>{this.elementsCollectionSortedCIDs||(this.elementsCollectionSortedCIDs=[...document.querySelectorAll("[data-lqd-model-cid]")].map(r=>r.getAttribute("data-lqd-model-cid")));const s=t.cid,n=i.cid;let o=0;return this.elementsCollectionSortedCIDs.indexOf(s)>this.elementsCollectionSortedCIDs.indexOf(n)?o=1:this.elementsCollectionSortedCIDs.indexOf(s)<this.elementsCollectionSortedCIDs.indexOf(n)&&(o=-1),o},this.elementsCollection.on("sort",()=>{this.elementsCollectionSortedCIDs=null}),this.topWrap=document.querySelector(this.topWrapSelector),this.setActiveBreakpoint(),Object.entries(this.layoutRegions).forEach(([t,i])=>{const s=typeof i.el=="string"?document.getElementById(i.el):i.el,n=typeof i.contentWrap=="string"?document.getElementById(i.contentWrap):i.contentWrap;this.layoutRegions[t].el=s,this.layoutRegions[t].contentWrap=n}),this.buildElementsCollection(),this.addLayoutRegions(),this.model.set({childrenCollection:this.elementsCollection}),_.defer(()=>{e.isEditor||(this.addBehaviors(),this.initializeBehaviors()),this.trigger("app:start",this)}),_.defer(()=>{this.bindWindowResize()}),_.defer(()=>{e.isEditor||(this.isStarted=!0)})}childrenComparator(e,t){const i=this.elementsCollection.map(r=>r.cid),s=e.cid,n=t.cid;let o=0;return i.indexOf(s)>i.indexOf(n)?o=1:i.indexOf(s)<i.indexOf(n)&&(o=-1),o}addLayoutRegions(){Object.entries(this.layoutRegions).forEach(([e,{el:t,contentWrap:i}])=>{const s=this.elementsCollection.where(l=>l.get("layoutRegion")===e),n=Backbone.Collection.extend({model:LiquidWidgetBaseModel}),o=new n(s),r=new LiquidBaseModel({childrenCollection:o,contentWrap:i,regionName:e}),a=new LiquidBaseView({model:r,contentWrap:i,el:t});o.comparator=this.childrenComparator.bind(this),r.view=a,this.layoutRegions[e]=this.layoutRegions[e]||{},this.layoutRegions[e].model=r})}buildElementsCollection(){(liquid?.elementsCollection?.length?liquid.elementsCollection:[...document.querySelectorAll(`${this.containersSelector}, ${this.widgetsSelector}`)]).forEach(t=>this.buildElementModelAndView(t)),liquid?.elementsCollection&&(liquid.elementsCollection=[])}buildElementModelAndView(e,{region:t,sort:i=!1}={}){if(e.hasAttribute("data-lqd-model-cid"))return;const s=e.classList.contains(this.containersClassname),n=t||this.getElRegion(e),o=[],r={},a=e.hasAttribute("data-lqd-has-inner-animatables"),l=new LiquidWidgetBaseModel({isContainer:s,layoutRegion:n,animatableElements:a?e.querySelectorAll("[data-lqd-inner-animatable-el]"):[e],dataId:e.getAttribute("data-id")}),h=new LiquidBaseView({model:l,el:e});l.view=h,e.setAttribute("data-lqd-model-cid",l.cid),e.setAttribute("data-lqd-view-cid",h.cid),this.elementsCollection.add(l,{sort:i});const g=this.layoutRegions[n]?.model?.get("childrenCollection");g&&g.add(l,{sort:i});let c=e.parentElement?.closest(`${this.containersSelector}, ${this.widgetsSelector}`);for(;c;)o.push(c),c=c?.parentElement?.closest(`${this.containersSelector}, ${this.widgetsSelector}`);const u=this.getModelsOfElements(o,{layoutRegion:n,sort:i});if(u.length){const m=Backbone.Collection.extend({model:LiquidWidgetBaseModel});r.parentsCollection=new m(u),r.topParentContainer=u.at(-1)}const p=[...e.querySelectorAll(`${this.containersSelector}, ${this.widgetsSelector}`)];if(p.length){const m=this.getModelsOfElements(p,{layoutRegion:n,sort:i}),f=Backbone.Collection.extend({model:LiquidWidgetBaseModel});r.childrenCollection=new f(m),r.isBoxed=e.classList.contains(this.containersBoxedClassname),r.childrenCollection.comparator=this.childrenComparator.bind(this)}return s&&!r.topParentContainer&&(r.isTopLevelContainer=!0),l.set(r),r.parentsCollection&&r.parentsCollection.forEach(m=>{const f=m.get("childrenCollection");f&&f.add(l,{sort:i})}),l}getElRegion(e){const t=_.omit(this.layoutRegions,"liquidPageContent");let i="liquidPageContent";return Object.entries(t).forEach(([s,{contentWrap:n}])=>{if(!(!n||typeof n=="string")&&n.contains(e))return i=s}),i}getModelsOfElements(e=[],{layoutRegion:t,sort:i=!1}={}){let s=[];return e?.length&&(s=e.map(n=>this.elementsCollection.findWhere(o=>o.cid===n.getAttribute("data-lqd-model-cid"))||this.buildElementModelAndView(n,{layoutRegion:t,sort:i})).filter(n=>n&&n.view)),s}addToElementsCollection(e,{layoutRegion:t="liquidPageContent"}={}){this.buildElementModelAndView(e,{layoutRegion:t,sort:!0})}removeFromElementsCollection(e){if(!e)return;const t=e.getAttribute("data-lqd-model-cid"),i=this.elementsCollection.get(t);if(!i)return;this.elementsCollection.remove(i);const s=i.get("layoutRegion");this.elementsCollection.find(n=>{const o=n.get("parentsCollection"),r=n.get("childrenCollection");o?.forEach(a=>a?.get("childrenCollection")?.remove(i)),r?.remove(i)}),this.layoutRegions[s].model.get("childrenCollection").remove(i),i.view.destroy()}addBehaviors(){const e=[];this.model.on("change:loadedBehaviors",(t,i)=>{if(!this.uninitializedBehaviors.length)return;const n=i.at(-1).behaviorName,o=this.uninitializedBehaviors.filter(({behavior:r})=>r.behaviorName===n);o.forEach(({model:r,behavior:a})=>this.addElementBehaviors({model:r,behaviorsArray:[a]})),this.uninitializedBehaviors=_.difference(this.uninitializedBehaviors,o)}),[...this.elementsCollection.models].reverse().forEach(t=>{const i=t.get("dataId"),s=t.view.el,n=window.liquid.behaviors?.filter(o=>{if(o.dataId&&i)return o.dataId===i;if(o.el)return o.el===s})?.flatMap(o=>o.behaviors);n?.length&&e.push({model:t,behaviorsArray:n})}),Object.entries(this.layoutRegions).forEach(([t,{behaviors:i,model:s}])=>{i&&e.push({model:s,behaviorsArray:[...i,...window.liquid?.behaviors?.filter(n=>n.layoutRegion&&n.layoutRegion===t)?.flatMap(n=>n.behaviors)||[]]})}),this.globalBehaviors.length&&e.push({model:this.model,behaviorsArray:this.globalBehaviors}),this.constructBehaviors(e),window.liquid.behaviors=[]}addElementBehaviors({el:e,dataId:t,model:i,behaviorsArray:s,layoutRegion:n}){if(!e&&!i&&!t&&!n||!s)return;let o=null;i?o=i:t?o=this.elementsCollection.find(r=>r.get("dataId")===t):e?o=this.elementsCollection.find(r=>r.view.el===e):n&&(o=this.layoutRegions[n]?.model),o&&(this.constructBehaviors([{model:o,behaviorsArray:s}]),this.initializeBehaviors())}constructBehaviors(e){[...e].sort((i,s)=>i.model.get("isContainer")-s.model.get("isContainer")).forEach(({model:i,behaviorsArray:s})=>{s.forEach(n=>{let{behaviorClass:o,behaviorName:r}=n;if(r&&!o&&(o=this.model.get("loadedBehaviors").find(g=>g.behaviorName===r)),!o||typeof o=="string")return this.uninitializedBehaviors.push({model:i,behavior:n});const a=o.initializeConditions;if(a?.length&&!a.every(g=>g))return;const l=new o(i.view,n?.options||{}),h=i.get("behaviors")||[];if(i.set({behaviors:[...h,l]}),l.willEmitInitializeTriggerEvents.length)return this.deferredBehaviorsQueue.set(i.cid,[...this.deferredBehaviorsQueue.get(i.cid)||[],l]);this.behaviorsInitializeQueue.push(l)})})}initializeBehaviors(){if(this.behaviorsInitializeQueue.forEach(e=>{e.initializeTriggers.size===0&&e.initialize()}),this.behaviorsInitializeQueue=[],this.deferredBehaviorsQueue.size!==0)for(const[e,t]of this.deferredBehaviorsQueue){const i=this.elementsCollection.get(e)?.get("behaviors"),s=i?.at(0)?.model?.cid;i?.length===1&&s===t?.at(0)?.model?.cid||(t.forEach(n=>n.initialize()),this.deferredBehaviorsQueue.delete(e))}}destroyElementBehaviors({el:e,model:t,dataId:i}={}){if(!(!e&&!t&&!i)){if(!e&&i&&(t=this.elementsCollection.find(s=>s.get("dataId")===i),e=t?.view?.el),e&&!t){const s=e.getAttribute("data-lqd-model-cid");t=this.elementsCollection.find(n=>n.cid===s)}t&&t.get("behaviors")?.forEach(s=>{s.destroy()})}}setActiveBreakpoint(){const e=liquid?.breakpoints;if(!e)return;const t=[{mm:window.matchMedia("(min-width: 1201px)"),breakpointKey:"desktop"}];Object.entries(e).forEach(([i,{direction:s,is_enabled:n,value:o}])=>{n&&t.push({mm:window.matchMedia(`(${s}-width: ${o}px)`),breakpointKey:i})}),this.activeBreakpoint=t.filter(({mm:i})=>i.matches)?.at(-1)?.breakpointKey||"desktop"}bindWindowResize(){window.addEventListener("resize",()=>{this.beforeWindowResize(),this.afterWindowResize()})}beforeWindowResize(){this.prevWindowSize=this.windowSize,this.trigger("before:windowResize",{prevSize:this.prevWindowSize,currentSize:this.windowSize})}afterWindowResize(){this.windowSize={width:window.innerWidth,height:window.innerHeight},this.setActiveBreakpoint(),this.fastdom.mutate(()=>{this.trigger("after:windowResize",{prevSize:this.prevWindowSize,currentSize:this.windowSize})})}destroy(){this.isStarted=!1,this.off(),this.stopListening(),this.layoutRegions={},this.elementsCollection=new ElementsCollection}}window.liquid={app:null,loadedBehaviors:[],behaviors:[],breakpoints:{mobile:{label:"Mobile",value:767,default_value:767,direction:"max",is_enabled:!0},tablet:{label:"Tablet",value:1024,default_value:1024,direction:"max",is_enabled:!0},laptop:{label:"Laptop",value:1366,default_value:1366,direction:"max",is_enabled:!1}},...window.liquid||{}};const liquidApp=new LiquidApp({layoutRegions:{liquidPageHeader:{el:"lqd-page-header-wrap",contentWrap:"lqd-page-header"},liquidPageContent:{el:"lqd-page-content-wrap",contentWrap:"lqd-page-content"},liquidPageFooter:{el:"lqd-page-footer-wrap",contentWrap:"lqd-page-footer"}},containersClassname:"e-con",containersBoxedClassname:"e-con-boxed",widgetsClassname:"elementor-widget"});window.liquid.app=liquidApp;
