<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WordPress editor or any Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$anubia_content = '';
$anubia_blog_archive_mask = '%%CONTENT%%';
$anubia_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $anubia_blog_archive_mask);
if ( have_posts() ) {
	the_post();
	if (($anubia_content = apply_filters('the_content', get_the_content())) != '') {
		if (($anubia_pos = strpos($anubia_content, $anubia_blog_archive_mask)) !== false) {
			$anubia_content = preg_replace('/(\<p\>\s*)?'.$anubia_blog_archive_mask.'(\s*\<\/p\>)/i', $anubia_blog_archive_subst, $anubia_content);
		} else
			$anubia_content .= $anubia_blog_archive_subst;
		$anubia_content = explode($anubia_blog_archive_mask, $anubia_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) anubia_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$anubia_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$anubia_args = anubia_query_add_posts_and_cats($anubia_args, '', anubia_get_theme_option('post_type'), anubia_get_theme_option('parent_cat'));
$anubia_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($anubia_page_number > 1) {
	$anubia_args['paged'] = $anubia_page_number;
	$anubia_args['ignore_sticky_posts'] = true;
}
$anubia_ppp = anubia_get_theme_option('posts_per_page');
if ((int) $anubia_ppp != 0)
	$anubia_args['posts_per_page'] = (int) $anubia_ppp;
// Make a new main query
$GLOBALS['wp_the_query']->query($anubia_args);


// Add internal query vars in the new query!
if (is_array($anubia_content) && count($anubia_content) == 2) {
	set_query_var('blog_archive_start', $anubia_content[0]);
	set_query_var('blog_archive_end', $anubia_content[1]);
}

get_template_part('index');
?>