<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_blog_style = explode('_', anubia_get_theme_option('blog_style'));
$anubia_columns = empty($anubia_blog_style[1]) ? 1 : max(1, $anubia_blog_style[1]);
$anubia_expanded = !anubia_sidebar_present() && anubia_is_on(anubia_get_theme_option('expand_content'));
$anubia_post_format = get_post_format();
$anubia_post_format = empty($anubia_post_format) ? 'standard' : str_replace('post-format-', '', $anubia_post_format);
$anubia_animation = anubia_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($anubia_columns).' post_format_'.esc_attr($anubia_post_format) ); ?>
	<?php echo (!anubia_is_off($anubia_animation) ? ' data-animation="'.esc_attr(anubia_get_animation_classes($anubia_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($anubia_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'" icon="'.esc_attr(anubia_get_post_icon()).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	anubia_show_post_featured( array(
											'class' => $anubia_columns == 1 ? 'anubia-full-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => anubia_get_thumb_size(
																	strpos(anubia_get_theme_option('body_style'), 'full')!==false
																		? ( $anubia_columns > 1 ? 'huge' : 'original' )
																		: (	$anubia_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('anubia_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('anubia_action_before_post_meta'); 

			// Post meta
			$anubia_components = anubia_array_get_keys_by_value(anubia_get_theme_option('meta_parts'));
			$anubia_counters = anubia_array_get_keys_by_value(anubia_get_theme_option('counters'));
			$anubia_post_meta = empty($anubia_components) 
										? '' 
										: anubia_show_post_meta(apply_filters('anubia_filter_post_meta_args', array(
												'components' => $anubia_components,
												'counters' => $anubia_counters,
												'seo' => false,
												'echo' => false
												), $anubia_blog_style[0], $anubia_columns)
											);
			anubia_show_layout($anubia_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$anubia_show_learn_more = !in_array($anubia_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($anubia_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($anubia_post_format == 'quote') {
					if (($quote = anubia_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						anubia_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($anubia_post_format, array('link', 'aside', 'status', 'quote'))) {
				anubia_show_layout($anubia_post_meta);
			}
			// More button
			if ( $anubia_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'anubia'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>