<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_blog_style = explode('_', anubia_get_theme_option('blog_style'));
$anubia_columns = empty($anubia_blog_style[1]) ? 2 : max(2, $anubia_blog_style[1]);
$anubia_expanded = !anubia_sidebar_present() && anubia_is_on(anubia_get_theme_option('expand_content'));
$anubia_post_format = get_post_format();
$anubia_post_format = empty($anubia_post_format) ? 'standard' : str_replace('post-format-', '', $anubia_post_format);
$anubia_animation = anubia_get_theme_option('blog_animation');
$anubia_components = anubia_array_get_keys_by_value(anubia_get_theme_option('meta_parts'));
$anubia_counters = anubia_array_get_keys_by_value(anubia_get_theme_option('counters'));

?><div class="<?php echo trim($anubia_blog_style[0]) == 'classic' ? 'column' : 'masonry_item masonry_item'; ?>-1_<?php echo esc_attr($anubia_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($anubia_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($anubia_columns)
					. ' post_layout_'.esc_attr($anubia_blog_style[0]) 
					. ' post_layout_'.esc_attr($anubia_blog_style[0]).'_'.esc_attr($anubia_columns)
					); ?>
	<?php echo (!anubia_is_off($anubia_animation) ? ' data-animation="'.esc_attr(anubia_get_animation_classes($anubia_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	anubia_show_post_featured( array( 'thumb_size' => anubia_get_thumb_size($anubia_blog_style[0] == 'classic'
													? (strpos(anubia_get_theme_option('body_style'), 'full')!==false 
															? ( $anubia_columns > 2 ? 'big' : 'huge' )
															: (	$anubia_columns > 2
																? ($anubia_expanded ? 'med' : 'small')
																: ($anubia_expanded ? 'big' : 'med')
																)
														)
													: (strpos(anubia_get_theme_option('body_style'), 'full')!==false 
															? ( $anubia_columns > 2 ? 'masonry-big' : 'full' )
															: (	$anubia_columns <= 2 && $anubia_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );

	if ( !in_array($anubia_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('anubia_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('anubia_action_before_post_meta'); 

			// Post meta
			if (!empty($anubia_components))
				anubia_show_post_meta(apply_filters('anubia_filter_post_meta_args', array(
					'components' => $anubia_components,
					'counters' => $anubia_counters,
					'seo' => false
					), $anubia_blog_style[0], $anubia_columns)
				);

			do_action('anubia_action_after_post_meta'); 
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$anubia_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($anubia_post_format, array('link', 'aside', 'status'))) {
				the_content();
			} else if ($anubia_post_format == 'quote') {
				if (($quote = anubia_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
					anubia_show_layout(wpautop($quote));
				else
					the_excerpt();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($anubia_post_format, array('link', 'aside', 'status', 'quote'))) {
			if (!empty($anubia_components))
				anubia_show_post_meta(apply_filters('anubia_filter_post_meta_args', array(
					'components' => $anubia_components,
					'counters' => $anubia_counters
					), $anubia_blog_style[0], $anubia_columns)
				);
		}
		// More button
		if ( $anubia_show_learn_more ) {
			?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'anubia'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>