<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_post_format = get_post_format();
$anubia_post_format = empty($anubia_post_format) ? 'standard' : str_replace('post-format-', '', $anubia_post_format);
$anubia_animation = anubia_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($anubia_post_format) ); ?>
	<?php echo (!anubia_is_off($anubia_animation) ? ' data-animation="'.esc_attr(anubia_get_animation_classes($anubia_animation)).'"' : ''); ?>
	><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	anubia_show_post_featured(array( 'thumb_size' => anubia_get_thumb_size( strpos(anubia_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));

	// Title and post meta
		?>
		<div class="post_header entry-header">
			<?php
            do_action('anubia_action_before_post_meta');

            // Post meta
            $anubia_components = anubia_array_get_keys_by_value(anubia_get_theme_option('meta_parts'));
            $anubia_counters = anubia_array_get_keys_by_value(anubia_get_theme_option('counters'));

            if (!empty($anubia_components))
                anubia_show_post_meta(apply_filters('anubia_filter_post_meta_args', array(
                        'components' => $anubia_components,
                        'counters' => $anubia_counters,
                        'seo' => false
                    ), 'excerpt', 1)
                );

			do_action('anubia_action_before_post_title');

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			?>
		</div><!-- .post_header --><?php

	
	// Post content
	?><div class="post_content entry-content"><?php
		if (anubia_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'anubia' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'anubia' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$anubia_show_learn_more = !in_array($anubia_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($anubia_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($anubia_post_format == 'quote') {
					if (($quote = anubia_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						anubia_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
		}
	?></div><!-- .entry-content -->
</article>