<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_blog_style = explode('_', anubia_get_theme_option('blog_style'));
$anubia_columns = empty($anubia_blog_style[1]) ? 2 : max(2, $anubia_blog_style[1]);
$anubia_post_format = get_post_format();
$anubia_post_format = empty($anubia_post_format) ? 'standard' : str_replace('post-format-', '', $anubia_post_format);
$anubia_animation = anubia_get_theme_option('blog_animation');
$anubia_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($anubia_columns).' post_format_'.esc_attr($anubia_post_format) ); ?>
	<?php echo (!anubia_is_off($anubia_animation) ? ' data-animation="'.esc_attr(anubia_get_animation_classes($anubia_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($anubia_image[1]) && !empty($anubia_image[2])) echo intval($anubia_image[1]) .'x' . intval($anubia_image[2]); ?>"
	data-src="<?php if (!empty($anubia_image[0])) echo esc_url($anubia_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$anubia_image_hover = 'icon';
	if (in_array($anubia_image_hover, array('icons', 'zoom'))) $anubia_image_hover = 'dots';
	$anubia_components = anubia_array_get_keys_by_value(anubia_get_theme_option('meta_parts'));
	$anubia_counters = anubia_array_get_keys_by_value(anubia_get_theme_option('counters'));
	anubia_show_post_featured(array(
		'hover' => $anubia_image_hover,
		'thumb_size' => anubia_get_thumb_size( strpos(anubia_get_theme_option('body_style'), 'full')!==false || $anubia_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. (!empty($anubia_components)
										? anubia_show_post_meta(apply_filters('anubia_filter_post_meta_args', array(
											'components' => $anubia_components,
											'counters' => $anubia_counters,
											'seo' => false,
											'echo' => false
											), $anubia_blog_style[0], $anubia_columns))
										: '')
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'anubia') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>