<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_blog_style = explode('_', anubia_get_theme_option('blog_style'));
$anubia_columns = empty($anubia_blog_style[1]) ? 2 : max(2, $anubia_blog_style[1]);
$anubia_post_format = get_post_format();
$anubia_post_format = empty($anubia_post_format) ? 'standard' : str_replace('post-format-', '', $anubia_post_format);
$anubia_animation = anubia_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($anubia_columns).' post_format_'.esc_attr($anubia_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!anubia_is_off($anubia_animation) ? ' data-animation="'.esc_attr(anubia_get_animation_classes($anubia_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$anubia_image_hover = anubia_get_theme_option('image_hover');
	// Featured image
	anubia_show_post_featured(array(
		'thumb_size' => anubia_get_thumb_size(strpos(anubia_get_theme_option('body_style'), 'full')!==false || $anubia_columns < 3 
								? 'masonry-big' 
								: 'masonry'),
		'show_no_image' => true,
		'class' => $anubia_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $anubia_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>