<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$anubia_post_format = get_post_format();
$anubia_post_format = empty($anubia_post_format) ? 'standard' : str_replace('post-format-', '', $anubia_post_format);
$anubia_animation = anubia_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($anubia_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($anubia_post_format) ); ?>
	<?php echo (!anubia_is_off($anubia_animation) ? ' data-animation="'.esc_attr(anubia_get_animation_classes($anubia_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	anubia_show_post_featured(array(
		'thumb_size' => anubia_get_thumb_size($anubia_columns==1 ? 'big' : ($anubia_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($anubia_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			anubia_show_post_meta(apply_filters('anubia_filter_post_meta_args', array(), 'sticky', $anubia_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>