<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('anubia_storage_get')) {
	function anubia_storage_get($var_name, $default='') {
		global $ANUBIA_STORAGE;
		return isset($ANUBIA_STORAGE[$var_name]) ? $ANUBIA_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('anubia_storage_set')) {
	function anubia_storage_set($var_name, $value) {
		global $ANUBIA_STORAGE;
		$ANUBIA_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('anubia_storage_empty')) {
	function anubia_storage_empty($var_name, $key='', $key2='') {
		global $ANUBIA_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($ANUBIA_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($ANUBIA_STORAGE[$var_name][$key]);
		else
			return empty($ANUBIA_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('anubia_storage_isset')) {
	function anubia_storage_isset($var_name, $key='', $key2='') {
		global $ANUBIA_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($ANUBIA_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($ANUBIA_STORAGE[$var_name][$key]);
		else
			return isset($ANUBIA_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('anubia_storage_inc')) {
	function anubia_storage_inc($var_name, $value=1) {
		global $ANUBIA_STORAGE;
		if (empty($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = 0;
		$ANUBIA_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('anubia_storage_concat')) {
	function anubia_storage_concat($var_name, $value) {
		global $ANUBIA_STORAGE;
		if (empty($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = '';
		$ANUBIA_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('anubia_storage_get_array')) {
	function anubia_storage_get_array($var_name, $key, $key2='', $default='') {
		global $ANUBIA_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($ANUBIA_STORAGE[$var_name][$key]) ? $ANUBIA_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($ANUBIA_STORAGE[$var_name][$key][$key2]) ? $ANUBIA_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('anubia_storage_set_array')) {
	function anubia_storage_set_array($var_name, $key, $value) {
		global $ANUBIA_STORAGE;
		if (!isset($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = array();
		if ($key==='')
			$ANUBIA_STORAGE[$var_name][] = $value;
		else
			$ANUBIA_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('anubia_storage_set_array2')) {
	function anubia_storage_set_array2($var_name, $key, $key2, $value) {
		global $ANUBIA_STORAGE;
		if (!isset($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = array();
		if (!isset($ANUBIA_STORAGE[$var_name][$key])) $ANUBIA_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$ANUBIA_STORAGE[$var_name][$key][] = $value;
		else
			$ANUBIA_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('anubia_storage_merge_array')) {
	function anubia_storage_merge_array($var_name, $key, $value) {
		global $ANUBIA_STORAGE;
		if (!isset($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = array();
		if ($key==='')
			$ANUBIA_STORAGE[$var_name] = array_merge($ANUBIA_STORAGE[$var_name], $value);
		else
			$ANUBIA_STORAGE[$var_name][$key] = array_merge($ANUBIA_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('anubia_storage_set_array_after')) {
	function anubia_storage_set_array_after($var_name, $after, $key, $value='') {
		global $ANUBIA_STORAGE;
		if (!isset($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = array();
		if (is_array($key))
			anubia_array_insert_after($ANUBIA_STORAGE[$var_name], $after, $key);
		else
			anubia_array_insert_after($ANUBIA_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('anubia_storage_set_array_before')) {
	function anubia_storage_set_array_before($var_name, $before, $key, $value='') {
		global $ANUBIA_STORAGE;
		if (!isset($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = array();
		if (is_array($key))
			anubia_array_insert_before($ANUBIA_STORAGE[$var_name], $before, $key);
		else
			anubia_array_insert_before($ANUBIA_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('anubia_storage_push_array')) {
	function anubia_storage_push_array($var_name, $key, $value) {
		global $ANUBIA_STORAGE;
		if (!isset($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($ANUBIA_STORAGE[$var_name], $value);
		else {
			if (!isset($ANUBIA_STORAGE[$var_name][$key])) $ANUBIA_STORAGE[$var_name][$key] = array();
			array_push($ANUBIA_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('anubia_storage_pop_array')) {
	function anubia_storage_pop_array($var_name, $key='', $defa='') {
		global $ANUBIA_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($ANUBIA_STORAGE[$var_name]) && is_array($ANUBIA_STORAGE[$var_name]) && count($ANUBIA_STORAGE[$var_name]) > 0) 
				$rez = array_pop($ANUBIA_STORAGE[$var_name]);
		} else {
			if (isset($ANUBIA_STORAGE[$var_name][$key]) && is_array($ANUBIA_STORAGE[$var_name][$key]) && count($ANUBIA_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($ANUBIA_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('anubia_storage_inc_array')) {
	function anubia_storage_inc_array($var_name, $key, $value=1) {
		global $ANUBIA_STORAGE;
		if (!isset($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = array();
		if (empty($ANUBIA_STORAGE[$var_name][$key])) $ANUBIA_STORAGE[$var_name][$key] = 0;
		$ANUBIA_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('anubia_storage_concat_array')) {
	function anubia_storage_concat_array($var_name, $key, $value) {
		global $ANUBIA_STORAGE;
		if (!isset($ANUBIA_STORAGE[$var_name])) $ANUBIA_STORAGE[$var_name] = array();
		if (empty($ANUBIA_STORAGE[$var_name][$key])) $ANUBIA_STORAGE[$var_name][$key] = '';
		$ANUBIA_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('anubia_storage_call_obj_method')) {
	function anubia_storage_call_obj_method($var_name, $method, $param=null) {
		global $ANUBIA_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($ANUBIA_STORAGE[$var_name]) ? $ANUBIA_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($ANUBIA_STORAGE[$var_name]) ? $ANUBIA_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('anubia_storage_get_obj_property')) {
	function anubia_storage_get_obj_property($var_name, $prop, $default='') {
		global $ANUBIA_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($ANUBIA_STORAGE[$var_name]->$prop) ? $ANUBIA_STORAGE[$var_name]->$prop : $default;
	}
}
?>