<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

anubia_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	anubia_show_layout(get_query_var('blog_archive_start'));

	$anubia_classes = 'posts_container '
						. (substr(anubia_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap columns_padding_bottom' : 'masonry_wrap');
	$anubia_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$anubia_sticky_out = anubia_get_theme_option('sticky_style')=='columns' 
							&& is_array($anubia_stickies) && count($anubia_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($anubia_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$anubia_sticky_out) {
		if (anubia_get_theme_option('first_post_large') && !is_paged() && !in_array(anubia_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($anubia_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($anubia_sticky_out && !is_sticky()) {
			$anubia_sticky_out = false;
			?></div><div class="<?php echo esc_attr($anubia_classes); ?>"><?php
		}
		get_template_part( 'content', $anubia_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	anubia_show_pagination();

	anubia_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>