<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

anubia_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	anubia_show_layout(get_query_var('blog_archive_start'));

	$anubia_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$anubia_sticky_out = anubia_get_theme_option('sticky_style')=='columns' 
							&& is_array($anubia_stickies) && count($anubia_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$anubia_cat = anubia_get_theme_option('parent_cat');
	$anubia_post_type = anubia_get_theme_option('post_type');
	$anubia_taxonomy = anubia_get_post_type_taxonomy($anubia_post_type);
	$anubia_show_filters = anubia_get_theme_option('show_filters');
	$anubia_tabs = array();
	if (!anubia_is_off($anubia_show_filters)) {
		$anubia_args = array(
			'type'			=> $anubia_post_type,
			'child_of'		=> $anubia_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $anubia_taxonomy,
			'pad_counts'	=> false
		);
		$anubia_portfolio_list = get_terms($anubia_args);
		if (is_array($anubia_portfolio_list) && count($anubia_portfolio_list) > 0) {
			$anubia_tabs[$anubia_cat] = esc_html__('All', 'anubia');
			foreach ($anubia_portfolio_list as $anubia_term) {
				if (isset($anubia_term->term_id)) $anubia_tabs[$anubia_term->term_id] = $anubia_term->name;
			}
		}
	}
	if (count($anubia_tabs) > 0) {
		$anubia_portfolio_filters_ajax = true;
		$anubia_portfolio_filters_active = $anubia_cat;
		$anubia_portfolio_filters_id = 'portfolio_filters';
		?>
		<div class="portfolio_filters anubia_tabs anubia_tabs_ajax">
			<ul class="portfolio_titles anubia_tabs_titles">
				<?php
				foreach ($anubia_tabs as $anubia_id=>$anubia_title) {
					?><li><a href="<?php echo esc_url(anubia_get_hash_link(sprintf('#%s_%s_content', $anubia_portfolio_filters_id, $anubia_id))); ?>" data-tab="<?php echo esc_attr($anubia_id); ?>"><?php echo esc_html($anubia_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$anubia_ppp = anubia_get_theme_option('posts_per_page');
			if (anubia_is_inherit($anubia_ppp)) $anubia_ppp = '';
			foreach ($anubia_tabs as $anubia_id=>$anubia_title) {
				$anubia_portfolio_need_content = $anubia_id==$anubia_portfolio_filters_active || !$anubia_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $anubia_portfolio_filters_id, $anubia_id)); ?>"
					class="portfolio_content anubia_tabs_content"
					data-blog-template="<?php echo esc_attr(anubia_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(anubia_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($anubia_ppp); ?>"
					data-post-type="<?php echo esc_attr($anubia_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($anubia_taxonomy); ?>"
					data-cat="<?php echo esc_attr($anubia_id); ?>"
					data-parent-cat="<?php echo esc_attr($anubia_cat); ?>"
					data-need-content="<?php echo (false===$anubia_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($anubia_portfolio_need_content) 
						anubia_show_portfolio_posts(array(
							'cat' => $anubia_id,
							'parent_cat' => $anubia_cat,
							'taxonomy' => $anubia_taxonomy,
							'post_type' => $anubia_post_type,
							'page' => 1,
							'sticky' => $anubia_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		anubia_show_portfolio_posts(array(
			'cat' => $anubia_cat,
			'parent_cat' => $anubia_cat,
			'taxonomy' => $anubia_taxonomy,
			'post_type' => $anubia_post_type,
			'page' => 1,
			'sticky' => $anubia_sticky_out
			)
		);
	}

	anubia_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>