<?php
/* Elegro Crypto Payment support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'anubia_elegro_payment_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'anubia_elegro_payment_theme_setup9', 9 );
	function anubia_elegro_payment_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'anubia_filter_tgmpa_required_plugins', 'anubia_elegro_payment_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'anubia_elegro_payment_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('anubia_filter_tgmpa_required_plugins',	'anubia_elegro_payment_tgmpa_required_plugins');
	function anubia_elegro_payment_tgmpa_required_plugins($list=array()) {
		if (anubia_storage_isset('required_plugins', 'elegro-payment')) {
			$list[] = array(
				'name' 		=> anubia_storage_get_array('required_plugins', 'elegro-payment'),
				'slug' 		=> 'elegro-payment',
				'required' 	=> false
			);
		}
		return $list;
	}
}


// Check if this plugin installed and activated
if ( ! function_exists( 'anubia_exists_elegro_payment' ) ) {
	function anubia_exists_elegro_payment() {
		return class_exists( 'WC_Elegro_Payment' );
	}
}
?>