<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( !function_exists( 'anubia_tribe_events_get_css' ) ) {
	add_filter( 'anubia_filter_get_css', 'anubia_tribe_events_get_css', 10, 4 );
	function anubia_tribe_events_get_css($css, $colors, $fonts, $scheme='') {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS
			
.tribe-events-list .tribe-events-list-event-title,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-h6--min-medium,
.tribe-common .tribe-common-h1, .tribe-common .tribe-common-h2,
.tribe-common .tribe-common-h3, .tribe-common .tribe-common-h4,
.tribe-common .tribe-common-h5, .tribe-common .tribe-common-h6,
.tribe-common .tribe-common-h7, .tribe-common .tribe-common-h8  {
	{$fonts['h3_font-family']}
}

#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
#tribe-bar-form button, #tribe-bar-form a,
.tribe-events-read-more {
	{$fonts['button_font-family']}
	{$fonts['button_letter-spacing']}
}
.tribe-events-list .tribe-events-list-separator-month,
.tribe-events-calendar thead th,
.tribe-events-schedule, .tribe-events-schedule h2{
	{$fonts['h5_font-family']}
}
.tribe-events-content,
#tribe-bar-form input, #tribe-events-content.tribe-events-month,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-mobile-container .type-tribe_events,
.tribe-events-list-widget ol li .tribe-event-title,
.tribe-events .datepicker .datepicker-switch,
.tribe-events .datepicker .day, .tribe-events .datepicker .dow,
.tribe-common .tribe-common-b1,
.tribe-common .tribe-common-b2,
.tribe-common .tribe-common-h3 .tribe-events-c-top-bar__datepicker-desktop,
.tribe-events .tribe-events-c-view-selector__list-item-text,
.tribe-common .tribe-common-c-btn, .tribe-common a.tribe-common-c-btn,
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-common .tribe-common-c-btn-border, .tribe-common a.tribe-common-c-btn-border,
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small,
.tribe-events .tribe-events-calendar-month__calendar-event-datetime,
.tribe-common.tribe-events .tribe-events-calendar-month__header-column-title,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-form-control-text__input, .tribe-common .tribe-common-form-control-text__input {
	{$fonts['p_font-family']}
}
.tribe-events-loop .tribe-event-schedule-details,
.single-tribe_events #tribe-events-content .tribe-events-event-meta dt,
#tribe-mobile-container .type-tribe_events .tribe-event-date-start {
	{$fonts['info_font-family']};
}

CSS;

			
			$rad = anubia_get_border_radius();
			$css['fonts'] .= <<<CSS

#tribe-bar-form .tribe-bar-submit input[type="submit"],
#tribe-bar-form button,
#tribe-bar-form a,
#tribe-events .tribe-events-button,
#tribe-bar-views .tribe-bar-views-list,
.tribe-events-button,
.tribe-events-cal-links a,
#tribe-events-footer ~ a.tribe-events-ical.tribe-events-button,
.tribe-events-sub-nav li a {
	-webkit-border-radius: {$rad};
	    -ms-border-radius: {$rad};
			border-radius: {$rad};
}

CSS;
		}


		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Filters bar */
#tribe-bar-form {
	color: {$colors['text_dark']};
}
#tribe-bar-form input[type="text"] {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
.tribe-bar-views-list {
	background-color: {$colors['text_link']};
}

.datepicker thead tr:first-child th:hover, .datepicker tfoot tr th:hover {
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}

.tribe-common a {
	color: {$colors['text_dark']};
}

.tribe-events-event-meta a, 
.tribe-events-event-meta a:visited{
	color: {$colors['text_link']};
}

.tribe-events-event-meta a:focus, 
.tribe-events-event-meta a:hover,
.tribe-common .tribe-common-anchor-thin-alt:active, 
.tribe-common .tribe-common-anchor-thin-alt:focus, 
.tribe-common .tribe-common-anchor-thin-alt:hover,
.tribe-common a:active, 
.tribe-common a:focus{
	color: {$colors['text_hover']};
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-view-selector--tabs .tribe-events-c-view-selector__list-item--active .tribe-events-c-view-selector__list-item-link:after {
	background: {$colors['text_hover']};
}
button.tribe-events-c-top-bar__datepicker-button,
button.tribe-events-c-top-bar__datepicker-button:hover {
	background: transparent!important;
	color: {$colors['text_dark']}!important;
}
.tribe-common .tribe-events-c-top-bar__datepicker-time .tribe-common-h3 {
	color: {$colors['text_dark']};
}
.tribe-common  .tribe-common-h3.tribe-events-c-top-bar__datepicker-button:hover,
.tribe-common  .tribe-common-h3.tribe-events-c-top-bar__datepicker-button:focus {
	background-color: {$colors['text_hover']};
}

.tribe-common .tribe-events-c-view-selector__list-item a:hover span,
.tribe-common .tribe-events-c-view-selector__list-item--active a span {
	color: {$colors['text_hover']};
}

.tribe-common button[disabled] {
	background-color: transparent !important;
}

.tribe-common .tribe-common-c-btn, 
.tribe-common a.tribe-common-c-btn {
	background-color: {$colors['text_dark']};
}

.tribe-events .tribe-events-c-search__button:focus, 
.tribe-events .tribe-events-c-search__button:hover, 
.tribe-events button.tribe-events-c-search__button:focus, 
.tribe-events button.tribe-events-c-search__button:hover,
.tribe-events .tribe-events-c-search__button:active, 
.tribe-events button.tribe-events-c-search__button:active,
.tribe-common .tribe-common-c-btn:hover, 
.tribe-common a.tribe-common-c-btn:hover {
	background-color: {$colors['text_link']};
}

input.tribe-common-form-control-text__input,
input.tribe-common-form-control-text__input:focus,
input.tribe-common-form-control-text__input.filled {
  	background-color: transparent;
}

.tribe-events .tribe-events-c-ical__link,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next, 
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:after, 
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:before {
	color: {$colors['bg_color']} !important;
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next, 
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev,
.tribe-events .tribe-events-c-ical__link  {
	background-color: {$colors['text_dark']} !important;	
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:hover, 
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:hover,
.tribe-events .tribe-events-c-ical__link:hover  {
	background-color: {$colors['text_link']} !important;
}

.tribe-common .tribe-common-c-btn-border, .tribe-common a.tribe-common-c-btn-border,
.tribe-common .tribe-common-c-btn-border-small, .tribe-common a.tribe-common-c-btn-border-small {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']} ;
}

.tribe-common .tribe-common-c-btn-border:focus, .tribe-common .tribe-common-c-btn-border:hover, 
.tribe-common a.tribe-common-c-btn-border:focus, .tribe-common a.tribe-common-c-btn-border:hover,
.tribe-common .tribe-common-c-btn-border-small:focus, .tribe-common a.tribe-common-c-btn-border-small:hover {
	color: {$colors['text_hover']};
	border-color: {$colors['text_hover']} ;
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__day:hover:after {
	background-color: {$colors['text_hover']};
}

.tribe-common .tribe-common-anchor-alt {
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}
.tribe-common .tribe-common-anchor-alt:hover {
	color: {$colors['text_hover']};
	border-color: {$colors['text_hover']};
}
.tribe-events .tribe-events-c-events-bar__search-button, 
.tribe-events .tribe-events-c-view-selector__button { 
	background: transparent !important;
}

.tribe-common .tribe-common-svgicon--list:before,
.tribe-events .tribe-events-c-events-bar__search-button-icon:before {
	color: {$colors['text_dark']};
}

.tribe-common .tribe-common-svgicon--list:hover:before,
.tribe-events .tribe-events-c-events-bar__search-button-icon:hover:before {
	color: {$colors['text_hover']};
}

.tribe-events .tribe-events-c-events-bar__search-button:before,
.tribe-events .tribe-events-c-view-selector__button:before {
	background-color: {$colors['text_hover']};
}

button.tribe-events-calendar-month__day-cell {
	background-color: transparent;
}

.tribe-events .tribe-events-calendar-month__day-cell--mobile:focus, 
.tribe-events .tribe-events-calendar-month__day-cell--mobile:hover {
	background-color: {$colors['text_hover']};
}

.tribe-events .tribe-events-calendar-month__day-cell--mobile:focus .tribe-events-calendar-month__day-date-daynum, 
.tribe-events .tribe-events-calendar-month__day-cell--mobile:hover .tribe-events-calendar-month__day-date-daynum {
	color: {$colors['bg_color']};
}

.tribe-events .tribe-events-calendar-month__mobile-events-icon--event {
	background-color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-month__day-cell--mobile:focus .tribe-events-calendar-month__mobile-events-icon--event, 
.tribe-events .tribe-events-calendar-month__day-cell--mobile:hover .tribe-events-calendar-month__mobile-events-icon--event {
	background-color: {$colors['bg_color']};
}

.tribe-common .tribe-common-c-loader .tribe-common-c-loader__dot {
	background-color: {$colors['text_link']};
}


.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:after,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:before,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-search__button:after,
.tribe-events .tribe-events-c-ical__link:after  {
	background-color: {$colors['text_link']};
}

.tribe-common--breakpoint-medium.tribe-common .tribe-common-h3 {
	color: {$colors['bg_color']};
	background-color: {$colors['text_link']};	
}
.tribe-common--breakpoint-medium.tribe-common .tribe-common-h3:hover {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};	
}

.tribe-common .tribe-events-c-top-bar__nav-list .tribe-common-c-btn-icon:before,
.tribe-common .tribe-events-c-top-bar__nav-list .tribe-common-c-btn-icon:after{
		color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};	
}

.tribe-common .tribe-events-c-top-bar__nav-list .tribe-common-c-btn-icon:hover:before,
.tribe-common .tribe-events-c-top-bar__nav-list .tribe-common-c-btn-icon:hover:after{
	color: {$colors['bg_color']};
	background-color: {$colors['text_hover']};	
}

.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner {
	color: {$colors['bg_color']};
	background-color: {$colors['text_link_02']};	
}

.tribe-events .datepicker .datepicker-switch, .tribe-events .datepicker .dow {
	color: {$colors['bg_color']};
}

.tribe-events .datepicker .datepicker-switch:focus, .tribe-events .datepicker .datepicker-switch:hover,
.tribe-events .datepicker .datepicker-switch:active, .tribe-events .datepicker .datepicker-switch:focus, 
.tribe-events .datepicker .datepicker-switch:hover, .tribe-events .datepicker .next:active, .tribe-events .datepicker .next:focus, 
.tribe-events .datepicker .next:hover, .tribe-events .datepicker .prev:active, .tribe-events .datepicker .prev:focus, .tribe-events .datepicker .prev:hover {
	background-color: {$colors['text_link']};	
}

.tribe-events .datepicker .day.current, .tribe-events .datepicker .day.current.focused, 
.tribe-events .datepicker .day.current:focus, .tribe-events .datepicker .day.current:hover, 
.tribe-events .datepicker .month.current, .tribe-events .datepicker .month.current.focused, 
.tribe-events .datepicker .month.current:focus, .tribe-events .datepicker .month.current:hover, 
.tribe-events .datepicker .year.current, .tribe-events .datepicker .year.current.focused, 
.tribe-events .datepicker .year.current:focus, .tribe-events .datepicker .year.current:hover {
	background-color: {$colors['input_bg_color']};
}


.tribe-events .datepicker .day.active, .tribe-events .datepicker .day.active.focused, 
.tribe-events .datepicker .day.active:focus, .tribe-events .datepicker .day.active:hover, 
.tribe-events .datepicker .month.active, .tribe-events .datepicker .month.active.focused, 
.tribe-events .datepicker .month.active:focus, .tribe-events .datepicker .month.active:hover, 
.tribe-events .datepicker .year.active, .tribe-events .datepicker .year.active.focused, .tribe-events .datepicker .year.active:focus, 
.tribe-events .datepicker .year.active:hover {
	background-color: {$colors['text_link']};	
}

.tribe-events .datepicker .day.focused, .tribe-events .datepicker .day:focus, 
.tribe-events .datepicker .day:hover, .tribe-events .datepicker .month.focused, 
.tribe-events .datepicker .month:focus, .tribe-events .datepicker .month:hover, 
.tribe-events .datepicker .year.focused, .tribe-events .datepicker .year:focus, 
.tribe-events .datepicker .year:hover {
	background-color: {$colors['text_hover']};	
}



/* Content */
.tribe-events-calendar thead th {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']} !important;
	border-color: {$colors['text_dark']} !important;
}
.tribe-events-calendar thead th + th:before {
	background: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-calendar td {
	border-color: {$colors['bd_color']} !important;
}
.tribe-events-calendar td div[id*="tribe-events-daynum-"],
.tribe-events-calendar td div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_dark']};
}
.tribe-events-calendar td.tribe-events-othermonth {
	color: {$colors['alter_light']};
	background: {$colors['alter_bg_color']} !important;
}
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"] > a {
	color: {$colors['alter_light']};
}
.tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"], .tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_light']};
}
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_link']};
}
.tribe-events-calendar td.tribe-events-present:before {
	border-color: {$colors['text_link']};
}
.tribe-events-calendar .tribe-events-has-events:after {
	background-color: {$colors['text']};
}
.tribe-events-calendar .mobile-active.tribe-events-has-events:after {
	background-color: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active,
#tribe-events-content .tribe-events-calendar td.mobile-active:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active div[id*="tribe-events-daynum-"] {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar td.tribe-events-othermonth.mobile-active div[id*="tribe-events-daynum-"] a,
.tribe-events-calendar .mobile-active div[id*="tribe-events-daynum-"] a {
	background-color: transparent;
	color: {$colors['bg_color']};
}
.tribe-common .tribe-events-calendar-list__event-date-tag-daynum,
.tribe-common--breakpoint-medium.tribe-common .tribe-common-h6--min-medium{
	color: {$colors['text_link']};
}

.tribe-common .tribe-events-calendar-month__day-date,
.tribe-common .tribe-events-calendar-month__day-date a{
	color: {$colors['text_dark']};
}

.tribe-common .tribe-events-calendar-month__day-date a.tribe-events-calendar-month__day-date-link:hover{
	color: {$colors['text_hover']};
}


/* Tooltip */
.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip,
.tribe-events-tooltip .tribe-events-arrow {
	color: {$colors['alter_text']};
	background: {$colors['alter_bg_color']};
}
#tribe-events-content .tribe-events-tooltip h4 { 
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}
.tribe-events-tooltip .tribe-event-duration {
	color: {$colors['text_light']};
}

/* Events list */
.tribe-events-list-separator-month {
	color: {$colors['text_dark']};
}
.tribe-events-list-separator-month:after {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .type-tribe_events + .type-tribe_events,
.tribe-events-day .tribe-events-day-time-slot + .tribe-events-day-time-slot + .tribe-events-day-time-slot {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .tribe-events-event-cost span {
	color: {$colors['bg_color']};
	border-color: {$colors['text_dark']};
	background: {$colors['text_dark']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a {
	color: {$colors['alter_link']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a:hover {
	color: {$colors['alter_hover']};
}
.tribe-mobile .tribe-events-list .tribe-events-venue-details {
	border-color: {$colors['alter_bd_color']};
}

/* Events day */
.tribe-events-day .tribe-events-day-time-slot h5 {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']};
}

/* Single Event */
.single-tribe_events .tribe-events-venue-map {
	color: {$colors['alter_text']};
}
.single-tribe_events .tribe-events-schedule .tribe-events-cost {
	color: {$colors['text_dark']};
}
.single-tribe_events .type-tribe_events {
	border-color: {$colors['bd_color']};
}

.tribe-events-content{
     color: {$colors['text']};
}

.tribe-events-single .tribe-events-sub-nav li a,
.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-next a:focus,
.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-next a:hover,
.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-previous a:focus, 
.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-previous a:hover{
    color: {$colors['extra_dark']};
}

.tribe-events .datepicker .day,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link,
.tribe-events .tribe-events-calendar-day__event-title-link,
.tribe-events .tribe-events-calendar-list__event-title-link{
	color: {$colors['text_dark']};
}

.tribe-events .datepicker .past{
	color: {$colors['text_light']};
}
.tribe-events .datepicker .past.focused {
	color: {$colors['inverse_link']};
}

.tribe-events .datepicker .day.active{
	color: {$colors['extra_text']};
}

.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link:hover,
.tribe-events .tribe-events-calendar-day__event-title-link:hover,
.tribe-events .tribe-events-calendar-list__event-title-link:hover {
	color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-events .tribe-events-calendar-day__event-datetime,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-day__event-venue,
.tribe-events .tribe-events-calendar-list__event-datetime,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-venue{
	color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-description{
	color: {$colors['text']};
}

.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}

.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button.tribe-events-c-subscribe-dropdown__button--active, 
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:focus, 
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:focus-within, 
.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__header-column-title,
.tribe-common.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-datetime{
    color: {$colors['text']};
}

.tribe-common .tribe-common-c-loader__dot circle {
	fill: {$colors['text_link']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__day {
	background-color: {$colors['bg_color']};
}

CSS;
		}
		
		return $css;
	}
}
?>