<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('anubia_trx_addons_get_mycss')) {
	add_filter('anubia_filter_get_css', 'anubia_trx_addons_get_mycss', 10, 4);
	function anubia_trx_addons_get_mycss($css, $colors, $fonts, $scheme='') {

        if (isset($css['fonts']) && $fonts) {
            $css['fonts'] .= <<<CSS
            .sc_price_item_price,
            .body_wrap .page_wrap .BigWhiteText,
            .sc_blogger .sc_blogger_item .sc_blogger_item_title,
            .sc_dishes_float .sc_dishes_item_title .sc_dishes_item_price,
            .sc_testimonials_item_content,
            .sc_skills_counter .sc_skills_total,
            .sc_skills_pie.sc_skills_compact_off .sc_skills_total,
            .sidebar[class*="scheme_"] .widget.widget_block h2,
            .sidebar[class*="scheme_"] .widget .widget_title {
                {$fonts['h1_font-family']}
            }
            .body_wrap .page_wrap .SliderButton,
            .body_wrap .page_wrap .SmallWhiteText,
            .sc_icons_item_title,
            .esg-filters div.esg-navigationbutton,
            .woocommerce nav.woocommerce-pagination ul li a,
            .woocommerce nav.woocommerce-pagination ul li span.current,
            .page_links > span:not(.page_links_title),
            .page_links > a,
            .comments_pagination .page-numbers,
            .nav-links .page-numbers,
            .comments_wrap .comments_form_title,
            .comments_list_wrap .comments_list_title,
            .sc_testimonials_item_author_title,
            .sc_price_item_title,
            .footer_wrap .widget.widget_block h2,
            .footer_wrap .widget_title, .footer_wrap .widgettitle {
                {$fonts['h5_font-family']}
            }
            

CSS;
        }

        if (isset($css['colors']) && $colors) {
            $css['colors'] .= <<<CSS
            
            /* Main menu */
            .sc_layouts_menu_nav>li>a {
                color: {$colors['text_dark']} !important;
            }
            .sc_layouts_menu_nav>li>a:hover,
            .sc_layouts_menu_nav>li.sfHover>a,
            .sc_layouts_menu_nav>li.current-menu-item>a,
            .sc_layouts_menu_nav>li.current-menu-parent>a,
            .sc_layouts_menu_nav>li.current-menu-ancestor>a {
                color: {$colors['text_link']} !important;
            }
            
            /* Dropdown menu */
            .sc_layouts_menu_nav>li>ul:before,
            .sc_layouts_menu_nav>li ul{
                background-color: {$colors['text_link']};
            }
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li>a,
            .sc_layouts_menu_nav>li li>a {
                color: {$colors['inverse_link']} !important;
            }
            .sc_layouts_menu_nav>li li>a:hover:after,
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li>a:hover,
            .sc_layouts_menu_popup .sc_layouts_menu_nav>li.sfHover>a,
            .sc_layouts_menu_nav>li li>a:hover,
            .sc_layouts_menu_nav>li li.sfHover>a,
            .sc_layouts_menu_nav>li li.current-menu-item>a,
            .sc_layouts_menu_nav>li li.current-menu-parent>a,
            .sc_layouts_menu_nav>li li.current-menu-ancestor>a {
                color: {$colors['inverse_text']} !important;
                background-color: {$colors['bg_color_0']};
            }
            
            /* Breadcrumbs */
            .sc_layouts_title_caption {
                color: {$colors['text_dark']};
            }
            .sc_layouts_title_breadcrumbs,
            .sc_layouts_title_breadcrumbs a {
                color: {$colors['text_dark']} !important;
            }
            .breadcrumbs_item.current{
                color: {$colors['text_dark']} !important;
            }
            .sc_layouts_title_breadcrumbs a:hover {
                color: {$colors['text_link']} !important;
            }
            
            /* Slider */
            .sc_slider_controls .slider_controls_wrap > a,
            .slider_container.slider_controls_side .slider_controls_wrap > a,
            .slider_outer_controls_side .slider_controls_wrap > a {
                color: {$colors['inverse_link']};
                background-color: {$colors['bg_color_0']};
            }
            .sc_slider_controls .slider_controls_wrap > a:hover,
            .slider_container.slider_controls_side .slider_controls_wrap > a:hover,
            .slider_outer_controls_side .slider_controls_wrap > a:hover {
                 color: {$colors['text_link']};
                 background-color: {$colors['bg_color_0']};
            }
            
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet,
            .swiper-pagination-custom .swiper-pagination-button {
                background-color: {$colors['inverse_link']};
            }
            .swiper-pagination-custom .swiper-pagination-button.swiper-pagination-button-active,
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet.swiper-pagination-bullet-active,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet.swiper-pagination-bullet-active,
            .slider_container .slider_pagination_wrap .swiper-pagination-bullet:hover,
            .slider_outer .slider_pagination_wrap .swiper-pagination-bullet:hover {
                background-color: {$colors['inverse_link']};
            }
            
            
            /* Layouts */
            .sc_layouts_logo .logo_text {
                color: {$colors['text_dark']};
            }
            

            /* Shortcodes */
            .sc_skills .sc_skills_total,
            .sc_skills_pie.sc_skills_compact_off .sc_skills_total {
                color: {$colors['text_dark']};
            }
            .sc_skills_pie.sc_skills_compact_off .sc_skills_item_title {
                color: {$colors['text_dark']};
            }
            .sc_countdown .sc_countdown_label,
            .sc_countdown_default .sc_countdown_digits span {
                color: {$colors['text_dark']};
                background: {$colors['bg_color_0']};
            }
            .sc_skills_counter .sc_skills_icon  {
                color: {$colors['text_dark']};
                border-color: {$colors['input_bd_color']};
            }
            
            /* Audio */
            .format-audio .post_featured.without_thumb .mejs-controls,
            .trx_addons_audio_player.without_cover .mejs-controls {
                background: {$colors['bg_color_0']};
            }
            .format-audio .post_featured.without_thumb .mejs-container,
            .trx_addons_audio_player.without_cover .mejs-container {
                background: {$colors['bg_color_0']};
            }
            .format-audio .post_featured.without_thumb .mejs-controls .mejs-time,
            .trx_addons_audio_player.without_cover .mejs-time {
                color: {$colors['text']};
            }
            .trx_addons_audio_player.without_cover,
            .format-audio .post_featured.without_thumb .post_audio {
                background-color: {$colors['alter_bg_color']};
                border-color: {$colors['alter_bg_color']};
            }
            .mejs-controls .mejs-button > button {
                background: {$colors['text_link']} !important;
                color: {$colors['inverse_link']}!important;
            }
            .mejs-controls .mejs-button > button:hover {
                background: {$colors['text_hover']} !important;
                color: {$colors['inverse_link']}!important;
            }
            
            
            /* Video */
            .trx_addons_video_player.with_cover .video_hover,
            .format-video .post_featured.with_thumb .post_video_hover {
                color: {$colors['text_link']};
                background-color: {$colors['inverse_link']};
            }
            .trx_addons_video_player.with_cover .video_hover:hover,
            .format-video .post_featured.with_thumb .post_video_hover:hover {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_hover']};
            }
            
            /* Price */
            .sc_price_item {
                color: {$colors['text_dark']};
                background-color: {$colors['bg_color']};
                border-color: {$colors['extra_light']};
            }
            .sc_price_item:hover {
                 color: {$colors['text_dark']};
                background-color: {$colors['bg_color']};
                border-color: {$colors['extra_light']};
            }
            .sc_price_item:hover .sc_price_item_title,
            .sc_price_item .sc_price_item_title,
            .sc_price_item .sc_price_item_title a {
                color: {$colors['text_dark']};
            }
            .sc_price_item:hover .sc_price_item_title a {
                color: {$colors['text_link']};
            }
            .sc_price_item .sc_price_item_price {
                color: {$colors['text_dark']};
            }
            .sc_price_item .sc_price_item_description{
                color: {$colors['text']};
            }
            .sc_price_item .sc_price_item_details {
                color: {$colors['text_link']};
            }

            
            .scheme_self.sidebar .sidebar_inner .widget.widget_search{
                background-color: {$colors['text_link2']};
                color: {$colors['inverse_link']};
                border-color: {$colors['text_link2']};
            }
            .scheme_self.sidebar .sidebar_inner .widget.widget_search .widget_title{
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search .widget_title:before {
                background: linear-gradient(to right,{$colors['inverse_link']} 0%, {$colors['inverse_link']} 74%, rgba(255,255,255,0) 74%,rgba(255,255,255,0) 87%,{$colors['inverse_link']} 87%);
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"] {
                background-color: {$colors['extra_hover']};
                color: {$colors['inverse_link']};
                border-color: {$colors['extra_hover']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"]::-webkit-input-placeholder {
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input[type="search"]::-moz-placeholder {
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search input.search-submit {
                background: {$colors['text_link2']} !important;
                border-color: {$colors['inverse_link_02']} !important;
                border-bottom-color: {$colors['inverse_link']} !important;
            }
            .sidebar[class*="scheme_"] .widget.widget_search form:hover input.search-submit,
            .sidebar[class*="scheme_"] .widget.widget_search input.search-submit:hover {
                background: {$colors['inverse_link']} !important;
            }
            .sidebar[class*="scheme_"] .widget.widget_search form:after {
                color: {$colors['inverse_link']};
            }
            .sidebar[class*="scheme_"] .widget.widget_search form:hover:after {
                color: {$colors['text_link']};
            }
            
            li.recentcomments > a {
                color: {$colors['text']};
            }
            .comment-author-link {
                color: {$colors['text_dark']};
            }
            .body_wrap .page_wrap .BigWhiteText:before,
            .sc_item_title.sc_item_title_style_default:before,
            .sidebar[class*="scheme_"] .widget.widget_block h2:before,
            .sidebar[class*="scheme_"] .widget .widget_title:before {
                background: linear-gradient(to right,{$colors['text_link']} 0%, {$colors['text_link']} 74%, rgba(255,255,255,0) 74%,rgba(255,255,255,0) 87%,{$colors['text_link']} 87%);
            }
            
            .scheme_self.footer_wrap .widget ul:before,
            .sidebar[class*="scheme_"] .widget ul:before {
                background: {$colors['bd_color']};
            }
            ul[class*="trx_addons_list"].trx_addons_list_tooltip li:before,
            .scheme_self.footer_wrap .widget li > a:before,
            .sidebar[class*="scheme_"] .widget li > a:before {
                background: {$colors['text_link']};
            }
            .scheme_self.footer_wrap li a,
            .scheme_self.footer_wrap a {
                color: {$colors['text']} !important;
            }
            .scheme_self.footer_wrap li a:hover,
            .scheme_self.footer_wrap a:hover {
                color: {$colors['text_dark']} !important;
            }
			.scheme_self.footer_wrap li a.rsswidget,
            .scheme_self.footer_wrap a.rsswidget {
                color: {$colors['text_dark']} !important;
            }	
			.scheme_self.footer_wrap li a.rsswidget:hover,
            .scheme_self.footer_wrap a.rsswidget:hover {
                color: {$colors['text_hover']} !important;
            }				
            .scheme_self.footer_wrap .sc_layouts_row_type_narrow .socials_wrap .social_item .social_icon {
                background: {$colors['bg_color_0']};
                color: {$colors['text']} !important;
            }
            .scheme_self.footer_wrap .sc_layouts_row_type_narrow .socials_wrap .social_item:hover .social_icon {
                background: {$colors['bg_color_0']};
                color: {$colors['text_dark']} !important;
            }
            .sc_skills_counter .sc_skills_icon {
                background-color: {$colors['alter_bg_color']};
                color: {$colors['text_link']};
            }
            .sc_testimonials_item {
                background-color: {$colors['text_link']};
            }
            .sc_testimonials_item_content:before {
                color: {$colors['text_link2']};
            }
            .sc_testimonials_item_author_subtitle,
            .sc_testimonials_item_author_title,
            .sc_testimonials_item_content {
                color: {$colors['inverse_link']};
            }
            
            .sc_testimonials .slider_container.slider_controls_side .swiper-button-prev,
            .sc_testimonials .slider_container.slider_controls_side .swiper-button-next {
                color: {$colors['inverse_link_05']};
            }
            .sc_testimonials .slider_container.slider_controls_side .swiper-button-prev:hover,
            .sc_testimonials .slider_container.slider_controls_side .swiper-button-next:hover {
                color: {$colors['inverse_link']};
            }
            .sc_icons .sc_icons_item_title,
            .socials_share .socials_caption {
                color: {$colors['text_dark']};
            }
            .comments_wrap .form-submit input[type="submit"],
			.post-password-form input[type="submit"]{
                border-color: {$colors['text_link']} !important;
            }
            .sc_icons_item_description {
                color: {$colors['text']};
            }            
                       
            .scheme_dark .sc_form_default .sc_form_field_button button {
                border-color: {$colors['inverse_link_02']} !important;
                background-color: {$colors['bg_color_0']};
                color: {$colors['inverse_link']} !important;
            }
            .scheme_dark form.wpcf7-form .contact_us input[type="submit"] {
                border-color: {$colors['text_link']} !important;                
            }
            .scheme_dark form.wpcf7-form .contact_us input[type="submit"]:hover {
                border-color: {$colors['text_link']} !important;
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']} !important;
            }
            
            .scheme_dark .sc_form_default .sc_form_field_button button:hover {
                border-color: {$colors['text_link']} !important;
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']} !important;
            }
            .eg-nubia-element-1 {
                border-bottom-color: {$colors['text_link']} !important;
            }
            .sc_events_date_month {
                color: {$colors['text_link']};
            }
            .sc_events_detailed .sc_events_item_date {
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .scheme_dark .sc_icons .sc_icons_icon {
                color: {$colors['alter_light']};
            }
            .trx_addons_list_tooltip li .trx_addons_tooltip {
                color: {$colors['text']};
            }
            .trx_addons_list_tooltip li:hover .trx_addons_tooltip {
                color: {$colors['text_dark']};
            }
            .scheme_dark ul[class*="trx_addons_list_line"]:before {
                background-color: {$colors['inverse_link_02']};
            }
            .ui-datepicker .ui-datepicker-buttonpane button,
            .scheme_dark .trx_addons_tooltip:before {
                background-color: {$colors['text_link']};
                color: {$colors['inverse_link']};
            }
            .ui-datepicker .ui-datepicker-buttonpane button:hover {
                background-color: {$colors['text_dark']};
                color: {$colors['inverse_link']};
            }
            .scheme_dark .trx_addons_tooltip:after {
                border-top-color: {$colors['text_link']};
            }
            .scheme_dark .wpcf7-form-control[type="tel"],
            .scheme_dark .wpcf7-form-control[type="text"] {
                background-color: {$colors['extra_hover']};
                border-color: {$colors['extra_hover']};
                color: {$colors['inverse_link']};
            }
            .scheme_dark div.wpcf7-validation-errors,
            .scheme_dark span.wpcf7-not-valid-tip {
                color: {$colors['inverse_link']};
            }
            .wpcf7 input[type="submit"] {
                background-color: {$colors['bg_color_0']};
                border-color: {$colors['text_dark_02']} !important;
                border-bottom-color: {$colors['text_dark']} !important;
                color: {$colors['text_dark']};
            }
            .wpcf7 input[type="submit"]:hover {
                background-color: {$colors['text_dark']};
                border-color: {$colors['text_dark']} !important;
                border-bottom-color: {$colors['text_dark']} !important;
                color: {$colors['bg_color']};
            }
            .wpcf7 div[class*="icon-"]:before {
                color: {$colors['text_dark_03']};
            }
            .sc_dishes_float .sc_dishes_item_title .sc_dishes_item_price {
                color: {$colors['text_link']};
            }
            .sc_dishes_float .sc_dishes_item {
                border-color: {$colors['alter_bd_hover']};
            }
            .sc_blogger_item_content {
                color: {$colors['text']};
            }
            .custom.tparrows:hover:before {
                color: {$colors['text_link']} !important;
            }
            .scheme_default .sc_blogger_item {
                background-color: {$colors['bg_color_0']};
            }
            .slider_elastistack.sc_slider_controls .slider_controls_wrap > a,
            .slider_elastistack.slider_container.slider_controls_side .slider_controls_wrap > a,
            .slider_elastistackslider_outer_controls_side .slider_controls_wrap > a {
                color: {$colors['text_dark']};
                background-color: {$colors['bg_color_0']};
            }
            .slider_elastistack.sc_slider_controls .slider_controls_wrap > a:hover,
            .slider_elastistack.slider_container.slider_controls_side .slider_controls_wrap > a:hover,
            .slider_elastistack.slider_outer_controls_side .slider_controls_wrap > a:hover {
                 color: {$colors['text_link']};
                 background-color: {$colors['bg_color_0']};
            }
            
            .sc_slider_controls.sc_slider_controls_default .slider_controls_wrap > a {
                color: {$colors['text_dark']};
                background-color: {$colors['bg_color_0']};
            }
            .sc_slider_controls.sc_slider_controls_default .slider_controls_wrap > a:hover {
                 color: {$colors['text_link']};
                 background-color: {$colors['bg_color_0']};
            }
            
            

CSS;
		}

		return $css;
	}
}
?>