<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

if (anubia_sidebar_present()) {
	ob_start();
	$anubia_sidebar_name = anubia_get_theme_option('sidebar_widgets');
	anubia_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($anubia_sidebar_name) ) {
		dynamic_sidebar($anubia_sidebar_name);
	}
	$anubia_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($anubia_out)) {
		$anubia_sidebar_position = anubia_get_theme_option('sidebar_position');
		?>
		<div class="sidebar <?php echo esc_attr($anubia_sidebar_position); ?> widget_area<?php if (!anubia_is_inherit(anubia_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(anubia_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'anubia_action_before_sidebar' );
				anubia_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $anubia_out));
				do_action( 'anubia_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>