<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0.10
 */

$anubia_footer_id = str_replace('footer-custom-', '', anubia_get_theme_option("footer_style"));
if ((int) $anubia_footer_id == 0) {
	$anubia_footer_id = anubia_get_post_id(array(
												'name' => $anubia_footer_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$anubia_footer_id = apply_filters('anubia_filter_get_translated_layout', $anubia_footer_id);
}
$anubia_footer_meta = get_post_meta($anubia_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($anubia_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($anubia_footer_id))); 
						if (!empty($anubia_footer_meta['margin']) != '') 
							echo ' '.esc_attr(anubia_add_inline_css_class('margin-top: '.anubia_prepare_css_value($anubia_footer_meta['margin']).';'));
						if (!anubia_is_inherit(anubia_get_theme_option('footer_scheme')))
							echo ' scheme_' . esc_attr(anubia_get_theme_option('footer_scheme'));
						?>">
	<?php
    // Custom footer's layout
    do_action('anubia_action_show_layout', $anubia_footer_id);
	?>
</footer><!-- /.footer_wrap -->
