<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0.10
 */

// Logo
if (anubia_is_on(anubia_get_theme_option('logo_in_footer'))) {
	$anubia_logo_image = '';
	if (anubia_is_on(anubia_get_theme_option('logo_retina_enabled')) && anubia_get_retina_multiplier(2) > 1)
		$anubia_logo_image = anubia_get_theme_option( 'logo_footer_retina' );
	if (empty($anubia_logo_image)) 
		$anubia_logo_image = anubia_get_theme_option( 'logo_footer' );
	$anubia_logo_text   = get_bloginfo( 'name' );
	if (!empty($anubia_logo_image) || !empty($anubia_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($anubia_logo_image)) {
					$anubia_attr = anubia_getimagesize($anubia_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($anubia_logo_image).'" class="logo_footer_image" alt="'.esc_attr(basename($anubia_logo_image)).'"'.(!empty($anubia_attr[3]) ? ' ' . wp_kses_data($anubia_attr[3]) : '').'></a>' ;
				} else if (!empty($anubia_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($anubia_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>