<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0.10
 */

// Footer sidebar
$anubia_footer_name = anubia_get_theme_option('footer_widgets');
$anubia_footer_present = !anubia_is_off($anubia_footer_name) && is_active_sidebar($anubia_footer_name);
if ($anubia_footer_present) { 
	anubia_storage_set('current_sidebar', 'footer');
	$anubia_footer_wide = anubia_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($anubia_footer_name) ) {
		dynamic_sidebar($anubia_footer_name);
	}
	$anubia_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($anubia_out)) {
		$anubia_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $anubia_out);
		$anubia_need_columns = true;
		if ($anubia_need_columns) {
			$anubia_columns = max(0, (int) anubia_get_theme_option('footer_columns'));
			if ($anubia_columns == 0) $anubia_columns = min(4, max(1, substr_count($anubia_out, '<aside ')));
			if ($anubia_columns > 1)
				$anubia_out = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($anubia_columns).' widget', $anubia_out);
			else
				$anubia_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($anubia_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$anubia_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($anubia_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'anubia_action_before_sidebar' );
				anubia_show_layout($anubia_out);
				do_action( 'anubia_action_after_sidebar' );
				if ($anubia_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$anubia_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>