<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0.06
 */

$anubia_header_css = '';
$anubia_header_image = get_header_image();
$anubia_header_video = anubia_get_header_video();
if (!empty($anubia_header_image) && anubia_trx_addons_featured_image_override(is_singular() || anubia_storage_isset('blog_archive') || is_category())) {
	$anubia_header_image = anubia_get_current_mode_image($anubia_header_image);
}

$anubia_header_id = str_replace('header-custom-', '', anubia_get_theme_option("header_style"));
if ((int) $anubia_header_id == 0) {
	$anubia_header_id = anubia_get_post_id(array(
												'name' => $anubia_header_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$anubia_header_id = apply_filters('anubia_filter_get_translated_layout', $anubia_header_id);
}
$anubia_header_meta = get_post_meta($anubia_header_id, 'trx_addons_options', true);

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($anubia_header_id); 
				?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($anubia_header_id)));
				echo !empty($anubia_header_image) || !empty($anubia_header_video) 
					? ' with_bg_image' 
					: ' without_bg_image';
				if ($anubia_header_video!='') 
					echo ' with_bg_video';
				if ($anubia_header_image!='') 
					echo ' '.esc_attr(anubia_add_inline_css_class('background-image: url('.esc_url($anubia_header_image).');'));
				if (!empty($anubia_header_meta['margin']) != '') 
					echo ' '.esc_attr(anubia_add_inline_css_class('margin-bottom: '.esc_attr(anubia_prepare_css_value($anubia_header_meta['margin'])).';'));
				if (is_single() && has_post_thumbnail()) 
					echo ' with_featured_image';
				if (anubia_is_on(anubia_get_theme_option('header_fullheight'))) 
					echo ' header_fullheight anubia-full-height';
				if (!anubia_is_inherit(anubia_get_theme_option('header_scheme')))
					echo ' scheme_' . esc_attr(anubia_get_theme_option('header_scheme'));
				?>"><?php

	// Background video
	if (!empty($anubia_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('anubia_action_show_layout', $anubia_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>