<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_header_css = '';
$anubia_header_image = get_header_image();
$anubia_header_video = anubia_get_header_video();
if (!empty($anubia_header_image) && anubia_trx_addons_featured_image_override(is_singular() || anubia_storage_isset('blog_archive') || is_category())) {
	$anubia_header_image = anubia_get_current_mode_image($anubia_header_image);
}

?><header class="top_panel top_panel_default<?php
					echo !empty($anubia_header_image) || !empty($anubia_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($anubia_header_video!='') echo ' with_bg_video';
					if ($anubia_header_image!='') echo ' '.esc_attr(anubia_add_inline_css_class('background-image: url('.esc_url($anubia_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (anubia_is_on(anubia_get_theme_option('header_fullheight'))) echo ' header_fullheight anubia-full-height';
					if (!anubia_is_inherit(anubia_get_theme_option('header_scheme')))
						echo ' scheme_' . esc_attr(anubia_get_theme_option('header_scheme'));
					?>"><?php

	// Background video
	if (!empty($anubia_header_video)) {
		get_template_part( 'templates/header-video' );
	}
	
	// Main menu
	if (anubia_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Mobile header
	if (anubia_is_on(anubia_get_theme_option("header_mobile_enabled"))) {
		get_template_part( 'templates/header-mobile' );
	}
	
	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Display featured image in the header on the single posts
	// Comment next line to prevent show featured image in the header area
	// and display it in the post's content
	get_template_part( 'templates/header-single' );

?></header>