<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_args = get_query_var('anubia_logo_args');

// Site logo
$anubia_logo_type   = isset($anubia_args['type']) ? $anubia_args['type'] : '';
$anubia_logo_image  = anubia_get_logo_image($anubia_logo_type);
$anubia_logo_text   = anubia_is_on(anubia_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$anubia_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($anubia_logo_image) || !empty($anubia_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($anubia_logo_image)) {
			if (empty($anubia_logo_type) && function_exists('the_custom_logo') && is_numeric( $anubia_logo_image ) && $anubia_logo_image > 0 ) {
				the_custom_logo();
			} else {
				$anubia_attr = anubia_getimagesize($anubia_logo_image);
				echo '<img src="'.esc_url($anubia_logo_image).'" alt="'.esc_attr(basename($anubia_logo_image)).'"'.(!empty($anubia_attr[3]) ? ' '.wp_kses_data($anubia_attr[3]) : '').'>';
			}
		} else {
			anubia_show_layout(anubia_prepare_macros($anubia_logo_text), '<span class="logo_text">', '</span>');
			anubia_show_layout(anubia_prepare_macros($anubia_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>