<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

// Page (category, tag, archive, author) title

if ( anubia_need_page_title() ) {
	anubia_sc_layouts_showed('title', true);
	anubia_sc_layouts_showed('postmeta', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() )  {
							?><div class="sc_layouts_title_meta"><?php
								anubia_show_post_meta(apply_filters('anubia_filter_post_meta_args', array(
									'components' => anubia_array_get_keys_by_value(anubia_get_theme_option('meta_parts')),
									'counters' => anubia_array_get_keys_by_value(anubia_get_theme_option('counters')),
									'seo' => anubia_is_on(anubia_get_theme_option('seo_snippets'))
									), 'header', 1)
								);
							?></div><?php
						}
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$anubia_blog_title = anubia_get_blog_title();
							$anubia_blog_title_text = $anubia_blog_title_class = $anubia_blog_title_link = $anubia_blog_title_link_text = '';
							if (is_array($anubia_blog_title)) {
								$anubia_blog_title_text = $anubia_blog_title['text'];
								$anubia_blog_title_class = !empty($anubia_blog_title['class']) ? ' '.$anubia_blog_title['class'] : '';
								$anubia_blog_title_link = !empty($anubia_blog_title['link']) ? $anubia_blog_title['link'] : '';
								$anubia_blog_title_link_text = !empty($anubia_blog_title['link_text']) ? $anubia_blog_title['link_text'] : '';
							} else
								$anubia_blog_title_text = $anubia_blog_title;
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr($anubia_blog_title_class); ?>"><?php
								$anubia_top_icon = anubia_get_category_icon();
								if (!empty($anubia_top_icon)) {
									$anubia_attr = anubia_getimagesize($anubia_top_icon);
									?><img src="<?php echo esc_url($anubia_top_icon); ?>" alt="<?php echo esc_attr(basename($anubia_top_icon)); ?>" <?php if (!empty($anubia_attr[3])) anubia_show_layout($anubia_attr[3]);?>><?php
								}
								echo wp_kses($anubia_blog_title_text, 'anubia_kses_content');
							?></h1>
							<?php
							if (!empty($anubia_blog_title_link) && !empty($anubia_blog_title_link_text)) {
								?><a href="<?php echo esc_url($anubia_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($anubia_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'anubia_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>